<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * Դ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * Rent_operate_model CLASS
 *
 * Դ࣬װԴ(ʧЧᡢɾٷ)
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz
 */
class Rent_operate_model extends MY_Model {
    
    /**
     * Դ״̬
     * @var string 
     */
    private $_house_esta = array();
    
    //캯
    public function __construct() 
    {
        parent::__construct(1,1,1);
        
        //طԴ
        $this->load->model('rent_base_model');
        $this->_house_esta = $this->rent_base_model->get_house_esta();
    }
    
    /**
     * ʧЧԴ
     *
     * @access  public
     * @param   mixed $rowids ԴţԴΪΪʽ
     * @return  int   Ӱ
     */
    public function invalid_house($rowids)
    {   
        $invalid_num = 0;
        
        if( !empty($rowids) )
        {   
            if(is_array($this->_house_esta) && isset($this->_house_esta['invalid']))
            {    
                //ֶ
                $update_data  = array();
                $update_data['esta'] =  $this->_house_esta['invalid'];
                //ʧЧԴ
                $invalid_num = $this->rent_base_model->update( $update_data , $rowids );
            }
        }
        
       return $invalid_num;
    }
    
    
    /**
     * ɾԴ
     *
     * @access  public
     * @param   mixed $rowids ԴţԴΪΪʽ
     * @return  boolean  ɾǷɹ
     */
    public function delete_house($rowids)
    {   
        if( !empty($rowids) )
        {
            $result_delete = 0;
            if(is_array($this->_house_esta) && isset($this->_house_esta['delete']))
            {    
                //ֶ
                $update_data  = array();
                $update_data['esta'] =  $this->_house_esta['delete'];

                //ʧЧԴ
                $result_delete = $this->rent_base_model->update( $update_data , $rowids );
            }
        }
        
       return $result_delete;
    }
    
    
    /**
     * ᷿Դ
     *
     * @access  public
     * @param   mixed $rowids ԴţԴΪΪʽ
     * @return  boolean  ɾǷɹ
     */
    public function freeze_house($rowids)
    {   
        $result = FALSE;
        
        if( !empty($rowids) )
        {
            if(  $this->tbl != '' )
            {   
                $result_invalid = 0;
                if(is_array($this->_house_esta) && isset($this->_house_esta['frozen']))
                {    
                    //ֶ
                    $update_data  = array();
                    $update_data['esta'] =  $this->_house_esta['frozen'];
                    
                    //ʧЧԴ
                    $result_invalid = $this->rent_base_model->update_data( $update_data , $rowids );
                }
                
                $result = $result_invalid > 0 ? TRUE : FALSE;
            }
        }
        
       return $result;
    }
    
    
    /**
     * Դ
     *
     * @access  public
     * @param   mixed $rowids ԴţԴΪΪʽ
     * @return  boolean  ɾǷɹ
     */
    public function active_house($rowids)
    {   
        $result = FALSE;
        
        if( !empty($rowids) )
        {
            $result_invalid = 0;
            if(is_array($this->_house_esta) && isset($this->_house_esta['active']))
            {    
                //ֶ
                $update_data  = array();
                $update_data['esta'] =  $this->_house_esta['active'];
                $update_data['istop'] =  0;//ֹƼԴʧЧټƼԴ

                //ʧЧԴ
                $result_invalid = $this->rent_base_model->update( $update_data , $rowids );
            }

            $result = $result_invalid > 0 ? TRUE : FALSE;
        }
        
       return $result;
    }
}
/* End of file Rent_operate_model.php */
/* Location: ./application/models/rent_operate_model.php */