<?php !defined('APP_DIR') ? die('acceess not defined') : '';

/**
 * Զ
 *
 * @param string $class_name
 */
spl_autoload_register('myAutoload');
function myAutoload($class_name){
    if (preg_match('/^'.ACTIONS.'_[0-9a-zA-Z_]+$/',$class_name)) {  //ĵ
        $class_name = str_replace('_','/',$class_name);
    	$class_file = APP_DIR."/$class_name.php";
    }else if ($class_name[0]>='a' && $class_name[0]<='z') {
        $class_name = strtolower(str_replace('_','/',$class_name));
    	$class_file = ROOT_DIR."/system/$class_name.php";
    }elseif ($class_name[0]>='A' && $class_name[0]<='Z'){
        if( substr($class_name,0,4)=='DAO_' ){  //daoĵĿΪԶDAO
            $class_name = 'dao/'.substr($class_name,4);
        }else {
            if (strpos($class_name,'_')) {
            	$class_name = str_replace('_','/',$class_name);
            }
            $class_name = strtolower($class_name);
        }
        $class_file = ROOT_DIR."/library/$class_name.php";
    }
    if(file_exists($class_file)){	
        require_once($class_file);
        return true;
    }
    return false;
}

/**
 * ȡbmĺ
 *
 * @param string $bm_name
 * @return obj
 */
function bm($bm_name){
    return BM::instance($bm_name);
}

/**
 * ȡwidget
 *
 * @param string $widget_name
 * @return obj
 */
function widget($widget_name){
    return WIDGET::instance($widget_name);
}

/**
 * ٵ÷
 *
 * @param string $city
 * @return cache Obj
 */
function cache($city='local',$file=false){
    return cache::instance($city,$file);
}

/**
 * жǷajax
 *
 * @return bool
 */
function is_ajax(){
	return (isset($_SERVER['HTTP_X_REQUESTED_WITH']) AND strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest');
}




/**
 * ȡĳһֶεļ
 *
 * @param array_type $data_lists
 * @param string_type $col_name
 * @param string_type $ret a:array, s:,ַ
 * @return array or string
 */
function get_col(&$data_lists, $col_name, $ret_type = 'a', $dimension = 2) {
	$ret = array();
	
	if ( is_array($data_lists) ) {
		switch ($dimension) {
			case 2:
				foreach ($data_lists as $r) {
					if ( $r[$col_name] && !in_array($r[$col_name], $ret) ) {
						$ret[] = $r[$col_name];
					}
				}
				break;
			case 3:
				foreach ($data_lists as $tmp_r) {
					foreach ($tmp_r as $r) {
						if ( $r[$col_name] && !in_array($r[$col_name], $ret) ) {
							$ret[] = $r[$col_name];
						}
					}
				}
				break;
		}
	}
	if($ret_type != 'a') {
		return implode(',', $ret); 
	}
	return $ret; 
}

/**
 * άΪ ڶάĳ
 * 
 * @param array $arr
 * @param int $key
 */
function change_array_key($arr, $index){
	$arr1 = array();
	foreach ($arr as $key => $val) {
		$arr1[$val[$index]] = $val;
	}
	return $arr1;
}



function pagebar($total,$query,$pagesize=20,$pageseg=7){
	
	$page = $_GET['page'];//ǰҳ
	$page = $page?$page:1;//
	$pagenum = ceil($total/$pagesize);
	if($page==1 && $pagenum==1){//ֻһҳĻ
		$firstPage = $nextPage = $prevPage = $endPage = 1;
	}elseif($page==1 && $pagenum==0){
		$firstPage = $nextPage = $prevPage = $endPage = 1;
	}elseif($page==1){
		$firstPage = $prevPage =1;
		$nextPage  = $page+1;
		$endPage   = $pagenum;
	}elseif($page==$pagenum){
		$firstPage = 1;
		$endPage = $nextPage  = $pagenum;
		$prevPage = $page-1;		
	}else{
		$firstPage = 1;
		$nextPage = $page+1;
		$prevPage = $page-1;
		$endPage = $pagenum;
	}
	
	$tmp = (int)(($page-1)/$pageseg);
	$start = $tmp*$pageseg+1;
	$start = $start<=0?1:$start;
	$navstr = '';
	$tag = (strpos($query,"?")===false)?"?":"&";

	if($page>=4){

		$start = $page-3;//ֻpagesize=7
		for($i= $start;$i<$start+$pageseg && $i<=$pagenum;$i++){
			if($i==$page) $class='class="current"'; else $class='';
			$navstr.='<li><a '.$class.' href="'.$query.$tag.'page='.$i.'">'.$i.'</a></li>';
		}
	}else{

		for($i= $start;$i<$start+$pageseg && $i<=$pagenum;$i++){
			if($i==$page) $class='class="active"'; else $class='';
			$navstr.='<li '.$class.'><a  href="'.$query.$tag.'page='.$i.'">'.$i.'</a></li>';
		}
	}
	
	$prev = '<li><a href="'.$query.$tag.'page='.$prevPage.'">&lt; һҳ</a></li>';
	$end = '<li><a href="'.$query.$tag.'page='.$nextPage.'">һҳ &gt;</a></li> <span class="c-orange fb plr5">'.$total.'</span>Ϣ';
	$nav['start'] = ($page-1)*$pagesize;
	$nav['pagenation'] ='<ul class="pagination">'. $prev.$navstr.$end.'</ul>';
	return $nav;
}


function pagebar_2($total,$query,$pagesize=20,$pageseg=7){
	
	$page = $_GET['page'];//ǰҳ
	$page = $page?$page:1;//
	$pagenum = ceil($total/$pagesize);
	if($page==1 && $pagenum==1){//ֻһҳĻ
		$firstPage = $nextPage = $prevPage = $endPage = 1;
	}elseif($page==1 && $pagenum==0){
		$firstPage = $nextPage = $prevPage = $endPage = 1;
	}elseif($page==1){
		$firstPage = $prevPage =1;
		$nextPage  = $page+1;
		$endPage   = $pagenum;
	}elseif($page==$pagenum){
		$firstPage = 1;
		$endPage = $nextPage  = $pagenum;
		$prevPage = $page-1;		
	}else{
		$firstPage = 1;
		$nextPage = $page+1;
		$prevPage = $page-1;
		$endPage = $pagenum;
	}
	
	$tmp = (int)(($page-1)/$pageseg);
	$start = $tmp*$pageseg+1;
	$start = $start<=0?1:$start;
	$navstr = '';
	$tag = (strpos($query,"?")===false)?"?":"&";
	
	if($total>$pageseg){
		if($page>=4){

			$start = $page-3;//ֻpagesize=7
			for($i= $start;$i<$start+$pageseg && $i<=$pagenum;$i++){
				if($i==$page) $class='class="on"'; else $class='';
				$navstr.='<a '.$class.' href="'.$query.$tag.'page='.$i.'">'.$i.'</a>';
			}
		}else{

			for($i= $start;$i<$start+$pageseg && $i<=$pagenum;$i++){
				if($i==$page) $class='class="on"'; else $class='';
				$navstr.='<a '.$class.' href="'.$query.$tag.'page='.$i.'">'.$i.'</a>';
			}
		}
	}
	if($total>$pageseg){
		$prev = '<a class="cur" href="'.$query.$tag.'page='.$prevPage.'">&lt; һҳ</a>';
		$end = '<a class="cur" href="'.$query.$tag.'page='.$nextPage.'">һҳ &gt;</a> ';
	}
	$end .= '<span class="c-orange fb plr5">'.$total.'</span>Ϣ';
	$nav['start'] = ($page-1)*$pagesize;
	$nav['pagenation'] = $prev.$navstr.$end;
	return $nav;
}
/**
*   page  ǰҳ 
*	pages ҳ
*	nums  ÿҳ¼
*	url  ҳʱҪתurlҪĲ
*   num  еļ¼
*/
function getPageHtml($page, $pages, $nums,$url,$num){
	$_pageNum = 5;
	$page = $page<1?1:$page;
	$page = $page > $pages ? $pages : $page;
	$pages = $pages < $page ? $page : $pages;
	$_start = $page - floor($_pageNum/2);
	$_start = $_start<1 ? 1 : $_start;
	$_end = $page + floor($_pageNum/2);
	$_end = $_end>$pages? $pages : $_end;

	$_curPageNum = $_end-$_start+1;
	if($_curPageNum<$_pageNum && $_start>1){  
		$_start = $_start - ($_pageNum-$_curPageNum);
		$_start = $_start<1 ? 1 : $_start;
		$_curPageNum = $_end-$_start+1;
	}

	if($_curPageNum<$_pageNum && $_end<$pages){ 
		$_end = $_end + ($_pageNum-$_curPageNum);
		$_end = $_end>$pages? $pages : $_end;
	}

	$_pageHtml = '<ul class="pagination">';
	if($page>1){
		$_pageHtml .= '<li ><a title="һҳ" href="'.$url.'&disNums='.$nums.'&page='.($page-1).'">һҳ</a></li>';
	}
	for ($i = $_start; $i <= $_end; $i++) {
		if($i == $page){
			$_pageHtml .= '<li class="active"><a>'.$i.'</a></li>';
		}else{
			$_pageHtml .= '<li><a href="'.$url.'&disNums='.$nums.'&page='.$i.'">'.$i.'</a></li>';
		}
    }
	if($page<$_end){
		$_pageHtml .= '<li ><a title="һҳ" href="'.$url.'&disNums='.$nums.'&page='.($page+1).'">һҳ</a></li>';
	}
    $_pageHtml .= '&nbsp; '.$num.' ¼';
	$_pageHtml .= '</ul>';
	
	switch($nums){
		case 10:
			$_pageHtml .= '<ul class="pagination1"><li style="width: 185px;" align="center">ÿҳʾ <a class="slc" href="'.$url.'&disNums=10&page='.$page.'">10</a> <a href="'.$url.'&disNums=20&page='.$page.'">20</a> <a href="'.$url.'&disNums=30&page='.$page.'">30</a> </li></ul>';
			break;
		case 20:
			$_pageHtml .= '<ul class="pagination1"><li style="width: 185px;" align="center">ÿҳʾ <a href="'.$url.'&disNums=10&page='.$page.'">10</a> <a class="slc" href="'.$url.'&disNums=20&page='.$page.'">20</a> <a href="'.$url.'&disNums=30&page='.$page.'">30</a> </li></ul>';
			break;
		case 30:
			$_pageHtml .= '<ul class="pagination1"><li style="width: 185px;" align="center">ÿҳʾ <a href="'.$url.'&disNums=10&page='.$page.'">10</a> <a href="'.$url.'&disNums=20&page='.$page.'">20</a> <a class="slc" href="'.$url.'&disNums=30&page='.$page.'">30</a> </li></ul>';
			break;
		default :
			$_pageHtml .= '<ul class="pagination1"><li style="width: 185px;" align="center">ÿҳʾ <a class="slc" href="'.$url.'&disNums=10&page='.$page.'">10</a> <a href="'.$url.'&disNums=20&page='.$page.'">20</a> <a href="'.$url.'&disNums=30&page='.$page.'">30</a> </li></ul>';
			break;
	}
    
	
	return $_pageHtml;
 }


/**
 * ͨCURLʽȡԶ̵ַ
 * 
 * @param $t_urlҪαװԴַhttp://www.sina.com
 * @param $proxyҪʹõĴַͶ˿ڣ127.0.0.1:8080
 * 
 */
function curl_get_contents($str, $t_url='', $proxy='') {
	$ch = curl_init();
	$t_url = $t_url ? $t_url : 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
	if ($proxy) curl_setopt($ch, CURLOPT_PROXY, $proxy); 
	curl_setopt($ch, CURLOPT_URL, $str);
	curl_setopt($ch, CURLOPT_REFERER, $t_url);
	curl_setopt($ch,CURLOPT_RETURNTRANSFER, 1);

	$str = curl_exec($ch);
	curl_close($ch);
	return $str;
}

function _get_fetch($url){
	$ch = curl_init($url) ; 
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2); // ӳʱ룩 
	curl_setopt($ch, CURLOPT_REFERER,$url); 
	curl_setopt($ch,CURLOPT_RETURNTRANSFER, 1);
	$output = curl_exec($ch) ;
	curl_close($ch);
	return $output;
}

/*
*
*/
function xlsBOF() {
	echo pack("ssssss", 0x809, 0x8, 0x0, 0x10, 0x0, 0x0);
	return;
}
function xlsEOF() {
	echo pack("ss", 0x0A, 0x00);
	return;
}
function xlsWriteNumber($Row, $Col, $Value) {
	echo pack("sssss", 0x203, 14, $Row, $Col, 0x0);
	echo pack("d", $Value);
	return;
}
function xlsWriteLabel($Row, $Col, $Value ) {
	$L = strlen($Value);
	echo pack("ssssss", 0x204, 8 + $L, $Row, $Col, 0x0, $L);
	echo $Value;
	return;
}
function exportexcel($filename,$fields=array(),$records=array()){
	header("Pragma: public");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Content-type: application/vnd.ms-excel;charset=gb2312");
	header("Content-Type: application/force-download");
	header("Content-Type: application/octet-stream");
	header("Content-Type: application/download");;
	header("Content-Disposition: attachment;filename=$filename.xls");
	header("Content-Transfer-Encoding: binary ");//*/		
	xlsBOF();
	$I=0;
	foreach ($fields as $key=>$item){
		$name = $item;
		xlsWriteLabel(0,$I,$name);
		$I++;
	}			
	foreach ($records as $key=>$item){
		$I=0;
		for($j=0;$j<count($item);$j=$j+1){
			$value = $item[$j];
			xlsWriteLabel($key+1,$I,"$value");
			$I++;
		}																					
	}
	xlsEOF();	
}

function exportexcel_tj($filename,$fields=array(),$records=array()){
	header("Pragma: public");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Content-type: application/vnd.ms-excel;charset=gb2312");
	header("Content-Type: application/force-download");
	header("Content-Type: application/octet-stream");
	header("Content-Type: application/download");;
	header("Content-Disposition: attachment;filename=$filename.xls");
	header("Content-Transfer-Encoding: binary ");//*/		
	xlsBOF();
	$I=0;
	foreach ($fields as $key=>$item){
		$name = $item;
		xlsWriteLabel($I,0,$name);
		$I++;
	}			
	foreach ($records as $key=>$item){
		$I=0;
		for($j=0;$j<count($item);$j=$j+1){
			$value = $item[$j];
			xlsWriteLabel($I,$key+1,"$value");
			$I++;
		}																					
	}
	xlsEOF();	
}

function array_remove(&$arr, $offset)
{
	array_splice($arr, $offset, 1);
} 

function htmldecode($str)  
{  
	if(empty($str)) return;  
	if($str=="") return $str;  
	$str=str_replace("&",chr(34),$str);  
	$str=str_replace(">",">",$str);  
	$str=str_replace("<","<",$str);  
	$str=str_replace("&","&",$str);  
	$str=str_replace(" ",chr(32),$str);  
	$str=str_replace(" ",chr(9),$str);  
	$str=str_replace("'",chr(39),$str);  
	$str=str_replace("<br />",chr(13),$str);  
	$str=str_replace("''","'",$str);  
	$str=str_replace("select","select",$str);  
	$str=str_replace("join","join",$str);  
	$str=str_replace("union","union",$str);  
	$str=str_replace("where","where",$str);  
	$str=str_replace("insert","insert",$str);  
	$str=str_replace("delete","delete",$str);  
	$str=str_replace("update","update",$str);  
	$str=str_replace("like","like",$str);  
	$str=str_replace("drop","drop",$str);  
	$str=str_replace("create","create",$str);  
	$str=str_replace("modify","modify",$str);  
	$str=str_replace("rename","rename",$str);  
	$str=str_replace("alter","alter",$str);  
	$str=str_replace("cas","cast",$str);  
	$farr = array(   
	"//s+/" , //˶Ŀհ   
	"/<(//?)(img|script|i?frame|style|html|body|title|link|meta|/?|/%)([^>]*?)>/isU" , // <script ֹݻ,Ҫflash,Լ<objectĹ   
	"/(<[^>]*)on[a-zA-Z]+/s*=([^>]*>)/isU" , //javascripton¼   
	);   
	$tarr = array(   
	" " ,   
	"<//1//2//3>" , //Ҫֱȫıǩ   
	"//1//2" ,   
	);   
	$str = preg_replace ( $farr , $tarr , $str );   
	return $str;  
} 

function filterStr($str){
    return trim(str_replace(array('&nbsp;','n'), array('',''), strip_tags($str)));
}

/**
 **
 **/
 function send_push($arr){
	$pusharr = tool::json_encode($arr);   //ֻUTF-8
	//print_r($pusharr);
	//ϻ
	//$url='http://mps.house365.com/house365-mps-web/message/messageAddOuter';
	//Ի
	$url='http://192.168.105.28:8682/house365-mps-web/message/messageAddOuter'; 
	$push_re=http_post_data($url,$pusharr);
	//дļ
	/*file_put_contents("log_title_tmp.txt", $pusharr,FILE_APPEND);
	fclose($file);*/
	return $push_re;
 }

 //php ģjson,Ƚ,Ҫƶheader
function http_post_data($url, $data_string) {

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
	curl_setopt($ch, CURLOPT_TIMEOUT, 5); // óʱƷֹѭ
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Content-Length: ' . strlen($data_string))
    );
    ob_start();
    curl_exec($ch);
    $return_content = ob_get_contents();
    ob_end_clean();

    $return_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);//200
    return array($return_code, $return_content);
}

//ά鰴ĳֶεƴ  
	function sysSortArray($ArrayData,$KeyName1,$SortOrder1 = "SORT_ASC",$SortType1 = "SORT_REGULAR"){ 
		if(!is_array($ArrayData) || empty($ArrayData)) { 
            return $ArrayData; 
		}
		$ArgCount = func_num_args(); 
		for($I = 1;$I < $ArgCount;$I ++){ 
			$Arg = func_get_arg($I); 
			if(!preg_match("/^SORT/i",$Arg)) { 
				$KeyNameList[] = $Arg; 
				$SortRule[] = '$'.$Arg; 
			}else{ 
				$SortRule[] = $Arg; 
			} 
		} 
		foreach($ArrayData AS $Key => $Info) 
		{ 
			foreach($KeyNameList AS $KeyName){ 
				${$KeyName}[$Key] = $Info[$KeyName]; 
			}	
		} 
		$EvalString = 'array_multisort('.join(",",$SortRule).',$ArrayData);'; 
		eval ($EvalString); 
		return $ArrayData; 
    }

	function writeLog($content = ""){
		global $yii_start_time;
		global $yii_seed;
		if(isset($_COOKIE['yii_debug']) && $_COOKIE['yii_debug']){
			if(!$yii_seed){
				$yii_seed = rand(10000,99999);
				echo $yii_seed;
			}
			if(!$yii_start_time){
				list($msec, $sec) = explode(' ', microtime());
				$msectime =  (float)sprintf('%.0f', (floatval($msec) + floatval($sec)) * 1000);
				$yii_start_time = $msectime;
			}


			list($msec, $sec) = explode(' ', microtime());
			$cur_time =  (float)sprintf('%.0f', (floatval($msec) + floatval($sec)) * 1000);
			$gap_time = $cur_time - $yii_start_time;
			$content.= "  execute_time=$gap_time,seed=$yii_seed";
			echo curl_get_contents("http://newrent.house365.com/server-task/sentry-log?key=srwjZ1UjUw4O5X08py78m1J4PEJrWhMM&content=$content");
		}
	}


