<?php

/**
 * core\lib\growth\GrowthCreditRecord.php
 */

/**
 * ּ¼
 *
 * @author Administrator
 */
class GrowthCreditRecord {
    /**
     *
     * @var type ȫֶdbmemcache
     */
    private $container;
    /**
     *
     * @var String 
     */
    private $table;
    
    /**
     *
     * @var array аֶ
     */
    public static $fields = array('id','broker_id','way_alias','score','credit','description','ctime','discard');


    /**
     * 캯ʼ$container,$table
     * @param type $weekday 
     */
    public function __construct($strDate = null) {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        if ($strDate == '') {
            $strDate = date('Ymd');
        }
        $this->table = "growth_credit_record_" . $strDate;
        $this->credit = new GrowthCredit();
    }
    
    /**
     * ṹ
     * @param type $strDate
     * @return type
     */
    public function createTable($tablename) {
        $sql = "CREATE TABLE IF NOT EXISTS `{$tablename}` (
            `id` int(10) unsigned NOT NULL auto_increment,
            `broker_id` int(11) NOT NULL COMMENT 'ID',
            `way_alias` varchar(20) NOT NULL COMMENT 'ȡ;credit_wayway_aliasֶ',
            `score` int(11) NOT NULL COMMENT 'λȡֵַ0ʾãС0ʾ۳',
            `credit` int(11) NOT NULL COMMENT 'λȡʱĻ',
            `description` varchar(256) character set gbk default NULL COMMENT '',
            `ip` varchar(30) NOT NULL COMMENT '¼˵IPַ',
            `ctime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'ֱ仯ʱ',
            `discard` tinyint(4) NOT NULL default '0' COMMENT 'Ƿ10״̬',
            PRIMARY KEY  (`id`),
            KEY `brokerid` (`broker_id`)
          ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ֱ仯¼'";
        return $this->db->execute($sql);
    }
    
    /**
     * ɾ
     * @param type $tablename
     */
    public function dropTable($tablename) {
        $sql = "DROP TABLE  IF EXISTS  $tablename";
        return $this->db->execute($sql);
    }
    
    /**
     * õĻֵַ
     * @param array $fields ֵ
     * @return boolean
     */
    public function save($fields) {
        $keys = array_keys($fields);
        $sql = "replace into $this->table (".  implode(",", $keys).") value ('".  implode("','", $fields)."')";
        $db = $this->getDb('db');
        if($db->execute($sql)) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * һֱ仯¼
     * @param int $brokerId id
     * @param String $wayAlias ȡʽ
     * @param int $score ȡʽӦķֵ
     * @param String $description 
     * @param int $discard Ƿ Ĭ0 ʾǷ
     * @return boolean
     */
    public function insertData($brokerId,$wayAlias,$score,$description,$discard = 0) {
        $arrFieldsValue = array();
        $creditOne = $this->credit->findByBrokerId($brokerId);
        $arrFieldsValue['broker_id'] = $brokerId;
        $arrFieldsValue['way_alias'] = $wayAlias;
        $arrFieldsValue['score'] = $score;
        $arrFieldsValue['credit'] = $creditOne['credit'] - $creditOne['frozen'];;
        $arrFieldsValue['description'] = $description;
        $arrFieldsValue['ip'] = GetIp();
        $arrFieldsValue['discard'] = $discard;
        $sql = SqlCombinHelper::insert_sql($this->table, $arrFieldsValue);
        return $this->db->execute($sql);
    }
    
    /**
     * ݾid һֱ仯¼
     * @param int $brokerId id
     * @param int $start ʼļ¼
     * @param int $number ص
	 * @param string ʽ
     * @return type
     */
    public function findByBrokerId($brokerId,$start=null,$number=null,$order=null) {
        $limit = '';
        if($start !== null&&$number !== null) {
            $limit = "limit $start,$number";
        }
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields,"broker_id = '$brokerId'");
		if($order !== null){
		    $sql .= "order by id $order ";
		}
        $sql .= $limit;
	
       return $this->dbback->getAll($sql);
    }

        /**
     * ƻݿ
     * @param string $dbname
     * @return Mixed ݿӶ
     */
    public function getDb($dbname) {
        return $this->container->get($dbname);
    }
}

?>
