<?php

/**
 * core\lib\block\BlockLevelHeatSetting.php
 */

/**
 * ȶȣpvͷԴСȼ
 *
 * @author Administrator
 */
class BlockLevelHeatSetting {

    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $dbback;
    /**
     *
     * @var Memcache  
     */
    private $mc;
    /**
     *
     * @var string 
     */
    private $table;
    /**
     *
     * @var array аֶ
     */
    public static $fields = array('id', 'level', 'pv', 'house_number', 'credit_way_alias', 'exp_way_alias');

    /**
     *
     * @var array ּĸ
     */
    public static $levels = array('1'=>'A','2'=>'B','3'=>'C','4'=>'D',);

    /**
     * 캯 ʼdbmemcache
     * @param string $table 
     */
    public function __construct($table = 'block_level_heat_setting') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = $table;
    }

    /**
     * СּݣA,B,C,D4ּ
     * @return array Сȼ
     */
    public function findAll() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);
        $sql .= "order by level";
        $res = $this->db->getAll($sql);
        if ($res) {
            foreach ($res as $key => $value) {
                $res[$key] = $this->removeNumberKey($value);
            }
        }
        return $res;
    }

    /**
     * ȥмֵΪԪ
     * @param array $arr ֵַֺ
     * @return array ֵ
     */
    private function removeNumberKey($arr) {
        $rarr = array();
        foreach ($arr as $k => $val) {
            if (!is_int($k)) {
                $rarr[$k] = $val;
            }
        }
        return $rarr;
    }

    /**
     * ߸Сȼ
     * @param array $fields Сȼ
     * @return boolean ɹtrueʧܷfalse
     */
    public function save($fields) {
        $keys = array_keys($fields);
        if (array_key_exists('pv', $fields) && array_key_exists('house_number', $fields)) {
            $pv = $fields['pv'];
            $houseNumber = $fields['house_number'];
            $sql = "insert into $this->table (" . implode(",", $keys) . ") value ('" . implode("','", $fields) . "')";
            $sql .= " ON DUPLICATE KEY UPDATE pv='$pv',house_number='$houseNumber'";
            if ($this->db->execute($sql)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * $pv,$houseNumber
     * @param int $pv Ϊnullʱ
     * @param int $houseNumber Ϊnullʱ
     * @return int ظµļ¼Ŀ
     */
    public function update($pv, $houseNumber) {
        
        $fields = array();
        if($pv===null&&$houseNumber===null) {
            return false;
        } else {
            if($pv!==null) {
                $fields['pv'] = $pv;
            }
            if($houseNumber!==null) {
                $fields['house_number'] = $houseNumber;
            }
            $sql = SqlCombinHelper::update_sql($this->table, $fields, '');
            $this->db->execute($sql);
            return $this->db->affected_Rows();
        }
    }

    /**
     * pvֵ
     * @param int $pv pvֵ
     * @return int ظµļ¼Ŀ
     */
    public function updatePv($pv) {
        $sql = SqlCombinHelper::update_sql($this->table, array('pv' => $pv));
        $this->db->execute($sql);
        return $this->db->affected_Rows();
    }

    /**
     * ·Դ
     * @param int $houseNumber Դ
     * @return int ظµļ¼Ŀ
     */
    public function updateHouseNumber($houseNumber) {
        $sql = SqlCombinHelper::update_sql($this->table, array('house_number' => $houseNumber));
        $this->db->execute($sql);
        return $this->db->affected_Rows();
    }

    /**
     * ݵȼһֻȡʽı
     * @param int $level Сȼ
     * @return string  ֻȡʽ
     */
    public function getCreditWayAlias($level) {
        $sql = SqlCombinHelper::select_sql($this->table, 'credit_way_alias', "level = '$level'");
        return $this->dbback->getOne($sql);
    }

    /**
     * ݵȼҾȡʽı
     * @param int $level Сȼ
     * @return string ȡʽı
     */
    public function getExpWayAlias($level) {
        $sql = SqlCombinHelper::select_sql($this->table, 'exp_way_alias', "level = '$level'");
        return $this->dbback->getOne($sql);
    }

    /**
     * Сȼñ
     */
    public function emptyTable() {
        $sql = "TRUNCATE TABLE $this->table";
        $this->db->Execute($sql);
    }
}

?>
