<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ۱ϵͳ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * Rent_demand_model CLASS
 *
 * ࣬ṩ⹺Ϣķ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz     
 */

//ظ
load_m("rent_demand_base_model");

class Rent_demand_model extends Rent_demand_base_model{
    
    /**
    * Constructor
    */
    public function __construct() 
    {
        parent::__construct();
    }
    
    
    /**
    * ݾ˱Żȡ˳ⷿԴаϢ
    *
    * @access	public
    * @param	void
    * @param   
    * @return	array  ԴϢҪѯֶ
    */
    private function _get_streetinfo_by_uid ( $uid )
    {
        //˷ԴİϢ[ȡԴ࣬ȡзԴ漰İϢ]
        $street_info = array();
        
        if( $uid > 0  )
        {
            //ضַģ
            $this->load->model('rent_model');
            
            //òѯֶ
            $selet_fields = array('streetid');
            $this->rent_model->set_select_fields($selet_fields);
            
            //װѯ
            $cond_where = "uid = '".$uid."' AND esta = 1 AND infofrom = '5' ";
            
            $street_info_all = array();
            //ȡаϢ
            $street_info_all = $this->rent_model->find_all_by( $cond_where , 0 , 0 );
            
            if(is_array($street_info_all) && !empty($street_info_all))
            {   
                $street_info_all = array_unique($street_info_all);
                
                foreach($street_info_all as $key => $value)
                {
                    $street_info[] = $value['streetid'];
                }
            }
        }
         
        return $street_info;
    }
    
    
    /**
    *
    * ݾ˱Żȡ뾭˷ԴƥϢ
    *
    * @access	public
    * @return	int   Ϣ
    */
    public function get_demand_num_by_uid( $uid )
    {   
        //ԴϢ
        $demands_num = 0;
        
        //˷ԴİϢ[ȡԴ࣬ȡзԴ漰İϢ]
        $street_info = $this->_get_streetinfo_by_uid( $uid );

        //ϢΪգֱӷؿ
        if( empty( $street_info ) )
        {
            return  $demands_num;
        }
        
        //ĬϵĲѯ
        $limit_time = time() + 86400;
        $cond_where = "esta = 1 AND allow_match = 1 AND "
                . "( infofrom = '0' OR infofrom = '5' ) AND expiretime > $limit_time";
        
        $str_streetid = implode( ',' , $street_info ) ;
        $cond_where .= " AND ( street IN (".$str_streetid.") "
                . "OR street1 IN (".$str_streetid.") OR street2 IN (".$str_streetid.") )";

        $demands_num = $this->get_count_by_cond( $cond_where );
        
        return $demands_num ;
    }
    
    
    /**
    *
    * ݾ˱Żȡ뾭˷ԴƥϢϢб
    *
    * @access	public
    * @param	int     $uid    ˱
    * @param	int     $offset ƫ,ĬֵΪ0
    * @param	int     $pagesize ÿȡĬֵΪ10
    * @param	string  $order_key ֶΣĬֵ
    * @param	string  $order_by  򡢽ĬϽ
    * @return	array   ƥϢ
    */
    public function get_demand_list_by_uid( $uid , $offset = 0 , $limit = 10 
            , $order_key = 'creattime' , $order_by = 'DESC' )
    {   
        //ԴϢ
        $arr_data = array();
        
        //˷ԴİϢ[ȡԴ࣬ȡзԴ漰İϢ]
        $street_info = $this->_get_streetinfo_by_uid( $uid );
        
        //ĬϵĲѯ
        $limit_time = time() + 86400;
        $cond_where = "esta = 1 AND allow_match = 1 AND "
                . "( infofrom = '0' OR infofrom = '5' ) AND expiretime > $limit_time";
        
        //жǷڰϢ
        if( is_array( $street_info ) && !empty( $street_info ) )
        {
            $str_streetid = implode( ',' , $street_info ) ;
            $cond_where .= " AND ( street IN (".$str_streetid.") OR "
                . "street1 IN (".$str_streetid.") OR street2 IN (".$str_streetid.") )";
        }
        else
        {
           return  $arr_data;
        }
       
        $arr_data = $this->get_list_by_cond( $cond_where , $offset , $limit , $order_key , $order_by );
        
        return $arr_data ;
    }
}
/* End of file rent_demand_model.php */
/* Location: ./app/models/rent_demand_model.php */
