<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Vas_packing_house_zhou extends MY_Controller {

    /**
     * 
     *
     * @access public
     * @return void
     */
    public function __construct($type = NULL) {
        parent::__construct($type);
        $this->config_cityflag = 'nj';
        $this->load->model('broker_model');
        $this->load->model('payment_model');
        $this->house = $this->config->item('house');
        $this->load->helper('common_url_helper');
        //ûϢʼ
        $info = $this->broker_model->get_user_session();
		
		
        $groupId = $info['package_id']; //ײ
        $gbc = new GrowthBrokerCredit(array('id' => $info['uid'], 'groupid' => $groupId));
        $gbe = new GrowthBrokerExp(array('id' => $info['uid'], 'groupid' => $groupId));
        //
        $info['credit'] = $gbc->getValidCredit();
        //ȼ
        $info['level'] = $gbe->getLevel(2);
        //
        $info['exp'] = $gbe->getExp();
        $this->info = $info;
    }

    /**
     * Դװҳ
     */
    public function index() {
		
        $check = $this->checkVasLevel();
        if ($check !== true) {
            $page_text = "&nbsp;<span style='color:green;'>{$check}</span>&nbsp;Ϳʹô˹Ŷ <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ȥɣͣ";
            $this->jump('/', $page_text, 4000);
            return;
        }

        $packType = $this->input->get('type', TRUE);
        $packTypeArr = array("Mansionshow", "Search", "Video");
        if ($packType == "") {
            //$packType = "Search";
			$packType = "Mansionshow";
        } elseif (in_array($packType, $packTypeArr)) {
            $packType = $packType;
        } else {
            //$packType = "Search";
			$packType = "Mansionshow";
        }
        $viewData['page_title'] = 'Դװ';
        $viewData['info'] = $this->info;
        $viewData['documentation'] = $this->config->item('documentation');
        //ȡԴװ۸
		
		// 2016-1-14 Ǽ -----------start -------->
		
		$this->load->model('broker_zhou_model');
		
		$broker_new_info =$this->broker_zhou_model->get_broker_info_by_uid($this->info['uid']);
		// 2016-1-14 Ǽ -----------end -------->
		
        $VasPrice = new VasPrice();
        $viewData['price'] = $VasPrice->findByType($packType);
        //ȡԴװѹ
        $VasQueueLimit = new VasQueueLimit();
		
        $viewData['buy_num'] = $VasQueueLimit->findtypenum($packType);
        $viewData['limit_num'] = $VasQueueLimit->findtypelimitnum($packType);
        $viewData['pack_type'] = $packType;
        $viewData['payment_url'] = $this->payment_model->get_module_url('recharge');        
        
        $viewData['house_num'] = $this->getHouseNum($packType);//ķԴ
        $viewData['google_analytics'] = get_ga_js_code('/Ӫ/Դװ/Ҫ/');

		$viewData['broker_new_info'] = $broker_new_info;
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
		//echo $this->getIndexTemplet($packType);die;
		//print_r($viewData);die;
        $this->view('market', 'vas/vas_show_zhou', $viewData);
    }

   

    /**
     * Դװб
     */
    public function orderlist() {
        $check = $this->checkVasLevel();
        if ($check !== true) {
            $page_text = "&nbsp;<span style='color:green;'>{$check}</span>&nbsp;Ϳʹô˹Ŷ <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ȥɣͣ";
            $this->jump('/', $page_text, 4000);
            return;
        }


        $viewData['page_title'] = 'Դװб';
        $viewData['info'] = $this->info;
        $viewData['documentation'] = $this->config->item('documentation');
        $viewData['packing_house_staus'] = $this->config->item('packing_house_staus');
        $viewData['packing_house'] = $this->config->item('packing_house');
        //ȡԴװ۸
        $VasPrice = new VasPrice();
        $viewData['price'] = $VasPrice->findByType('Search');
        //ȡԴװѹ
        $VasQueueLimit = new VasQueueLimit();
        $viewData['buy_num'] = $VasQueueLimit->findtypenum('Search');
        $viewData['limit_num'] = $VasQueueLimit->findtypelimitnum('Search');

        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        $viewData['payment_url'] = $this->payment_model->get_module_url('recharge');
        //ȡ
        $VasRecord = new VasRecord('vas_packing_house_record');
        $where = "uid = " . $this->user_arr['uid'];
        if ($this->input->post('packing_house_staus')) {
            $viewData['packing_staus'] = $this->input->post('packing_house_staus');
            $where .= " and status=" . $viewData['packing_staus'];
        }
        $viewData['record_num'] = $VasRecord->findNumberBy($where);
        $viewData['pagesize'] = 15; //趨ÿһҳʾļ¼
        $viewData['pages'] = $viewData['record_num'] ? ceil($viewData['record_num'] / $viewData['pagesize']) : 0;  //ҳ
        $viewData['page'] = $this->input->post('page') ? intval($this->input->post('page')) : 1; // ȡǰҳ
        $viewData['page'] = ($viewData['page'] > $viewData['pages'] && $viewData['pages'] != 0) ? $viewData['pages'] : $viewData['page'];  //жתҳ
        $viewData['offset'] = $viewData['pagesize'] * ($viewData['page'] - 1);   //¼ƫ
        //Ƿʾҳ
        $pagination = NULL;
        if ($viewData['record_num'] > $viewData['pagesize']) {
            $viewData['pagination'] = helper_pagination($viewData['page'], $viewData['pages'], $viewData['record_num']);
        }
        $recordlist = $VasRecord->findBy($where, 'buy_time desc', $viewData['pagesize'], $viewData['offset']);
        $Vas_packing_house = new VasRecord('vas_packing_house');
        if (is_array($recordlist) && !empty($recordlist)) {
            foreach ($recordlist as $key => $value) {
				$housestr = "";
                $conf = "record_id =" . $value['id'];
                $housedetail = $Vas_packing_house->findBy($conf);
                if (is_array($housedetail) && !empty($housedetail)) {
                    $housestr = '';
                    foreach ($housedetail as $value2) {
                        $housestr .= '<a class="c1" href="' . get_sellinfo_url($value2['houseid']) . '" target="_blank">' . $value2['houseid'];
                        $housestr.= $value2['house_typ'] == 2 ? '</a> ' : ' </a>';
                    }
                }
                $viewData['recordlist'][$key] = $value;
                $viewData['recordlist'][$key]['housestr'] = $housestr;
				
            }
        }
        $viewData['google_analytics'] = get_ga_js_code('/Ӫ/Դװ/ҵĹ¼/');
        $this->view('market', 'vas/vas_orderlist', $viewData);
    }

    /**
     * Index Page for this controller.
     */
    public function buy() {
        $check = $this->checkVasLevel();
        if ($check !== true) {
            $page_text = "&nbsp;<span style='color:green;'>{$check}</span>&nbsp;Ϳʹô˹Ŷ <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ȥɣͣ";
            $this->jump('/', $page_text, 4000);
            return;
        }

        $viewData['page_title'] = 'Դװб';
        $viewData['info'] = $this->info;
        //طԴ
        $this->load->model('sell_model');
        $uid = $this->user_arr['uid']; //˺
        //ѯԴ
        $cond_where = "uid = '" . $uid . "' AND esta = 1  AND infofrom = '5' ";
        $viewData['house_all'] = $this->sell_model->find_all_by($cond_where, 0, 200);
        //ȡԴװ۸
        $VasPrice = new VasPrice();
        $viewData['price'] = $VasPrice->findByType('Search');
        //ȡԴװѹ
        $VasQueueLimit = new VasQueueLimit();
        $viewData['buy_num'] = $VasQueueLimit->findtypenum('Search');
        $viewData['limit_num'] = $VasQueueLimit->findtypelimitnum('Search');
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/jquery.mCustomScrollbar.css');
        $viewData['payment_url'] = $this->payment_model->get_module_url('recharge');
        $this->load->model('street_model');
        $this->view('market', 'vas/vas_packing_buy', $viewData);
    }

    /**
     * Ƶ
     * vas_video
     * 
     */
    public function vas_video() {
        $check = $this->checkVasLevel();
        if ($check !== true) {
            $page_text = "&nbsp;<span style='color:green;'>{$check}</span>&nbsp;Ϳʹô˹Ŷ <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ȥɣͣ";
            $this->jump('/', $page_text, 4000);
            return;
        }

        $viewData['page_title'] = 'Դװб';
        $viewData['info'] = $this->info;
        //طԴ
        $this->load->model('sell_model');
        $uid = $this->user_arr['uid']; //˺
        //ѯԴ
        // $cond_where = "uid = '".$uid."' AND esta = 1  AND infofrom = '5'";
        $cond_where = "uid = '" . $uid . "' AND esta = 1  AND infofrom = '5' AND fitment IN('װ','װ')";
        $viewData['house_all'] = $this->sell_model->find_all_by($cond_where, 0, 200);

        //ȡԴװ۸
        $VasPrice = new VasPrice();
        $viewData['price'] = $VasPrice->findByType('Video');
        //ȡԴװѹ
        $VasQueueLimit = new VasQueueLimit();
        $viewData['buy_num'] = $VasQueueLimit->findtypenum('Video');
        $viewData['limit_num'] = $VasQueueLimit->findtypelimitnum('Video');
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/jquery.mCustomScrollbar.css');
        $viewData['payment_url'] = $this->payment_model->get_module_url('recharge');
        $this->load->model('street_model');
        $this->view('market', 'vas/vas_video_buy', $viewData);
    }

    /**
     * vas_show
     * լ
     */
    public function vas_show() {
        $check = $this->checkVasLevel();
        if ($check !== true) {
            $page_text = "&nbsp;<span style='color:green;'>{$check}</span>&nbsp;Ϳʹô˹Ŷ <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ȥɣͣ";
            $this->jump('/', $page_text, 4000);
            return;
        }
        $packType = "Mansionshow";
        $viewData['page_title'] = 'Դװб';
        $viewData['info'] = $this->info;
        //طԴ
        $this->load->model('sell_model');
        $uid = $this->user_arr['uid']; //˺
        //ѯԴ
        // $cond_where = "uid = '".$uid."' AND esta = 1  AND infofrom = '5'";
        $cond_where = "uid = '" . $uid . "' AND esta = 1  AND infofrom = '5' AND fitment IN('װ','װ') AND buildarea>=90 AND room>=3";
        $viewData['house_all'] = $this->sell_model->find_all_by($cond_where, 0, 200);

        //ȡԴװ۸
        $VasPrice = new VasPrice();
        $viewData['price'] = $VasPrice->findByType($packType);
        //ȡԴװѹ
        $VasQueueLimit = new VasQueueLimit();
        $viewData['buy_num'] = $VasQueueLimit->findtypenum($packType);
        $viewData['limit_num'] = $VasQueueLimit->findtypelimitnum($packType);
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/jquery.mCustomScrollbar.css');
        $viewData['payment_url'] = $this->payment_model->get_module_url('recharge');
        $this->load->model('street_model');
        $this->view('market', 'vas/vas_show_buy', $viewData);
    }

    /**
     * ɶ
     */
    public function addorder() {
        $broker['id'] = $this->info['uid'];
        $broker['groupid'] = $this->info['package_id'];
        $str = $this->input->post('str');
        $str = rtrim($str, ',');
        $id_arr = explode(',', $str);
        //Դ
        if (count($id_arr) < 5) {
            echo json_encode(array('status' => '2', 'msg' => 'Դ'));
            exit;
        }

        //ȡԴװѹ
        $VasQueueLimit = new VasQueueLimit();
        $viewData['buy_num'] = $VasQueueLimit->findtypenum('Search');
        $viewData['limit_num'] = $VasQueueLimit->findtypelimitnum('Search');
        if ($viewData['buy_num'] >= $viewData['limit_num']) {
            echo json_encode(array('status' => '2', 'msg' => ''));
            exit;
        }
        //ȡԴװ۸   
        $truthPrice = $this->getTruthPrice('Search');
        //
        $myDou = $this->info['credit'];
        if($myDou<$truthPrice){
            echo json_encode(array('status'=>'4','msg'=>'Բķ㣬ֵ'));exit;            
        }
        //ȡԴװ۸
        $price = $truthPrice;
        $GrowthBrokerCredit = new GrowthBrokerCredit($broker);
        $pay_order = $GrowthBrokerCredit->reduce('packingHouse', 'Դװ', $price);
        if ($pay_order['status'] == 1) {
            //¼ϸϢ
            $fieldData = array('type' => 'Search', 'uid' => $this->info['uid'], 'buy_time' => date("Y-m-d H:i:s", time()), 'order_id' => $pay_order['transaction_id'], 'cost' => $price, 'status' => 1);
            $VasSetPromotRecord = new VasSetPromotRecord('vas_packing_house_record');
            $record_id = $VasSetPromotRecord->insert($fieldData);
            //¼ԴϢ
            if (!empty($id_arr)) {
                $Vas_packing_house = new VasSetPromotRecord('vas_packing_house');
                foreach ($id_arr as $key => $value) {
                    $house_typ = $key >= 5 ? 2 : 1;
                    $fieldData = array('record_id' => $record_id, 'houseid' => $value, 'house_typ' => $house_typ);
                    $Vas_packing_house->insert($fieldData);
                }
            }
            //¹
            $fieldData = array('number' => $viewData['buy_num'] + 1);
            $conf = "type = 'Search'";
            $VasQueueLimit->update($fieldData, $conf);
            //ӹ
            $VasBroker = new VasBroker();
            //2ʾԴװ
            $VasBroker->addJoinVasRecord(2, $broker['id']);
        }
        print json_encode($pay_order);
    }

    /**
     * addorder_video
     * Ƶɶ
     */
    public function addorder_video() {
        $packType = "Video";
        $broker['id'] = $this->info['uid'];
        $broker['groupid'] = $this->info['package_id'];
        $rowid = $this->input->post('rowid', TRUE);
		
        //طԴ
        $this->load->model('sell_model');
        $houseInfo = $this->sell_model->find_by_id($rowid);
        if ($houseInfo['uid'] != $this->info['uid'] || !in_array($houseInfo['fitment'], array('װ', 'װ'))) {
            echo json_encode(array('status' => '2', 'msg' => 'Դ'));
            exit;
        }

        //ȡԴװѹ
        $VasQueueLimit = new VasQueueLimit();
        $viewData['buy_num'] = $VasQueueLimit->findtypenum($packType);
        $viewData['limit_num'] = $VasQueueLimit->findtypelimitnum($packType);
        if ($viewData['buy_num'] >= $viewData['limit_num']) {
            echo json_encode(array('status' => '4', 'msg' => ''));
            exit;
        }	
		
        $truthPrice = $this->getTruthPrice($packType);//var_dump($truthPrice);
        //
        $myDou = $this->info['credit'];
        if($myDou<$truthPrice){
            echo json_encode(array('status'=>'4','msg'=>'Բķ㣬ֵ'));exit;            
        }
        //ȡԴװ۸     
        $price = $truthPrice;       
        $GrowthBrokerCredit = new GrowthBrokerCredit($broker);
        $pay_order = $GrowthBrokerCredit->reduce('packingHouse', 'ƵԴ-Դװ', $price);
        if ($pay_order['status'] == 1) {
            //¼ϸϢ
            $fieldData = array('type' => $packType, 'uid' => $this->info['uid'], 'buy_time' => date("Y-m-d H:i:s", time()), 'order_id' => $pay_order['transaction_id'], 'cost' => $price, 'status' => 1);
            $VasSetPromotRecord = new VasSetPromotRecord('vas_packing_house_record');
            $record_id = $VasSetPromotRecord->insert($fieldData);
            //¼ԴϢ
            if ($record_id>0) {
                $Vas_packing_house = new VasSetPromotRecord('vas_packing_house');
                $fieldData = array('record_id' => $record_id, 'houseid' => $rowid, 'house_typ' => 1);
                $Vas_packing_house->insert($fieldData);
				
            }

            //¹           
            $VasQueueLimit->addNumberToOneType($packType, 1);
            //ӹ
            $VasBroker = new VasBroker();
            //2ʾԴװ
            $VasBroker->addJoinVasRecord(2, $broker['id']);
        }
        print json_encode($pay_order);
    }

    /**
     * addorder_show
     * Ƶɶ
     */
    public function addorder_show() {
        $packType = "Mansionshow";
        $broker['id'] = $this->info['uid'];
        $broker['groupid'] = $this->info['package_id'];
        $rowid = $this->input->post('rowid', TRUE);
        //жϷԴ
		$this->load->model('sell_model');
        $houseInfo = $this->sell_model->find_by_id($rowid);
        if ($houseInfo['uid'] != $this->info['uid'] || !in_array($houseInfo['fitment'], array('װ', 'װ')) || $houseInfo['room'] < 3 || $houseInfo['buildarea'] < 90) {
            echo json_encode(array('status' => '2', 'msg' => 'Դ'));
            exit;
        }
        //ȡԴװѹ
        $VasQueueLimit = new VasQueueLimit();
        $viewData['buy_num'] = $VasQueueLimit->findtypenum($packType);
        $viewData['limit_num'] = $VasQueueLimit->findtypelimitnum($packType);
        if ($viewData['buy_num'] >= $viewData['limit_num']) {
            echo json_encode(array('status' => '4', 'msg' => ''));
            exit;
        }        
        
        $truthPrice = $this->getTruthPrice($packType);
        //
        $myDou = $this->info['credit'];
        if($myDou<$truthPrice){
            echo json_encode(array('status'=>'4','msg'=>'Բķ㣬ֵ'));exit;            
        }
        //ȡԴװ۸            
        $price = $truthPrice;
        $GrowthBrokerCredit = new GrowthBrokerCredit($broker);        
        $pay_order = $GrowthBrokerCredit->reduce('packingHouse', 'լ-Դװ', $price);
        if ($pay_order['status'] == 1) {
            //¼ϸϢ
            $fieldData = array('type' => $packType, 'uid' => $this->info['uid'], 'buy_time' => date("Y-m-d H:i:s", time()), 'order_id' => $pay_order['transaction_id'], 'cost' => $price, 'status' => 1);
            $VasSetPromotRecord = new VasSetPromotRecord('vas_packing_house_record');
            $record_id = $VasSetPromotRecord->insert($fieldData);
            //¼ԴϢ
            if ($record_id>0) {
                $Vas_packing_house = new VasSetPromotRecord('vas_packing_house');
                $fieldData = array('record_id' => $record_id, 'houseid' => $rowid, 'house_typ' => 1);
                $Vas_packing_house->insert($fieldData);
            }

            //¹           
            $VasQueueLimit->addNumberToOneType($packType, 1);
            //ӹ
            $VasBroker = new VasBroker();
            //2ʾԴװ
            $VasBroker->addJoinVasRecord(2, $broker['id']);
        }
        print json_encode($pay_order);
    }
    
    /**
     * ĳµķԴ
     * getHouseNum
     * @param string $type 
     * @return int $house_num 
     */
    private function getHouseNum($type){  
        $key = $this->config_cityflag."_vas_packing_house_get_house_num_".$type;
        $house_num = $this->mc->get($key);
        if($house_num === false) {
            //طԴ
            $this->load->model('sell_model');
            $uid = $this->user_arr['uid']; //˺
            //ѯԴ
            switch ($type){
                case 'Search':  $cond_where = "uid = '" . $uid . "' AND esta = 1  AND infofrom = '5' ";
                    break;
                case 'Mansionshow': $cond_where = "uid = '" . $uid . "' AND esta = 1  AND infofrom = '5' AND fitment "
                        . "IN('װ','װ') AND buildarea>=90 AND room>=3";
                    break;
                case 'Video':         $cond_where = "uid = '" . $uid . "' AND esta = 1  AND infofrom = '5' "
                        . "AND fitment IN('װ','װ')";
                    break;
                default : $cond_where = "uid = '" . $uid . "' AND esta = 1  AND infofrom = '5' ";
            }          
            $house_num = $this->sell_model->find_count_by($cond_where);
            $this->mc->set($key,$house_num,20);
        }
        return $house_num; 
    }
    
    
     /**
     * ȡҳģ
     * getIndexTemplet
     * @param string $searchType Դװ
     * @return string $templet 
     */
    private function getIndexTemplet($searchType) {
        switch ($searchType) {
            case 'Search': $templet = "vas/vas_packing";
                break;
            case 'Video' : $templet = "vas/vas_video";
                break;
            case 'Mansionshow' : $templet = "vas/vas_show";
                break;
            //default : $templet = "vas/vas_packing";
			default : $templet = "vas/vas_show";
        }
        return $templet;
    }
    
    
    
    
    /**
     * ȡռ۸
     */
    private function getTruthPrice($type){
        $key = $this->config_cityflag."_vas_set_promot_truth_price_".$type;
        $SchoolNowPrice = $this->mc->get($key);
        if($SchoolNowPrice === false) {
            $this->VasPrice = new VasPrice(); 
            $SchoolNowPrice = $this->VasPrice->ServicePrice($type);//ƽʵʼ۸
            $this->mc->set($key,$SchoolNowPrice,600);	
        }
        return $SchoolNowPrice;      
    }
    
    

    /**
     *
     * @return boolean ɹʱtrueʧʱصȼ
     */
    private function checkVasLevel() {
        //жȨ
        $brokerLevel = $this->info['level'];
        //˲ȼȨ
        $permi = new GrowthLevelWayPermission();
        $minLevel = $permi->findMinLevelByWayAliasAndType('packingHouse', 2);

        if ($brokerLevel < $minLevel || $minLevel == '') {
            return $minLevel;
        } else {
            return true;
        }
    }

}

/* End of file validcode.php */
/* Location: ./application/controllers/validcode.php */

