<?php if (!defined('BASEPATH'))exit('No direct script access allowed');

/**
 * statistics_analysis Class
 *
 * ۱ַͳģ
 *
 * @package		zsb
 * @subpackage	Controllers
 * @category	Controllers
 * @author      liuhu
 */

class statistics_analysis_li extends MY_Controller {
    
	/**
	*
	* @var Statistics 
	*/
    public $stat;

	/**
    * ǰûuid
    *
    * @access private
    * @var int
    */
    private $uid;


    private $info;

	/**
    * ǰҳ
    *
    * @access private
    * @var string
    */
    private $_current_page = 1;

    /**
    * ÿҳĿ
    *
    * @access private
    * @var int
    */
    private $_limit = 7;

    /**
    * ƫ
    *
    * @access private
    * @var int
    */
    private $_offset = 0;

    /**
    * Ŀ
    *
    * @access private
    * @var int
    */
    private $_total_count = 0;

    public function __construct() 
	{
        parent::__construct();

        $this->load->model('statistics_model','stat');
        $this->load->model('broker_check');
        $this->load->library('TabPage');
        $this->load->library('statistics_plus');

        $info = $this->broker_model->get_user_session();
        $this->info = $info;
        $this->uid = $info['uid'];
    }

	
	/**
    * ʼҳ
    *
    * @access public
    * @param  int  $current_page
    * @param  int  $page_size
    * @return void
    */
    private function _init_pagination($current_page = 1 , $page_size = 0)
    {
        /** ǰҳ */
        $this->_current_page = ( $current_page && is_numeric( $current_page ) ) ?
                intval( $current_page ) : 1;

        /** ÿҳ */
        $this->_limit = ( $page_size && is_numeric( $page_size ) ) ?
                intval( $page_size ) : $this->_limit;

        /** ƫ */
        $this->_offset = ( $this->_current_page - 1 ) * $this->_limit;

        if($this->_offset < 0)
        {
            redirect(base_url());
        }
    }

    
    public function index() 
    {
        $this->today();
    }


    /**
     * ʹøſ 
     */
    public function today() 
    {
        $viewData = array();
        $groupId = $this->info['package_id'];//ײ
        $brokerType = $this->info['groupid'];//or
        
        //ʱ
        $data['time'] = date("Y-m-d H:i");

        //ոſ
        $overViewToday = $this->stat->overViewToday($this->uid,$groupId);
        $data = array_merge($data, $overViewToday);

        $viewData['data'] = $data;
        //tabҳ
        $curPage = 'today';
        $viewData['tab'] = $this->overViewTab($curPage);
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        $viewData['page_title'] = '۱-ʹøſ-';
		$viewData['google_analytics'] = get_ga_js_code('/ͳƷ/ʹøſ/ոſ/');
        $this->view('statics', 'statistics_analysis/today_li', $viewData);
    }
    
    /**
     * ʹøſ ʷ
     */
    public function history()
    {
        $viewData = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        //Ĭһ
		$stime = $this->input->post('stime', TRUE);
        if($stime === FALSE) 
		{
            $stime = date("Y-m-d",strtotime("-7days"));
        }
        $viewData['stime'] = $stime;

        $etime = $this->input->post('etime',TRUE);
        if($etime === FALSE) 
		{
            $etime = date("Y-m-d",strtotime("-1days"));
        }
        $viewData['etime'] = $etime;


		/** ҳ */
		$page = $this->input->post( 'page' , TRUE);
        $page = (isset($page)&& intval($page) > 0) ? intval($page) : 1;
        $this->_init_pagination($page);
        $this->_total_count = $this->stat->historyCount($this->uid, $stime, $etime);
		$pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;
        $viewData['list'] = $this->stat->historyList($this->uid, $stime, $etime, $this->_offset , $this->_limit);

        foreach ($viewData['list'] as &$value) 
		{
            $value['house_add'] = $value['sell_add'] + $value['rent_add'];
            $value['house_add_valid'] = $value['sell_add_valid'] + $value['rent_add_valid'];
            $value['remain_refresh'] = $value['total_refresh'] >= $value['refresh'] ?
				$value['total_refresh'] - $value['refresh'] : 0;
            $value['remain_tag_num'] = $value['package_tag_num'] >= $value['is_tag_num'] ?
				$value['package_tag_num'] - $value['is_tag_num'] : 0;
            $value['remain_nofee_num'] = $value['nofee_limit'] - $value['nofee_num'];
        }

		//Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {	
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }

        //tabҳ
        $curPage = 'history';
        $viewData['tab'] = $this->overViewTab($curPage);
        
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        //js
        $viewData['js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
        $viewData['page_title'] = '۱-ʹøſ-ʷ';
		$viewData['google_analytics'] = get_ga_js_code('/ͳƷ/ʹøſ/ʷſ/');
		$viewData['page']  = $this->_current_page;
        $viewData['pagination'] = $pagination;
        $this->view('statics', 'statistics_analysis/history', $viewData);
    }

	
	/**
     * ʹøſ ʷ
     */
    public function history_download()
    {
		$broker_info = array();

        //Ĭһ
		$stime = $this->input->post('stime', TRUE);
        if($stime === FALSE) 
		{
            $stime = date("Y-m-d",strtotime("-7days"));
        }
        $viewData['stime'] = $stime;

        $etime = $this->input->post('etime',TRUE);
        if($etime === FALSE) 
		{
            $etime = date("Y-m-d",strtotime("-1days"));
        }
        $viewData['etime'] = $etime;


		/** ҳ */
        $broker_info = $this->stat->historyList($this->uid, $stime, $etime, 0 , 60);

		/** PHPExcel_IOFactory */
		$this->load->library('PHPExcel');
		$this->load->library('PHPExcel/IOFactory');

		//ʼ
		$objReader = new IOFactory('Excel5');

		//ģ
		if(!empty($broker_info))
		{
			$tplname =	APPPATH.'views/statistics_analysis/broker_use_statistic_temp.xls' ;
		}
		else
		{
			$tplname =	APPPATH.'views/statistics_analysis/broker_use_statistic_temp_nodata.xls' ;
		}
		$objPHPExcel = $objReader->load($tplname);

		//Ԫֵ
		$baseRow = 3;
		if(is_array($broker_info) && !empty($broker_info))
		{
			foreach($broker_info as $r => $dataRow) 
			{	
				$remain_refresh = $dataRow['total_refresh'] >= $dataRow['refresh'] ?
				$dataRow['total_refresh'] - $dataRow['refresh'] : 0;
				$remain_tag_num = $dataRow['package_tag_num'] >= $dataRow['is_tag_num'] ?
				$dataRow['package_tag_num'] - $dataRow['is_tag_num'] : 0;
				$remain_nofee_num = $dataRow['nofee_limit'] - $dataRow['nofee_num'];

				$row = $baseRow + $r;
				$objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
				$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $dataRow['stattime'])
					  ->setCellValue('B'.$row, intval( $dataRow['sell_house_num'] ) )
					  ->setCellValue('C'.$row, $dataRow['rent_house_num'])
					  ->setCellValue('D'.$row, intval($dataRow['sell_star_num']) )
					  ->setCellValue('E'.$row, intval($dataRow['rent_star_num']) )
					  ->setCellValue('F'.$row, intval( $dataRow['sell_add']+$dataRow['rent_add'] ) )
					  ->setCellValue('G'.$row, intval( $dataRow['sell_add_valid']+$dataRow['rent_add_valid'] ) )
					  ->setCellValue('H'.$row, intval( $dataRow['refresh'] ) )
					  ->setCellValue('I'.$row, intval( $remain_refresh ) )
					  ->setCellValue('J'.$row, intval( $dataRow['is_tag_num'] ) )
					  ->setCellValue('K'.$row, $remain_tag_num)
					  ->setCellValue('L'.$row, intval( $dataRow['nofee_num'] ))
					  ->setCellValue('M'.$row, intval( $dataRow['nofee_limit'] ))
					  ->setCellValue('N'.$row, intval( $dataRow['click_num'] ) );
			}
		}

		$outputFileName = 'ʹͳ.xls';
		header('Content-Type: application/vnd.ms-excel');
		header("Content-Disposition: attachment;filename=".$outputFileName."");
		header('Cache-Control: max-age=0');
		$objWriter = IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
		exit;
    }


    /**
     * ʹ־
     */
    public function log() 
    {
		
        $viewData = array();
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
		$app	= '';

        //
        $type = $this->input->post( 'type' , TRUE);

		if($type === FALSE) 
		{
            $type = 0;
        }

		/** ҳ */
		$page = $this->input->post( 'page' , TRUE);
        $page = (isset($page)&& intval($page) > 0) ? intval($page) : 1;
        $this->_init_pagination($page);

        $types = array(0 => 'ȫ', 1 => '',2 => 'ˢ',3 => 'ɾ',4 => 'ʧЧ',5 => '');
        if( !in_array( $type , array_keys($types)) ) 
		{
            $type = 0;
        }

        $viewData['types'] = $types;
        $viewData['type'] = $type;

        //ͳƵڣĬ
        $count_day = $this->input->post('count_day', TRUE);

        if($count_day === FALSE)
		{
            $yesterday  = date('Y-m-d', mktime(0, 0, 0, date('m'), date('d') - 1, date('Y')));
            $count_day = $yesterday;
        }
		
        $viewData['count_day'] = $count_day;
		$day	= date('Ymd' , strtotime($count_day));
		$this->_total_count = $this->statistics_plus->getOperateCount($day , $this->uid , $type , $app);
		//ҳ
		$this->_total_count = (int)$this->_total_count;
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;
		
        $viewData['list'] = $this->statistics_plus->getOperateListByType( $day , $this->uid ,'' , $this->_offset, $this->_limit , 0 , $type);

		//Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {	
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }
		
        $curPage = 'log';
        $viewData['tab'] = $this->logTab($curPage);
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        $viewData['js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
        $viewData['page_title'] = '۱-ͳƷ-ʹ־';
		$viewData['google_analytics'] = get_ga_js_code('/ͳƷ/ʹ־/Դ/');
		$viewData['page']  = $this->_current_page;
        $viewData['pagination'] = $pagination;
        $this->view('statics', 'statistics_analysis/log', $viewData);
    }


	
    
    /**
     * ǩʹ
     */
    public function label() 
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->load->model('house_tag');
        $viewData = array();
        
        //ʱĬһ
		$stime = $this->input->post('stime', TRUE);
        if($stime === FALSE) 
		{
            $stime = date("Y-m-d",strtotime("-7days"));
        }
        $viewData['stime'] = $stime;

        $etime = $this->input->post('etime',TRUE);
        if($etime === FALSE) 
		{
            $etime = date("Y-m-d",strtotime("-1days"));
        }
        $viewData['etime'] = $etime;
        
		/** ҳ */
		$page = $this->input->post('page' , TRUE);
        $page = (isset($page)&& intval($page) > 0) ? intval($page) : 1;
        $this->_init_pagination($page);

        $this->_total_count = $this->house_tag->findCountByUidTime($this->uid, $stime, $etime);
        $viewData['list'] = $this->_total_count ? $this->house_tag->findByUidTime($this->uid, $stime, $etime, $this->_offset, $this->_limit):array();

        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;

		//Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }
        
        $curPage = 'label';
        $viewData['tab'] = $this->logTab($curPage);
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        $viewData['js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
        $viewData['page_title'] = '۱-ͳƷ-ǩʹ';
		$viewData['google_analytics'] = get_ga_js_code('/ͳƷ/ʹ־/ǩʹ/');
		$viewData['page']  = $this->_current_page;
        $viewData['pagination'] = $pagination;
        $this->view('statics', 'statistics_analysis/label', $viewData);
    }
    
    /**
     * ¼ʷ
     */
    public function login_history() 
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $viewData = array();
        
        //ͳƵڣĬ
        $count_day = $this->input->post('count_day', TRUE); // 
        if($count_day === FALSE) {
            $yesterday  = date('Y-m-d', mktime(0, 0, 0, date('m'), date('d') - 1, date('Y')));
            $count_day = $yesterday;
        }
        $viewData['count_day'] = $count_day;
        
		/** ҳ */
		$page = $this->input->post( 'page' , TRUE);
        $page = (isset($page)&& intval($page) > 0) ? intval($page) : 1;
        $this->_init_pagination($page);
        
        $day	= date('Ymd',strtotime($count_day));
        $this->_total_count = $this->statistics_plus->getLoginCount($day, $this->uid);
        
        $viewData['list'] = $this->statistics_plus->getLoginList($day,$this->uid,'sell',$this->_offset, $this->_limit);
        
        $pages  = !empty($this->_total_count) ? ceil( $this->_total_count / $this->_limit ) : 0;

		//Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }

        $curPage = 'login_history';
        $viewData['tab'] = $this->logTab($curPage);
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        $viewData['js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
        $viewData['page_title'] = '۱-ͳƷ-¼ʷ';
		$viewData['google_analytics'] = get_ga_js_code('/ͳƷ/ʹ־/¼ʷ/');
		$viewData['page']  = $this->_current_page;
        $viewData['pagination'] = $pagination;
        $this->view('statics', 'statistics_analysis/login_history', $viewData);
    }
    
    /**
     * Υ¼
     */
    public function violation() 
    {
        $viewData = array();
        
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        //
        $type = $this->input->post('type',TRUE);
        if($type === FALSE) {
            $type = 'frozen';
        }
        $types = array('frozen'=>'ԴΥ','pic'=>'ͼƬΥ',);
        if(!in_array($type, array_keys($types))) {
            show_404();
        }
        $viewData['types'] = $types; 
        $viewData['type'] = $type;
        
        //ʱĬһ
        $etime = $this->input->post('etime',TRUE);
        if($etime === FALSE) {
            $etime = date("Y-m-d",strtotime("-1days"));
        }
        $viewData['etime'] = $etime;

        $stime = $this->input->post('stime', TRUE);
        if($stime === FALSE) {
            $stime = date("Y-m-d",strtotime("-7days"));
        }
        $viewData['stime'] = $stime;
        
		/** ҳ */
		$page = $this->input->post( 'page' , TRUE);
        $page = (isset($page)&& intval($page) > 0) ? intval($page) : 1;
        $this->_init_pagination($page);
        $this->_total_count = $this->getVTotal($type,$stime, $etime);
        
        $viewData['list'] = $this->_total_count ? $this->getVList($type, $stime, $etime, $this->_offset, $this->_limit) : array();

		$pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;

		//Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }
        
        $curPage = 'violation';
        $viewData['tab'] = $this->logTab($curPage);
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        $viewData['js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
        $viewData['page_title'] = '۱-ͳƷ-Υ¼';
		$viewData['google_analytics'] = get_ga_js_code('/ͳƷ/ʹ־/Υ¼/');
		$viewData['page']  = $this->_current_page;
        $viewData['pagination'] = $pagination;
        $this->view('statics', 'statistics_analysis/violation', $viewData);
    }
    

    /**
     * ͳ
     */
    public function click() 
    {
        $viewData = array();

        //ͳƵڣĬ
        $yesterday  = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d") - 1, date("Y")));

        $start_day = $this->input->post('start_day',TRUE);
        $end_day = $this->input->post('end_day',TRUE);

        $start_day  = !empty($start_day) ? $start_day : $yesterday;
        $end_day    = !empty($end_day) ? $end_day : $yesterday;
        
        //жʱ䣬ǷҪʼ
        $start_time = strtotime($start_day);
        $end_time   = strtotime($end_day);

        if($start_time > $end_time)
        {
            $temp_day   = $end_day;
            $end_day    = $start_day;
            $start_day  = $temp_day;
            //ʾͳ
            $viewData['day_show']   = $start_day .'  '. $end_day ;
        }
        else if($start_time == $end_time)
        {
            $viewData['day_show']   = $start_day ;
        }
        else
        {
             $viewData['day_show']   = $start_day .'  '. $end_day ;
        }

        //
        $diff_count = ($end_time - $start_time) / 86400 ;
        $i = 0;
        do{
            $countday_arr[$i] = date('Ymd',$start_time + (86400 * $i) );
            $countday_arr_Day[$i] = date('Y-m-d',$start_time + (86400 * $i) ) ;
            -- $diff_count;
            ++ $i;
        }while( $diff_count >= 0);
		
        //ͳơСʱͳ
        $countType  = $this->input->post('countType' , TRUE);
        $countType  = in_array($countType, array('Hour','Day')) ? $countType : 'Hour';

        //ʾ all-ȫsell-ַrent-ⷿ
        $showType  = $this->input->post('showType',TRUE);
        $showType   = in_array($showType,array('all','sell','rent')) ? $showType : 'all';
        
        //˱
        $uid = $this->user_arr['uid'];
        
        //ͳ
        $this->load->library('statistics');
        
        //ͨͳȡܵ
        $this->load->model('statistics_model');
        $click_info = $this->statistics_model->get_broker_clickdata($uid , $start_day , $end_day );
		
        if( $countType == 'Hour' )
        {
            //ʱηԴ
            $arr_sell   = array();
            $arr_rent   = array();
            $sellClickBYHour    = array();
            $rentClickBYHour    = array();
            $houseClickBYHour	= array();

            if( $showType == 'all' )
            {
                //ȫۼ
                if( is_array($countday_arr) && !empty($countday_arr) )
                {	
                    //ѭѡڵĵ
                    foreach( $countday_arr as $key => $day )
                    {   
                        $arr_sell[$day]   = $this->statistics->get_dayclickcount( $day, $uid , 'sell' );
                        $arr_rent[$day]   = $this->statistics->get_dayclickcount( $day, $uid , 'rent' );
                    }
                }
            }
            else if( $showType == 'sell' )
            {

                //ַԴۼ
                if(is_array($countday_arr) && !empty($countday_arr))
                {
                    //ѭѡڵĵ
                    foreach( $countday_arr as $key => $day )
                    {
                        $arr_sell[$day]   = $this->statistics->get_dayclickcount( $day, $uid , 'sell' );
                    }
                }
            }
            else if($showType == 'rent')
            {
                //ⷿԴۼ
                if(is_array($countday_arr) && !empty($countday_arr))
                {
                    //ѭѡڵĵ
                    foreach( $countday_arr as $key => $day )
                    {
                        $arr_rent[$day]   = $this->statistics->get_dayclickcount( $day, $uid , 'rent' );
                    }
                }
            }

            for ($i = 0 ; $i < 24 ; $i++)
            {
                //ѭַʱε֮
                if( $showType == 'all' || $showType == 'sell' )
                {
                    foreach($arr_sell as $key=>$value)
                    {   
                        if(isset($sellClickBYHour[$i]))
                        {
                            $sellClickBYHour[$i]  += isset($value[$i]) ? intval($value[$i]) : 0;
                        }
                        else
                        {
                            $sellClickBYHour[$i]  = isset($value[$i]) ? intval($value[$i]) : 0;
                        }
                    }
               }

                //ѭⷿʱε֮
                if( $showType == 'all' || $showType == 'rent' )
                {  
                    foreach($arr_rent as $key=>$value)
                    {   
                        if(isset($rentClickBYHour[$i]))
                        {
                            $rentClickBYHour[$i]  += isset($value[$i]) ? intval($value[$i]) : 0;
                        }
                        else
                        {
                            $rentClickBYHour[$i]  = isset($value[$i]) ? intval($value[$i]) : 0;
                        }
                    }                       
                }

                //Сʱܺ
                if( $showType == 'all' )
                {
                    $houseClickByHour[$i]  = $sellClickBYHour[$i] + $rentClickBYHour[$i];
                }
                else if($showType == 'sell')
                {
                    $houseClickByHour[$i]  = $sellClickBYHour[$i];
                }
                else if($showType == 'rent')
                {
                    $houseClickByHour[$i]  = $rentClickBYHour[$i];
                }

                $xAxis[$i] = $i;
            }

            //׼ʾ
            $viewData['clickNum_json']  = json_encode($houseClickByHour);
            $viewData['xAxis_json'] = json_encode($xAxis);
            $viewData['unit']   = 'ʱ';
        }
        else if( $countType == 'Day' )
        {
            if(is_array($countday_arr_Day) && !empty($countday_arr_Day))
            {
                $click_info_day = array();
                if(is_array($click_info) && !empty($click_info))
                {
                    foreach( $click_info as $key=>$value)
                    {
                        $click_info_day[$value['stattime']]	= $value;
                    }
                }

                //ѭѡڵĵ
                $count_day_num = count($countday_arr_Day);
                for( $i = 0; $i <  $count_day_num ; $i++ )
                {
                    //X
                    $xAxis[$i]  = date( 'd',strtotime($countday_arr_Day[$i]));
                    $day_key    = $countday_arr_Day[$i];
                    //Сʱܺ
                    if( $showType == 'all' )
                    {
                        $house_click[$i]    = isset($click_info_day[$day_key]['click_num']) ? 
                                intval($click_info_day[$day_key]['click_num']) : 0;
                    }
                    else if($showType == 'sell')
                    {
                        $house_click[$i]    = isset($click_info_day[$day_key]['sell_click']) ? 
                                intval($click_info_day[$day_key]['sell_click']) : 0;
                    }
                    else if($showType == 'rent')
                    {   
                        if(isset($click_info_day[$day_key]['click_num']) && isset($click_info_day[$day_key]['sell_click']))
                        {
                            $house_click[$i]    = 
                            intval($click_info_day[$day_key]['click_num']) - intval($click_info_day[$day_key]['sell_click']);
                        }
                        else if(isset($click_info_day[$day_key]['click_num']))
                        {
                            $house_click[$i]    = intval($click_info_day[$day_key]['click_num']);
                        }
                        else
                        {
                             $house_click[$i]    =  0;
                        }
                    }
                }
            }

            //׼ʾ
            $viewData['clickNum_json']  = json_encode($house_click);
            $viewData['xAxis_json'] = json_encode($xAxis);
            $viewData['unit']   = '';
        }
        
        $viewData['showType']	= $showType;
        $viewData['countType']	= $countType;
        $viewData['start_day']	= $start_day;
        $viewData['end_day']	= $end_day;
        
        //ܺ
        $viewData['house_clickcount']	= 0;
        $viewData['house_starclick']	= 0;
        $viewData['sell_total_click']	= 0;
        if(is_array($click_info) && !empty($click_info))
        {
            foreach($click_info as $key => $value)
            {
                $viewData['house_clickcount']   += intval($value['click_num']);
                $viewData['house_starclick']    += intval($value['sell_star_click']) + intval($value['rent_star_click']);
                $viewData['sell_total_click']   += intval($value['sell_click']) ;
            }
        }

        $viewData['rent_total_click']   = intval($viewData['house_clickcount']) - intval($viewData['sell_total_click']) ;
        
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        $viewData['js'] = load_js('common/js/My97DatePicker/WdatePicker.js,common/js/Highcharts/js/highcharts.js');
        $viewData['page_title'] = '۱-ͳƷ-ͳ';
		$viewData['google_analytics'] = get_ga_js_code('/ͳƷ/ͳ/');
        $this->view('statics', 'statistics_analysis/click', $viewData);
    }
    
    
    /**
     * Դˢ
     */
    public function refresh() 
    {	
        $viewData = array();
        
        //Ϣ
        $uid  = intval( $this->user_arr['uid']);

		//ŵ˺
		$agentcode = strip_tags($this->user_arr['agentcode']);

        //ʾ all-ȫsell-ַrent-ⷿ
        $showType  = $this->input->post('showType',TRUE);
        $showType   = in_array($showType,array('all','sell','rent')) ? $showType : 'all';

        //ͳƵڣĬ
        $count_day  = $this->input->post('count_day',TRUE);
        $count_day   = !empty ($count_day) ? $count_day : date("Y-m-d", mktime(0, 0, 0, date("m"), date("d") - 1, date("Y")));

        //ͳʱ
        $day    = date('Ymd', strtotime($count_day));

        $refresh_info	= array();
        $app	= $showType != 'all' ? $showType : '' ;
        $kind	= 2;	//ˢ
		
        //þˢ¼¼
        $this->load->library('statistics_plus');
        $refresh_info = $this->statistics_plus->getOperateListByType($day,$uid,$app,0,0,0,$kind);

        //ѭ24Сʱʱˢܺ
        $refreshu_sell = 0;
        $refreshu_rent = 0;
        $houseRefreshByHour   = array();

        //ˢ
        $refresh_sell = (int)$this->statistics_plus->getOperateCount($day,$uid,$kind,'sell');
        $refresh_rent = (int)$this->statistics_plus->getOperateCount($day,$uid,$kind,'rent');

		//ͳ
        $this->load->library('statistics');
		$agentinfo = array();
		$search = array();
		if($agentcode != '')
		{	
			$this->load->model('agency_model');
			$agentinfo = $this->agency_model->get_company_info_by_code($agentcode);
			$search['streetid'] = $agentinfo['streetid'];
		}

        //ѭʾСʱˢ
		$search_data = array();
        for ($i = 0 ; $i < 24 ;$i++)
        {
            $xAxis[$i] = $i;
            if(is_array($refresh_info) && !empty($refresh_info) )
            {
                foreach ($refresh_info as $key =>$value)
                {
                    if( $value['hour'] == $i )
                    {
                        $houseRefreshByHour[$i] = isset($houseRefreshByHour[$i]) ?
							$houseRefreshByHour[$i] + 1 : 1;	
                    }
                    else
                    {
                        $houseRefreshByHour[$i] = isset($houseRefreshByHour[$i]) ?
							$houseRefreshByHour[$i] : 0; 
                    }
                }
            }
            else
            {
                $houseRefreshByHour[$i] = 0;
            }

			//
			if($agentcode != '')
			{
				$search['hour'] = $i;
				if($showType == 'all')
				{
					$search_data_sell[$i] = $this->statistics->get_searchcount_bak($day,'sell',$search);
					$search_data_rent[$i] = $this->statistics->get_searchcount_bak($day,'rent',$search);
					$search_data_sell[$i] = isset($search_data_sell[$i]) && $search_data_sell[$i] > 0 ? intval($search_data_sell[$i]): 0;
					$search_data_rent[$i] = isset($search_data_rent[$i]) && $search_data_rent[$i] > 0 ? intval($search_data_rent[$i]): 0;
					$search_data[$i] = $search_data_sell[$i] + $search_data_rent[$i];
				}
				else if($showType == 'sell')
				{
					$search_data_sell[$i] = $this->statistics->get_searchcount_bak($day,'sell',$search);
					$search_data[$i] = isset($search_data_sell[$i]) && $search_data_sell[$i] > 0 ? intval($search_data_sell[$i]): 0;
				}
				else if($showType == 'rent')
				{
					$search_data_rent[$i] = $this->statistics->get_searchcount_bak($day,'rent',$search);
					$search_data[$i] = isset($search_data_rent[$i])&& $search_data_rent[$i] > 0 ? intval($search_data_rent[$i]): 0;
				}
			}
        }

        $viewData['count_day'] = $count_day;
        $viewData['showType'] = $showType;
        $viewData['refresh_sell']  = $refresh_sell;
        $viewData['refresh_rent']  = $refresh_rent;
        $viewData['refresh_total']  = $refresh_sell + $refresh_rent;
        $viewData['RefreshNum_json']    = json_encode($houseRefreshByHour);
		$viewData['SearchNum_json']    = json_encode($search_data);
        $viewData['xAxis_json'] = json_encode($xAxis);

        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        $viewData['js'] = load_js('common/js/My97DatePicker/WdatePicker.js,common/js/Highcharts/js/highcharts.js');
        $viewData['page_title'] = '۱-ͳƷ-ˢͳ';
		$viewData['google_analytics'] = get_ga_js_code('/ͳƷ/ˢͳ/');
        $this->view('statics', 'statistics_analysis/refresh', $viewData);
    }
    
    
    /**
     * ʹøſǩҳ
     * @param type $curPage
     * @return type
     */
    private function overViewTab($curPage) {
        $tabData = array();
        $tabData['today'] = array('url'=>'/statistics_analysis/today/','name'=>'ոſ');
        $tabData['history'] = array('url'=>'/statistics_analysis/history/','name'=>'ʷſ');
        return $this->tabpage->generate($tabData,$curPage);
    }
    
    /**
     * ʹ־ǩҳ
     * @param type $curPage
     * @return type
     */
    private function logTab($curPage) {
        $tabData = array();
        $tabData['log'] = array('url'=>'/statistics_analysis/log/','name'=>'Դ');
        $tabData['label'] = array('url'=>'/statistics_analysis/label/','name'=>'ǩʹ');
        $tabData['login_history'] = array('url'=>'/statistics_analysis/login_history/','name'=>'¼ʷ');
        $tabData['violation'] = array('url'=>'/statistics_analysis/violation/','name'=>'Υ¼');
        //array('statistics_analysis/log','statistics_analysis/label','statistics_analysis/login_history','statistics_analysis/violation')
        return $this->tabpage->generate($tabData,$curPage);
    }
    
    public function etime_check($etime,$stime) {
        $time = strtotime($etime);
        if(!$time) {
            $this->form_validation->set_message('etime_check', '%s ʽ');
            return FALSE;
        }
        if($time < strtotime($stime)) {
            $this->form_validation->set_message('etime_check', '%s ڿʼʱ֮ǰ');
            return FALSE;
        }
        /*
        $int = $time - strtotime($stime);
        if($int/(3600*24)>7) {
            $this->form_validation->set_message('etime_check', 'һ');
            return FALSE;
        }*/
        return TRUE;
    }
    
    public function stime_check($stime,$etime) {
        $time = strtotime($etime);
        if(!$time) {
            $this->form_validation->set_message('stime_check', '%s ʽ');
            return FALSE;
        }
        if($time > strtotime($etime)) {
            $this->form_validation->set_message('stime_check', '%s ڿʼʱ֮');
            return FALSE;
        }

        return TRUE;
    }
    
    /**
     * Υ
     * @param type $type
     * @param type $stime
     * @param type $etime
     */
    private function getVTotal($type,$stime,$etime)  
	{
        if($type=='frozen') {
            $this->load->model("house_frozen");
            $total = $this->house_frozen->findCountByUidTime($this->uid,$stime,$etime);
        } 
		else if ($type=='pic') 
		{
            $this->load->model("upload_log");
            $total = $this->upload_log->findCountByUidTime($this->uid,$stime,$etime);
        }

        return $total;
    }
    

    /**
     * Υ¼
     * @param type $type
     * @param type $stime
     * @param type $etime
     * @param type $start
     * @param type $number
     * @return int
     */
    private function getVList($type,$stime,$etime,$start,$number)  
	{
        if($type=='frozen') 
		{
            $this->load->model("house_frozen");
            $list = $this->house_frozen->findByUidTime($this->uid,$stime,$etime,$start,$number);
        } 
		elseif ($type=='pic') 
		{
            $this->load->model("upload_log");
            $list = $this->upload_log->findByUidTime($this->uid,$stime,$etime,$start,$number);
        }

        return $list;
    }
}
?>