<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * 
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * Tag_package_base_model CLASS
 *
 * Ʊǩ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xue
 */
//ظ


class Tag_package_base_wang_model extends MY_Model {
   
   
    
    /**
     * Դǩ
     * @var const
     */
    const TAG_PACKAGE_TBL = 'house_tag_package';
    
    /**
     * key
     * @var const
    */
    private $_mem_key;
    
    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct(1,1,1);       
 
        $this->_mem_key = GB_CITY.'_house_tag_package_base_model';
    }
    
   
   public function get_now_time(){
	   return time();
   }

   public function get_month_begin_time(){
        return mktime(0,0,0,date('m'),1,date('Y'));
   }


    /**
     * ǩ
     * @access  public
     * @param   int $package_id id
	 * @param   int $num 
	 * @param   int $expire_day Ч
     * @param  int $uid  ûuid
	 * @return  int $id  һid
     */
	 public function add_tag_pacakage($package_id,$num,$expire_day,$uid){
		 $package_arr = array();
         $add_time = $this->get_now_time();
		 $end_time = strtotime( date("Y-m-d 23:59:59") ) + 86400 * ($expire_day-1);
		 if($num>1){
			 for($i=0;$i<$num;$i++){
			    $package_arr[$i] = array('tag_price_id'=>$package_id,'add_time'=>$add_time,'end_time'=>$end_time,'uid'=>$uid,'esta'=>0);			 
			 }		     
		 }elseif($num==1){
			 $package_arr = array('tag_price_id'=>$package_id,'add_time'=>$add_time,'end_time'=>$end_time,'uid'=>$uid,'esta'=>0);
		 
		 }else{
		    return false;
		 }   
		 return $this->insert_package($package_arr);
    		
	 }


	

	 /**
     * ȡǰñǩ
     *
     * @access  public
	 * @param int $uid ûid
	 * @param int $clear_cache Ƿ建
	 * @param int $force_db Ƿǿ
     * @return  array   ƱǩϢ
     */
	 public function get_tag_valid($uid,$clear_cache = 0, $force_db = 0){
		 $data_info = array();
		 $mem_key = $this->_mem_key.'_get_tag_package_record_'.$uid;
		 if( $clear_cache == 1)
		 {
		 	$this->mc->delete($mem_key);
		 }
		 $cache = $this->mc->get($mem_key);
		 if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		 {
			$data_info = $cache['data'];
		 }
		 else{
			 $nowtime = $this->get_now_time();
			 if($force_db == 1)
			 {				
				$cond_where = "uid = $uid AND esta =0 AND $nowtime<=end_time";
                $this->db->where($cond_where);
				//
                $this->db->order_by("end_time", "ASC");
                $data_info = $this->db->get( self::TAG_PACKAGE_TBL )->result_array();
				//echo $this->db->last_query();
			
			 }
			 else
			 {
				$cond_where = "uid = $uid AND esta =0 AND $nowtime<=end_time";
                $this->dbback->where($cond_where);
				//
                $this->dbback->order_by("end_time", "ASC");
                $data_info = $this->dbback->get( self::TAG_PACKAGE_TBL )->result_array();
				
			 }
			 $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$data_info),  600);
			
		 }
		 return $data_info;

	 }


	  /**
     * ȡǰñǩ
     *
     * @access  public
	 * @param int $uid ûid
	 * @param int $clear_cache Ƿ建
	 * @param int $force_db Ƿǿ
     * @return  int  ǰüƱǩ
     */
	 public function get_tag_valid_num($uid,$clear_cache = 0, $force_db = 0){
		 
		 $mem_key = $this->_mem_key.'_get_tag_package_record_num_'.$uid;
		 if( $clear_cache == 1)
		 {
		 	$this->mc->delete($mem_key);
		 }
		 $cache = $this->mc->get($mem_key);
		 if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		 {
			$tag_num = $cache['data'];
		 }
		 else{
			 $nowtime = $this->get_now_time();
			 if($force_db == 1)
			 {
				
				$cond_where = "uid = $uid AND esta =0 AND $nowtime<=end_time";
                $this->db->where($cond_where);              
                $tag_num = $this->db->from( self::TAG_PACKAGE_TBL )->count_all_results();
			   
			 }
			 else
			 {
				$cond_where = "uid = $uid AND esta =0 AND $nowtime<=end_time";
                $this->dbback->where($cond_where);               
                $tag_num = $this->dbback->from( self::TAG_PACKAGE_TBL )->count_all_results();				
			 }
			 $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$tag_num),  300);
			
		 }
		 return $tag_num;

	 }


	 
	  /**
     * ȡʹñǩ
     *
     * @access  public
	 * @param int $uid ûid
	 * @param int $clear_cache Ƿ建
	 * @param int $force_db Ƿǿ
     * @return  int  ǰüƱǩ
     */
	 public function get_used_tag_valid_num($uid,$clear_cache = 0, $force_db = 0){
		 
		 $mem_key = $this->_mem_key.'_get_used_tag_package_record_num_'.$uid;
		 if( $clear_cache == 1)
		 {
		 	$this->mc->delete($mem_key);
		 }
		 $cache = $this->mc->get($mem_key);
		 if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		 {
			$tag_num = $cache['data'];
		 }
		 else{
			 $nowtime = $this->get_now_time();
			 //$month_begin_time = $this->get_month_begin_time();
			 if($force_db == 1)
			 {
				
				$cond_where = "uid = $uid AND esta =1 AND $nowtime<=end_time";
				//$cond_where = "uid = $uid AND esta =1 AND $month_begin_time<=end_time";
                $this->db->where($cond_where);              
                $tag_num = $this->db->from( self::TAG_PACKAGE_TBL )->count_all_results();
			   
			 }
			 else
			 {
				$cond_where = "uid = $uid AND esta =1 AND $nowtime<=end_time";
				//$cond_where = "uid = $uid AND esta =1 AND $month_begin_time<=end_time";
                $this->dbback->where($cond_where);               
                $tag_num = $this->dbback->from( self::TAG_PACKAGE_TBL )->count_all_results();	
			   // echo $this->dbback->last_query();exit();
			 }
			 $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$tag_num),  300);
			
		 }
		 return $tag_num;

	 }

     /**
     * ޸ʹñǩ
     *
     * @access  public
	 * @param int $uid ûid
     * @return boolean Ƿóɹ	
     */
	 public function update_tag_record($uid){
		
		 $result = FALSE;
		 $nowtime = $this->get_now_time();
		 $update_data = array();
         $update_data['esta'] = 1;
         $cond_where = "uid = $uid AND esta =0 AND $nowtime<=end_time";
         $this->db->where($cond_where);
		 $this->db->order_by('end_time',"ASC");
         $this->db->limit(1);
         $this->db->update(self::TAG_PACKAGE_TBL, $update_data);
         // echo $this->db->last_query();exit();		
         $result = $this->db->affected_rows() > 0 ? TRUE : FALSE;
		 return $result;
	 }

     /**
     *  //
     *
     * @access  public
	 * @param int $uid ûid
	 * @param int $clear_cache Ƿ建
	 * @param int $force_db Ƿǿ
     * @return boolean Ƿóɹ	
     */
	
	 public function expire_remind($uid,$clear_cache = 0, $force_db = 0){
		 $tag_valid_arr = $this->get_tag_valid($uid,$clear_cache,$force_db);
		 $time_count =array();
		 if(is_array($tag_valid_arr)&&!empty($tag_valid_arr)){
			 foreach($tag_valid_arr as $key=>$value){

				$time_arr[] = $this->tag_exipire_days($value['end_time']);			    
			 }
			 $time_count = array_count_values($time_arr);
		 
		 }
		 return $time_count;
		
	 }  
  
    
    
    /**
     * ȡԴǩʣ
     *
     * @access  public
     * @param   int $expiretime ʱ
     * @return  strting  ʣ
     */
    public function tag_exipire_days( $expiretime )
    {   
	$strRemainder = '';

        if($expiretime > 0) 
        {
            $nowtime = strtotime( date('Y-m-d 00:00:00') );
            $dif    = $expiretime - $nowtime;
            
            $strRemainder = ceil( $dif / 86400 );
        }
        
        return isset($strRemainder) ? $strRemainder.'' : '';
    }


	 //ǩ
	 private function insert_package($insert_data){
		if (isset($insert_data[0]) && is_array($insert_data[0]))
        {
            //
            if ($this->db->insert_batch(self::TAG_PACKAGE_TBL, $insert_data))
            {
                return $this->db->insert_id();
            }
        } 
        else 
        {
            //
            if ($this->db->insert(self::TAG_PACKAGE_TBL, $insert_data))
            {
                return $this->db->insert_id();
            }
        }
        return false;
		
	 }












}







/* End of file sell_tag_base_model.php */
/* Location: ./applications/models/sell_tag_base_model.php */