<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * Դ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * House_freeze_base_model CLASS
 *
 * Դ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          sun
 * @link            
 */
class House_delete_base_model extends MY_Model {
    
    /**
     * 
     * @var string 
     */
    const FREEZE_TBL = 'house_delete';
    
    /**
     * ᷿Դ
     * @var string 
     */
    private $_tbl = '';
    
    /**
     * ¼״̬
     * @var array 
     */
    private $_freeze_esta = array('1' =>'ɾ', '2' => '', '3' => 'ָ', '4' => 'ܾ');
    
    /**
     * Ҫѯݱֶ
     * @var string 
     */
    protected $select_fields = '';

    /**
     * ᷿Դ
     * @param string $tbl
     */
    public function set_tbl($tbl) 
    {
        $this->_tbl = $tbl;
    }
    
    /**
     * ȡ᷿Դ
     * @return string $tbl 
     */
    public function get_tbl() 
    {
         return $this->_tbl;
    }
    
    /**
     * ȡԴ״̬
     * @return string $house_esta Դ״̬
     */
    public function get_freeze_esta() 
    {
        return $this->_freeze_esta;
    }
    
    
    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct(1,1,1);
    }

	public function database(){
		return $this->dbback;
	}
    
    
    /**
     * Ҫѯֶ
     * @param array $select_fields
     */
    public function set_select_fields($select_fields)
    {
        $select_fields_str = '';
        if(isset( $select_fields ) && !empty($select_fields))
        {   
            $select_fields_str = implode( ',' , $select_fields) ;
        }
        
        $this->select_fields = $select_fields;
    }
    
    /**
     * ȡҪѯֶ
     * @return type
     */
    public function get_select_fields()
    {
        return $this->select_fields;
    }
    
    
    /**
     * ͨԴŻȡԴɾ־¼
     * @param int $rowid Դ
     * @param int $esta ɾ־״̬
     * @return array ɾ־¼
     */
    public function get_freeze_by_rowid( $rowid , $esta = '' )
    {   
        $freeze_info = array();
       
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        
        $tbl = $this->get_tbl();
        
        if( $rowid > 0 && $tbl != '' )
        {
            //ѯ
            $this->dbback->where('rowid', $rowid);
            $this->dbback->where('tbl', $this->get_tbl());
            $this->dbback->order_by('id', ' desc ');
            if( $esta != '')
            {
                $this->dbback->where('esta', $esta);
            }
            
            
            $freeze_info = $this->dbback->get(self::FREEZE_TBL)->row_array();

        }
        
        return $freeze_info;
    }
    
    
    /**
    * ᷿Դ
    *
    * @access	public
    * @param	int $rowid Դ
    * @param	array $data_info Դ
    * @return	boolean Ƿ߳ɹ
    */
    public function house_appeal ( $rowid , $data_info  )
    {
        $reslut = FALSE;
        
        if( $rowid > 0 && $this->_tbl != '')
        {
            $cond_where =  "rowid = '".$rowid."' AND tbl = '".$this->_tbl."' ";
            $this->db->where($cond_where);
            $this->db->update( self::FREEZE_TBL , $data_info);
            
            $reslut = $this->db->affected_rows() > 0 ? TRUE : FALSE;
        }
        
        return $reslut;
    }

	/**
    * ᷿ԴͼƬϢ
    *
    * @access	public
    * @param	int $rowid Դ
    * @param	array $data_info ԴͼƬϢ
    * @return	boolean Ƿ߳ɹ
    */
    public function house_pic_insert ($tbl, $rowid , $data_pic_info  )
    {
        $reslut = FALSE;
        $num =count($data_pic_info['pics_arr']);
		//$this->db->delete('house_delete_pic' , array('tbl' => $tbl, 'house_free_id' => $rowid ) );
		for($i =0;$i<$num;$i++)
		{
			$data_info['house_free_id'] = $rowid;
			$data_info['position'] = $i;
			$data_info['filename'] = $data_pic_info['pics_arr'][$i];
			$data_info['sort'] = 2;
			$data_info['tbl'] = $tbl;
			$data_info['createtime'] = time();
			$this->db->insert( 'house_delete_pic' , $data_info );
			$result = ( $this->db->affected_rows() == 1 ) ? $this->db->insert_id() : 0;
		
		}
		 
        return $result;
        
       
    }

	/**
    * ᷿ԴͼƬɾ
    *
    * @access	public
    * @param	int $rowid Դ
    * @param	array $data_info ԴͼƬϢ
    * @return	boolean Ƿ߳ɹ
    */
    public function house_pic_delete ($tbl, $rowid)
    {
		

		$this->db->delete('house_freeze_pic' , array('tbl' => $tbl, 'house_free_id' => $rowid ) ); 
		
		 
        return $result;
        
       
    }

}
/* End of file house_freeze_base_model.php */
/* Location: ./application/models/house_freeze_base_model.php */
