<?php !defined('APP_DIR') ? die('acceess not defined') : '';
class BM_block extends BM {
    
    private $_dao_block = 'block';
    
    private $_dao_area_price = 'block_area_price';
    
    /**
     * IDȡ400ĻϢ
     *
     * @param int $id
     * @return array
     * 
     * @example bm('400')->get(1)
     */
    public function get($id){
        return $this->dao($this->_dao_block)->get($id);
    }
    
    /**
     * ݲѯȡ400
     *
     * @param int $query_struct
     * @param string $key_field
     * @return array
     * 
     * @example bm('company')->get_all($query_struct, $key_field)
     */
    public function get_all($query_struct, $key_field=NULL){	
        return $this->dao($this->_dao_block)->get_all($query_struct, $key_field);
    }
    
    /**
     * ޸400
     *
     * @param array $data
     * @return bool
     * 
     */
    public function edit($data){
        return $this->dao($this->_dao_block)->edit($data);
    }
    
    /**
     * 400
     *
     * @param array $data
     * @return bool | int
     */
    public function add($data){
        return $this->dao($this->_dao_block)->add($data);
    }
    
    /**
     * ɾ
     *
     * @param int $id
     * @return bool
     */
    public function delete($id){
        return $this->dao($this->_dao_block)->delete($id);
    }
    
    /**
     *ѯ 
     */
    public function count($query_struct){
        return $this->dao($this->_dao_block)->count($query_struct);
    }
    
    /**
     * ȡСľ
     *
     * @param unknown_type $block_id
     * @param unknown_type $city
     */
    public function block_area_prices($block_id,$city='nj'){
        $cache_f = "{$city}/block/area_price/{$block_id}";
        $data = fcache::get($cache_f);
        if (!$data){
            $query_struct = array(
                'where' => array(
                    'city' => $city,
                    'block_id' => $block_id,
                ),
            );
            $data = $this->dao($this->_dao_area_price)->get_all($query_struct,'area_extent');
            fcache::set($cache_f, '', $data,86400*7);
        }
        return $data;
    }
}