<?php

/**
 * Description of GrowthBrokerBidHouse
 *
 * @author user
 */
include_once Growth::getCoreLibDir() . '/HouseSell.php';

class GrowthBrokerBidHouse {

    const BID_ERROR_AUTH_IS_PAY = 1; //ʾǸѾ
    const BID_ERROR_AUTH_CREDIT = 2; //ʾֲ
    const BID_ERROR_AUTH_LEVEL = 4; //ʾ˵ȼ
    const BID_ERROR_AUTH_SCORE = 5; //ʾͶĻֲ
    const BID_ERROR_AUTH_HOUSE = 3; //ʾǼԴ
    /**
      const BID_ERROR_AUTH_HOUSE_GRADE = 1;//ʾʷԴ

      const BID_ERROR_AUTH_HOUSE_BLOCK = 6;//ʾͶС
      const BID_ERROR_AUTH_HOUSE_TITLE = 7;//ʾͶķԴⲻ* */
    const BID_ERROR_SYS_DB = 10; //ݿ
    const BID_ERROR_FINISH = 100;//ͶύͶ
    const BID_ERROR_MIN_TIME = 200;//ʱ䲻
    
    const BID_NEED_SCORE_TYPE_WIN = 2; //Ͷ
    const BID_NEED_SCORE_TYPE_NOT_WIN_1 = 1; //δͶ,Ͷ>=2
    const BID_NEED_SCORE_TYPE_NOT_WIN_0 = 0; //δͶ,Ͷ<2

    const BID_MIN_TIME = 2;//ͶСʱ,λ
    
    private $broker;
    private $dbback;
    public static $bidProjectName = 'ԴͶ';

    /**
     * 1,ɹ 2,ʧ,3,δͶ,4,δͶ,5,Ͷ
     * @var type 
     */
    public static $bidBehavior = array(
        'success' => 1, 'failure' => 2, 'noPut' => 3,
        'noHit' => 4, 'on' => 5, 'tempHit' => 6
    );

    /**
     * Դ״̬
     * @var type 
     */
    public static $houseState = array(
	  0 => '', 1 => '', 2 => 'ʧЧ', 3 => 'ɽ', 
	  4 => 'ɾ', 5 => ''
    );

    /**
     * trueʾǷͼfalseʾ
     * @var type 
     */
    private $checkStar = false;
    /**
     *
     * @var array 
     */
    private $bidError;

    private $creditName;
    private $creditUnit;
    /**
     *
     * @var type credit or dou
     */
    private $mode;
    
    private $additionalScore=1;
    
    public function __construct($broker, $growthBrokerCredit,$mode='credit') {
        $this->dbback = Container::getInstance()->get('dbback');
        $this->db = Container::getInstance()->get('db');
        $this->mc = Container::getInstance()->get('mc');
        $this->broker = $broker;
        $this->growthBidHouse = new GrowthBidHouse();
        $this->houseSell = new HouseSell();
        $this->growthBidRecord = new GrowthBidHouseRecordOn();
        $this->growthBidRecordHistory = new GrowthBidHouseRecordHistory();
        $this->growthBrokerCredit = $growthBrokerCredit;
        $this->mKeyFront = 'growth_bidhouse_';
        $this->mode = $mode;
        if($this->mode == 'credit') {
            $this->creditName = '';
            $this->creditUnit = '';
        } else {
            $this->creditName = '';
            $this->creditUnit = '';
        }
    }

   /**
     * ׷ӵͷ
     * @param type $additionalScore
     */
    public function setAdditionalScore($additionalScore) {
        $this->additionalScore = $additionalScore;
    }

    /**
     * ȡ׷ӷ
     * @return type
     */
    public function getAdditionalScore() {
        return $this->additionalScore;
    }
    
    /**
     * ڸʽ.
     * @param type $strDate
     * @return string
     */
    private function getMonthDayByFormatTime($strDate) {
        return date('m.d', strtotime($strDate));
    }

    /**
     * ȡ˱
     * @return type
     */
    private function getBrokerId() {
        return $this->broker['id'];
    }

    public function getBidError() {
        return $this->bidError;
    }

    /**
     * ȡԴͶ¼
     * @param type $cPeriods
     * @param type $type
     * @param type $houseId
     */
    public function findHouseBidRecord($periodsId, $houseId, $status = 'on') {
        //ҵľͶ¼м¼
        if ($status == 'on') {
            return $this->growthBidRecord->findByPidAndHouseId($periodsId, $houseId);
        } else {
            return $this->growthBidRecordHistory->findByPidAndHouseId($periodsId, $houseId);
        }
    }

    /**
     * ȡԴĳͶ¼
     * @param type $bid
     * @param type $houseId
     * @return type
     */
    public function findHouseBidTypeRecord($bid, $houseId, $status = 'on') {
        if ($status == 'on') {
            return $this->growthBidRecord->findByBidAndHouseId($bid, $houseId);
        } else {
            return $this->growthBidRecordHistory->findByBidAndHouseId($bid, $houseId);
        }
    }

    /**
     * ˼Դ
     * @param type $searchWhere
     * @return type
     */
    public function findHouseCount($searchWhere) {
        $this->houseSell->setWhere($searchWhere);
        return $this->houseSell->getHouseCount();
    }

    /**
     * Ӧȡ˼Դб
     * @param type $where
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     */
    public function findHouseList($searchWhere, $orderField, $order, $start, $limit) {
        $this->houseSell->setWhere($searchWhere);
        $this->houseSell->setOrder($orderField, $order);
        $this->houseSell->setLimit($start, $limit);
        return $this->houseSell->getHouseList();
    }

    /**
     * ǰԴеľͶ״
     * @param type $cPeriods
     * @param type $houseInfo
     * @return boolean
     */
    public function findBidHouseRecordList($cPeriods, $houseInfo) {
        if (!$houseInfo) {
            return false;
        }
        $ids = array();
        foreach ($houseInfo as $value) {
            $ids[] = $value['id'];
        }
        $bidAllRecord = $this->findHouseBidRecord($cPeriods['id'], $ids);
        $bidAllNewRecord = SqlCombinHelper::changeToDoubleKeyArray($bidAllRecord, 'house_id');
        foreach ($houseInfo as &$v) {
            //Ͷ״̬
            $bidStatus = array();
            if ($cPeriods['status'] == 1 || $cPeriods['status'] == 3) {
                //оͶļ¼
                if (isset($bidAllNewRecord[$v['id']]) && CommonBase::isFullArray($bidAllNewRecord[$v['id']])) {
                    //Ҵ˷ԴľͶ¼
                    $bidRecord = $bidAllNewRecord[$v['id']];
                    //ҾͶĴͶ״̬
                    foreach ($bidRecord as $bR) {
                        if ($bR['type'] == 1) {
                            $bidWords = $v['blockshowname'];
                        } else {
                            $bidWords = $this->growthBidHouse->getBidHotWordsByBid($bR['bid_id']);
                        }
                        if ($cPeriods['status'] == 1) {
                            //Ͷ
                            $bidBehavior = self::$bidBehavior['on'];
                        } else {
                            //Ͷ
                            $mKeyB = $this->mKeyFront . 'winRecord_' . $bR['bid_id'];
                            $winRecord = $this->mc->get($mKeyB);
                            if ($winRecord === false) {
                                $winRecord = $this->findTempWinnerRecord($bR['bid_id']);
                                $this->mc->set($mKeyB, $winRecord, 3600);
                            }
                            $mKeyH = $this->mKeyFront . 'myRecord_' . $bR['bid_id'] . $bR['house_id'];
                            $myRecord = $this->mc->get($mKeyH);
                            if ($myRecord === false) {
                                $myRecord = $this->findHouseBidTypeRecord($bR['bid_id'], $bR['house_id']);
                                $this->mc->set($mKeyH, $myRecord, 3600);
                            }
                            $bidRank = $this->checkWinBid($winRecord, $myRecord);
                            $bidBehavior = $bidRank > 0 ?
                                    self::$bidBehavior['success'] : self::$bidBehavior['failure'];
                        }
                        $bidStatus[] = array(
                            'words' => $bidWords,
                            'behavior' => $bidBehavior,
                        );
                    }
                } else {
                    //δͶ
                    $bidStatus[] = array(
                        'words' => '',
                        'behavior' => self::$bidBehavior['noPut'],
                    );
                }
                $v['bid_status'] = $bidStatus;
            } else if ($cPeriods['status'] == 2) {
                $v['start_time'] = $cPeriods['start_time'];
            }
            $v['house_id'] = $v['id'];
            $v['block_id'] = $v['blockid'];
            $v['content'] = "{$v['address']}{$v['room']}"
                    . "{$v['hall']}" . " {$v['buildarea']}O "
                    . "{$v['price']}";
            $v['status'] = $cPeriods['status'];
            $v['tg_start_time'] = $cPeriods['tg_start_time'];
            $v['tg_end_time'] = $cPeriods['tg_end_time'];
        }
        return $houseInfo;
    }

    /**
     * ȡͶеķԴ
     * @return type
     */
    public function findBidOnHouseRecordCount() {
        $searchWhere = array();
        $brokerId = $this->getBrokerId();
        $searchWhere['broker_id'] = $brokerId;
        $this->growthBidRecord->setWhere($searchWhere);
        return $this->growthBidRecord->findBrokerbidHouseCount();
    }

    /**
     * ȡĳξͶзԴ¼
     * @param type $cPeriods
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     * @return boolean
     */
    public function findBidOnHouseRecord($orderField, $order, $start, $limit) {
        $brokerId = $this->getBrokerId();
        $searchWhere = array();
        $searchWhere['broker_id'] = $brokerId;
        $this->growthBidRecord->setWhere($searchWhere);
        $this->growthBidRecord->setOrder($orderField, $order);
        $this->growthBidRecord->setLimit($start, $limit);
        return $this->growthBidRecord->findBrokerBidHouse();
    }

    /**
     * ȡͶеķԴϢ
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     */
    public function findBidOnHouseRecordList($cPeriods, $bidHouseRecord) {
        if (!CommonBase::isFullArray($bidHouseRecord) || $cPeriods['status'] == 2) {
            return array();
        }
        $brokerId = $this->getBrokerId();
        $ids = array();
        foreach ($bidHouseRecord as $value) {
            $ids[] = $value['house_id'];
        }
        //ȡԴĻϢ
        $searchWhere = array();
        $searchWhere['uid'] = $brokerId;
        $houseids = implode(',', $ids);
        $searchWhere['id'] = "IN($houseids)";
        $this->houseSell->setWhere($searchWhere);
        $house = $this->houseSell->getAllHouse();
        $houseNew = SqlCombinHelper::changeToKeyArray($house, 'id');
        //ȡͶ¼
        $bidAllRecord = $this->findHouseBidRecord($cPeriods['id'], $ids);
        $bidAllNewRecord = SqlCombinHelper::changeToDoubleKeyArray($bidAllRecord, 'house_id');
        foreach ($bidHouseRecord as &$value) {
            //˾Ͷļ¼
            $bidRecord = array_key_exists($value['house_id'], $bidAllNewRecord)?$bidAllNewRecord[$value['house_id']]:array();
            //˵ķԴ
            $houseInfo = $houseNew[$value['house_id']];
            $bidStatus = array();
            foreach ($bidRecord as $v) {
                //Ͷ
                if ($v['type'] == 1) {
                    $bidWords = $houseInfo['blockshowname'];
                } else {
                    $bidWords = $this->growthBidHouse->getBidHotWordsByBid($v['bid_id']);
                }
                $value['block_id'] = $houseInfo['blockid'];
                //Ͷ״̬
                if ($cPeriods['status'] == 1) {
                    //Ͷ
                    $bidBehavior = self::$bidBehavior['on'];
                } else {
                    //Ͷ
                    $mKeyB = $this->mKeyFront . 'winRecord_' . $v['bid_id'];
                    $winRecord = $this->mc->get($mKeyB);
                    if ($winRecord === false) {
                        $winRecord = $this->findTempWinnerRecord($v['bid_id']);
                        $this->mc->set($mKeyB, $winRecord, 3600);
                    }
                    $mKeyH = $this->mKeyFront . 'myRecord_' . $v['bid_id']
                            . $v['house_id'];
                    $myRecord = $this->mc->get($mKeyH);
                    if ($myRecord === false) {
                        $myRecord = $this->findHouseBidTypeRecord($v['bid_id'], $v['house_id']);
                        $this->mc->set($mKeyH, $myRecord, 3600);
                    }
                    $bidRank = $this->checkWinBid($winRecord, $myRecord);
                    $bidBehavior = $bidRank > 0 ?
                            self::$bidBehavior['success'] : self::$bidBehavior['failure'];
                }
                $bidStatus[] = array(
                    'words' => $bidWords,
                    'behavior' => $bidBehavior,
                );
            }
            $value['bid_status'] = $bidStatus;
            //ԴȡϢ
            if (isset($houseInfo) && $houseInfo['esta'] == 1) {
                $value['blockshowname'] = $houseInfo['blockshowname'];
                $value['infotype'] = $houseInfo['infotype'];
                $value['content'] = "{$houseInfo['address']}{$houseInfo['room']}"
                        . "{$houseInfo['hall']}" . " {$houseInfo['buildarea']}O "
                        . "{$houseInfo['price']}";
                $value['esta'] = $houseInfo['esta'];
                $value['grade'] = $houseInfo['grade'];
                $value['isstar'] = $houseInfo['isstar'];
            } else {
                //ȡͶʱϢ
                $value['blockshowname'] = $v['blockname'];
                $value['infotype'] = $v['infotype'];
                $value['content'] = $v['content'];
                $value['esta'] = isset($houseInfo) ? $houseInfo['esta'] : 4;
                $value['content'] = $v['content'] . '<span style="color:red;">[' 
                        . self::$houseState[$houseInfo['esta']] . ']</span>';
            }
            $value['tg_start_time'] = $cPeriods['tg_start_time'];
            $value['tg_end_time'] = $cPeriods['tg_end_time'];
        }
        return $bidHouseRecord;
    }

    /**
     * ȡͶʷ¼ķԴ
     * @return type
     */
    public function findBidHistoryHouseRecordCount($searchWhere) {
        $recordWhere = array();
        $brokerId = $this->getBrokerId();
        $recordWhere['broker_id'] = $brokerId;
        if(isset($searchWhere['infotype'])) {
        $recordWhere['infotype'] = $searchWhere['infotype'];
        }
        if(isset($searchWhere['blockshowname'])) {
        $recordWhere['blockname'] = $searchWhere['blockshowname'];
        }
        $this->growthBidRecordHistory->setWhere($recordWhere);
        return $this->growthBidRecordHistory->findBrokerbidHouseCount();
    }

    /**
     * 
     * @param type $searchWhere
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     * @return type
     */
    public function findBidHistoryHouseRecord($searchWhere, $orderField, $order, $start, $limit) {
        $brokerId = $this->getBrokerId();
        $recordWhere['broker_id'] = $brokerId;
        if(array_key_exists('infotype', $searchWhere)) {
            $recordWhere['infotype'] = $searchWhere['infotype'];
        }
        if(array_key_exists('blockname', $searchWhere)) {
            $recordWhere['blockname'] = $searchWhere['blockshowname'];
        }
        $this->growthBidRecordHistory->setWhere($recordWhere);
        $this->growthBidRecordHistory->setOrder($orderField, $order);
        $this->growthBidRecordHistory->setLimit($start, $limit);
        return $this->growthBidRecordHistory->findBrokerBidHouse();
    }

    /**
     * ȡͶʷ¼ķԴϢ
     * @param type $orderField
     * @param type $order
     * @param type $start
     * @param type $limit
     */
    public function findBidHistoryHouseRecordList($bidHouseRecord) {
        if (!CommonBase::isFullArray($bidHouseRecord)) {
            return array();
        }
        $brokerId = $this->getBrokerId();
        $growthBidPeriods = new GrowthBidPeriods();
        $ids = array();
        foreach ($bidHouseRecord as $value) {
            $ids[] = $value['house_id'];
        }
        //ȡԴĻϢ
        $searchWhere = array();
        $searchWhere['uid'] = $brokerId;
        $houseids = implode(',', $ids);
        $searchWhere['id'] = "IN($houseids)";
        $this->houseSell->setWhere($searchWhere);
        $house = $this->houseSell->getAllHouse();
        $houseNew = SqlCombinHelper::changeToKeyArray($house, 'id');
        foreach ($bidHouseRecord as &$value) {
            $houseInfo = $houseNew[$value['house_id']];
            $periodsId = $value['bid_periods_id'];
            $memKeyRecord = $this->mKeyFront . $periodsId . $value['house_id'];
            $bidRecord = $this->mc->get($memKeyRecord);
            if ($bidRecord === false) {
                $bidRecord = $this->findHouseBidRecord($periodsId, $value['house_id'], 'history');
                $this->mc->set($memKeyRecord, $bidRecord, 600);
            }
            if (!$bidRecord) {
                return array();
            }
            $cBidPeriods = $growthBidPeriods->findById($periodsId);
            $bidStatus = array();
            foreach ($bidRecord as $v) {
                //Ͷ
                $memKeyBid = $this->mKeyFront . $v['bid_id'];
                $bidOne = $this->mc->get($memKeyBid);
                if ($bidOne === false) {
                    $bidOne = $this->growthBidHouse->findOneById($v['bid_id']);
                    $this->mc->set($memKeyBid, $bidOne, 3600);
                }
                if ($v['type'] == 1) {
                    $bidWords = $houseInfo['blockshowname'];
                } else {
                    $bidWords = $bidOne['keyword'];
                }
                $intBehavior = $v['status'] == 1 ? self::$bidBehavior['success'] : self::$bidBehavior['failure'];
                $bidStatus[] = array(
                    'behavior' => $intBehavior, 'words' => $bidWords,
                    'score' => $v['score']
                );
                //Ͷ
                $mKeyB = $this->mKeyFront . 'winRecord_' . $v['bid_id'];
                $winRecord = $this->mc->get($mKeyB);
                if ($winRecord === false) {
                    $winRecord = $this->findWinnerRecord($v['bid_id']);
                    $this->mc->set($mKeyB, $winRecord, 3600);
                }
                $mKeyH = $this->mKeyFront . 'myRecord_' . $v['bid_id']
                        . $v['house_id'];
                $myRecord = $this->mc->get($mKeyH);
                if ($myRecord === false) {
                    $myRecord = $this->findHouseBidTypeRecord($v['bid_id'], $v['house_id'], 'history');
                    $this->mc->set($mKeyH, $myRecord, 3600);
                }
                $template = '<span style="padding-left:10px;"><span class="m_l_33 blod">NO.%s</span><span style="border-right-width: 0px; margin-right: 5px;" class="rank %s">%s</span>'.$this->creditUnit.'</span>';
                $value['record_list'][] = $this->rankList($winRecord, GrowthBidPeriods::BID_PERIODS_STATUS_FINISH, $template, $myRecord);
                $value['number'][] = $bidOne['number'];
                $value['tg_start_time'] = $cBidPeriods['tg_start_time'];
                $value['tg_end_time'] = $cBidPeriods['tg_end_time'];
            }
            $value['bid_status'] = $bidStatus;
            //ԴȡϢ
            if (isset($houseInfo) && $houseInfo['esta'] == 1) {
                $value['blockshowname'] = $houseInfo['blockshowname'];
                $value['infotype'] = $houseInfo['infotype'];
                $value['content'] = "{$houseInfo['address']}{$houseInfo['room']}"
                        . "{$houseInfo['hall']}" . " {$houseInfo['buildarea']}O "
                        . "{$houseInfo['price']}";
                $value['esta'] = $houseInfo['esta'];
            } else {
                //ȡͶʱϢ
                $value['blockshowname'] = $v['blockname'];
                $value['infotype'] = $v['infotype'];
                $value['content'] = $v['content'];
                $value['esta']= isset($houseInfo) ? $houseInfo['esta'] : 4;
                $value['content'] = $v['content'] . '<span style="color:red;">[' 
                        . '' . self::$houseState[$value['esta']] . ']</span>';
            }
        }
        return $bidHouseRecord;
    }

    /**
     * ȡһڵľͶ¼
     * @return type
     */
    public function findNewBidRecord($cPeriods) {
        $brokerId = $this->getBrokerId();
        $cPeriodsStatus = $cPeriods['status'];
        if ($cPeriods['status'] == 1 || $cPeriods['status'] == 3) {
            $growthBidRecord = $this->growthBidRecord;
        } else {
            //һ
            $growBidPeriods = new GrowthBidPeriods();
            $cPeriods = $growBidPeriods->upBidPeriods(2, $cPeriods['id']);
            $growthBidRecord = $this->growthBidRecordHistory;
        }
        $periodsId = $cPeriods['id'];
        $bidAllRecord = $growthBidRecord->findByPidAndBrokerId($periodsId, $brokerId, 10);
        if (!CommonBase::isFullArray($bidAllRecord)) {
            return array();
        }
        $arrBidRecord = array();
        foreach ($bidAllRecord as $k => $v) {
            $bidMaxMinScore = $growthBidRecord->findMaxMinScoreByBid($v['bid_id']);
            if ($cPeriods['status'] == 1 || $cPeriods['status'] == 3) {
                $bidRecord = $this->findTempWinnerRecord($v['bid_id']);
            } else {
                $bidRecord = $this->findWinnerRecord($v['bid_id']);
            }
            $myRecord = $growthBidRecord->findByBidAndHouseId($v['bid_id'], $v['house_id']);
            $bidRank = $this->checkWinBid($bidRecord, $myRecord);
            //Ͷ
            $bidOne = $this->growthBidHouse->findOneById($v['bid_id']);
            if ($cPeriods['status'] == 1) {
                if ($bidRank > 0) {
                    $intBehavior = self::$bidBehavior['tempHit'];
                    $arrBidRecord[$k]['rank'] = $bidRank;
                } else {
                    $intBehavior = self::$bidBehavior['noHit'];
                }
            } else {
                $intBehavior = $bidRank > 0 ? self::$bidBehavior['success'] : self::$bidBehavior['failure'];
            }
            $houseWhere = array('uid' => $brokerId, 'id' => $v['house_id']);
            $this->houseSell->setWhere($houseWhere);
            $houseInfo = $this->houseSell->getOneHouse();
            if ($v['type'] == 1) {
                $bidWords = $houseInfo['blockshowname'];
            } else {
                $bidWords = $bidOne['keyword'];
            }
            if (isset($houseInfo) && $houseInfo['esta'] == 1) {
                $content = "{$houseInfo['address']}{$houseInfo['room']}"
                        . "{$houseInfo['hall']}" . " {$houseInfo['buildarea']}O "
                        . "{$houseInfo['price']}";
                $esta = $houseInfo['esta'];
            } else {
                $esta = isset($houseInfo) ? $houseInfo['esta'] : 4;
                $content = $v['content'] . '[' . self::$houseState[$esta] . ']';
            }
            if ($cPeriodsStatus == 1 || $cPeriodsStatus == 3) {
                $bidRankUrl = 'market_bid_house.php?type=' . $v['type']
                        . '&houseid=' . $v['house_id'];
            } else {
                $bidRankUrl = 'market_bid_house_manage.php?tab=history';
            }
            $tgStartTime = $cPeriods['tg_start_time'];
            $tgEndTime = $cPeriods['tg_end_time'];
            $arrBidRecord[$k]['projectname'] = self::$bidProjectName;
            $arrBidRecord[$k]['tg_start_time'] = $this->getMonthDayByFormatTime($tgStartTime);
            $arrBidRecord[$k]['tg_end_time'] = $this->getMonthDayByFormatTime($tgEndTime);
            $arrBidRecord[$k]['utime'] = $v['utime'];
            $arrBidRecord[$k]['content'] = $content;
            $arrBidRecord[$k]['score'] = $v['score'];
            $arrBidRecord[$k]['behavior'] = $intBehavior;
            $arrBidRecord[$k]['max_score'] = $cPeriods['status'] == GrowthBidPeriods::BID_PERIODS_STATUS_ON ? '' : $bidMaxMinScore['max'];
            $arrBidRecord[$k]['min_score'] = $bidMaxMinScore['min'];
            $arrBidRecord[$k]['operate'] = $bidRankUrl;
            $arrBidRecord[$k]['words'] = "{$bidWords}";
            $arrBidRecord[$k]['esta'] = $esta;
            $arrBidRecord[$k]['type'] = $v['type'];
            $arrBidRecord[$k]['house_id'] = $v['house_id'];
        }
        //print_r($arrBidRecord);
        return $arrBidRecord;
    }

    /**
     * ֤ԴǷʷ
     * @param type $grade
     */
    private function checkHouseGrade($grade) {
        if ($grade == 1) {
            return true;
        } else {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_HOUSE;
            return false;
        }
    }

    /**
     * ֤ԴǷǼԴ
     * @param type $grade
     */
    private function checkHouseEsta($esta) {
        if ($esta == 1) {
            return true;
        } else {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_HOUSE;
            return false;
        }
    }

    /**
     * 鷿ԴıǷѴ
     * @param type $address
     * @param type $periodsId 
     */
    private function checkHouseAddress($address, $periodsId) {
        $bidHotSearch = $this->growthBidHouse->findPeriodsHotSearch($periodsId);
        $bidHotSearchNew = array();
        if ($bidHotSearch) {
            foreach ($bidHotSearch as $v) {
                $bidHotSearchNew[] = $v['keyword'];
            }
        }
        $hotSearchWords = implode('|', $bidHotSearchNew);
        if (preg_match("/{$hotSearchWords}/", $address)) {
            return true;
        } else {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_HOUSE;
        }
    }

    /**
     * 鷿ԴСǷ뾺Ͷ
     * @param type $blockId
     * @param type $periodsId 
     */
    private function checkHouseBlockId($blockId, $periodsId) {
        $bidBlock = $this->growthBidHouse->findPeriodsBlock($periodsId);
        $bidBlockNew = array();
        if ($bidBlock) {
            foreach ($bidBlock as $v) {
                $bidBlockNew[] = $v['block_id'];
            }
        }
        if (in_array($blockId, $bidBlockNew)) {
            return true;
        } else {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_HOUSE;
            return false;
        }
    }

    //鷿Դ
    private function checkHouse($houseInfo, $periodsId) {
        if ($this->checkHouseEsta($houseInfo['esta'])) {
            if($this->checkCustomConf($houseInfo)) {
                if ($houseInfo['bidType'] == 1) {
                    return $this->checkHouseBlockId($houseInfo['blockid'], $periodsId);
                } else {
                    return $this->checkHouseAddress($houseInfo['address'], $periodsId);
                }
            } else {
                return false;
            }
            
        } else {
            return false;
        }
    }
    /**
     * Զ
     */
    private function checkCustomConf($houseInfo) {
        if($this->checkStar) {
            return $this->checkHouseStar($houseInfo['isstar']);
        } else {
            return $this->checkHouseGrade($houseInfo['grade']);
        }
    }
    
    public function setCheckStar($checkStar) {
        $this->checkStar = $checkStar;
    }
    
    private function checkHouseStar($star) {
        if($star==3) {
            return true;
        } else {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_IS_PAY;
            return false;
        }
    }
    
    //龭˸
    private function checkBroker() {
        if ($this->broker['is_pay'] == 0) {
            return true;
        } else {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_IS_PAY;
            return false;
        }
    }

    //˵ȼǷ㷿ԴͶı׼
    public function checkBrokerLevel($bidBrokerLevel) {
        $brokerLevel = $this->broker['level']; //˵ȼ
        $arr = explode(",", $bidBrokerLevel);
        if (in_array($brokerLevel, $arr)) {
            return true;
        } else {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_LEVEL;
            return false;
        }
    }

    /**
     * ͶĻǷС
     * @param int $score
     * @param array $needScore $this->getNeedScore($bid,$winnerRecord,$myRecord)ֵ
     */
    public function checkScore($score, $needScore) {
        //$type = $needScore['type'];
        $flag = $score >= $needScore['score'];
        if (!$flag) {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_SCORE;
            return false;
        }
        return true;
    }

    /**
     * ֹ
     * @param int $score
     * @return boolean
     */
    public function checkCredit($score) {
        $myCredit = $this->broker['credit'];
        if ($myCredit < $score) {
            $this->bidError['errorCode'] = self::BID_ERROR_AUTH_CREDIT;
            return false;
        }
        return true;
    }

    /**
     * ṩľͶ;Ͷ¼жǷԾͶ
     * @param array $bid
     * @param int $score
     * @param array $winnerRecord
     * @param array $myRecord
     * @return boolean
     */
    public function checkByRecord($bid, $score, $winnerRecord, $myRecord, $houseInfo) {
        //ʱ
        //$bidڵڴ
        $bidPeriodsId = $bid['bid_periods_id'];
        $growthBidPeriods = new GrowthBidPeriods();
        $bidPeriods = $growthBidPeriods->findById($bidPeriodsId);
        if (!GrowthBidPeriods::isBidOn($bidPeriods)) {
            //Ͷ
            $this->bidError['errorCode'] = self::BID_ERROR_FINISH;
            return false;
        }
        if ($this->checkHouse($houseInfo, $bidPeriodsId) && $this->checkBroker() && $this->checkCredit($score)) {
            if ($bid) {
                //ͶķǷڱξͶǰҪͷ
                $needScore = $this->getNeedScore($bid, $winnerRecord, $myRecord);
                if ($this->checkScore($score, $needScore)) {
                    $bidBrokerLevel = $bid['broker_level']; //ԾͶĵȼ
                    return $this->checkBrokerLevel($bidBrokerLevel);
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    //Ͷ
    public function bid($bidId, $score, $houseId) {
        //ƾͶʱ
        if($this->controlTime()==false) {
            $this->bidError['errorCode'] = self::BID_ERROR_MIN_TIME;
            return false;
        }
        $brokerId = $this->broker['id'];
        $bid = $this->growthBidHouse->findById($bidId);
        if (!$bid) {
            return false;
        }
        $bidPeriodsId = $bid['bid_periods_id'];
        $type = $bid['type'];
        $myRecord = $this->growthBidRecord->findByBidAndHouseId($bidId, $houseId);
        //Ͷļ¼
        $winnerRecord = $this->findTempWinnerRecord($bidId);
        $this->houseSell->setWhere(array('id' => $houseId, 'uid' => $brokerId));
        $houseInfo = $this->houseSell->getOneHouse();
        if ($houseInfo) {
            $houseInfo['bidType'] = $type;
        } else {
            return false;
        }
        if($type==1) {
            $bid['bidWord'] = $houseInfo['blockshowname'];
        } else if($type==2) {
            $bid['bidWord'] = $bid['keyword'];
        }
        $x = $this->checkByRecord($bid, $score, $winnerRecord, $myRecord, $houseInfo);
        if ($x) {
            $bidWord = $bid['bidWord'];
            $winFlag = $this->checkWinBid($winnerRecord, $myRecord);
            switch ($winFlag) {
                case '-1':
                    $fieldData = array('broker_id' => $brokerId,
                        'bid_id' => $bidId,
                        'score' => $score,
                        'house_id' => $houseId,
                        'content' => "{$houseInfo['address']}{$houseInfo['room']}"
                        . "{$houseInfo['hall']}" . " {$houseInfo['buildarea']}O "
                        . "{$houseInfo['price']}",
                        'blockname' => $houseInfo['blockshowname'],
                        'infotype' => $houseInfo['infotype'],
                        'type' => $type,
                        'bid_periods_id' => $bidPeriodsId);
                    $recordId = $this->growthBidRecord->insert($fieldData);
                    if ($recordId) {
                        //
                        $this->growthBidHouse->addJoinNumber($bidId);

                        //ѾμӹͶ
                        $growthBidUserBroker = new GrowthBidUserBroker();
                        $growthBidUserBroker->addJoinBidHouseRecord($brokerId);
                        
                        // 뷿ԴͶͶʣѧ1234
                        $this->growthBrokerCredit->frozenCredit($score,null,'','뷿ԴͶͶʣ'.$bidWord.'۳'.$this->creditName.$score.$this->creditUnit);
                        //˷
                        $this->complete($bid);

                        //ͬʱע
                        if (!$this->hasAttention($bidId, $houseId)) {//ûע
                            $attentionNumber = GrowthBidAttentionHelper::totalNumber($this->broker);
                            if ($attentionNumber < GrowthBidAttentionHelper::ATTENTION_MAX_NUMBER) {
                                $this->attent($bidId, $bidPeriodsId, $houseId);
                            }
                        }
                    } else {
                        $this->bidError['errorCode'] = self::BID_ERROR_SYS_DB;
                        //¼־
                    }
                    break;
                case '0':
                    $fieldData = array('score' => $score,'status'=>'1');
                    $conf = "house_id='$houseId' and bid_id='$bidId'";
                    $affectRows = $this->growthBidRecord->update($fieldData, $conf);
                    if ($affectRows) {
                        $this->growthBrokerCredit->frozenCredit($score,null,'','뷿ԴͶͶʣ'.$bidWord.'׷'.$this->creditName.$score.$this->creditUnit);
                        //֣ľˣbid=$bidand ֡score and status = 1
                        //ּ¼ ⶳ֣frozen= frozen-scoreע֪ͨ
                        $this->complete($bid);
                    } else {
                        
                    }
                    break;
                case '1'://׷
                case '2':
                case '3':
                case '4':
                    $fieldData = array('score' => $score);
                    $conf = "house_id='$houseId' and bid_id='$bidId'";
                    $affectRows = $this->growthBidRecord->add($fieldData, $conf);
                    if ($affectRows) {
                        $this->growthBrokerCredit->frozenCredit($score,null,'','뷿ԴͶͶʣ'.$bidWord.'׷'.$this->creditName.$score.$this->creditUnit);
                    } else {
                        
                    }
                    break;
                default:
                    break;
            }
        }
    }

    public function complete($bid) {
        //֣ľˣbid=$bidand ֡score and status = 1
        //ּ¼ ⶳ֣frozen= frozen-scoreע֪ͨ
        $bidId = $bid['id'];
        $bidWord = $bid['bidWord'];
        $refundRecord = $this->findRecordForRefund($bidId);
        if ($refundRecord) {
            //ЩΪʧ
            $ids = array();
            $refundBroker = array();
            foreach ($refundRecord as $value) {
                $ids[] = $value['id'];
                $temp = array();
                $temp['broker_id'] = $value['broker_id'];
                $temp['score'] = "-" . $value['score'];
                $refundBroker[] = $temp;
            }
            //statusΪʧ
            $this->growthBidRecord->update(array('status' => 0), "id in ('" . implode("','", $ids) . "')");
            //ⶳ
            if ($refundBroker) {
                //$growthCredit = $this->growthBrokerCredit->getGrowthCredit();
                foreach ($refundBroker as $value) {
                    //$growthCredit->unfreeze($value['broker_id'], $value['score']);
                    $this->growthBrokerCredit->frozenCredit($value['score'],$value['broker_id'],'','뷿ԴͶʧܣͶʣ'.$bidWord.''.$this->creditName.abs($value['score']).$this->creditUnit);
                }
            }
        }
    }

    /**
     * һͶķ
     * @param array $bid
     */
    public function lastBidScore($myRecord) {
        if ($myRecord) {
            return $myRecord['score'];
        } else {
            return 0;
        }
    }

    /**
     * ʱӮþͶ˵ľͶ¼
     * @param int $bidId Ͷid
     * @return array Ͷļ¼
     */
    public function findTempWinnerRecord($bidId) {
        return $this->growthBidRecord->findByBid($bidId, "score desc, utime asc", "0,2");
    }

    /**
     * ӮþͶ˵ľͶ¼
     * @param int $bidId Ͷid
     * @return array Ͷļ¼
     */
    public function findWinnerRecord($bidId) {
        return $this->growthBidRecordHistory->findBy("bid_id='$bidId' and status=1", "score desc, utime asc", "0,2");
    }

    /**
     * ˷ֵı־
     * @param int $bidId
     * @return array
     */
    public function findRecordForRefund($bidId) {
        $res = $this->growthBidRecord->findBy("bid_id='$bidId' and status=1", "score desc, utime asc", "2,10");
        if ($res) {
            return $res;
        } else {
            return array();
        }
    }

    /**
     * ͶûԼڼλ
     * @param array $winnerRecord
     * @param array $myRecord
     * @return int Σ0ʾδͶУ1234ʾڼλ -1,ʾûͶ
     */
    public function checkWinBid($winnerRecord, $myRecord) {
        $number = 0;
        if ($myRecord && $winnerRecord) {
            $myRecordId = $myRecord['house_id'];
            $i = 0;
            foreach ($winnerRecord as $value) {
                $i++;
                if ($value['house_id'] == $myRecordId) {
                    $number = $i;
                    break;
                }
            }
        } else {
            $number = '-1';
        }
        return $number;
    }

    /**
     * ؾͶҪͶͻ
     * @return array $result = array('type'=>'','score'=>'');typeʾǷģ0ķ,1,ڶķ֣2,׷ӷ
     */
    public function getNeedScore($bid, $winnerRecord, $myRecord) {
        //Ͷû
        $result = array('type' => '', 'score' => '');
        $bidRank = $this->checkWinBid($winnerRecord, $myRecord);
        if ($bidRank > 0) {//Ͷ
            $result['type'] = self::BID_NEED_SCORE_TYPE_WIN;
            $result['score'] = $this->additionalScore;
        } else {//δͶ
            if (count($winnerRecord) == 2) {
                $result['type'] = self::BID_NEED_SCORE_TYPE_NOT_WIN_1;
                $result['score'] = $winnerRecord[1]['score'] + $this->additionalScore;
            } else {
                $result['type'] = self::BID_NEED_SCORE_TYPE_NOT_WIN_0;
                $result['score'] = $bid?$bid['min_score']:0;
            }
        }
        return $result;
    }

    /**
     * ؾͶϵʾֹʾ
     * @param int $myCredit ҵĻ
     * @param array $needScore ͶҪĻ ͨ getNeedScore($bid,$winnerRecord,$myRecord)
     * @return string ʾַ
     */
    public function tipOnPanel($myCredit, $needScore) {
        $tip = "";
        if ($needScore) {
            $type = $needScore['type'];
            $minScore = $needScore['score'];
            if($this->mode=='credit') {
                $t = "".$this->creditName."Ŷ " . '<a target="_blank" href="./my_growth.php">ȥ׬'.$this->creditName.'&gt;&gt;</a>';
            } else {
                $t = "".$this->creditName."Ŷ ";
            }
            if ($type == 0) {
                $tip = $myCredit < $minScore ? $t : "";
            }
            if ($type == 1) {
                $tip = $myCredit < $minScore ? $t : "";
            }
            if ($type == 2) {
                $tip = $myCredit < 1 ? $t : "";
            }
        }
        return $tip;
    }

    /**
     * Ͷɹʧܵʾ
     * @param array $myRecord
     * @param int $winFlag
     * @return string
     */
    public function tip1OnPanel($myRecord, $winFlag) {
        $myScore = $this->lastBidScore($myRecord);
        if ($winFlag == '-1') {
            $tip2 = "";
        } elseif ($winFlag == 0) {
            $tip2 = "Ͷ" . $myScore . "".$this->creditName.",δǰ2˻";
        } else {
            $tip2 = "Ͷ" . $myScore . "".$this->creditName."";
        }
        return $tip2;
    }

    /**
     * ɼʱԲ
     * @param string $startTime ͶƱʼʱ
     * @param string $endTime ͶƱʱ
     */
    public function TimeRing($startTime, $endTime) {
        $time = time();
        $stime = strtotime($startTime);
        $etime = strtotime($endTime);
        $hours = ($etime - $stime) / 3600;
        $ev = $hours / 4;
        if ($time >= $stime && $time < $stime + 3600 * $ev) {
            return 1;
        } elseif ($time >= $stime + 3600 * $ev && $time < $stime + 3600 * $ev * 2) {
            return 2;
        } elseif ($time >= $stime + 3600 * $ev * 2 && $time < $stime + 3600 * $ev * 4) {
            return 3;
        } else {
            return 4;
        }
    }

    /**
     * Ͷ
     * @param array $needScore
     * @return array
     */
    public function scoreInputDefault($needScore, $myScore) {
        $default = array('span' => '', 'value' => '', 'totalTip' => '');
        if ($needScore) {
            $type = $needScore['type'];
            $minScore = $needScore['score'];
            if ($type == 0) {
                $default['value'] = "" . $minScore;
                $default['span'] = "ҪͶ";
                $default['totalTip'] = "";
            }
            if ($type == 1) {
                $default['value'] = "" . $minScore;
                $default['span'] = "ҪͶ";
                $default['totalTip'] = "";
            }
            if ($type == 2) {
                $default['value'] = "".$minScore;
                $default['span'] = "Ҫ׷";
                $default['totalTip'] = 'Ͷ'.$this->creditName.':<span class="calScore" value="' . $myScore . '" style="width: 21px; color: red;">' . $myScore . '</span>'.$this->creditUnit;
            }
        }
        return $default;
    }

    public function getAttentionList($cPeriods) {
        $bidPeriodsId = $cPeriods['id'];
        $attentionList = $this->findAttention($bidPeriodsId);
        //print_r($attentionList);
        if (!$attentionList) {//ûйעؿ
            return array();
        }
        $bidList = array();
        foreach ($attentionList as $value) {
            $myRecords = $this->findHouseBidRecord($bidPeriodsId, $value['house_id']);
            $bidOne = $this->growthBidHouse->findById($value['target_id']);
            $type = $bidOne['type'];
            $temp = $this->findHouseBidRecordList($cPeriods, $myRecords, $type, $value['house_id']);
            $temp['disabled_bid_link'] = $this->getBidError()?true:false;
            $bidList[] = $temp;//$this->findHouseBidRecordList($cPeriods, $myRecords, $type, $value['house_id']);
        }
        return $bidList;
    }

    /**
     * ȡڷԴͶ
     * @param type $cBidPeriods
     * @param type $myRecord
     * @param type $type
     */
    public function findHouseBidRecordList($cPeriods, $myRecords, $type, $houseId, $bidId = '') {
        $periodsId = $cPeriods['id'];
        $bidPeriodsStatus = $cPeriods['status'];
        $brokerId = $this->getBrokerId();
        $myCredit = $this->broker['credit'];
        if(count($myRecords)) {
            $myRecordsNew = SqlCombinHelper::changeToKeyArray($myRecords, 'type');
            $myRecord = array_key_exists($type, $myRecordsNew)?$myRecordsNew[$type]:array();
        } else {
            $myRecord = array();
        }
        
        //ȡԴϸϢ
        $searchWhere = array('id' => $houseId, 'uid' => $brokerId, 'esta' => 1);
        $this->houseSell->setWhere($searchWhere);
        $houseInfo = $this->houseSell->getOneHouse();
        //жϷԴǷЧ
        $houseInfo['bidType'] = $type;
        if (!$this->checkHouse($houseInfo, $periodsId)) {
            //return false;
        }
        if ($type == 2) {
            $hotSearch = $this->growthBidHouse->findPeriodsHotSearch($periodsId);
            $hotSearchNew = SqlCombinHelper::changeToKeyArray($hotSearch, 'id');
            $houseInfo['hotsearch'] = array();
            $houseInfo['keyword'] = '';
            if ($myRecord) {
                //ѴʾͶ
                $keyword = $hotSearchNew[$myRecord['bid_id']]['keyword'];
                $bidId = $myRecord['bid_id'];
                $houseInfo['hotsearch'][] = array(
                    'bid' => $myRecord['bid_id'],
                    'keyword' => $keyword,
                );
                $houseInfo['keyword'] = $keyword;
            } else {
                //ƥ䷿ԴԾͶĹؼ
                foreach ($hotSearch as $v) {
                    if (strstr($houseInfo['address'], $v['keyword'])) {
                        $houseInfo['hotsearch'][] = array(
                            'bid' => $v['id'],
                            'keyword' => $v['keyword']
                        );
                    }
                }
                if ($bidId) {
                    //ûоͶֻѡĳͶ
                    $keyword = $hotSearchNew[$bidId]['keyword'];
                    $houseInfo['keyword'] = $keyword;
                }
            }
        } else {
            $block = $this->growthBidHouse->findPeriodsBlock($periodsId);
            $blockNew = SqlCombinHelper::changeToKeyArray($block, 'block_id');
            if (!isset($blockNew[$houseInfo['blockid']])) {
                //СͶ
                $this->bidError['errorCode'] = self::BID_ERROR_AUTH_HOUSE;
                return false;
            }
            $bidId = $blockNew[$houseInfo['blockid']]['id'];
        }
        if ($bidId) {
            $houseInfo['bid'] = $bidId;
        } else {
            $houseInfo['bid'] = '';
        }
        //ע¼
        $attentionList = $this->findAttention($periodsId);
        //Ԥ
        //print_r($attentionList);
        $attentionListNew = SqlCombinHelper::changeToDoubleKeyArray($attentionList, 'target_id', 'house_id');
        //print_r($attentionListNew);
        if (isset($myRecord) || $type == 1 || $bidId) {
            $bidOne = $this->growthBidHouse->findById($bidId);
        }
        if ($cPeriods['status'] == 1) {
            //ؾͶ¼
            $houseInfo['my_record'] = $myRecord;
            $houseInfo['bid_status'] = $bidPeriodsStatus;
            $houseInfo['record'] = $bidOne?$this->findTempWinnerRecord($bidOne['id']):array();
            //ؿʹõĻ
            $houseInfo['my_credit'] = $myCredit;
            //ϴͶĻ
            $houseInfo['my_score'] = $this->lastBidScore($houseInfo['my_record']);
            //ע״̬
            if (array_key_exists($bidId, $attentionListNew) && array_key_exists($houseId, $attentionListNew[$bidId])) {
                $houseInfo['attention_id'] = $attentionListNew[$bidId][$houseId];
            }
            //Ĭҳ
            if ($houseInfo['my_record'] == '' && $type == 2 && $bidId == '') {
                $tempBid = $this->growthBidHouse->findById($houseInfo['hotsearch'][0]['bid']);
                $houseInfo['min_score'] = array('type' => 0, 'score' => $tempBid['min_score']);
                $houseInfo['number'] = '--'; //μ     
            } else {
                //ͶҪͷ
                $houseInfo['min_score'] = $this->getNeedScore($bidOne, $houseInfo['record'], $houseInfo['my_record']);
                $houseInfo['number'] = $bidOne?$bidOne['number']:0; //μ     
            }
            //ʾ
            $houseInfo['tip'] = $this->tipOnPanel($houseInfo['my_credit'], $houseInfo['min_score']);
            //жûоͶɹ
            $winFlag = $this->checkWinBid($houseInfo['record'], $houseInfo['my_record']);
            $houseInfo['winFlag'] = $winFlag;
            //ʾ1
            $houseInfo['tip1'] = $this->tip1OnPanel($houseInfo['my_record'], $winFlag);
            //Ĭ
            $houseInfo['score_input_default'] = $this->scoreInputDefault($houseInfo['min_score'], $houseInfo['my_score']);

            //ͶϢ
            $houseInfo['bid_status_str'] = 'Ͷ';
            $houseInfo['end_time'] = $cPeriods['end_time'];
            $houseInfo['tg_start_time'] = $cPeriods['tg_start_time'];
            $houseInfo['tg_end_time'] = $cPeriods['tg_end_time'];
            $houseInfo['start_time'] = $cPeriods['start_time'];
            $houseInfo['timeRing'] = $this->TimeRing($houseInfo['start_time'], $houseInfo['end_time']);
        } else if ($cPeriods['status'] == 3) {
            $houseInfo['bid_status_str'] = 'Ͷ';
            $houseInfo['bid_status'] = $bidPeriodsStatus;
            $houseInfo['tg_start_time'] = $cPeriods['tg_start_time']; //ƹʱ
            $houseInfo['tg_end_time'] = $cPeriods['tg_end_time']; //ƹʱ
            $houseInfo['end_time'] = $cPeriods['end_time']; //Ͷʱ
            $houseInfo['start_time'] = $cPeriods['start_time'];
            $houseInfo['timeRing'] = $this->TimeRing($houseInfo['start_time'], $houseInfo['end_time']);

            //Ͷǰ2λ
            $houseInfo['record'] = $this->findTempWinnerRecord($bidOne['id']);
            $houseInfo['number'] = $bidOne['number']; //μ    
            //ע״̬
            if (array_key_exists($bidOne['id'], $attentionListNew) && $attentionListNew[$bidId][$houseId]) {
                $houseInfo['attention_id'] = $attentionListNew[$bidOne['id']][$houseId];
            }
            //ļ¼
            //echo $tempBid['id'].'x';
            $houseInfo['my_record'] = $myRecord; //ҵļ¼
            $houseInfo['my_credit'] = $myCredit; //ҵĿû
            if ($houseInfo['my_record'] == '' && $type == 2 && $bidId == '') {
                $tempBid = $this->growthBidHouse->findById($hotSearchId[0]);
                $houseInfo['min_score'] = array('type' => 0, 'score' => $tempBid['min_score']);
                $houseInfo['number'] = '--'; //μ     
            } else {
                //ͶҪͷ
                $houseInfo['min_score'] = $this->getNeedScore($bidOne, $houseInfo['record'], $houseInfo['my_record']);
                $houseInfo['number'] = $bidOne['number']; //μ     
            }
            //Ļ
            //㣬ûͶ
            //ϴͶĻ
            $houseInfo['my_score'] = $this->lastBidScore($houseInfo['my_record']);
            //ͻ֣Ǹ
            $houseInfo['min_score'] = $this->getNeedScore($bidOne, $houseInfo['record'], $houseInfo['my_record']);
            //ʾ
            $houseInfo['tip'] = $this->tipOnPanel($houseInfo['my_credit'], $houseInfo['min_score']);
            //ǷͶб
            $winFlag = $this->checkWinBid($houseInfo['record'], $houseInfo['my_record']);

            $houseInfo['winFlag'] = $winFlag;
            //ʾ1
            $houseInfo['tip1'] = $this->tip1OnPanel($houseInfo['my_record'], $winFlag);
            //Ĭ
            $houseInfo['score_input_default'] = $this->scoreInputDefault($houseInfo['min_score'], $houseInfo['my_score']);
        } else if ($cPeriods['status'] == 2) {
            //ͶϢ
            $houseInfo['bid_status_str'] = 'ڴ'; //'ھͶ';
            $houseInfo['bid_status'] = $bidPeriodsStatus;
            $houseInfo['tg_start_time'] = $cPeriods['tg_start_time']; //ƹʱ
            $houseInfo['tg_end_time'] = $cPeriods['tg_end_time']; //ƹʱ
            $houseInfo['end_time'] = $cPeriods['end_time']; //Ͷʱ
            $houseInfo['start_time'] = $cPeriods['start_time']; //Ͷʼʱ
            $houseInfo['timeRing'] = $this->TimeRing($houseInfo['start_time'], $houseInfo['end_time']);
            //ļ¼
            //echo $tempBid['id'].'x';
            //$houseInfo['my_record'] = $myRecord;//ҵļ¼
            $houseInfo['my_credit'] = $myCredit; //ҵĿû
            $houseInfo['number'] = '--'; //μ  
            $houseInfo['record'] = array();
            //Ļ
            //㣬ûͶ
            //ϴͶĻ
            $houseInfo['my_record'] = $myRecord;
            $houseInfo['my_score'] = $this->lastBidScore($houseInfo['my_record']);
            //ͻ֣Ǹ
            if ($type == 2) {
                $tempBid = $this->growthBidHouse->findById($houseInfo['hotsearch'][0]['bid']);
                $houseInfo['min_score'] = array('type' => 0, 'score' => $tempBid['min_score']);
            } else {
                $houseInfo['min_score'] = $this->getNeedScore($bidOne, $houseInfo['record'], $houseInfo['my_record']);
            }
            //ʾ
            $houseInfo['tip'] = $this->tipOnPanel($houseInfo['my_credit'], $houseInfo['min_score']);
            //ǷͶб
            //$winFlag = $this->checkWinBid($houseInfo['record'], $houseInfo['my_record']);
            //$houseInfo['winFlag'] = $winFlag;
            //ʾ1
            // $houseInfo['tip1'] = $this->tip1OnPanel($houseInfo['my_record'], $winFlag); 
            //Ĭ
            $houseInfo['score_input_default'] = $this->scoreInputDefault($houseInfo['min_score'], $houseInfo['my_score']);
        }
        $houseInfo['type'] = 2;
        return $houseInfo;
    }

    /**
     * ȡĳ¾Ͷ״
     * @param type $bid
     */
    public function getNewBidBaseInfo($bidOne) {
        //ǰķֵ
        $bidRecord = $this->findTempWinnerRecord($bidOne['id']);
        //оͶ¼鿴
        //bid_idȡͶ
        $userNumber = $bidOne['number'];
        return array('number' => $userNumber, 'records' => $bidRecord);
    }

    /**
     * б
     * @param array $records ¼
     * @param string $tType  Ͷ״̬GrowthBidPeriods::BID_PERIODS_STATUS_ON;
      GrowthBidPeriods::BID_PERIODS_STATUS_NOT_START;
      GrowthBidPeriods::BID_PERIODS_STATUS_FINISH//ַonhistory,Ĭon
     * @param type $template
     * @param type $myrecord
     * @return type
     */
    public function rankList($records, $tType = GrowthBidPeriods::BID_PERIODS_STATUS_ON, $template = null, $myrecord = null) {
        if (!$records) {
            $records = array();
        }
        $records = array_pad($records, 2, array());
        $html = '';
        foreach ($records as $key => $value) {
            if ($tType == GrowthBidPeriods::BID_PERIODS_STATUS_ON) {
                $html .= $this->renderRankHasScore($key, $value, $myrecord, $template);
            } else {
                $html .= $this->renderRankNoScore($key, $value, $myrecord, $template);
            }
        }
        //echo $html;
        return $html;
    }

    /**
     * Ͷеʾ
     * @param type $k
     * @param type $r
     * @param type $myrecord
     * @param type $template
     * @return string
     */
    private function renderRankHasScore($k, $r, $myrecord = null, $template = null) {
        $no = $k + 1;
        //$rank02 = $no>2?'rank02':'';
        $rank02 = 'rank02';
        if (!empty($r)) {
            //$score = $r['score']?$r['score']:' ';
            //$rank02 = 'rank02';
            if ($myrecord && $myrecord['id'] == $r['id']) {//жǲԼ
                //echo 'xxx';
                //echo "#".$r['id']."--#".$myrecord['id'];
                $rank02 = '';
                $score = '<strong class="num">' . $r['score'] . '</strong>'.$this->creditUnit;
            } else {
                $score = '<strong class="num">ѱռ</strong>';
            }
        } else {
            $score = '<strong class="num">ȱϯ</strong>';
        }
        if ($template) {
            $html = sprintf($template, $no, $rank02, $score);
        } else {
            $html = '<div class="fraction_rank_box"><div class="fraction_rank'
                    . ' radius3"><span class="rank ' . $rank02 . '">NO.' . $no . '</span>'
                    . '<span class="fraction">' . $score . '</span></div></div>';
        }
        return $html;
    }

    /**
     * Ͷʾ
     * @param type $k
     * @param type $r
     * @param type $myrecord
     * @param type $template
     * @return string
     */
    private function renderRankNoScore($k, $r, $myrecord = null, $template = null) {
        $no = $k + 1;
        //$rank02 = $no>2?'rank02':'';
        $score = $r&&$r['score'] ? $r['score'] : ' ';
        $rank02 = 'rank02';
        if ($myrecord) {//жǲԼ
            //echo 'xxx';
            //echo "#".$r['id']."--#".$myrecord['id'];
            if ($r&&$r['id'] == $myrecord['id']) {
                $rank02 = '';
            }
        }
        if ($template) {
            $html = sprintf($template, $no, $rank02, $score);
        } else {
            $html = '<div class="fraction_rank_box"><div class="fraction_rank'
                    . ' radius3"><span class="rank ' . $rank02 . '">NO.' . $no . '</span>'
                    . '<span class="fraction"><strong class="num">' . $score
                    . '</strong>'.$this->creditUnit.'</span></div></div>';
        }
        return $html;
    }

    /**
     * ȡھͶʷ¼
     * @param type $bids
     * @return type
     */
    public function findBidHistoryRecordCount($type, $bid) {
        return $this->growthBidHouse->findHistoryByTypeAndBid($type, $bid);
    }

    /**
     * ȡھͶʷ¼
     * @param type $start
     * @param type $limit
     */
    public function findBidHistoryRecordList($bids) {
        //bid ȡھͶtype 
        //type=1 С ͨblock_id type =2 ƥkeyword
        //ҳʷbidbid<>$bid
        if ($bids) {
            foreach ($bids as $v) {
                $bidNews[] = $v['id'];
            }
            //$bidIds = implode("','", $bidNews);
            //$bidWhere = "bid_id IN ('" . $bidIds . "')";
        }
        foreach ($bids as $value) {
            $bidPeriodsIds[] = $value['bid_periods_id'];
        }
        $growthBidPeriods = new GrowthBidPeriods();
        $bidPeriodsMKey = $bidPeriodsIds;
        $bidPs = $this->mc->get($bidPeriodsMKey);
        if ($bidPs === false) {
            $bidPs = $growthBidPeriods->findBy("id in ('" . implode("','", $bidPeriodsIds) . "')");
            $bidPs = SqlCombinHelper::changeToKeyArray($bidPs, 'id');
            $this->mc->set($bidPeriodsMKey, $bidPs, 3600);
        }
        //$bidHistoryRecord = $this->growthBidRecordHistory->findBidHistoryBy($bidWhere, $start, $limit);
        $bidNewHistoryRecord = array();
        $template = '<div style="float: left; width: 120px;margin-bottom: 2px;"><span class="m_l_33 blod">NO.%s</span><span style="border-right-width: 0px; margin-right: 5px;" class="%s">%s</span>'.$this->creditUnit.'</div>';
        $block = new Block();
        foreach ($bids as $bid) {
            $periodsId = $bid['bid_periods_id'];
            if ($bid['type'] == 1) {
                $blockOne = $block->findOneBy($bid['block_id']);
                $keyword = $blockOne['blockname'];
            } else {
                $keyword = $bid['keyword'];
            }
            $bidNewHistoryRecord[] = array(
                'tg_start_time' => $bidPs[$periodsId]['tg_start_time'],
                'tg_end_time' => $bidPs[$periodsId]['tg_end_time'],
                'number' => $bid['number'],
                'bid_status' => 'ѽ',
                'record_list' => $this->rankList($this->findWinnerRecord($bid['id']), GrowthBidPeriods::BID_PERIODS_STATUS_FINISH, $template),
                'keyword' => $keyword,
            );
        }
        return $bidNewHistoryRecord;
    }

    public function hasAttention($bidId, $houseId) {
        //Ƿע
        $growthAttention = new GrowthBidAttention();
        $brokerId = $this->broker['id'];
        $conf = "broker_id='$brokerId' and type=2 and target_id='$bidId' and house_id='$houseId'";
        $number = $growthAttention->findNumberBy($conf);
        if ($number == 1) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * ǷԹע
     * @param int $bidid Ͷid
     */
    public function checkAttention($bidId, $houseId) {
        //return true;
        if ($this->hasAttention($bidId, $houseId)) {
            return false;
        }
        if ($this->checkBroker()) {
            $bid = $this->growthBidHouse->findById($bidId);
            if ($bid) {
                //$blockId = $bid['broker_id'];
                $bidBrokerLevel = $bid['broker_level']; //ԾͶĵȼ
                return $this->checkBrokerLevel($bidBrokerLevel);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function findAttention($bidPeriodsId) {
        $brokerId = $this->broker['id'];
        $growthAttention = new GrowthBidAttention();
        return $growthAttention->findBy("broker_id='$brokerId' and bid_periods_id='$bidPeriodsId' and type=2");
    }

    public function attent($bidId, $cBidPeriods, $houseId) {
        $fieldData = array();
        $fieldData['broker_id'] = $this->broker['id'];
        $fieldData['type'] = 2;
        $fieldData['target_id'] = $bidId;
        $fieldData['bid_periods_id'] = $cBidPeriods;
        $fieldData['house_id'] = $houseId;
        $growthAttention = new GrowthBidAttention();
        //print_r($fieldData);
        return $growthAttention->insert($fieldData);
    }

    public function cancelAttent($attentionId) {
        $growthAttention = new GrowthBidAttention();
        $brokerId = $this->broker['id'];
        $conf = "id='$attentionId' and broker_id='$brokerId'";
        return $growthAttention->delBy($conf);
    }
    
    /**
     * ƿԲ뾺Ͷʱ
     */
    public function  controlTime() {
        if(isset($_SESSION['last_bid_time'])) {
            $lastTime = $_SESSION['last_bid_time'];
            if($lastTime>time()) {
                return false;
            } else {
                $_SESSION['last_bid_time'] = time()+self::BID_MIN_TIME;
                return true;
            }
        } else {
            $_SESSION['last_bid_time'] = time()+self::BID_MIN_TIME;
            return true;
        }
    }
}
