<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of statistics
 *
 * @author Administrator
 */
class Statistics_Wang_model extends MY_Model 
{
    private $tbl_sell = 'sell';
    private $tbl_rent = 'rent';
    private $tbl_housefreeze = 'house_freeze';
    private $tbl_picdel = 'upload_log';
    private $_tbl_broker_stat = 'broker_stat';
    
    /**
     * Ч۷Դ
     * @var type 
     */
    private $sellCount = null;
    
    /**
     * Ч۶ͼԴ
     * @var type 
     */
    private $sellCountStar = null;
    
    /**
     * ЧⷿԴ
     * @var type 
     */
    private $rentCount = null;
    
    /**
     * ЧͼԴ
     * @var type 
     */
    private $rentCountStar = null;
    
    /**
     * key
     * @var string 
     */
    private $_mem_key ;
    
    public function __construct() 
    {
        parent::__construct(1,1,3);
        //سserver
        $this->load->library('server',array('appName'=>NS_SELL,'strCheckMethod'=>"",'returnMethod'=>"ary",'returnCharSet'=>"gbk"),'serverSell');
        //سserver
        $this->load->library('server',array('appName'=>NS_RENT,'strCheckMethod'=>"",'returnMethod'=>"ary",'returnCharSet'=>"gbk"),'serverRent');
        
        $this->_mem_key = GB_CITY.'_statistics_model';
    }
    
    /**
     * ոſ
     * @param type $uid
     * @param type $groupId
     * @return type
     */
    public function overViewToday($uid,$groupId) 
	{

        // Ч
        $data['sellCountToday'] = $this->sellCountToday($uid);
        $data['rentCountToday'] = $this->rentCountToday($uid);
        $data['countToday'] = $data['sellCountToday'] + $data['rentCountToday'];		

        // ʧЧ
        $data['sellnoCountToday'] = $this->sellCountToday($uid,2);
        $data['rentnoCountToday'] = $this->rentCountToday($uid,2);
        $data['noCountToday'] = $data['sellnoCountToday'] + $data['rentnoCountToday'];

        //ǰ
        $data['sellCount'] = $this->sellCount($uid);
        $data['rentCount'] = $this->rentCount($uid);

		//$data['sell360CountToday'] = $this->sell360Count($uid);
        //$data['rent360CountToday'] = 0;

		//ۺͳȫ
		$data['sell360Count'] = $this->sell360Count($uid);
		$data['rent360Count'] = 0;


        //ǰЧͼ
        $data['sellCountStar'] = $this->sellCountStar($uid);
        $data['rentCountStar'] = $this->rentCountStar($uid);
        
        //ˢ
        $data['refreshNumber'] = $this->refreshNumber($groupId);
        $data['refreshCountToday'] = $this->refreshNumberToday($uid);
        $data['remainRefresh'] = $data['refreshNumber']-$data['refreshCountToday'];

		

         //Ʊǩ
        $data['jtLabelNumber'] = $this->jtLabelNumber($groupId);		
        $data['jtLabelCount'] = $this->jtLabelCount($uid);
        //$data['remainJtLable'] = $data['jtLabelNumber'] - $data['jtLabelCount'];
		$this->load->model("house_tag_package_model");
        $data['remainJtLable'] = $this->house_tag_package_model->get_tag_valid_num($uid,1);

        //·ֱ
        $data['sellNewNumber'] = $this->sellNewNumber($uid);
        $data['sellNewCount'] = $this->sellNewCount($uid);
        $data['remainNew'] = $data['sellNewNumber']-$data['sellNewCount'];

        return $data;
    }

	/**
	 * 360ȫ۷Դͳ
	 *
	 */
	public function sell360Count($uid = 0)
	{
		$result = 0;

		if(empty($uid))
		{
			return $result;
		}

		$mem_key = $this->_mem_key.'_get_active_sell_360_count_'.$uid;
		$cache = $this->mc->get($mem_key);
		
		if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		{
			$result = $cache['data'];
		}
		else
		{
			$this->dbback->where("uid = '$uid' AND esta = '1' AND infofrom = '5' && is360='2'");
			$result = $this->dbback->count_all_results('sell');
			
			$this->mc->add($mem_key , array('is_ok' => 1 , 'data' => $result) , 20);
		}

        return $result;
	}
	
	/**
     * նַ360ȫԴͳ
	 *
	 */
	public function sell360CountToday($uid,$esta=1)
	{
		$house_add = 0;
		$today = strtotime(date('Y-m-d 00:00:00'))-86400;
		if( $uid > 0)
		{
			$mem_key = $this->_mem_key.'_get_sell_360_count_today_'.$uid."_".$esta;
			$cache = $this->mc->get($mem_key);
			
		    if(isset($cache['is_ok']) && $cache['is_ok'] == 1)
		    {
		        $house_add = $cache['data'];
		    }
			else
			{
				$today = strtotime(date('Y-m-d 00:00:00'));
				$cond_where = "uid = '$uid' AND esta='$esta' AND infofrom = '5' AND creattime > '$today' && is360='2'";
				$this->load->model('sell_model');
				$house_add = $this->sell_model->find_count_by($cond_where);
				
				$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$house_add) , 20);
			}
		}
		
        return $house_add;
	}

    /**
     * շ۷Դ
     * @param type $uid
     * @param int $esta 1ʾЧ2ʾЧ
     * @return type
     */
    public function sellCountToday($uid,$esta=1) 
    {   

		//$mem_key = $this->_mem_key.'_get_sell_count_today_'.$uid."_".$esta;
        //$this->mc->delete($mem_key);
      //  $cache = $this->mc->get($mem_key);
        
      //  if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
      //  {
       //     $house_add = $cache['data'];
       // }
        //else
        //{
			$house_add = 0;
			$today = strtotime(date('Y-m-d 00:00:00'));
			if( $uid > 0)
			{
				$today = strtotime(date('Y-m-d 00:00:00'));
				$cond_where = "uid = '$uid' AND esta='$esta' AND infofrom = '5' AND creattime > '$today'";
				$this->load->model('sell_model');
				$house_add = $this->sell_model->find_count_by($cond_where);
				
				//$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$house_add) , 20);
			}
		//}
        
        return $house_add;
    }
    
    /**
     * շⷿԴ
     * @param type $uid
     * @param int $esta 1ʾЧ2ʾЧ
     * @return type
     */
    public function rentCountToday($uid,$esta=1)
    {
		$mem_key = $this->_mem_key.'_get_rent_count_today_'.$uid."_".$esta;
        //$this->mc->delete($mem_key);
        $cache = $this->mc->get($mem_key);
        
        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $house_add = $cache['data'];
        }
        else
        {
			$house_add = 0;
			$today = strtotime(date('Y-m-d 00:00:00'));
			if( $uid > 0)
			{
				$today = strtotime(date('Y-m-d 00:00:00'));
				$cond_where = "uid = '$uid' AND esta='$esta' AND infofrom = '5' AND creattime > '$today'";
				$this->load->model('rent_model');
				$house_add = $this->rent_model->find_count_by($cond_where);
				$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$house_add) , 20);
			}
		}
        
        return $house_add;
    }
    /**
     * ۷Դ
     * @param int $uid ˺ű
     * @return int Դ
     */
    public function sellCount($uid) 
    {
        if($this->sellCount === null) 
        {   
			$mem_key = $this->_mem_key.'_get_active_sell_count_'.$uid;
			//$this->mc->delete($mem_key);
			$cache = $this->mc->get($mem_key);
			
			if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
			{
				$this->sellCount = $cache['data'];
			}
			else
			{
				$cond_where = "uid = '$uid' AND esta = '1' AND infofrom = '5'";
				$this->load->model('sell_model');
				$this->sellCount = $this->sell_model->find_count_by($cond_where);

				/*$this->dbback->select("id,is360")->where("uid = '$uid' AND esta = '1' AND infofrom = '5'");
				$sellInfo = $this->dbback->get('sell')->result_array();
				
				$this->sellCount = 0;
				if(!empty($sellInfo))
				{
					foreach($sellInfo as $key => $item)
					{
						$this->sellCount += 1;

						if($item['is360'] == '2')
						{
							$this->sellCount += 1;
						}
					}
				}*/


                $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$this->sellCount) , 20);
			}
        }
        return $this->sellCount;
    }
    
    /**
     * ЧͼԴ
     * @param int $uid ˺ű
     * @return int Դ
     */
    public function sellCountStar($uid) 
    {
        if($this->sellCountStar === null) 
        {
			$mem_key = $this->_mem_key.'_get_sell_count_star_'.$uid;
			//$this->mc->delete($mem_key);
			$cache = $this->mc->get($mem_key);
			
			if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
			{
				$this->sellCountStar = $cache['data'];
			}
			else
			{
				$cond_where = "uid = '$uid' AND esta = '1' AND infofrom = '5' AND isstar = 3";
				$this->load->model('sell_model');
				$this->sellCountStar = $this->sell_model->find_count_by($cond_where);
                $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$this->sellCountStar) , 20);
			}
        }
        
        return $this->sellCountStar;
    }
    
    /**
     * ⷿԴ
     * @param int $uid ˺ű
     * @return int Դ
     */
    public function rentCount($uid) 
    {
        if($this->rentCount === null)
        {
			$mem_key = $this->_mem_key.'_get_active_rent_count_'.$uid;
			//$this->mc->delete($mem_key);
			$cache = $this->mc->get($mem_key);
			
			if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
			{
				$this->rentCount = $cache['data'];
			}
			else
			{
				$cond_where = "uid = '$uid' AND esta = '1' AND infofrom = '5'";
				$this->load->model('rent_model');
				$this->rentCount = $this->rent_model->find_count_by($cond_where);
                $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$this->rentCount) , 20);

			}
        }
        
        return $this->rentCount;
    }

    /**
     * ЧͼԴ
     * @param int $uid ˺ű
     * @return int Դ
     */
    public function rentCountStar($uid) 
    {
        if($this->rentCountStar === null) 
        {
			$mem_key = $this->_mem_key.'_get_rent_count_star_'.$uid;
			//$this->mc->delete($mem_key);
			$cache = $this->mc->get($mem_key);
			
			if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
			{
				$this->rentCountStar = $cache['data'];
			}
			else
			{
				$cond_where = "uid = '$uid' AND esta = '1' AND infofrom = '5' AND isstar = 3";
				$this->load->model('rent_model');
				$this->rentCountStar = $this->rent_model->find_count_by($cond_where);
                $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$this->rentCountStar) , 20);

			}
        }
        
        return $this->rentCountStar;
    }
    
    
    /**
     * Υ淿Դ
     * @param int  $uid
     * @param string $startTime
     * @param string $endTime
     */
    public function countViolationHouse($uid,$startTime,$endTime) 
    {
		$mem_key = $this->_mem_key.'_get_count_violation_house_'.$uid."_".$startTime."_".$endTime;
		//$this->mc->delete($mem_key);
		$cache = $this->mc->get($mem_key);
		
		if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		{
			$count = $cache['data'];
		}
		else
		{
            $this->dbback->select("id")->from($this->tbl_housefreeze)
                ->where("agentcode = 'B000' AND uid = $uid AND freezetime > $startTime AND freezetime < $endTime");
            $count = $this->dbback->count_all_results();
            $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$count) , 20);


		}
        return $count;
    }
    
    
    /**
     * ΥͼƬ
     * @param int  $uid
     * @param string $startTime
     * @param string $endTime
     */
    public function countViolationPic($uid,$startTime,$endTime) 
    {
		$mem_key = $this->_mem_key.'_get_count_violation_pic_'.$uid."_".$startTime."_".$endTime;
		//$this->mc->delete($mem_key);
		$cache = $this->mc->get($mem_key);
		
		if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		{
			$count = $cache['data'];
		}
		else
		{
			$this->dbback->select("id")->from($this->tbl_picdel)
					->where("uid = $uid and sort != '99' and optime > $startTime and optime < $endTime");
			$count = $this->dbback->count_all_results();
            $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$count) , 20);
		}
        return $count;
    }
    
    
    /**
     * ײˢ
     * @param type $packageId
     * @return type
     */
    public function refreshNumber($packageId) 
    {
		$mem_key = $this->_mem_key.'_get_refresh_number_'.$packageId;
		//$this->mc->delete($mem_key);
		$cache = $this->mc->get($mem_key);
		
		if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		{
			$groupRefreshNumber = $cache['data'];
		}
		else
		{
			$this->load->model("broker_package_model",'package');
			$package = $this->package->find_by_id($packageId);        
            $groupRefreshNumber = $package['package_refresh_num'];
            $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$groupRefreshNumber) , 20);
		}

        return $groupRefreshNumber;
    }
    
    
    /**
     * ˢ
     * @param type $uid
     */
    public function refreshNumberToday($uid) 
    {
        $this->load->model("log_refresh");
        $refreshnum = $this->log_refresh->findTodayNumberByBrokerId($uid);
        
        return $refreshnum;
    }
    
    
    /**
     * ײͱǩ
     */
    public function jtLabelNumber($packageId) 
    {   
		$mem_key = $this->_mem_key.'_get_jt_label_number_'.$packageId;
		//$this->mc->delete($mem_key);
		$cache = $this->mc->get($mem_key);
		
		if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
		{
			$tag_packge_num = $cache['data'];
		}
		else
		{
			$tag_packge_num = 0;
			
			if( $packageId > 0 )
			{
				$this->load->model('broker_package_model');
				$packge_info = $this->broker_package_model->find_by_id($packageId);				
				$tag_packge_num = (isset($packge_info) && !empty($packge_info)) ?
						$packge_info['package_tag_num'] : 0;				
			    $this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$tag_packge_num) , 20);

			}
		}
        
        return $tag_packge_num;
    }
    
    
    /**
     * ñǩ
     * 
     * @param int $uid ˺
     * @param int $update_cache ʶ0棬1û桢
	 * @param   int $force_db Ƿǿ⣬1
     * return  int Ʊǩ
     */
    public function jtLabelCount($uid , $update_cache = 0 , $force_db = 0) 
    {   
        $tag_num_used = 0;
        
        if( $uid > 0)
        {   
            $date   = date('Y-m').'-1 00:00:00';
            $monthstartime  = strtotime($date);
            $mem_key = $this->_mem_key .'_jtLabelCount_'.$uid.'_'.$monthstartime;
            if( $update_cache == 1 )
            {
                $this->mc->delete($mem_key);
            }
            $cache = $this->mc->get($mem_key);
            
            if(isset($cache['is_ok']) && $cache['is_ok'] == 1)
            {
                $tag_num_used = $cache['data'];
            }
            else 
            {	
				if($force_db == 1)
				{
					$this->db->where("uid = $uid AND addtime >= $monthstartime");
					$tag_num_used = $this->db->count_all_results('house_tag');
				}
				else
				{
					$this->dbback->where("uid = $uid AND addtime >= $monthstartime");
					$tag_num_used = $this->dbback->count_all_results('house_tag');
				}

                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$tag_num_used), 300);
            }
        }
        
        return $tag_num_used;
    }
    
    
    /**
     * ·ֱ,ײͿõ
     * @return int
     */
    public function sellNewNumber($uid) 
    {
       $nofee_num = 0;
       if( $uid > 0 )
       {    
            $this->load->model('broker_model');
            $this->broker_model->set_uid($uid);
            $broker_info = $this->broker_model->get_broker_info();
            
            $nofee_num = (is_array($broker_info) && !empty($broker_info)) ?
                    $broker_info['nofee_num'] : 0 ;
       }
       
       return $nofee_num;
    }

    /**
     * ˺ŵǰʱ㼤״̬·ֱ۷Դ
     */
    public function sellNewCount($uid) 
    {   
        $nofee_num = 0;
        
        if( $uid > 0)
        {
            $cond_where = "uid = '$uid' AND esta = '1' AND infofrom = '5' AND nofee = 1";
            $this->load->model('sell_model');
            $nofee_num = $this->sell_model->find_count_by($cond_where);
        }
        
        return $nofee_num;
    }

    /**
     * ʷʹ
     * @param type $uid
     * @param type $startTime Y-m-d
     * @param type $endTime Y-m-d
     * @return type
     */
    public function historyCount($uid,$startTime,$endTime)
    {
        $startTime = $startTime;
        $endTime = $endTime;
        $count = 0;
        if( $uid > 0)
        {   
            $mem_key = $this->_mem_key .'_historyCount_'.$uid.'_'.$startTime.'_'.$endTime;
            $cache = $this->mc->get($mem_key);
            
            if(isset($cache['is_ok']) && $cache['is_ok'] == 1)
            {
                $count = $cache['data'];
            }
            else 
            {
                $this->dbback->where("uid = $uid AND stattime >= '$startTime' AND stattime <= '$endTime'");
                $count =  $this->dbback->count_all_results($this->_tbl_broker_stat);
                
                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$count),  3600);
            }
        }
        
        return $count;
    }
    
    
    /**
     * ʷʹ
     * @param type $uid
     * @param type $startTime
     * @param type $endTime
     * @param type $limitStart
     * @param type $limit
     * @return type
     */
    public function historyList($uid , $startTime , $endTime , $limitStart , $limit , $desc = 0)
    {	
        $result = array();
        $desc_str = $desc == 0 ? 'DESC' : 'ASC';
        
        if( $uid > 0)
        {   
            $mem_key = $this->_mem_key .'_historyList_'.$uid.'_'.$startTime.'_'.$endTime.'_'.$limitStart.'_'.$limit.'_'.$desc;
            $cache = $this->mc->get($mem_key);
            
            if(isset($cache['is_ok']) && $cache['is_ok'] == 1 && false)
            {
                $result = $cache['data'];
            }
            else 
            {
                $select_arr = array('agentcode','uid','stattime','sell_add','rent_add',
                            'sell_add_valid','rent_add_valid','total_refresh',
                            'refresh','click_num','sell_star_num','rent_star_num',
                            'sell_house_num','rent_house_num','tag_num','is_tag_num',
                            'package_tag_num','nofee_limit','nofee_num','panorama'
                            );
				
                $this->dbback->select($select_arr);
                $this->dbback->where("uid = $uid AND stattime >= '$startTime' AND stattime <= '$endTime'");
                $this->dbback->order_by('stattime',$desc_str);
                $this->dbback->limit($limit,$limitStart);

                $result = $this->dbback->get($this->_tbl_broker_stat)->result_array();
                
                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$result),  3600);
            }
        }
        return $result;
    }
    
    
    /**
     * ʷĳʹ
     * @param type $uid
     * @param type $time
     * @return type
     */
    public function historyDay($uid,$time) 
    {   
        $data_info = array();
        if(  $uid > 0)
        {
            $mem_key = $this->_mem_key .'_historyDay_'.$uid.'_'.$time;
            $cache = $this->mc->get($mem_key);
            
            if(isset($cache['is_ok']) && $cache['is_ok'] == 1)
            {
                $data_info = $cache['data'];
            }
            else 
            {
                $this->dbback->from($this->_tbl_broker_stat)
                    ->where("uid = $uid AND stattime = '$time'");
                $data_info = $this->dbback->get()->row_array();
                
                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$data_info),  3600);
            }
        }
        
        return $data_info;
    }
    
    /**
     * Ч۷Դ
     */
   public function sellNumInvalid($uid)
   {   
       $invalid_num = 0;
       
        if( $uid > 0)
        {
            $cond_where = "uid = '$uid' AND esta IN(2,5) AND infofrom = '5'";
            $this->load->model('sell_model');
            $invalid_num = $this->sell_model->find_count_by($cond_where);
        }
        
        return $invalid_num;
   }
   
   
    /**
     * ЧⷿԴ
     */
    public function rentNumInvalid($uid)
    {
       $invalid_num = 0;
       
       if( $uid > 0)
       {
            $cond_where = "uid = '$uid' AND esta IN(2,5) AND infofrom = '5'";
            $this->load->model('rent_model');
            $invalid_num = $this->rent_model->find_count_by($cond_where);
       }
        
       return $invalid_num;
    }
   
   
    /**
    * ԤԼִˢ
    * @param int $uid ˺
    * @param string $day 
    * @return int ִ
    */
    public function reserve_refresh( $uid, $day = '')
    {   
        $uid = intval($uid);
        $countday =  $day == '' ? date('Y-m-d') : $day ;
        $this->dbback->where("uid = '".$uid."' AND  ymd = '".$countday."'");
        $num_rows = $this->dbback->count_all_results('reserve_refresh_deal_log');
        
        return $num_rows;
    }
    
    
    /**
    * REAL
    * @param int $uid ˺
    * @return int REAL
    */
    public function real_num_limit($uid)
    {   
       $real_limit = 0;
       if( $uid > 0 )
       {    
            $this->load->model('broker_model');
            $this->broker_model->set_uid($uid);
            $broker_info = $this->broker_model->get_broker_info();
            
            $real_limit = (is_array($broker_info) && !empty($broker_info)) ?
                    $broker_info['real_limit'] : 0 ;
       }
       
       return $real_limit;
    }
    
    /**
    * REAL
    * @param int $uid ˺
    * @param string $day 
    * @return int REAL
    */
    public function real_num_today($uid)
    {   
        $uid = intval($uid);
        $real_num =  0;
        
        if( $uid > 0 )
        {   
            $cond_where = "uid = '$uid'  AND esta = '1' AND infofrom = '5' AND isreal = 1";
            $this->load->model('sell_model');
            $real_num = $this->sell_model->find_count_by($cond_where);
        }
        return $real_num;
    }
    
   
    /**
    * ȡ˵ͳ
    * @param int $uid ˺
    * @param string $start_day ʼ
    * @param string $end_day ֹ
    * @param string $order_key ؼ
    * @param string $order_by 
    * @return array ˵
    */
    public function get_broker_clickdata( $uid ,$start_day ,$end_day ,$order_key='stattime' ,$order_by = 'ASC')
    {   
        $click_info = array();
        
        if( $uid > 0)
        {   
            $mem_key = $this->_mem_key .'_get_broker_clickdata_3_'.$uid.'_'.$start_day.'_'.$end_day.'_'.$order_key.'_'.$order_by;
            $cache = $this->mc->get($mem_key);
            if(isset($cache['is_ok']) && $cache['is_ok'] == 1 && false)
            {
                $click_info = $cache['data'];
            }
            else
            {
                //ѯֶ
                $this->dbback->select("click_num,sell_click,sell_star_click,rent_star_click, stattime");
                //ѯ
                $cond_where = "uid = '".$uid."' AND stattime BETWEEN '".$start_day."' AND '".$end_day."'";
                $this->dbback->where($cond_where);
                //
                $this->dbback->order_by($order_key, $order_by);
                $click_info =  $this->dbback->get($this->_tbl_broker_stat)->result_array();
                
                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$click_info),  3600);
            }
        }

        return $click_info;
    }
    
    
    /**
     * 
     * @param type $sql
     * @return boolean
     */
    public function sellQuery($sql) 
    {	
        $res = $this->serverSell->query($this->lql($sql));
        
        if( isset($res['MSG']) && $res['MSG'] === 'ok') 
        {
            return $res;
        } 
        else 
        {
            return false;
        }
    }
    
    
    /**
     * 
     * @param type $sql
     * @return boolean
     */
    public function rentQuery($sql) 
    {	
        $res = $this->serverRent->query($this->lql($sql));
        if(isset($res['MSG']) && $res['MSG'] === 'ok') 
        {
            return $res;
        } 
        else 
        {
            return false;
        }
    }
    
    
    /**
     * ƴSQL
     * @param string $sql
     * @return string
     */
    public function lql($sql) 
    {
        return $sql . ' LUC';
    }
    
    
    /**
     * luc صļ¼ʧܻûж0
     * @param type $lucRresult
     * @return int
     */
    private function lcount($lucRresult) 
    {
        if($lucRresult) 
        {
            return $lucRresult['TOTAL'];
        } 
        else 
        {
            return 0;
        }
    }
    
   //ԤԼδˢ
   public function getReserveRemainNum($uid)
   {	    
        $memkey = $uid . "_reserverRemainNum_nj";
        $cache = $this->mc->get($memkey);
        
        if($cache['isok'] == 1) 
        {
            $remainNum = $cache['data'];
        } 
        else 
        {
            $remainNum = 0;			
            $this->dbback->select("id");
            $this->dbback->where("uid = $uid");  			
            $getProjectId = $this->dbback->get("reserve_refresh_project")->result_array();
            
            if ($getProjectId) 
            {
                $getProjectNewId = array();
                
                foreach($getProjectId as $v) 
                {
                    $getProjectNewId[] = $v['id'];
                }
                
                $pids = implode(',', $getProjectNewId);
                if ($pids) 
                {
                    $nowShortDate = date('H:i:s');
                    $this->dbback->select("pid, count(*) as num");
                    $where = "pid in ($pids) and time >= '$nowShortDate'";                   
                    $this->dbback->where($where);  	
                    $this->dbback->group_by('pid');
                    $hasPid = $this->dbback->get("reserve_refresh_project_time")->result_array();
                    
                    if ($hasPid) 
                    {
                        //ֵĽ
                        $hasPidNum = array();
                        foreach($hasPid as $v) 
                        {
                            $hasNewPid[] = $v['pid'];
                            $hasPidNum[$v['pid']] = $v['num'];
                        }
                        
                        if ($hasNewPid) 
                        {
                            $hasNewPids = implode(',', $hasNewPid);
                            $this->dbback->select("count(id) as num, pid");
                            $where = "pid IN($hasNewPids)";                   
                            $this->dbback->where($where);  	
                            $this->dbback->group_by('pid');
                            $housePid = $this->dbback->get("reserve_refresh_project_house")->result_array();  
                            if ($housePid) 
                            {
                                foreach($housePid as $v) {
                                    $remainNum = $remainNum +  $hasPidNum[$v['pid']] * $v['num'];
                                }
                            }
                        }
                    }
                }
            }
            $this->mc->add($memkey, array('isok'=>1,'data'=>$remainNum), 60);
        }
        return $remainNum;
    }
}
/* End of file statistics_model.php */
/* Location: ./models/statistics_model.php */