<?php
/**
 * 
 *
 * @author sun
 */
class PaymentBrokerHousebean {
    
    /**
     * ֶ
     * @var object 
     */ 
    private $credit;
    
    /**
     * ¼
     * @var object 
     */
    private $housebeanRecord;
    
    /**
     * 
     * @var object 
     */
    private $housebeanWay;
    
    /**
     * 
     * @var array
     */
    private $broker;
    
    public function __construct($broker = array()) {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->credit = new GrowthCredit();
        $this->housebeanRecord = new PaymentHousebeanRecord();
        $this->housebeanWay = new PaymentHousebeanWay();
        $this->broker = $broker;
    }
    
    /**
     * ȡ˱
     * @return int
     */
    private function getBrokerId() {
        return $this->broker['id'];
    }
    
    /**
     * ȡ·
     * @param string $wayAlias 
     * @return int
     */
    private function getNumByWayAlias($wayAlias) {
        return $this->housebeanWay->getNumByWayAlias($wayAlias);
    }
    
    /**
     * ȡϢ
     * @param string $wayAlias 
     * @return int
     */
    private function getDescriptionByWayAlias($wayAlias) {
        //δӶ
        return $this->housebeanWay->getDescriptionByWayAlias($wayAlias);
    }
    
    /**
     * þ˵ǰֵ顣
     * @return array  
     */
    public function getBrokerCredit($brokerId) {
        $credit = new GrowthCredit();
        return $credit->getValidCredit($brokerId);
    }
    
    /**
     * ӷ
     * @param string $wayAlias ȡķʽ
     * @param string $description ȡʽԶ
     * @param int $num 
     * @param string $transactionId ׺
     * @return array
     */
    public function increase($wayAlias, $description = null,
            $num = null, $ishidden = 1, $transactionId = null) {
        $brokerId = $this->getBrokerId();
        //Դ
        $source = PaymentHousebeanSource::getSource();
        //ж
        if ($wayAlias == null) {
            return array('status' => false, 'msg' => 'wayAliasֶβΪ');
        }
        //
        if($num == null) {
            $num = $this->getNumByWayAlias($wayAlias);
        } else {
            $num = abs($num);
        }
        //
        if($description == null) {
            $description = $this->getDescriptionByWayAlias($wayAlias);
        }
        //׺
        if ($transactionId == null) {
            $transactionId = PaymentTransactionId::getTransactionId($wayAlias);
        }
        //ӷ
        $updateNumStatus = $this->credit->addCreditToOne($brokerId, $num);

        if ($updateNumStatus) {
            //Ӽ¼
            $this->housebeanRecord->insert($brokerId, $transactionId, $wayAlias, 
                    $source, $num, $description, $ishidden);
            $arrRtnResult['status'] = 1;
            $arrRtnResult['transaction_id'] = $transactionId;
            $arrRtnResult['num'] = $num;
        } else {
            $arrRtnResult['status'] = 0;
            $arrRtnResult['msg'] = 'ӷʧ';
        }
        return $arrRtnResult;
    }
    
    
    /**
     * ٷ
     * @param string $wayAlias ȡķʽ
     * @param string $description ȡʽԶ
     * @param int $num 
     * @param string $transactionId ׺
     * @return array
     */
    public function reduce($wayAlias,$description = null, 
            $num = null, $ishidden = 1, $transactionId = null) {
        $arrRtnResult = array();
        $brokerId = $this->getBrokerId();
        //Դ
        $source = PaymentHousebeanSource::getSource();
        //ж
        if ($wayAlias == null) {
            return array('status' => false, 'msg' => 'wayAliasֶβΪ');
        }
        //
        if($num == null) {
            $num = $this->getNumByWayAlias($wayAlias);
        } else {
            $num = '-'. abs($num);
        }
        $credit = $this->getBrokerCredit($brokerId);
        //ҾĿǰ
        if ($wayAlias != 'systemReduce' && $credit < abs($num)) {
            $arrRtnResult['status'] = 2;
            $arrRtnResult['msg'] = '';
        } else {
            if ($wayAlias == 'systemReduce' && abs($num) > $credit) {
                $num = '-'. abs($credit);
            }
            //
            if($description == null) {
                $description = $this->getDescriptionByWayAlias($wayAlias);
            }
            //
            if ($transactionId == null) {
                $transactionId = PaymentTransactionId::getTransactionId($wayAlias);
            }
            //۳
            $updateNumStatus = $this->credit->addCreditToOne($brokerId, $num);
            if ($updateNumStatus) {
                //Ӽ¼
                $this->housebeanRecord->insert($brokerId, $transactionId, $wayAlias, 
                        $source, $num, $description, $ishidden);
                $arrRtnResult['status'] = 1;
                $arrRtnResult['transaction_id'] = $transactionId;
                $arrRtnResult['num'] = $num;
            } else {
                $arrRtnResult['status'] = 0;
                $arrRtnResult['msg'] = '۳ʧ';
            }
        }
        return $arrRtnResult;
    }
    
    /**
     * ߷
     * @param int $num  
     * @param int $brokerId ˱
     * @param string $wayAlias ȡķʽ
     * @param string $description 
     * @return true or false
     */
    public function frozen($num, $brokerId, $wayAlias, $ishidden, $description='') {
        //Դ
        $source = PaymentHousebeanSource::getSource();
        if($num > 0) { 
            $x = -$num;
        } else if($num < 0) {
            $x =  abs($num);
        }
        //׺
        $transactionId = PaymentTransactionId::getTransactionId($wayAlias);
        if($brokerId === null) { $brokerId = $this->getBrokerId();}
        $status = $this->credit->frozen($brokerId, $num);
        //Ӽ¼
        $this->housebeanRecord->insert($brokerId, $transactionId, $wayAlias, $source, 
                $x, $description, $ishidden);
        return $status;
    }
}
