<?php

/**
 * statistics_plus
 * ĬϽַgbk,ҳַgbk,ֻ֧getʽ$dayʽdate("Ymd")
 * @package classes  
 * @author breathing
 * @copyright www.house365.com
 * @version 2013
 * @access public
 */
class statistics_plus {

    public  $appName;
	public  $appName_old;
    public  $city;
    public  $sourceCharSet;
    public  $inChar;
    public  $outChar;
    
    private $mc;

    /**
     * 
     * @param mixed $appName Ӧ
     * @param string $sourceCharSet 
     * @return
     */
    public function __construct() {

        $ci = & get_instance();
        $configStat = $ci->config->item('statistics');
        $configStatOld = $configStat[1]['old'];
		$configStatNew = $configStat[1]['new'];
        if(!$configStatOld) 
		{
            error_log('ͳô');
            show_404();
        }

        $this->appName = $configStatNew['appName'];
		$this->appName_old = $configStatOld['appName'];
        $this->city = $configStatOld['city'];
        $this->sourceCharSet = strtolower($configStatNew['charSet']);

        $ci->load->library('My_memcached',null,'memcached');

        if(!$ci->memcached) 
		{
            show_404();
        }

		$this->mc = $ci->memcached;
    }

    /**
     * ȡСܵм¼(xz_new 2013-06-18)
     * @param day,ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app,Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit,ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc ,ͳ1=0
     * @param string district  
     * @return м¼
     * @throws RemoteException
     */
    public function getClickCountListOfBlockWeekly($day = '', $app = 'sell', $limit = '', $desc = '', $district = '') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountListOfBlockWeekly,params:[" . $day . "," . $app . "," . $limit . "," . $desc . ",'" . $district . "'," . $this->city . "]}";
        $strData = $this->curl_get_contents($url);

        $array_data = json_decode($strData, TRUE);
        $array_data = json_decode($array_data['returnobject'], TRUE);
        return $array_data;
    }

    /**
     * ȡСܵм¼(xz_new 2013-06-18)
     * 
     * @param day   ,ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   ,Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ,ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ,ͳ1=0
     * @return м¼
     * @throws RemoteException
     */
    public function getClickCountListOfDistrictWeekly($day = '', $app = 'sell', $limit = '', $desc = '') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountListOfDistrictWeekly,params:[" . $day . "," . $app . "," . $limit . "," . $desc . "," . $this->city . "]}";

        $strData = $this->curl_get_contents($url);
        return $this->json_to_array($strData);
    }

    /**
     *  ȡ¸ΧСԴľۺͷԴͳ
     * @param day,ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid,id
     * @param regionType, ͳƵķΧ1-С 2-ֵ 3-
     * @param idСidֵ߽idֵregionType ʹ
     * @param app,Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return һͳƼ¼ۡԴϢ
     */
    public function getHouseCountByUidRegion($day = '', $uid='', $regionType ='', $id = '', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountByUidRegion,params:[" . $day . "," . $uid . "," . $regionType . "," . $id . "," . $app . "]}";
        $strData = $this->curl_get_contents($url);
        $array_data = json_decode($strData, TRUE);
        $array_data = json_decode($array_data[returnobject], TRUE);
        return ($array_data);
    }

    /**
     * ȡ 巶ΧСľۡԴͳ  (xz_new 2013-06-18)
     * @param day,ͳڣyyyyMMdd룬ĬΪǰһ
     * @param regionType, ͳƵķΧ1-С 2-ֵ 3-
     * @param idСidֵ߽idֵregionType ʹ
     * @param app,Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return һͳƼ¼ۡԴϢ
     */
    public function getHouseCountByRegion($day = '', $regionType='', $id='', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountByRegion,params:[" . $day . "," . $regionType . "," . $id . "," . $app . "," . $this->city . "]}";
        $strData = $this->curl_get_contents($url);

        $array_data = json_decode($strData, TRUE);
        $array_data = json_decode($array_data[returnobject], TRUE);

        return ($array_data);
    }

    /**
     * ȡĳһĳ˲¼
     * @param day,ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid,id
     * @param app,Ӧ,rent ⷿsell ַ룬ĬΪsell,Ϊsell+rent
     * @param start,ҳѯļ¼ֵڻ 0
     * @param limit,ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc,ղʱ1=0
     * @return
     * @throws RemoteException
     */
    public function getOperateList($day = '', $uid='', $app='', $start='', $limit='', $desc = '0') 
	{
        $url = "http://".$this->appName."{name:OperateCount,method:getOperateList,params:[".$day.",".$uid."," .$app.",".$start.",".$limit.",".$desc."]}";
		//echo $url;
        return $this->get_array_data($url);
    }

    /**
     * ȡĳһ쾭˲ͳ (xz_new 2013-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @param operateType   ͳƵķΧ0 е,>0ضӦĲ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell+rent
     * @param fid  Դid
     * @return
     */
    public function getOperateCount($day = '', $uid = '', $operateType = 0, $app = '',$fid = 0)
	{
        if(!empty($app)){
            $str = '&app='.$app;
        }else{
            $str = '';
        }
        if($operateType==0)
        {


            $url = NewStatisticsUrl."/operate?type=getOperateUIDDayCount&city=".GB_CITY."&day=".$day."&uid=".$uid.$str."&fid=".$fid;
        }
        else
        {
            $url =NewStatisticsUrl."/operate?type=getOperateUIDDayCount&city=".GB_CITY."&day=".$day."&uid=".$uid."&operatetype=".$operateType.$str.'&fid='.$fid;

        }
//        if(!empty($fid)){
//            exit($url);
//        }
        return $this->get_array_data($url);
    }

    /**
     * ȡĳһĳ˲¼ (xz_new 2013-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell+rent
     * @param start ҳѯļ¼ֵڻ 0
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ղʱ1=0
     * @param type  1 2ˢ 3ɾ 4ʧЧ 5ٷ,0,ȫ
     * @param fid  Դid
     * @return
     * @throws RemoteException
     */
    public function getOperateListByType($day = '', $uid='', $app='', $start='0', $limit='0', $desc = 0, $type = 0, $fid =0) {

        if($type==0)
        {
            if($app)
            {
                $url = NewStatisticsUrl. "/operate?type=getOperateUIDDayDetail&city=".GB_CITY."&day=".$day."&uid=".$uid."&start=".$start."&limit=".$limit."&app=".$app;
            }
            else
            {
                $url = NewStatisticsUrl. "/operate?type=getOperateUIDDayDetail&city=".GB_CITY."&day=".$day."&uid=".$uid."&start=".$start."&limit=".$limit;
            }
        }
        else
        {
            if($app)
            {
                $url = NewStatisticsUrl. "/operate?type=getOperateUIDDayDetail&city=".GB_CITY."&day=".$day."&uid=".$uid."&operatetype=".$type."&start=".$start."&limit=".$limit."&app=".$app;
            }else
            {
                $url = NewStatisticsUrl. "/operate?type=getOperateUIDDayDetail&city=".GB_CITY."&day=".$day."&uid=".$uid."&operatetype=".$type."&start=".$start."&limit=".$limit;
            }
        }

        $url .='&fid='.$fid;

        //echo $url;

//        echo $url;die;
        $all = $this->get_array_data($url);


        return $all;
    }
	

    /**
     * ȡĳһĳ˵¼ (xz_new 2013-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param start ҳѯļ¼ֵڻ 0
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  յʱ1=0
     * @return  ص¼
     * @throws  RemoteException
     */
    public function getLoginList($day = '', $uid=0, $app = 'sell', $start=0, $limit=0, $desc=0) 
	{
        $url = NewStatisticsUrl."/login?type=getLoginUIDDayDetail&city=".GB_CITY."&day=".$day."&uid=".$uid."&start=".$start."&limit=".$limit;
        //echo $url;die;
        return $this->get_array_data($url);
    }

    /**
     * ȡĳһ쾭˵ͳ(xz_new 2031-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @return
     */
    public function getLoginCount($day = '', $uid='') 
	{
        $url = NewStatisticsUrl."/login?type=getLoginUIDDayCount&city=".GB_CITY."&day=".$day."&uid=".$uid;
        //echo $url;die;
        return $this->get_array_data($url);
    }

    /**
     * ȡĳĳԴ͵ķԴͳ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @param infoType  Դͣסլ̣д¥
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return  ͳֵ
     */
    public function getHouseCountByUidInfotype($day = '', $uid, $infotype, $app = 'sell') 
	{
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountByUidInfotype,params:[" . $day . "," . $uid . "," . $infotype . "," . $app . "]}";
        $strData = $this->curl_get_contents($url);

        $array_data = json_decode($strData, TRUE);
        $array_data = json_decode($array_data[returnobject], TRUE);

        return $array_data;
    }

    /**
     * ȡĳ¸ԴͷķԴ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @return  м¼
     */
    public function getHouseCountListOfInfotypeByUid($day = '', $uid='', $app = 'sell', $limit='', $desc='')
	{
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountListOfInfotypeByUid,params:[" . $day . "," . $uid . "," . $app . "," . $limit . "," . $desc . "]}";
        $strData = $this->curl_get_contents($url);

        $array_data = json_decode($strData, TRUE);
        $array_data = json_decode($array_data[returnobject], TRUE);

        return $array_data;
    }

    /**
     * ȡĳ¸ķԴ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @return  м¼
     * @throws  RemoteException
     */
    public function getHouseCountListOfBuildareaByUid($day = '', $uid='', $app = 'sell', $limit='', $desc='') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountListOfBuildareaByUid,params:[" . $day . "," . $uid . "," . $app . "," . $limit . "," . $desc . "]}";
        $strData = $this->curl_get_contents($url);

        $array_data = json_decode($strData, TRUE);
        $array_data = json_decode($array_data[returnobject], TRUE);

        return $array_data;
    }

    /**
     * ȡĳ¸ݼ۸ķԴ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @return  м¼
     * @throws  RemoteException
     */
    public function getHouseCountListOfPriceByUid($day = '', $uid='', $app = 'sell', $limit='', $desc='') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountListOfPriceByUid,params:[" . $day . "," . $uid . "," . $app . "," . $limit . "," . $desc . "]}";
        $strData = $this->curl_get_contents($url);
        $array_data = json_decode($strData, TRUE);
        $array_data = json_decode($array_data[returnobject], TRUE);
        return $array_data;
    }

    /**
     * ȡСΧԴݣۻ߷ԴУ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id	 
     * @param countType 1  2 Դ
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param city  
     * @return  м¼
     * @throws  RemoteException
     */
    public function getHouseCountListOfRegionByUid($day = '', $uid='', $countType='', $limit='', $desc='', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountListOfRegionByUid,params:[" . $day . "," . $uid . ",$countType,$limit,$desc," . $app . "," . $this->city . "]}";
        $strData = $this->curl_get_contents($url);
        $array_data = json_decode($strData, TRUE);
        $array_data = json_decode($array_data[returnobject], TRUE);
        return $array_data;
    }

    /**
     * 	ȡ·ķԴͳ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param uid   id
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return
     */
    public function getHouseCountByUid($day = '', $uid='', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountByUid,params:[" . $day . "," . $uid . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ ÿСʱ ضΧŵ//ܹ˾ӦĲ͵ͳƼ¼
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param belongType    ҷΧ1-ŵ꣬2-3-ܹ˾
     * @param id    Χidŵ߹˾ϢȣֵbelongTypeʹ
     * @param operateType   ͣ 1: 2ˢ 3ɾ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return  ذհСʱѶÿͳб
     */
    public function getOpreateCountListOfHour($day = '', $belongType='', $id='', $operateType='', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:OperateCount,method:getOpreateCountListOfHour,params:[" . $day . "," . $belongType . "," . $id . "," . $operateType . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ ĳ ضΧŵ//ܹ˾ӦĲ͵ͳƼ¼
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param belongType    ҷΧ1-ŵ꣬2-3-ܹ˾
     * @param id    Χidŵ߹˾ϢȣֵbelongTypeʹ
     * @param operateType   ͣ 1: 2ˢ 3ɾ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return  ͳֵ
     */
    public function getOpreateCountOfDay($day = '', $belongType='', $id='', $operateType='', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:OperateCount,method:getOpreateCountOfDay,params:[" . $day . "," . $belongType . "," . $id . "," . $operateType . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ ضΧŵ//ܹ˾һʱڵĲ͵ͳƼ¼
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param belongType    ҷΧ1-ŵ꣬2-3-ܹ˾
     * @param id    Χidŵ߹˾ϢȣֵbelongTypeʹ
     * @param operateType   ͣ 1: 2ˢ 3ɾ
     * @param days  ڵݣdayֵʼǰ(day)ܼdays
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return  ؼ¼
     */
    public function getOpreateCountListOfDayByDays($day = '', $belongType='', $id='', $operateType='', $days='', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:OperateCount,method:getOpreateCountListOfDayByDays,params:[" . $day . "," . $belongType . "," . $id . "," . $operateType . "," . $days . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ һʱھŵܹ꣬˾ĵ¼
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param belongType    ҷΧ1-ŵ꣬2-3-ܹ˾
     * @param id    ŵ߹˾ϢȣֵbelongTypeʹ
     * @param days  ڵݣdayֵʼǰ(day)ܼdays
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return  ؼ¼
     */
    public function getClickCountListByBelong($day='', $belongType='', $id='', 
            $days='', $app ='sell') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountListByBelong,params:[" . $day . "," . $belongType . "," . $id . "," . $days . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡŵܹ꣬˾ĵ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param belongType    ҷΧ1-ŵ꣬2-3-ܹ˾
     * @param id    ŵ߹˾ϢȣֵbelongTypeʹ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return
     */
    public function getClickCountByBelong($day = '', $belongType='', $id='',
            $app = 'sell') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountByBelong,params:[" . $day . "," . $belongType . "," . $id . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ ŵꡢ򡢹˾ضǼԴ ۡԴͳ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param belongType    ͳƵͣ1-ŵ 2- 3-˾
     * @param id    ŵ߹˾Ϣ
     * @param grade Ǽ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return  һͳƼ¼ۡԴϢ
     * @throws  RemoteException
     */
    public function getHouseCountByBelongGrade($day='', $belongType='', 
            $id='', $grade='', $app ='sell') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCountByBelongGrade,params:[" . $day . "," . $belongType . "," . $id . "," . $grade . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡԴľۺͷԴͳ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param type  ͳƵķΧ1-С 2-ֵ 3-
     * @param id    Сidֵ߽idֵtype ʹ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return  ͳƼ¼ۡԴϢ
     */
    public function getNewAddHouseCountOfAvgAndCount($day='', $type='', $id='', $app ='sell') {
        $url = "http://" . $this->appName . "{name:NewAddHouseCount,method:getNewAddHouseCountOfAvgAndCount,params:[" . $day . "," . $type . "," . $id . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ ĳһԴͳ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return
     * @throws  RemoteException
     */
    public function getNewAddHouseCount($day = '', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:NewAddHouseCount,method:getNewAddHouseCount,params:[" . $day . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ壨Сֵĵͳ  (xz_new 2013-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param regionType    ͳƵķΧ1-С 2-ֵ 3-
     * @param id    Сidֵ߽idֵregionType ʹ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return
     */
    public function getClickCountByRegion($day='', $regionType='', $id='', $app='sell') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountByRegion,params:[" . $day . "," . $regionType . "," . $id . "," . $app . "," . $this->city . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡĳС¸ķԴ   (xz_new 2013-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ 
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @param blockid   Сid
     * @return
     * @throws  RemoteException
     */
    public function getHouseRoomCountByBlock($day='', $app='', $limit='', $desc=0, $blockid='') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseRoomCountByBlock,params:[" . $day . "," . $app . ",$limit," . $desc . ",$blockid," . $this->city . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡĳС¸ķԴ (xz_new 2013-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @param blockid   Сid
     * @return
     * @throws  RemoteException
     */
    public function getClickRoomCountByBlock($day='', $app='', $limit=0, $desc=0, $blockid='') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickRoomCountByBlock,params:[$day,$app,$limit,$desc,$blockid," . $this->city . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡĳС¸۸ķԴ (xz_new 2013-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @param blockid   Сid
     * @return
     * @throws  RemoteException
     */
    public function getHousePriceCountByBlock($day='', $app='', $limit='', $desc='', $blockid='') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHousePriceCountByBlock,params:[" . $day . "," . $app . ",$limit," . $desc . ",$blockid," . $this->city . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡĳС¸۸ķԴ (xz_new 2013-06-18)
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @param blockid   Сid
     * @return
     * @throws  RemoteException
     */
    public function getClickPriceCountByBlock($day='', $app='', $limit='', $desc='', $blockid='') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickPriceCountByBlock,params:[" . $day . "," . $app . ",$limit," . $desc . ",$blockid," . $this->city . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ ĳһЧԴͳ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return
     */
    public function getHouseCount($day = '', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseCount,params:[" . $day . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ ĳһе
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @return
     */
    public function getClickCount($day = '', $app = 'sell') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCount,params:[" . $day . "," . $app . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ ˾ڸСķԴͳϢ
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param company   ŵid
     * @return  jsonݣjsonֶΣ
     * {"blockid":"1","companycount":0,"allcount":971},companycountΪù˾ڸСķԴallcountСзԴ
     * @throws RemoteException
     */
    public function getHouseBlockCountByCompany($day = '', $app = 'sell', $agentcode='', $agenttype='') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseBlockCountByAllCompany,params:[" . $day . "," . $app . "," . $agentcode . "," . $agenttype . ',' . $this->city . "]}";
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData, "gbk", $this->sourceCharSet);
        return $this->json_to_array($strData);
    }

    /**
     * ȡ ˾ڸķԴͳϢ
     * @param dayday    ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param company   ˾id
     * @return  jsonݣjsonֶΣ
     * {"district":"¹","companycount":0,"allcount":7519},companycountΪù˾ڸķԴallcountСзԴ
     * @throws RemoteException
     */
    public function getHouseDistrictCountByCompany($day = '', $app = 'sell', $agentcode='', $agenttype='') {
        $url = "http://" . $this->appName . "{name:HouseCount,method:getHouseDistrictCountByAllCompany,params:[" . $day . "," . $app . "," . $agentcode . "," . $agenttype . ',' . $this->city . "]}";
        return $this->get_array_data($url);
    }

    /**
     * 
     * @param type $day
     * @param type $app
     * @param type $num
     * @return type
     */
    public function getFidCountList($day = '', $app = 'sell', $num='') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getFidCountList,params:[" . $day . "," . $app . "," . $num . ",0]}";
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData, "gbk", $this->sourceCharSet);
        return $this->json_to_array($strData);
    }

    /**
     * ȡַбҳСһҳн鹫˾ʱͳƵ
     * @param startDay  ͳƿʼڣyyyyMMdd룬ĬΪǰһ
     * @param endDay    ͳƽڣyyyyMMdd룬ĬΪʼ
     * @param blockIdStr    СID:id"-"ӷ
     * @param company   ˾(A1:ҵز,A2:ҰҼ,A3:úҵ,A4:˳۲A5:йҵA6:ԭزA7:1+2ϲ),nullΪй˾˾"-"
     * @param company,ʱ:ʱ"-"ӷ,ʱΪ0930,1100,1400,1530,1700,1900
     * @return json
     * @throws RemoteException
     */
    public function getHouseCountOfBlockCompany($starttime = '', $endtime='', $blockid='', $agentcode='', $time='') {
        $url = 'http://' . $this->appName . '{name:HouseCount,method:getHouseCountOfBlockCompany,params:[' . '"'. $starttime . '"' . "," . '"' . $endtime . '"' . "," . '"' . $blockid . '"' . "," . '"' . $agentcode . '"' . "," . '"' . $time . '"' . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡַм¼
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @param type  0ʾ1ʾ°2ʾС
     * @param id    typetypeΪ0idΪnull,ѯַtypeΪ1idΪid,ѯ°¼ typeΪ2idΪid,ѯС¼
     * @return м¼
     * @throws RemoteException
     */
    public function getClickCountListOfDirStrBlo($starttime = '', $endtime = '', $app = 'sell', $type, $data) {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountListOfDirStrBlo,params:[" . '"' . $starttime . '"'
                . "," . '"' . $endtime . '"' . "," . '"' . $app . '"' . ",10,0," . $type . "," . $data . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡַⷿ
     * @param day   ѯ yyyyMMdd
     * @param app   Ӧͣsell ַrent ס
     * @param type  infofrom-Դinfotype-ͣroomtype-ͣprice-ۣbuildarea-district-renttype-ʽⷿfitment-װޣⷿ
     * @param value Ӧֵ
     * @return
     * @throws RemoteException
     */
    public function getClickCountOfSearchCondition($starttime = '', $endtime = '', $app = 'sell', $type, $data) {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountOfSearchCondition,params:["
                . '"' . $starttime . '"' . "," . '"' . $endtime . '"' . "," . '"' . $app . '"' . "," . $type . ","
                . $data . "," . $this->city . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡַⷿؼм¼
     * @param day   ͳڣyyyyMMdd룬ĬΪǰһ
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @param desc  ͳ1=0
     * @return  м¼
     * @throws  RemoteException
     */
    public function getClickCountOfKeyWord($starttime='', $endtime='', $app='sell', $count='') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountOfKeyWord,params:[" . '"' . $starttime . '"'. "," . '"' . $endtime . '"' . "," . '"' . $app . '"' . "," . $count . ",0]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡַⷿм¼
     * @param startDay  ͳڣyyyyMMdd룬ĬΪǰһ
     * @param endDay    ͳڣyyyyMMdd룬ĬΪǰһ
     * @param district  
     * @param app   Ӧ,rent ⷿsell ַ룬ĬΪsell
     * @param limit ؼ¼0 ȫأ>0ضӦļ¼
     * @return
     * @throws RemoteException
     */
    public function getClickCountOfCombin($starttime='', $endtime='', $district='', $app = 'sell', $count='') {
        $url = "http://" . $this->appName . "{name:ClickCount,method:getClickCountOfCombin,params:[" . '"' . $starttime . '"'. "," . '"' . $endtime . '"' . "," . '"' . $district . '"' . "," . '"' . $app . '"' . "," . $count . "]}";
        return $this->get_array_data($url);
    }

    /**
     * ȡ˾idµľˢ¼¼
     * @param startDay  ʼʱYYYYMMDD
     * @param endDay    ʱYYYYMMDD
     * @param pid   qtype=1ʱpidΪid,qtype=2ʱpidΪ˾id
     * @param operatetype   2Ϊˢ²
     * @param app   sellΪַrentΪⷿ
     * @param qType 1ʾˣ2ʾ˾
     */
    public function getdayoperatebycid($startDay, $endDay, $pid, $operatetype, $qType) {
        $url = "http://" . $this->appName . "/getoperatecount?type=getdayoperatebycid&startDay=" . $startDay . "&endDay=" .$endDay. "&pid=" . $pid . "&operatetype=" . $operatetype . "&qType=" . $qType . "&city=" . $this->city;
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData, "gbk", $this->sourceCharSet);
        return json_decode($strData, true);
    }

    /**
     * ʽ statistics::tourl()
     * @param array $array
     * @return string
     */
    public static function tourl($array) {
        if (is_array($array) && !empty($array)) {
            foreach ($array as $k => $v) {
                $ss.="&" . $k . "=" . @urlencode(trim($v));
            }
        }
        return $ss;
    }

    /**
     * ÿͻip statistics::GetIP()
     * @return string
     */
    public static function GetIP() {
        $ip = $_SERVER["REMOTE_ADDR"];
        if (!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) {
            $tip = split(",", $_SERVER["HTTP_X_FORWARDED_FOR"]);
            $ip = $tip[0];
        }
        return(trim($ip));
    }

    /**
     * 鲢 statistics::aryIconv()
     * @param array $array 
     * @param mixed $inChar ı
     * @param mixed $outChar ı
     * @return array
     */
    private static function aryIconv($array, $inChar, $outChar) {
        $this->inChar = $inChar;
        $this->outChar = $outChar;
        return $this->arraymyicov($array);
    }

    /**
     * ڲ,ѭ statistics::arraymyicov()
     * 
     * @param array $array
     * @return array
     */
    private static function arraymyicov($array) {
        foreach ((array) $array as $key => $value) {
            $key = $this->strIconv($key);
            if (!is_array($value)) {
                $value = $this->strIconv($value);
            } else {
                $value = $this->arraymyicov($value);
            }
            $temparray[$key] = $value;
        }
        return $temparray;
    }

    /**
     * 滻 statistics::strIconv()
     * @param mixed $strInput
     * @param string $inChar
     * @param string $outChar
     * @return string
     */
    private static function strIconv($strInput, $inChar = "", $outChar = "") {
        if ($inChar)
            $this->inChar = $inChar;
        if ($outChar)
            $this->outChar = $outChar;
        $strOutput = iconv($this->inChar, $this->outChar, $strInput);
        if ($strOutput !== false)
            return $strOutput;
        else
            return $strInput;
    }

    /**
     * 
     * @param type $data
     * @return type
     */
    private function json_to_array($data) {
        $array_data = json_decode($data, TRUE);
        if($array_data['result']=='success') {
            $array_data = json_decode($array_data['returnobject'], TRUE);
            return $array_data;
        } else {
            //return array();
            return   $array_data;
        }
        
    }

    /**
     * 
     * @param type $url
     * @param type $t_url
     * @return type
     */
    private function curl_get_contents($url, $t_url = "") 
	{	
		$response = '';
		if($url != '')
		{	
			$memkey = md5($url);
			
			$cache = array();

			$cache = $this->mc->get($memkey);
			
			if ($cache['is_ok'] == 1) 
			{
                            $response = $cache['data'];
			} 
			else 
			{
				            $startTime = time();//ʼʱ 
                            $ch = curl_init();
                            $t_url = $t_url ? $t_url : "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
                            curl_setopt($ch, CURLOPT_URL, $url);
                            curl_setopt($ch, CURLOPT_REFERER, $t_url);
							curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                            curl_setopt($ch, CURLOPT_HEADER, 0);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                            $response  = curl_exec($ch);
                            curl_close($ch);



                            $this->mc->add($memkey, array('is_ok' => 1, 'data' => $response),  600);
							$endTime = time();//ʱ
			
							if($endTime-$startTime>3){
							   //־¼
								$time = date('Y-m-d H:i',time());
								$content = $time." ".$t_url." ".print_r($str,true)." \r\n";
								$fp1 = fopen('./applications/libraries/log_zjj_'.date('Ymd').'.txt','a');
								fwrite($fp1,"$content");
								fclose($fp1);
								
							}

							//־¼
							$errorArr = array('error');
							foreach($errorArr as $value){
								if(strpos($str,$value)!== FALSE){
									$content = $time." ".$t_url." ".print_r($str,true)." \r\n";
									$fp1 = fopen('./applications/libraries/log_zjj2_'.date('Ymd').'.txt','a');
									fwrite($fp1,"$content");
									fclose($fp1);
								
								}
						
							}		
			}
		}

		//־



        return $response;
    }
    
    /**
     * 
     * @param type $str apiurl
     * @param type $url referer urlΪ
     * @return type
     */
    private function get_array_data($str, $url = "") {
        $strData = $this->curl_get_contents($str);
        $array_data = $this->json_to_array($strData);
        //$array_data = json_decode($strData, TRUE);
        //$array_data = json_decode($array_data['returnobject'], TRUE);
        return $array_data;
    }
}

?>