<?php
/**
 * ͼƬ
 *
 * @author sun
 */
class Pic_model extends MY_Model {

    /**
     * ϴļ_FILES[$filename]
     * @var string
     */
    private $_filename = 'Filedata';

    /**
     * ϴļĴС Ĭ3M
     * @var int  3M
     */
    public $_max_size = 5120;

    /**
     * ļĿ¼
     * @var string
     */
    private $_save_dir = '/njhouse/';

    /**
     * ǷĬϼˮӡ
     * @var bollean ĬϿ
     */
    private $_water_mark_status = true;

    /**
     * Ƿԭͼ
     * @var bollean
     */
    private $_image_cut_status = true;

    /**
     * ͼƬ
     * @var int
     */
    public $_image_width = 1600;

    /**
     * ͼƬ߶
     * @var int
     */
    public $_image_height = 1200;

    /**
     * Ƿɵͼ
     * @var bollean ĬϿ
     */
    private $_resize_image_status = true;

    /**
     * ͼƬ
     * @var int
     */
    public $_resize_width = 240;

    /**
     * ͼƬ߶
     * @var int
     */
    public $_resize_height = 180;

    /**
     * ̨õͼ
     * @var bollean ĬϿ
     */
    private $_audit_status = true;

    /**
     * ͼ
     * @var int
     */
    private $_audit_width = 200;

    /**
     * ͼ߶
     * @var int
     */
    private $_audit_height = 150;

    /**
     * ͼƬ
     *
     */
    public $_imageCategory = 0;

    /**
     * ͼƬϸ :ͼƬĳṩ
     * @var string
     */
    private $_other_string = '';

    /**
     * ϴͼƬǷҪʱ
     * @var string
     */
    public $is_insert_temp_table = false;

    /**
     * ͼƬʱ
     * @var string
     */
    private $_insert_temp_tablename = 'house_upload_provisional';

    /**
     * صݽ
     * @var array
     */
    private $result = array('result' => '', 'msg' => '', 'data' => '');


    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct(1,0,0);
    }

    /**
     * $_FILE
     * @param string $filename 
     */
    public function set_filename($filename)
    {
        $this->_filename = $filename;
    }

    /**
     * ȡ$_FILE
     * @return string
     */
    public function get_filename()
    {
        return $this->_filename;
    }

    /**
     * ϴļĴС
     * @param int $max_size ļС
     */
    public function set_max_size($max_size)
    {
        $this->_max_size = $max_size;
    }

    /**
     * ȡϴļĴС
     * @return int
     */
    public function get_max_size()
    {
        return $this->_max_size;
    }

    /**
     * ϴļĿ¼
     * @param string $save_dir Ŀ¼
     */
    public function set_save_dir($save_dir)
    {
        $this->_save_dir = $save_dir;
    }

    /**
     * ȡϴļĿ¼
     * @return string
     */
    public function get_save_dir()
    {
        return $this->_save_dir;
    }

    /**
     * ͼƬˮӡ
     * @param string $water_mark_status ˮӡ
     */
    public function set_water_mark($water_mark_status)
    {
        $this->_water_mark_status = $water_mark_status;
    }

    /**
     * ȡͼƬˮӡ
     * @return string
     */
    public function get_water_mark()
    {
        return $this->_water_mark_status;
    }

    /**
     * ǷͼƬŹ
     * @param boolean $image_cut_status true or false
     */
    public function set_image_cut($image_cut_status)
    {
        $this->_image_cut_status = $image_cut_status;
    }

    /**
     * ȡǷͼƬŹ
     * @return boolean
     */
    public function get_image_cut()
    {
        return $this->_image_cut_status;
    }

    /**
     * ͼƬĿ
     * @param int $width 
     */
    public function set_image_width($width)
    {
        $this->_image_width = $width;
    }

    /**
     * ȡͼƬĿ
     * @return int
     */
    public function get_image_width()
    {
        return $this->_image_width;
    }

    /**
     * ͼƬĸ߶
     * @param int $height
     */
    public function set_image_height($height)
    {
        $this->_image_height = $height;
    }

    /**
     * ȡͼƬĸ߶
     * @return int
     */
    public function get_image_height()
    {
        return $this->_image_height;
    }

    /**
     * Ƿɵͼ
     * @param boolean $resize_image_status true or false
     */
    public function set_resize_image($resize_image_status)
    {
        $this->_resize_image_status = $resize_image_status;
    }

    /**
     * ȡǷɵͼ
     * @return boolean
     */
    public function get_resize_image()
    {
        return $this->_resize_image_status;
    }

    /**
     * ɵͼĿ
     * @param int $width 
     */
    public function set_resize_width($width)
    {
        $this->_resize_width = $width;
    }

    /**
     * ȡɵͼĿ
     * @return int
     */
    public function get_resize_width()
    {
        return $this->_resize_image_status;
    }

    /**
     * ɵͼĸ߶
     * @param int $height ߶
     */
    public function set_resize_height($height)
    {
        $this->_resize_height = $height;
    }

    /**
     * ȡɵͼĸ߶
     * @return int
     */
    public function get_resize_height()
    {
        return $this->_resize_height;
    }

    /**
     * Ƿɺ̨õͼ
     * @param boolean $audit_status true or false
     */
    public function set_audit($audit_status)
    {
        $this->_audit_status = $audit_status;
    }

    /**
     * ȡǷɺ̨õͼ
     * @return boolean
     */
    public function get_audit()
    {
        return $this->_audit_status;
    }

    /**
     * ų́õͼĿ
     * @param int $width 
     */
    public function set_audit_width($width)
    {
        $this->_audit_width = $width;
    }

    /**
     * ȡ̨õͼĿ
     * @return int
     */
    public function get_audit_width()
    {
        return $this->_audit_width;
    }

    /**
     * ų́õͼĸ߶
     * @param int $height ߶
     */
    public function set_audit_height($height)
    {
        $this->_audit_height = $height;
    }

    /**
     * ȡ̨õͼĸ߶
     * @return int
     */
    public function get_audit_height()
    {
        $this->_audit_height;
    }

    /**
     * ͼƬϸ
     * @param string $other_string 
     */
    public function set_other_string($other_string)
    {
        $this->_other_string = $other_string;
    }

    /**
     * ȡͼƬϸ
     * @return string
     */
    public function get_other_string()
    {
        return $this->_other_string;
    }



    /**
     * ϴʱsession_id
     * ֪Ϊʲô
     * @param string $session_id
     */
    private function set_session_id($session_id)
    {
        if ($session_id)
        {
            session_id($session_id);
        }
    }

    /**
     * ȡʱͼƬϢ
     * @param string $filename ͼƬϴʱinput
     * @return string
     */
    private function get_temp_pic($filename)
    {
        return $_FILES[$filename]["tmp_name"];
    }

    /**
     * ǷͼƬϴ
     * @param string $filename ͼƬϴʱinput
     * @return boolean
     */
    private function check_pic_isupload($filename)
    {
        if(isset($_FILES[$filename]['nocheck']) && 'house365' == $_FILES[$filename]['nocheck'])
        {
            return true;
        }
        else if (!isset($_FILES[$filename]) || !is_uploaded_file($this->get_temp_pic($filename))
            || $_FILES[$filename]["error"] != 0)
        {
            $this->result['result'] = 0;
            $this->result['msg'] = 'δ֪ļϴʧ';
            return false;
        }
        else
        {
            return true;
        }
    }

    /**
     * ȡͼƬϴ
     * @param string $temp_pic ʱļ·
     * @return string  jpg and png
     */
    private function get_pic_type($temp_pic)
    {
        $img_info = getimagesize($temp_pic);
        return $img_info['mime'] == "image/jpeg" ? "jpg" : "png";
    }

    /**
     * жͼƬǷ豸
     * 1 0
     * @param string $temp_pic ʱļ·
     * @return int
     */
    private function get_pic_from_device($temp_pic)
    {
        $from_maker = 0;

        if(function_exists("exif_read_data"))
        {
            $exif = @exif_read_data($temp_pic, 0, true);
            if($exif)
            {
                foreach ($exif as $key => $section)
                {
                    foreach ($section as $name => $val)
                    {
                        if($key == 'IFD0' && $name == 'Model')
                        {
                            $from_maker = 1; //Դ豸
                            break;
                        }
                    }
                }
            }
        }
        return $from_maker;
    }

    /**
     * ȡͼƬϢmd5
     * @param string $temp_pic ʱļ·
     * @return sting md5ַܺ
     */
    private function set_pic_md($temp_pic)
    {
        $bin ='';
        $f = fopen($temp_pic, "r");
        fseek($f, 0);
        $bin .= fread($f, 100);
        fseek($f, 165, SEEK_CUR);
        $bin = fread($f, 50);
        fseek($f, 365, SEEK_CUR);
        $bin .= fread($f, 50);
        fseek($f, 565, SEEK_CUR);
        $bin .= fread($f, 50);
        fseek($f, 765, SEEK_CUR);
        $bin .= fread($f, 50);
        fseek($f, -100, SEEK_END);
        $bin .= fread($f, 100);
        $file_md5 = md5($bin);
        return $file_md5;
    }


    /**
     * ϴͼƬϴĵַ
     */
    public function common_upload()
    {
        header('Content-Type:text/html;charset=utf-8');

        //ļϴʱsession_idֵ
        //$this->set_session_id($this->input->post('PHPSESSID'));

        $filename = $this->get_filename();
        //ȡʱͼƬϢ
        $temp_pic = $this->get_temp_pic($filename);
        //жϴЧͼƬ
        $pic_validate = $this->check_pic_isupload($filename);
        if (!$pic_validate)
        {
            return false;
        }
        list($width,$height) = getimagesize($_FILES[$filename]['tmp_name']);
//        if($width < 322 || $height < 236)
    /*    if($width < 236 || $height < 322)
        {
            return '1';
        }*/

        //ϴͼƬԲϴ
        $this->load->library('UploadFile', array('filename' => $filename),'uf');
        $this->uf->setInputName($filename);
        $this->uf->setFileType("jpg|gif|png|jpeg");
        $this->uf->setMaxSize($this->_max_size);
        $this->uf->setUploadType("fastdfs");
        $this->uf->setSaveDir($this->_save_dir);
        /*
        $this->uf->setWatermark($this->_water_mark_status);
        $this->uf->setWatermarkType(2);
        $this->uf->setWatermarkPosition("rb");
        $this->uf->setWatermarkImage("http://guanli.house365.com/images/sy2.png");//ˮӡ
         */
        $this->uf->setWatermark(true);//ʱˮӡ by zain 2018-9-26
        $this->uf->setWatermarkType(2);
        $logo = $_SERVER['DOCUMENT_ROOT']."/source/zsb/images/v1.0/logo_watermark.png";
        $this->uf->setWatermarkImage($logo);//ˮӡ


        $this->uf->setImageCut($this->_image_cut_status);
        $this->uf->setImageWidth($this->_image_width);
        $this->uf->setImageHeight($this->_image_height);
        $this->uf->setResizeImage($this->_resize_image_status);
        $this->uf->setResizeWidth($this->_resize_width);
        $this->uf->setResizeHeight($this->_resize_height);

        if ($this->get_other_string())
        {
            $this->uf->otherstring = $this->get_other_string();
        }

        if($this->uf->upload())
        {
            $picurl = $this->uf->getResizeImageURL();//ͼƬַ
        }
        return $picurl;
    }

    /**
     * ϴͼƬϴĵַ
     */
    public function common_upload2()
    {
        header('Content-Type:text/html;charset=utf-8');

        //ļϴʱsession_idֵ
        //$this->set_session_id($this->input->post('PHPSESSID'));

        $filename = $this->get_filename();

        //ȡʱͼƬϢ
        $temp_pic = $this->get_temp_pic($filename);

        //жϴЧͼƬ
        $pic_validate = $this->check_pic_isupload($filename);

        if (!$pic_validate)
        {
            return false;
        }

        //ϴͼƬԲϴ
        //$this->load->library('UploadFileZhou', array('filename' => $filename),'uf');
        $this->load->library('UploadFileZhou', array(),'uf');
        $this->uf->setInputName($filename);
        $this->uf->setFileType("jpg|gif|png|jpeg");
        $this->uf->setMaxSize($this->_max_size);
        $this->uf->setUploadType("fastdfs");

        $this->uf->setSaveDir($this->_save_dir);
        /*
        $this->uf->setWatermark($this->_water_mark_status);
        $this->uf->setWatermarkType(2);
        $this->uf->setWatermarkPosition("rb");
        $this->uf->setWatermarkImage("http://guanli.house365.com/images/sy2.png");//ˮӡ
         */

        $this->uf->setImageCut($this->_image_cut_status);
        $this->uf->setImageWidth($this->_image_width);
        $this->uf->setImageHeight($this->_image_height);
        $this->uf->setResizeImage($this->_resize_image_status);
        $this->uf->setResizeWidth($this->_resize_width);
        $this->uf->setResizeHeight($this->_resize_height);

        if ($this->get_other_string())
        {

            $this->uf->otherstring = $this->get_other_string();
        }


        if($this->uf->upload())
        {
            $picurl = $this->uf->getResizeImageURL();//ͼƬַ
        }


        return $picurl;
    }


    /**
     * ϴͼƬϴĵַ
     */
    public function upload()
    {
        header('Content-Type:text/html;charset=utf-8');
        //ļϴʱsession_idֵ
        //$this->set_session_id($this->input->post('PHPSESSID'));

        $filename = $this->get_filename();
        //die("aaa");
        //ȡʱͼƬϢ
        $temp_pic = $this->get_temp_pic($filename);
        //жϴЧͼƬ
        $pic_validate = $this->check_pic_isupload($filename);
        if (!$pic_validate)
        {
            return false;
        }

        //360ȫԴϴͼƬС350KB
        if(!empty($this->_imageCategory))
        {
            $minSize = $_FILES[$filename]['size'];

            if($minSize < 358400)
            {
                return '0';
            }
        }

        list($width,$height) = getimagesize($_FILES[$filename]['tmp_name']);
//        if($width < 322 || $height < 236)
        if($width < 700 || $height < 500)
        {
            return '1';
        }


        //ȡϴͼƬ
        //$pic_type = $this->get_pic_type($temp_pic);
        //ϴͼƬԲϴ
        //$this->load->library('UploadFile', array('filename' => $filename),'uf');
        $this->load->library('UploadFile', array(),'uf');

        $this->uf->setInputName($filename);

        $this->uf->setFileType("jpg|gif|png|jpeg");

        $this->uf->setImageCategory($this->_imageCategory);

        $this->uf->setMaxSize($this->_max_size);

        //$this->uf->setUploadType("ftp");
        $this->uf->setUploadType("fastdfs");

        $this->uf->setSaveDir($this->_save_dir);
        //$this->uf->setWatermark($this->_water_mark_status);
        $this->uf->setWatermark(true);//ʱˮӡ by zain 2018-9-26
		//$this->uf->setWatermarkType(1);//ʱĳˮӡ add wangzhen time:2015-11-17 17:53
		/*


        //$logo = "http://esf.fz.house365.com/zsb/images/v1.0/tf_logo_watermark.png";
        //$IpHostAllow =explode('.',GetIp());
        /*if($IpHostAllow['0']=='192' || $IpHostAllow['0']=='127')
        {
            $logo = "http://guanli.house365.com/images/tf_logo_watermark.png";

        }
        else
        {
            $logo = "http://esf.fz.house365.com/zsb/images/v1.0/logo_watermark.png";
        }
		$this->uf->setWatermarkPosition("rb");
		$logo = "http://esf.fz.house365.com/zsb/images/v1.0/logo_watermark.png";
		$this->uf->setWatermarkImage($logo);//ˮӡ
		$this->uf->setWatermarkType(2);//ʱĳˮӡ add wangzhen time:2015-11-17 17:53
		*/
		$this->uf->setWatermarkType(2);
		$logo = $_SERVER['DOCUMENT_ROOT']."/source/zsb/images/v1.0/logo_watermark.png";
		$this->uf->setWatermarkImage($logo);//ˮӡ
		
        $this->uf->setImageCut($this->_image_cut_status);
        $this->uf->setImageWidth($this->_image_width);
        $this->uf->setImageHeight($this->_image_height);
        $this->uf->setResizeImage($this->_resize_image_status);
        $this->uf->setResizeWidth($this->_resize_width);
        $this->uf->setResizeHeight($this->_resize_height);

        //$this->uf->setAudit($this->_audit_status);
        //$this->uf->setAuditWidth($this->_audit_width);
        //$this->uf->setAuditHeight($this->_audit_height);
        if ($this->get_other_string())
        {
            $this->uf->otherstring = $this->get_other_string();
        }

        $picurl = '0';
        $id = '';
        //ͼƬϢ浽ʱ

		writeLog('ready upload');

        if($this->uf->upload())
        {
			writeLog('over fastdfs ');
            $picurl = $this->uf->getResizeImageURL();//ͼƬַ

            if ($picurl)
            {
                //ȡͼƬǷ豸
                $from_mark = $this->get_pic_from_device($temp_pic);
                //ͼƬmd5
                $file_md = $this->set_pic_md($temp_pic);
                $id = $this->insert_temp_data($picurl, $from_mark, $file_md);
				writeLog('over db insert ');
                $picurl = $picurl."?pid=".$id;
            }else{
				writeLog('picurl ');
			}

        }
        //ͼƬĵַ
        return $picurl;
    }
    /**
     * 뷿Դʱ
     * @param string $filename ͼƬ·
     * @param int $from_device ǷԴ豸 1 0
     * @param string $file_md5 ͼƬmd5
     * @return int
     */
    public function insert_temp_data($filename, $from_device, $file_md5)
    {
        $this->db->set('filename', $filename);
        $this->db->set('dateline', date('Y-m-d'));
        $this->db->set('from_device', $from_device);
        $this->db->set('file_md5', $file_md5);
        $this->db->insert($this->_insert_temp_tablename);
        return $this->db->insert_id();
    }

    /**
     * ȡͼƬ浽ű
     * @param type $tbl 
     * @param type $id Դ
     * @return string
     */
    public function get_upload_table_name($tbl, $id)
    {

        if(GB_CITY == 'wh'){
            if($tbl == 'sell' && $id < 10310000) return 'upload';
            if($tbl == 'rent' && $id < 1577000) return 'upload';
            return 'upload1';
        }

        if(GB_CITY!='nj') return 'upload';
        if($tbl == 'sell' && $id < 23972101) return 'upload0';
        if($tbl == 'rent' && $id < 11907211) return 'upload0';

        if($tbl == 'sell' && ($id >= 23972101 && $id < 27029364)) return 'upload1';
        if($tbl == 'rent' && ($id >= 11907211 && $id < 13224200)) return 'upload1';

        if($tbl == 'sell' && ($id >= 27029364 && $id < 31695721)) return 'upload2';
        if($tbl == 'rent' && ($id >= 13224200 && $id < 14495163)) return 'upload2';

        if($tbl == 'sell' && ($id >= 31695721 && $id < 34963370)) return 'upload3';
        if($tbl == 'rent' && ($id >= 14495163 && $id < 15172611)) return 'upload3';

        if($tbl == 'sell' && ($id >= 34963370 && $id < 38640564)) return 'upload4';
        if($tbl == 'rent' && ($id >= 15172611 && $id < 15871631)) return 'upload4';

        if($tbl == 'sell' && ($id >= 38640564 && $id < 42138930)) return 'upload5';
        if($tbl == 'rent' && ($id >= 15871631 && $id < 16675751)) return 'upload5';

        if($tbl == 'sell' && ($id >= 42138930 && $id < 45947999)) return 'upload';
        if($tbl == 'rent' && ($id >= 16675751 && $id < 43871899)) return 'upload';

        if($tbl == 'sell' && ($id >= 45947999 && $id < 49830000)) return 'upload6';
        //49825505
        if($tbl == 'rent' && ($id >= 43871899 && $id < 45040000)) return 'upload6';
        //45038726
        if($tbl == 'sell' && ($id >= 49830000 && $id < 54705651)) return 'upload7';
        //54703651
        if($tbl == 'rent' && ($id >= 45040000 && $id < 45788862)) return 'upload7';
        //45787862
        if($tbl == 'sell' && ($id >= 54705651 && $id < 58020733)) return 'upload8';
        //58018737
        if($tbl == 'rent' && ($id >= 45788862 && $id < 46230598)) return 'upload8';
        //46229598
        if($tbl == 'sell' && ($id >= 58020733 && $id < 61223139)) return 'upload9';
        //61221139
        if($tbl == 'rent' && ($id >= 46230598 && $id < 46633747)) return 'upload9';
        //46633347
        if($tbl == 'sell' && ($id >= 61223139 && $id < 63983200)) return 'upload10';
        //63981991
        if($tbl == 'rent' && ($id >= 46633747 && $id < 46923000)) return 'upload10';
        //46922654
        if($tbl == 'sell' && ($id >= 63983200 && $id < 66893902)) return 'upload11';
        //66892902
        if($tbl == 'rent' && ($id >= 46923000 && $id < 47264784)) return 'upload11';
        //47264284
        if($tbl == 'sell' && ($id >= 66893902 && $id < 71182067)) return 'upload12';
        //71181067
        if($tbl == 'rent' && ($id >= 47264784 && $id < 47951200)) return 'upload12';
        //47950659
        if($tbl == 'sell' && ($id >= 71182067 && $id < 76015831)) return 'upload13';
        //76014531
        if($tbl == 'rent' && ($id >= 47951200 && $id < 48556731)) return 'upload13';                                                                             //48556231
        if($tbl == 'sell' && ($id >= 76015831 && $id < 81507192)) return 'upload14';
        //81506192
        if($tbl == 'rent' && ($id >= 48556731 && $id < 49140972)) return 'upload14';                                                                        //49140466

        if($tbl == 'sell' && ($id >= 81507192 && $id < 88723014)) return 'upload15';
        //88722131
        if($tbl == 'rent' && ($id >= 49140972 && $id < 49884209)) return 'upload15';
        //49883609

        if($tbl == 'sell' && ($id >= 88723014 && $id < 95316101)) return 'upload16';
        //95314101
        if($tbl == 'rent' && ($id >= 49884209 && $id < 50532293)) return 'upload16';
        //50531293

        if($tbl == 'sell' && ($id >= 95316101 && $id < 103859999)) return 'upload17';
        //103819999
        if($tbl == 'rent' && ($id >= 50532293 && $id < 51527468)) return 'upload17';
        //51527468
        if($tbl == 'sell' && ($id >= 103859999 && $id < 108815839)) return 'upload18';
        //108806111
        if($tbl == 'rent' && ($id >= 51527468 && $id < 52249156)) return 'upload18';
        //52239180
        if($tbl == 'sell' && ($id >= 108815839 && $id < 114379999)) return 'upload19';

        if($tbl == 'rent' && ($id >= 52249156 && $id < 53130499)) return 'upload19';


        if($tbl == 'sell' && ($id >= 114379999 && $id < 119229999)) return 'upload20';

        if($tbl == 'rent' && ($id >= 53130499 && $id < 53780499)) return 'upload20';



        if($tbl == 'sell' && ($id >= 119229999 && $id < 123619999)) return 'upload21';

        if($tbl == 'rent' && ($id >= 53780499 && $id < 54659999)) return 'upload21';



        if($tbl == 'sell' && ($id >= 123619999 && $id < 128434999)) return 'upload22';

        if($tbl == 'rent' && ($id >= 54659999 && $id < 55793999)) return 'upload22';


        if($tbl == 'sell' && ($id >= 128434999 && $id < 132662039)) return 'upload23';

        if($tbl == 'rent' && ($id >= 55793999 && $id < 56609929)) return 'upload23';


        if($tbl == 'sell' && ($id >= 132662039 && $id < 136312505)) return 'upload24';

        if($tbl == 'rent' && ($id >= 56609929 && $id < 57307409)) return 'upload24';


        if($tbl == 'sell' && ($id >= 136312505 && $id < 140145507)) return 'upload25';

        if($tbl == 'rent' && ($id >= 57307409 && $id < 58017786)) return 'upload25';


        if($tbl == 'sell' && ($id >= 140145507 && $id < 147125418)) return 'upload26';

        if($tbl == 'rent' && ($id >= 58017786 && $id < 59209979)) return 'upload26';

        if($tbl == 'sell' && ($id >= 147125418 && $id < 154138704)) return 'upload27';

        if($tbl == 'rent' && ($id >= 59209979 && $id < 60562010)) return 'upload27';

        if($tbl == 'sell' && ($id >= 154138704 && $id < 166754880)) return 'upload28';

        if($tbl == 'rent' && ($id >= 60562010 && $id < 63483875)) return 'upload28';

        return 'upload29';

    }

    /**
     * 360ȫԴͼƬ
     * @param array $insert_data Դ
     * @return int
     */
    public function insert_house_panorama_pic($insert_data)
    {
        $this->db->set('tbl', $insert_data['tbl']);
        $this->db->set('rowid', $insert_data['rowid']);
        $this->db->set('position', $insert_data['position']);
        $this->db->set('filename', $insert_data['filename']);
        $this->db->set('title', $insert_data['title']);
        $this->db->set('sort', $insert_data['title']);
        $this->db->set('createtime', $insert_data['createtime']);
        $this->db->set('flg', $insert_data['flg']);
        $this->db->set('isfrom', $insert_data['isfrom']);
        $this->db->set('isinfotype', $insert_data['isinfotype']);
        $this->db->set('roomtype', $insert_data['roomtype']);
        $this->db->insert('upload360');

        return  $this->db->insert_id();
    }

    /**
     * 360ȫԴͼƬ
     * @param array $insert_data Դ
     * @return int
     */
    public function update_house_panorama_pic($data)
    {
        if(empty($data))
        {
            return false;
        }

        $this->db->where('id',$data['id']);
        $this->db->update('upload360',array('position' => $data['position'],'title' => $data['title'],'roomtype' => $data['roomtype']));
    }

    /**
     * ȡ360ȫԴͼƬ
     * @param array $insert_data Դ
     * @return int
     */
    public function get_house_pic($tbl,$rowid)
    {
        $this->db->select('id,rowid,position,filename,title,sort,flg,isinfotype,roomtype');
        $this->db->where('tbl', $tbl);
        $this->db->where('rowid', $rowid);
        $this->db->order_by('id', 'ASC');

        return $this->db->get('upload360')->result_array();
    }


    /**
     * ɾ360ȫͼƬ
     *
     */
    public function del_house_some_pic($data = array())
    {
        if(empty($data))
        {
            return false;
        }

        $this->db->where_in('id', $data);
        $this->db->delete('upload360');
        return $this->db->affected_rows() > 0 ? true : false;
    }

    /**
     * 뷿ԴͼƬ
     * @param array $insert_data Դ
     * @return int
     */
    public function insert_house_pic($insert_data, $tbl, $house_id)
    {
        $uploadtable = $this->get_upload_table_name($tbl, $house_id);
        if ($this->db->insert($uploadtable, $insert_data))
        {
            return $this->db->insert_id();
        }
    }

    /**
     * ȡĳԴͼƬ
     * @param string $tbl 
     * @param int $house_id Դ
     * @param int $sort ͼƬ
     * @return array
     */
    public function find_house_pic_by($tbl, $house_id, $sort = '')
    {
        $uploadtable = $this->get_upload_table_name($tbl, $house_id);

        $this->db->select('id,filename,title,sort, position');
        $this->db->where('tbl', $tbl);
        $this->db->where('rowid', $house_id);
        $this->db->where_in('flg', array(0, 1));
        $this->db->order_by('id', 'ASC');
        if ($sort !== '')
        {
            $this->db->where('sort', $sort);
        }
        $housePic = $this->db->get($uploadtable)->result_array();

        // ͼͬʽͼƬַ(ַ?֮)
        foreach ($housePic as &$item) {
            // жǷfilenameֶ,ֹ
            if (isset($item['filename']) && $item['filename']) {
                $subLength = strpos($item['filename'],'?');
                $item['img_url'] = $subLength ? substr($item['filename'],0,$subLength) : $item['filename'];
            }
        }
        return $housePic;
    }

    /**
     * ɾĳԴͼƬ
     * @param string $tbl 
     * @param int $house_id Դ
     */
    public function del_house_pic_by($tbl, $house_id)
    {
        $uploadtable = $this->get_upload_table_name($tbl, $house_id);
        $this->db->where('tbl', $tbl);
        $this->db->where('rowid', $house_id);
        $this->db->delete($uploadtable);
        return $this->db->affected_rows() > 0 ? true : false;
    }

    /**
     * ȡʱͼƬ
     * @param int $id id
     * @return array һάɵļ¼
     */
    public function find_temp_by_id($id)
    {
        $this->db->select('from_device, file_md5');
        $this->db->where('id', $id);
        return $this->db->get($this->_insert_temp_tablename)->row_array();
    }

    public function pic_format($image_path,$format = ''){
        if (!empty($image_path) && preg_match('/\.com\/[A-Z]{1}[0-9]{2}\//', $image_path)) {
            preg_match('/_([0-9]+)x([0-9]+)/', $image_path, $match);
            //Ȱʺźȫȥ
            $strrpos1 = strpos($image_path, '?');
            if($strrpos1 != FALSE){
                $image_path = substr($image_path, 0,$strrpos1);
            }
            if ($match) {
                $strrpos = strpos($image_path, $match[0]);
                $picNameArr = explode('.', substr($image_path, $strrpos));
                $image_path = substr($image_path, 0, $strrpos);
                if($format){
                    $image_path .= $format . '.' . $picNameArr[1];
                }else{
                    $image_path .= '.'.$picNameArr[1];
                }
            }
            return $image_path;
        }
        return  $image_path;
    }

}