<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Guide_project extends MY_Controller {

    private $library;

    /**
     * 
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Index Page for this controller.
     */
    public function index()
    {
        $this->guide_project_extension();
    }

    public function guide_project_extension(){
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('guide_project_model');
        $this->_limit   = 10;
        $uid            = $this->user_arr['uid'];

        /** ҳ */
        $page = $this->input->post( 'page' , TRUE);
        $page = (isset($page)&& intval($page) > 0) ? intval($page) : 1;
        $this->_init_pagination($page);

        $total_count     = $this->guide_project_model->getGuideProjectTotal();
        $pages       = $total_count > 0 ? ceil( $total_count/$this->_limit ) : 0;

        //Ƿʾҳ
        $pagination = NULL;
        if( $total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page,$pages,$total_count);
        }
        $data_arr    = array();
        $data_arr['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/realhouse.css,zsb/css/v1.0/feedback.css');
        $data_arr['js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
        $result         = $this->guide_project_model->getGuideProject($uid,$this->_offset ,$this->_limit);

        $data_arr['project_info']       = $result;
        $data_arr['page']               = $this->_current_page;
        $data_arr['pagination']         = $pagination;

        $this->view('market', 'guide_project/guide_project_extension', $data_arr);

    }
    /**
     * ʼҳ
     *
     * @access public
     * @param  int  $current_page
     * @param  int  $page_size
     * @return void
     */
    private function _init_pagination($current_page = 1 , $page_size = 0)
    {
        /** ǰҳ */
        $this->_current_page = ( $current_page && is_numeric( $current_page ) ) ?
            intval( $current_page ) : 1;

        /** ÿҳ */
        $this->_limit = ( $page_size && is_numeric( $page_size ) ) ?
            intval( $page_size ) : $this->_limit;

        /** ƫ */
        $this->_offset = ( $this->_current_page - 1 ) * $this->_limit;

        if($this->_offset < 0)
        {
            redirect(base_url());
        }
    }

    //Ƿܽר
    public function is_guide_apply(){
        $this->load->model('guide_project_model');
        $uid            = $this->user_arr['uid'];
        $is_real_status = $this->guide_project_model->is_real_status($uid);
        if($is_real_status){
            if($is_real_status[0]['real_status'] >=1){
                $result['code'] = 1;
                $result['msg']  = '';
            }else{
                $result['code'] = 2;
                $result['msg']  = iconv("GBK","UTF-8",'ǷĿû');
            }
        }else{
            $result['code'] = 0;
            $result['msg']  = iconv("GBK","UTF-8",'˺쳣');
        }
        echo json_encode($result);die;
    }

    //ר
    public function guide_apply(){
        $guide_project_id = $_GET['guide_project_id'];
        if($guide_project_id){
            $this->load->helper(array('form', 'url'));
            $this->load->library('form_validation');
            $this->load->model('guide_project_model');
            $this->_limit   = 10;
            $uid            = $this->user_arr['uid'];
            /** ҳ */
            $page = $this->input->post( 'page' , TRUE);
            $page = (isset($page)&& intval($page) > 0) ? intval($page) : 1;
            $this->_init_pagination($page);
            //ȡǰ˷ĿԴ
            $total_count    = $this->guide_project_model->getRealHouseTotal($uid);
            $pages          = $total_count > 0 ? ceil( $total_count/$this->_limit ) : 0;
            //Ƿʾҳ
            $pagination     = NULL;
            if( $total_count > $this->_limit)
            {
                $pagination = helper_pagination( $this->_current_page,$pages,$total_count);
            }
            $data_arr        = array();
            $data_arr['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/realhouse.css,zsb/css/v1.0/feedback.css');
            $data_arr['js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
            //ȡĿԴϢ
            $result         = $this->guide_project_model->getRealHouseInfo($uid,$this->_offset ,$this->_limit,$guide_project_id);

            //鿴רϢ
            $guideProjectInfo = $this->guide_project_model->guide_project_info($guide_project_id);
//            print_r($guideProjectInfo);die;
            //鿴˾˴ר
            $ApplyNum = $this->guide_project_model->applyTotal($guide_project_id,$uid);
            $data_arr['real_house_info']    = $result;
            $data_arr['page']               = $this->_current_page;
            $data_arr['pagination']         = $pagination;
            $data_arr['guideProjectInfo']   = $guideProjectInfo;
            $data_arr['ApplyNum']           = $ApplyNum;
            $this->view('market', 'guide_project/guide_apply', $data_arr);
        }else{
            redirect(base_url());
        }
    }

    //¼
    public function my_apply(){
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->load->model('guide_project_model');
        $uid            = $this->user_arr['uid'];

        $this->_limit   = 10;
        /** ҳ */
        $page = $this->input->post( 'page' , TRUE);
        $page = (isset($page)&& intval($page) > 0) ? intval($page) : 1;
        $this->_init_pagination($page);

        //ȡǰ¼
        $total_count    = $this->guide_project_model->applyAllTotal($uid);
        $pages          = $total_count > 0 ? ceil( $total_count/$this->_limit ) : 0;
        //Ƿʾҳ
        $pagination     = NULL;
        if( $total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page,$pages,$total_count);
        }
        $data_arr        = array();
        $data_arr['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/realhouse.css,zsb/css/v1.0/feedback.css');
        $data_arr['js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
        //ȡĿԴϢ
        $result         = $this->guide_project_model->applyAllInfo($uid,$this->_offset ,$this->_limit);
        $data_arr['apply_info']         = $result;
        $data_arr['page']               = $this->_current_page;
        $data_arr['pagination']         = $pagination;
        $this->view('market', 'guide_project/my_apply', $data_arr);
    }

    //רж
    public function judge_guide_apply(){
        $this->load->model('guide_project_model');
        $uid            = $this->user_arr['uid'];
        if($_POST['guide_project_id'] && $_POST['select_id']){
            //鿴˾˴ר
            $ApplyNum = $this->guide_project_model->applyTotal($_POST['guide_project_id'],$uid);
            $houseArr = explode(',',$_POST['select_id']);
            $houseNum = count($houseArr)+$ApplyNum;
            if($houseNum <= 3){
                for($i=0;$i<count($houseArr);$i++){
                    $data['house_id']         = $houseArr[$i];
                    $data['guide_project_id'] = $_POST['guide_project_id'];
                    $data['uid']              = $uid;
                    $data['create_time']      = time();
                    $is_success = $this->guide_project_model->insert('guide_project_apply',$data);
                }
                $result['code'] = 1;
                $result['msg']  = iconv("GBK","UTF-8",'ɹ');
            }else{
                if($ApplyNum >= 3){
                    $num = 0;
                }else{
                    $num = 3-$ApplyNum;
                }
                $result['code'] = 0;
                $result['msg']  = iconv("GBK","UTF-8",'ÿרֻ׷Դ,'.$num.'');
            }
        }else{
            $result['code'] = 0;
            $result['msg']  = iconv("GBK","UTF-8",'ȱʧ');
        }
        echo json_encode($result);exit();
    }





}
