<?php !defined('APP_DIR') ? die('acceess not defined') : '';
class BM_sellwarning extends BM {
    
    private $_dao_warning = 'sell_price_warning';
    private $_dao_warning_refuse = 'sell_price_warning_refuse';
    private $_dao_warning_pass = 'sell_price_warning_pass';
    
    /**
     * IDȡ400ĻϢ
     *
     * @param int $id
     * @return array
     * 
     * @example bm('400')->get(1)
     */
    public function get($id){
        return $this->dao($this->_dao_warning)->get($id);
    }
    
    /**
     * ݲѯȡ400
     *
     * @param int $query_struct
     * @param string $key_field
     * @return array
     * 
     * @example bm('company')->get_all($query_struct, $key_field)
     */
    public function get_all($query_struct, $key_field=NULL){
        return $this->dao($this->_dao_warning)->get_all($query_struct, $key_field);
    }
    
    /**
     * ޸400
     *
     * @param array $data
     * @return bool
     * 
     */
    public function edit($data){
        return $this->dao($this->_dao_warning)->edit($data);
    }
    
    /**
     * 400
     *
     * @param array $data
     * @return bool | int
     */
    public function add($data){
        return $this->dao($this->_dao_warning)->add($data);
    }
    
    /**
     * ɾ
     *
     * @param int $id
     * @return bool
     */
    public function delete($id){
        return $this->dao($this->_dao_warning)->delete($id);
    }
    
    /**
     *ѯ 
     */
    public function count($query_struct){
        return $this->dao($this->_dao_warning)->count($query_struct);
    }
    
    /**
     * ᷿Դ
     *
     * @param unknown_type $warning
     */
    public function refuse($warning){
        //Դ¼붳ķԴ¼
        $this->dao($this->_dao_warning_refuse)->replace($warning);
        
        //ɾǰԴ
        $this->dao($this->_dao_warning)->remove(array(
            'where' => array(
                'city' => $warning['city'],
                'id' => $warning['id'],
            ),
        ));
        
        //ƷԴӿɾ
        $this->dao($this->_dao_warning)->remove(array(
            'where' => array(
                'city' => $warning['city'],
                'uid' => $warning['uid'],
            ),
        ));
    }
    
    /**
     * ͨ
     *
     * @param unknown_type $warning
     */
    public function pass($warning){
        $this->dao($this->_dao_warning_pass)->replace($warning);
        $this->dao($this->_dao_warning)->remove(array(
            'where' => array(
                'city' => $warning['city'],
                'id' => $warning['id'],
            ),
        ));
    }
    
    /**
     * 鷿ԴǷڼ۸٣ٷԴٷԴ
     *
     * @param array $sell
     * @param string $city
     */
    public function checkSellPrice( $sell , $city = 'nj', $log=1 ){
        //ǰֻϾ
        if ($city != 'nj'){
            return true;
        }
        
        $block_id   = $sell['blockid'];
        $buildarea  = $sell['buildarea'];
        $averprice  = $sell['averprice'];
        $floor      = $sell['floor'];
        $totalfloor = $sell['totalfloor'];
        
        //ȡСĲͬľ
        $area_prices = bm('block')->block_area_prices($block_id, $city);
        if ( empty($area_prices) ){
            return true;
        }
        
        //жĸ䷶Χ
        if ($buildarea<60){
            $area_extent = 10;
        }elseif ($buildarea>=60 && $buildarea<90){
            $area_extent = 20;
        }elseif ($buildarea>=90 && $buildarea<144){
            $area_extent = 30;
        }elseif ($buildarea>=144){
            $area_extent = 40;
        }
        
        //¸
        $rate = 0.1;
        if ( $floor==1 || $floor==$totalfloor ){
            $rate = 0.15;
        }
        
        //۸жϣԴ۸ССļ۸Χ
        if ( $area_prices[$area_extent] ){
            if ( $averprice < ($area_prices[$area_extent]['average_price']*(1-$rate) ) ){
                if ($log){
                    $_d = array(
                        'city'       => $city,
                        'id'         => $sell['id'],
                        'ownid'      => $sell[''],
                        'infotype'   => $sell['infotype'],
                        'infofrom'   => 5,
                        'agentcode'  => $sell['agentcode'],
                        'uid'        => $sell['uid'],
                        'esta'       => $sell['esta'],
                        'district'   => $sell['district'],
                        'blockid'    => $sell['blockid'],
                        'blockshowname' => $sell['blockshowname'],
                        'mright'     => $sell['mright'],
                        'buildarea'  => $sell['buildarea'],
                        'floor'      => $sell['floor'],
                        'totalfloor' => $sell['totalfloor'],
                        'room'       => $sell['room'],
                        'hall'       => $sell['hall'],
                        'toilet'     => $sell['toilet'],
                        'kitchen'    => $sell['kitchen'],
                        'price'      => $sell['price'],
                        'averprice'  => $sell['averprice'],
                        'contactor'  => $sell['contactor'],
                        'telno'      => $sell['telno'],
                        'mobile'     => $sell['mobile'],
                        'creattime'  => $sell['creattime'],
                        'updatetime' => $sell['updatetime'],
                        'expiretime' => $sell['expiretime'],
                    );
                    //
                    $this->dao($this->_dao_warning)->replace($_d);
                }
                return false;
            }
        }
        if ($log){
            $where = array(
                'city' => $city,
                'id' => $sell['id'],
            );
            $this->dao($this->_dao_warning)->removeWhere($where);
        }
        return true;
    }
    
    public function removeTimeout($city='nj'){
        $time_limit = time()-86400*30;
        $sql = "DELETE 
                FROM esfpublic.sell_price_warning 
                WHERE city = '$city' 
                AND `creattime` <= $time_limit";
        //echo $sql;die();
        $this->dao($this->_dao_warning)->query($sql);
    }
    
    
    public function removeByIds($ids , $city='nj'){
        $ids_str = implode(',',$ids);
        $sql = "DELETE 
                FROM esfpublic.sell_price_warning 
                WHERE city = '$city' 
                AND `id` IN ($ids_str)";
        $this->dao($this->_dao_warning)->query($sql);
    }

	public function checkSellPriceNew( $sell , $city = 'nj',$status)
	{
		 //ǰֻϾ
        /*if ($city != 'nj')
		{
            return 'no city';
        }*/
        
        if ($sell['mright']=='ʹȨ')
		{
            return 'safe house';
        }
        
        if(!empty($status))
		{
			$_d = array(
				'city'       => $city,
				'id'         => $sell['id'],
				'ownid'      => $sell[''],
				'infotype'   => $sell['infotype'],
				'infofrom'   => 5,
				'agentcode'  => $sell['agentcode'],
				'uid'        => $sell['uid'],
				'esta'       => $sell['esta'],
				'district'   => $sell['district'],
				'blockid'    => $sell['blockid'],
				'blockshowname' => $sell['blockshowname'],
				'mright'     => $sell['mright'],
				'buildarea'  => $sell['buildarea'],
				'floor'      => $sell['floor'],
				'totalfloor' => $sell['totalfloor'],
				'room'       => $sell['room'],
				'hall'       => $sell['hall'],
				'toilet'     => $sell['toilet'],
				'kitchen'    => $sell['kitchen'],
				'price'      => $sell['price'],
				'averprice'  => $sell['averprice'],
				'contactor'  => $sell['contactor'],
				'telno'      => $sell['telno'],
				'mobile'     => $sell['mobile'],
				'creattime'  => $sell['creattime'],
				'updatetime' => $sell['updatetime'],
				'expiretime' => $sell['expiretime'],
			);

			$this->dao($this->_dao_warning)->replace($_d);
			return 'warning house';
		}
		else
		{
			$where = array(
				'city' => $city,
				'id' => $sell['id'],
			);

			$this->dao($this->_dao_warning)->removeWhere($where);
			return 'safe house';
		}
	}
}