<?php
/**
 * ʹþͶ
 * type ֶΣ1Сרң2ԴͶ3ƥ䣬4ƥ
 * @author user
 */
class GrowthBidUserBroker {
    /**
     * ݿ
     */
    private $db;

    /**
     * ݿ
     */
    private $dbback;

    /**
     * 
     */
    private $mc;
    
    /**
     * ı
     * @var string
     */
    private $table;
    
    /**
     * ʹþͶ
     * @var type 
     */
    private static $brokerUserType = array(
        'blockexpert' => 1,
        'house' => 2,
        'buy'=>3,//
        'rent'=>4,//
        'rent_bid'=>5,//
    );
    
    /**
     * аֶ
     * @var array
     */
    private static $fields = array('id','type', 'broker_id','ctime');

    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = 'growth_bid_broker_user';
    }
    
    /**
     * ȡĳ͵ݵ
     * @param type $type
     * @return type
     */
    public function findCountByType($type) {
        $sql = SqlCombinHelper::count_sql($this->table, 'type = ' . $type);
        $bidNum = $this->mc->get($sql);
        if ($bidNum === false) {
            $bidNum = $this->dbback->getOne($sql);
        }
        return $bidNum;
    }
    
    /**
     * ȡͶСרҾ
     * @return type
     */
    public function findCountBidBlockExpert() {
        return $this->findCountByType(self::$brokerUserType['blockexpert']);
    }
    
    /**
     * ȡͶԴ
     * @return type
     */
    public function findCountBidHouse() {
        return $this->findCountByType(self::$brokerUserType['house']);
    }
    
    public function addJoinBidRecord($type, $brokerId) {
        $fieldData = array();
        $fieldData['type'] = $type;
        $fieldData['broker_id'] = $brokerId;
        $sql = SqlCombinHelper::replace_sql($this->table, $fieldData);
        return $this->db->execute($sql);
    }
    
    /**
     * ȡͶԴ
     * @return type
     */
    public function findCountBidRent() {
        return $this->findCountByType(self::$brokerUserType['rent_bid']);
    }
    
    public function addJoinBidRentRecord($brokerId) {
        return $this->addJoinBidRecord(self::$brokerUserType['rent_bid'], $brokerId);
    }
    /**
     * 
     * @param type $brokerId
     * @return type
     */
    public function addJoinBidHouseRecord($brokerId) {
        return $this->addJoinBidRecord(self::$brokerUserType['house'], $brokerId);
    }
    
    /**
     * 
     * @param type $brokerId
     * @return type
     */
    public function addJoinBidBlockExpertRecord($brokerId) {
        return $this->addJoinBidRecord(self::$brokerUserType['blockexpert'], $brokerId);
    }
}
