<?php

/**
 * @author applelor
 * @version ڣ2011.3.8
 */

class House_brokercp {
	var $sellTable;
	var $rentTable;
	var $stateField;
	var $stateArr;
	var $primaryKey;
	var $foreignKey;
	var $pic;
	var $trueIds;

    function __construct()
    {
    	$this->pic = new Picture();
    	$this->sellTable = 'sell';
    	$this->rentTable = 'rent';
		$this->stateField = 'esta';
		$this->primaryKey = 'id';
		$this->foreignKey = 'uid';
    	$this->stateArr  = array(
    		'valid'=>1,
    		'invalid'=>2,
    		'hide'=> 4,
    		'freeze'=>5
    	);
    }

	/*
	 * @use ķԴ״̬Ч
	 * @param $houseIds Դid
	 * @param $type ĵ sell  rent 
	 */

	function valid($houseIds,$type='sell'){
		$this->trueIds = array();
		if(is_array($houseIds)){
			$stateInfo = $this->getState($houseIds,$type);
			foreach ($stateInfo as $info){
				$this->validOnlyone($info[$this->primaryKey],$type,$info[$this->stateField]);
			}
		}else{
			$state = $this->getState($houseIds,$type);
			$this->validOnlyone($houseIds,$type,$state);
		}
		if($this->trueIds){
			return $this->trueIds;
		}else{
			return false;
		}
	}

	private function validOnlyone($hid,$type,$state){
		if($state!=$this->stateArr['valid']){
			$tableName = $this->getTableName($type);
			$rt = changeState($tableName,$this->stateField,$this->stateArr['valid'],$this->primaryKey,$hid,'broker');
			if($rt){
				switch ($state){
					case $this->stateArr['invalid']:
						$rs = $this->invalid2Valid($hid,$type);
						break;
					case $this->stateArr['hide']:
						$rs = $this->hide2Valid($hid,$type);
						break;
					case $this->stateArr['freeze']:
						$rs = $this->freeze2Valid($hid,$type);
						break;
					default:
						$rs = true;
				}
				$this->trueIds[] = $hid;
			}
		}
	}

    /*
	 * @use ķԴ״̬Ч
	 * @param $houseIds Դid
	 * @param $type ĵ sell  rent 
	 */
    function invalid($houseIds,$type='sell'){
    	$this->trueIds =array();
    	if(is_array($houseIds)){
			$stateInfo = $this->getState($houseIds,$type);
			foreach ($stateInfo as $info){
				$this->invalidOnlyone($info[$this->primaryKey],$type,$info[$this->stateField]);
			}
		}else{
			$state = $this->getState($houseIds,$type);
			$this->invalidOnlyone($houseIds,$type,$state);
		}
    	if($this->trueIds){
			return $this->trueIds;
		}else{
			return false;
		}
	}

	private  function invalidOnlyone($hid,$type,$state){
		if($state!=$this->stateArr['invalid']){
			$tableName = $this->getTableName($type);
			$rt = changeState($tableName,$this->stateField,$this->stateArr['invalid'],$this->primaryKey,$hid,'broker');
			if($rt){
				switch ($state){
					case $this->stateArr['valid']:
						$rs = $this->valid2Invalid($hid,$type);
						break;
					case $this->stateArr['hide']:
						$rs = $this->hide2Invalid($hid,$type);
						break;
					case $this->stateArr['freeze']:
						$rs = $this->freeze2Invalid($hid,$type);
						break;

					default:
						$rs = true;
				}
				$this->trueIds[] = $hid;
			}
		}
	}

 	/*
	 * @use ķԴ״̬Ч
	 * @param $houseIds Դid
	 * @param $type ĵ sell  rent 
	 */
    function hide($houseIds,$type='sell'){
		$this->trueIds =array();
    	if(is_array($houseIds)){
			$stateInfo = $this->getState($houseIds,$type);
			foreach ($stateInfo as $info){
				$this->hideOnlyone($info[$this->primaryKey],$type,$info[$this->stateField]);
			}
		}else{
			$state = $this->getState($houseIds,$type);
			$this->hideOnlyone($houseIds,$type,$state);
		}
    	if($this->trueIds){
			return $this->trueIds;
		}else{
			return false;
		}
    }

	private function hideOnlyone($hid,$type,$state){
		if($state!=$this->stateArr['hide']){
			$tableName = $this->getTableName($type);
			$rt = changeState($tableName,$this->stateField,$this->stateArr['hide'],$this->primaryKey,$hid,'broker');
			if($rt){
				switch ($state){
					case $this->stateArr['valid']:
						$rs = $this->valid2Hide($hid,$type);
						break;
					case $this->stateArr['invalid']:
						$rs = $this->invalid2Hide($hid,$type);
						break;
					case $this->stateArr['freeze']:
						$rs = $this->freeze2Hide($hid,$type);
						break;
					default:
						$rs = true;
				}
				$this->trueIds[] = $hid;
			}
		}
		return $rs;
	}

	/*
	 * @use ķԴ״̬Ч
	 * @param $houseIds Դid
	 * @param $type ĵ sell  rent 
	 */
    function freeze($houseIds,$type='sell'){
		$this->trueIds = array();
    	if(is_array($houseIds)){
			$stateInfo = $this->getState($houseIds,$type);
			foreach ($stateInfo as $info){
				$this->freezeOnlyone($info[$this->primaryKey],$type,$info[$this->stateField]);
			}
		}else{
			$state = $this->getState($houseIds,$type);
			$this->freezeOnlyone($houseIds,$type,$state);
		}
    	if($this->trueIds){
			return $this->trueIds;
		}else{
			return false;
		}
    }

	private function freezeOnlyone($hid,$type,$state){
		if($state!=$this->stateArr['freeze']){
			$tableName = $this->getTableName($type);
			$rt = changeState($tableName,$this->stateField,$this->stateArr['freeze'],$this->primaryKey,$hid,'broker');
			if($rt){
				switch ($state){
					case $this->stateArr['valid']:
						$rs = $this->valid2Freeze($hid,$type);
						break;
					case $this->stateArr['invalid']:
						$rs = $this->invalid2Freeze($hid,$type);
						break;
					case $this->stateArr['hide']:
						$rs = $this->hide2Freeze($hid,$type);
						break;
					default:
						$rs = true;
				}
				$this->trueIds[] = $hid;
			}
		}
		return $rs;
	}

    /*
     * @use ķԴ״̬ЧʧЧ
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ sell  rent 
     */
   	private function valid2Invalid($houseId,$type='sell'){
		/*$picErrorArr = $this->getPictureIds($houseId,array($this->pic->stateArr['check'],$this->pic->stateArr['uncheck'],$this->pic->stateArr['hide']),$type,true);
		if($picErrorArr){
			return -1;
		}else{
			return true;
		}*/
    }

    /*
     * @use ķԴ״̬Ч
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ sell  rent 
     */
    private function valid2Hide($houseId,$type='sell'){

    	if($houseId){
    		$picArr = $this->getPictureIds($houseId,array($this->pic->stateArr['check'],$this->pic->stateArr['uncheck']),$type);
    		$rt = $this->pic->hide($picArr);
    	}
/*		$picErrorArr = $this->getPictureIds($houseId,array($this->pic->stateArr['check'],$this->pic->stateArr['uncheck'],$this->pic->stateArr['hide']),$type,true);
		if($picErrorArr){
			return -1;
		}else{
			return true;
		}*/
    }

    /*
     * @use ķԴ״̬Ч
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ sell  rent
     */
    private function valid2Freeze($houseId,$type='sell'){
		if($houseId){
    		$picArr = $this->getPictureIds($houseId,array($this->pic->stateArr['check'],$this->pic->stateArr['uncheck']),$type);
			$rt = $this->pic->freeze($picArr);
    	}
		/*$picErrorArr = $this->getPictureIds($houseId,array($this->pic->stateArr['check'],$this->pic->stateArr['uncheck'],$this->pic->stateArr['hide']),$type,true);
		if($picErrorArr){
			return -1;
		}else{
			return true;
		}*/
    }


    /*
     * @use ķԴ״̬ʧЧЧ
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ sell  rent 
     */
    private function invalid2Valid($houseId,$type){
		/*$picErrorArr = $this->getPictureIds($houseId,array($this->pic->stateArr['check'],$this->pic->stateArr['uncheck'],$this->pic->stateArr['hide']),$type,true);
		if($picErrorArr){
			return -1;
		}else{
			return true;
		}*/
    }

	/*
     * @use ķԴ״̬Ч
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ 1  2 
     */
    private function invalid2Hide($houseId,$type){
    	$this->valid2Hide($houseId, $type);
    }

	/*
     * @use ķԴ״̬Ч
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ 1  2 
     */
    private function invalid2Freeze($houseId,$type){
    	$this->valid2Freeze($houseId, $type);
    }

	/*
     * @use ķԴ״̬Ч
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ 1  2 
     */
    private function hide2Valid($houseId,$type){
    	if($houseId){
    		$picArr = $this->getPictureIds($houseId,array($this->pic->stateArr['freeze']),$type);
    		$rt = $this->pic->uncheck($picArr);
    	}
		/*$picErrorArr = $this->getPictureIds($houseId,array($this->pic->stateArr['freeze'],$this->pic->stateArr['hide']),$type,true);
		if($picErrorArr){
			return -1;
		}else{
			return true;
		}*/
    }

	/*
     * @use ķԴ״̬Ч
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ 1  2 
     */
    private function hide2Invalid($houseId,$type){
    	$this->hide2Valid($houseId, $type);
    }

	/*
     * @use ķԴ״̬
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ 1  2 
     */
    private function hide2Freeze($houseId,$type){
		/*$picErrorArr = $this->getPictureIds($houseId,array($this->pic->stateArr['freeze'],$this->pic->stateArr['hide']),$type,true);
		if($picErrorArr){
			return -1;
		}else{
			return true;
		}*/
    }

	/*
     * @use ķԴ״̬Ч
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ 1  2 
     */
    private function freeze2Valid($houseId,$type){
    	$this->hide2Valid($houseId, $type);
    }

	/*
     * @use ķԴ״̬Ч
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ 1  2 
     */
    private function freeze2Invalid($houseId,$type){
    	$this->hide2Valid($houseId, $type);
    }

	/*
     * @use ķԴ״̬
     * @param $houseIds ĵľ˵ID
     * @param $type ĵ 1  2 
     */
    private function freeze2Hide($houseId,$type){
		/*$picErrorArr = $this->getPictureIds($houseId,array($this->pic->stateArr['freeze'],$this->pic->stateArr['hide']),$type,true);
		if($picErrorArr){
			return -1;
		}else{
			return true;
		}*/
    }

    /*
     * @use ȡǰҪĵı
     * @param $type 1:   2
     */
    function getTableName($type){
    	switch ($type){
    		case 'sell':
    			return $this->sellTable;
    			break;
    		case 'rent':
    			return $this->rentTable;
    			break;
    		default:
				return $this->sellTable;
    	}
    }

    /*
     * @use ȡԴ״̬
     * @param $hid Դid
     */
    function getState($hid,$type='sell'){
  		global $db;
    	$tableName = $this->getTableName($type);
    	if(is_array($hid)){
			$hidStrs = implode(',', $hid) ;
			$sql = "SELECT $this->primaryKey,$this->stateField FROM $tableName WHERE $this->primaryKey IN ($hidStrs) and agentcode='B000'";
			$rs = $db->GetAll($sql);
    	}else{
			$sql = "SELECT $this->stateField FROM $tableName WHERE $this->primaryKey = $hid and infofrom = '5'";
			$rs = $db->GetOne($sql);
    	}
    	return $rs;
    }

    /*
     * @use ȡԴµͼƬid
     * @param $sort ȡĸ ״̬ͼƬ
     * @param $type ȡsell rentķԴ sell
     */
    private function getPictureIds($hid,$sort,$type='sell',$notin=false){
    	global $db;
		$rt = array();
		$sortStr = is_array($sort)?'('.implode(',',$sort).')':'';
		if(!$notin){
			$addSql = $sortStr?" AND ".$this->pic->stateField." IN $sortStr ":' ';
		}else{
			$addSql = $sortStr?" AND ".$this->pic->stateField." NOT IN $sortStr ":' ';
		}

    	$sql = "SELECT ".$this->pic->primaryKey." FROM ".$this->pic->picTable." where ".$this->pic->extraField." = '$type' AND ".$this->pic->foreignKey." = '$hid' $addSql ";
    	$rs = $db->GetAll($sql);
    	if($rs){
	    	foreach ($rs as $row){
	    		$rt[] = $row[$this->pic->primaryKey];
	    	}
    	}
    	return $rt;
    }
}

?>
