<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class real_house_model  extends MY_Model
{
    public function __construct()
    {
        parent::__construct(1, 1, 1);
    }

    /**
     * չ涨ĸʽʾĲ0
     * @param int $value ֵ
     * @param int $length 
     * @return string
     */
    private static function formatValue($value, $length)
    {
        return sprintf("%0{$length}d", $value);
    }

    /**
     * Ķźλ
     * 1-9999
     */
    private static function randValue()
    {
        return rand(1, 9999);
    }

    public function getbrokermoney($uid){
        $this->dbback->select("real_house_money");
        $this->dbback->where('uid = '.intval($uid));
        $result = $this->dbback->get('broker')->row_array();
        return $result;
    }
    /**
     * ȡĳƷĽ׺
     * @return int
     */
    public function getTransactionId()
    {
        //ֹID۱ظ$type Ϊ88
        $type = 88;
        $formatType = self::formatValue($type, 2);
        //
        $randValue = self::formatValue(self::randValue(), 4);
        //
        return time() . $formatType . $randValue;
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function createOrder($data = array())
    {
        if ($this->db->insert('real_house_broker_orders', $data))
        {
            return $this->db->insert_id();
        }
    }

    /**
     * ȡ֤𶩵
     * @param $id
     * @return mixed
     */
    public function getOrderById($id)
    {
        $this->dbback->select("*");
        $this->dbback->where('id = '.intval($id));
        $result = $this->dbback->get('real_house_broker_orders')->row_array();
        return $result;
    }

    /**
     * ȡ֧ı֤𶩵
     * @param $brokerId
     * @return mixed
     */
    public function getOrderByBrokerId($brokerId)
    {
        $this->dbback->select("*");
        $this->dbback->where('pay_status = 1 and broker_id = '.intval($brokerId));
        $this->dbback->order_by('pay_time', 'DESC');
        $result = $this->dbback->get('real_house_broker_orders')->row_array();
        return $result;
    }
    /**
     * ȡ˱֤
     * @param $id
     * @return mixed
     */
    public function getBrokerRealHouseMoney($id)
    {
        $this->dbback->select("real_house_money");
        $this->dbback->where('uid = '.intval($id));
        $result = $this->dbback->get('broker')->row_array();
        return $result['real_house_money'];
    }


    /**
     * ȡ״γֵʱ
     */
    public function getBrokerPayTime($id)
    {

        $this->dbback->select("pay_time");
        $this->dbback->where('uid = '.intval($id));
        $result = $this->dbback->get('broker')->row_array();
        return $result['pay_time'];
    }

    /**
     * ȡָʱµʱ
     */
    public function getSixMonthTime($first_pay_time,$type='-6')
    {
        $first_pay_time  = date("Y-m-d H:i:s",$first_pay_time);
        $result          = $this->db->query("select date_add('".$first_pay_time."', interval '".$type."' month) as month_six")->row_array();
        $result['month_six'] = strtotime($result['month_six']);
        return $result['month_six'];
    }


    /**
     * ȡָʱǰ֮ڵִ
     * $uid id
     * $six_month_before ʱ
     * $type 3
     * $status 01Ѵ2Ǵɹ3ʧ
     */
    public function getSixMonthApplyTimes($uid,$six_month_before,$type,$status)
    {
        $sql = 'SELECT count(id) as apply_count FROM real_house_broker_log WHERE broker_id='.$uid.' and type='.$type.' and status='.$status.' and create_time >= '.$six_month_before.'';
        $result= $this->db->query($sql)->row_array();
        return $result['apply_count'];
    }

    /**
     * ȡָʱǰ֮ڵ
     */
    public function getSixMonthFristApply($uid,$six_month_before,$type,$status)
    {
        $sql = 'SELECT id,create_time FROM real_house_broker_log WHERE broker_id='.$uid.' and type='.$type.' and status='.$status.' and create_time >= '.$six_month_before.' order by create_time DESC limit 2';
        $result= $this->db->query($sql)->result_array();
        return $result;
    }


    /**
     * ȡϢ
     * @param $id
     * @return mixed
     */
    public function getRealHouseInfo($id)
    {
        $this->dbback->select("uid,username,truename,telno,real_house_money,real_status");
        $this->dbback->where('uid = '.intval($id));
        $result = $this->dbback->get('broker')->row_array();
        return $result;
    }

    /**
     * ֧ɲ
     * @param $data
     * @return mixed
     */
    public function payFinish($data)
    {
        $id = $data['id'];
        $brokerId = $data['broker_id'];
        $money = $data['money'];
        $transaction_id = $data['transaction_id'];
        //ȡ˱֤Ϣ
        $moneyData = $this->getRealHouseInfo($brokerId);
        $realHouseMoney = $moneyData['real_house_money'];
        $newMoney = $realHouseMoney + $money;
        $time = time();
        //Ķ״̬
        $result = $this->updateOrder($id, array('pay_status' => 1, 'payment_order_id' => $data['new_payment_order_id'], 'pay_time' => $time));
        if ($result) {
            $this->updateBroker($brokerId, array('real_house_money' => floatval($newMoney),'real_status'=>2));

            $payTypeList = array('wxpay' => '΢֧', 'alipay' => '֧');
            $payTypeName = $payTypeList[$data['pay_type']];
            $reason = 'ֵ֤֧'.$payTypeName;
            $logData = array(
                'transaction_id' => $transaction_id,
                'payment_order_id' => $data['new_payment_order_id'],
                'type' => 1,
                'broker_id' => $brokerId,
                'broker_username' => $moneyData['username'],
                'broker_phone' => $moneyData['telno'],
                'broker_name' => $moneyData['truename'],
                'money' => $money,
                'remain_money' => $newMoney,
                'create_time' => $time,
                'source' => 1,
                'ip' => GetIP(),
                'status' => 2,
                'reason' => $reason
            );
            $this->insertLog($logData);
            //߸¾״̬
            $accountData = array(
                'uid' => $brokerId,
                'username' => $moneyData['username'],
                'truename' => $moneyData['truename'],
                'telno' => $moneyData['telno'],
                'status' => 1,
                'time' => $time,
                'balance_time' => $time,
                'reason' => 0,
                'is_ka_status' => 0
            );
            $this->saveAccount($accountData);
        }
        return $result;
    }

    /**
     * ¾״̬
     * @param $brokerId
     * @param $data
     * @return mixed
     */
    public function updateBroker($brokerId, $data)
    {
        $this->db->where('uid', $brokerId);
        $result = $this->db->update('broker', $data);
        return $result;
    }

    /**
     * жǷ񾭼Ƿ֧ɹļ¼
     * @param $brokerId
     * @param $data
     * @return mixed
     */
    public function getBrokerPayRecord($brokerId)
    {
        $this->dbback->select("id");
        $this->dbback->where('pay_status = 1 and broker_id = '.intval($brokerId));
        $pay_result = $this->dbback->get('real_house_broker_orders')->row_array();
        return $pay_result;
    }

    /**
     * ¾ٱ״̬
     * @param $id
     * @param $data
     * @return mixed
     */
    public function updateReport($id, $data)
    {
        $this->db->where('id', $id);
        $result = $this->db->update('real_house_report', $data);
        return $result;
    }

    /**
     * ±֤𶩵
     * @param $id
     * @param $data
     * @return mixed
     */
    public function updateOrder($id, $data)
    {
        $this->db->where('id', $id);
        $result = $this->db->update('real_house_broker_orders', $data);
        return $result;
    }

    /**
     * ¼֤ϸ־
     * @param $data
     * @return mixed
     */
    public function insertLog($data)
    {
        if ($this->db->insert('real_house_broker_log', $data))
        {
            return $this->db->insert_id();
        }
    }

    /**
     * ¼¼
     * @param $data
     * @return mixed
     */
    public function insertRemit($data)
    {
        if ($this->db->insert('real_house_remit', $data))
        {
            return $this->db->insert_id();
        }
    }

    /**
     * 
     * @param $data
     * @return mixed
     */
    public function insertAppeal($data)
    {
        if ($this->db->insert('real_house_appeal', $data))
        {
            return $this->db->insert_id();
        }
    }

    /**
     * ͼƬ
     * @param $data
     * @return mixed
     */
    public function insertAppealImage($data)
    {
        if ($this->db->insert('real_house_appeal_image', $data))
        {
            return $this->db->insert_id();
        }
    }

    /**
     * ¼Դ־
     * @param $data
     * @return mixed
     */
    public function insertHouseLog($data)
    {
        if ($this->db->insert('real_house_set_log', $data))
        {
            return $this->db->insert_id();
        }
    }

    /**
     * 澭˺Ϣ
     * @param $data
     * @return mixed
     */
    public function saveAccount($data)
    {
        $result = $this->db->replace('real_house_account', $data);
        return $result;
    }

    /**
     * ȡ˱֤־
     * @param $brokerId
     * @return mixed
     */
    public function getBrokerLog($brokerId)
    {

        $this->dbback->select("*");
        $this->dbback->where('broker_id = '.intval($brokerId));
        $this->dbback->order_by('id', 'DESC');
        $result = $this->dbback->get('real_house_broker_log')->result_array();
        return $result;
    }

    /**
     * ȡٱϢ
     * @param array $data
     * @param int $offset
     * @param int $limit
     * @param string $select
     * @return mixed
     */
    public function getReport($data = array(), $offset = 0, $limit = 0, $select = "*")
    {
        $where = '';
        foreach ($data as $key => $value) {
            $where .= $where ? ' and '. $key .' = "'. $value .'"' : $key .' = "'. $value .'"';
        }
        $this->dbback->select($select);
        $this->dbback->where($where);
        $this->dbback->order_by('id', 'DESC');
        $this->dbback->limit($limit, $offset);
        $result = $this->dbback->get('real_house_report')->result_array();
        return $result;
    }

    /**
     * ȡٱ
     * @param array $data
     * @return mixed
     */
    public function getReportCount($data = array())
    {
        $where = '';
        foreach ($data as $key => $value) {
            $where .= $where ? ' and '. $key .' = "'. $value .'"' : $key .' = "'. $value .'"';
        }
        $this->dbback->select("count(*) count");
        $this->dbback->where($where);
        $result = $this->dbback->get('real_house_report')->row_array();
        //echo $this->dbback->last_query();die;
        return $result['count'];
    }

    /**
     * ȡԴ
     * @param array $data
     * @return mixed
     */
    public function getAppealCount($data = array())
    {
        $where = '';
        foreach ($data as $key => $value) {
            $where .= $where ? ' and '. $key .' = "'. $value .'"' : $key .' = "'. $value .'"';
        }
        $where .= ' and appeal != 0';
        $this->dbback->select("count(*) count");
        $this->dbback->where($where);
        $result = $this->dbback->get('real_house_report')->row_array();
        return $result['count'];
    }


    /**
     *
     * @param int $brokerId
     * @return mixed
     */
    public function get_real_house_account($brokerId)
    {
        $where = 'uid = '.$brokerId;
        $this->dbback->select("balance_time");
        $this->dbback->where($where);
        $result = $this->dbback->get('real_house_account')->result_array();
        return $result;
    }


    /**
     *
     * @param int $brokerId
     * @return mixed
     */
    public function get_real_house_sell_info($id)
    {
        $where = 'id = '.$id;
        $this->dbback->select("is_real_house");
        $this->dbback->where($where);
        $result = $this->dbback->get('sell')->result_array();
        return $result;
    }

    /**
     * ֲ
     * @param $uid
     * @return mixed
     */
    public function applyRemit($uid,$type='')
    {
        //ȡϢ
        $brokerData = $this->getRealHouseInfo($uid);
        // 2018721 09:55:14  xzk  qq724087709
        //֤жϱ
        /*if (!$brokerData['real_status']>0) {
             return false;
        }*/
        if ($brokerData['real_house_money'] < 299) {
            return false;
        }
        //¾˷Դ
        $updateData = array();
        $updateData['real_house_money'] = $brokerData['real_house_money'] - 299;
        $updateData['real_status']      = 0;
        $flag = $this->updateBroker($uid, $updateData);

        if ($flag) {
            $time = time();
            //뾭˺ű
            //߸¾״̬
            $real_house_account  =$this->get_real_house_account($uid);

            $accountData = array(
                'uid' => $uid,
                'username' => $brokerData['username'],
                'truename' => $brokerData['truename'],
                'telno' => $brokerData['telno'],
                'status' => 0,
                'time' => $time,
                'balance_time' => $real_house_account[0]['balance_time'],
                'reason' => 2
            );
            if($type){
                $accountData['status'] = 1;
                $accountData['reason'] = 0;
                $accountData['is_ka_status'] = 1;
            }
            $this->saveAccount($accountData);
            //淿Դ־
            $payTypeList = array('wxpay' => '΢֧', 'alipay' => '֧');
            //ȡһ֧¼
            $data = $this->getOrderByBrokerId($uid);
            $payTypeName = $payTypeList[$data['pay_type']];
            if($type){
                $reason = '(ϵͳ)'.$payTypeName;
            }else{
                $reason = '֣'.$payTypeName;
            }
            $logData = array(
                'type' => 3,
                'broker_id' => $uid,
                'broker_username' => $brokerData['username'],
                'broker_phone' => $brokerData['telno'],
                'broker_name' => $brokerData['truename'],
                'money' => -299,
                'payment_order_id' => $data['payment_order_id'],
                'remain_money' => 0,
                'create_time' => $time,
                'source' => 1,
                'ip' => GetIP(),
                'status' => 0,
                'reason' => $reason
            );
            $logId = $this->insertLog($logData);
            //
            if ($logId) {
                $remitData = array(
                    'infofrom' => 5,
                    'uid' => $uid,
                    'username' => $brokerData['truename'],
                    'telno' => $brokerData['telno'],
                    'paytype' => $data['pay_type'],
                    'orderid' => $data['payment_order_id'],
                    'price' => 299,
                    'reason' => '',
                    'isfrom' => $brokerData['username'],
                    'applytime' => $time,
                    'log_id' => $logId,
                    'status' => 0
                );
                $this->load->model('broker_model');
                $session_info = $this->broker_model->get_user_session();
                if(!empty($session_info['alipay_acount'])){
                    $remitData['account'] = $session_info['alipay_acount'];
                }
                /*if($type){
                    $remitData['reason'] = '';
                }*/
                $remitId = $this->insertRemit($remitData);
                //ȡǰзԴ
                $houseInfo = $this->getBrokerRealHouse($uid);
                //¼зԴ
                if($type){
                    //˾ʱ¼ܷԴ
                    return false;
                }
                $houseIds = array();
                foreach ($houseInfo as $key => $value) {
                    $houseIds[] = $value['id'];
                }
                $this->updateRealHouse($houseIds);
                //¼־
                $houseLog = array();
                $houseLog['uid'] = $uid;
                $houseLog['tbl'] = 'sell';
                $houseLog['type'] = 0;
                $houseLog['source'] = 0;
                $houseLog['ctime'] = $time;
                $houseLog['ip'] = GetIP();
                $houseLog['reason'] = 4; //Ŀ˳
                $houseLog['operatetime'] = time();
                foreach ($houseInfo as $key => $value) {
                    $houseLog['rowid'] = $value['id'];

                    $this->insertHouseLog($houseLog);
                }
            }

            $this->canclevr($uid);
        }
    }


    public function canclevr($broker_id){
        $url = "http://newrent.house365.com/api/zsb/cancle-vr";
        $pa['broker_id'] = $broker_id;
        $pa['token'] = md5($broker_id.'365zsh');
        $this->request_post_($url,$pa);
    }

    public  function request_post_($url = '', $param = '') {
        if (empty($url) || empty($param)) {
            return false;
        }
        $postUrl = $url;
        $curlPost = $param;
        $ch = curl_init();//ʼcurl
        curl_setopt($ch, CURLOPT_URL,$postUrl);//ץȡָҳ
        curl_setopt($ch, CURLOPT_HEADER, 0);//header
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);//ҪΪַĻ
        curl_setopt($ch, CURLOPT_POST, 1);//postύʽ
        curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
        $data = curl_exec($ch);//curl
        curl_close($ch);
        return $data;
    }


    /**
     * ·Դ
     * @param string $houseIds
     * @return mixed
     */
    public function updateRealHouse($houseIds)
    {
        $where = 'id in ('. implode(',',$houseIds) .')';
        $this->db->where($where);
        $data = array();
        //ע͵
        //$data['esta'] = 2;
        $data['is_real_house'] = 0;
        $data['lucupdatetime'] = time();
        $result = $this->db->update('sell', $data);
        return $result;
    }

    /**
     * ȡԴ
     * @param int $brokerId
     * @return mixed
     */
    public function getBrokerRealHouse($brokerId)
    {
        $where = 'uid = '.$brokerId.' and esta = 1 and infofrom = 5 and is_real_house = 1 ';
        $this->dbback->select("id");
        $this->dbback->where($where);
        $result = $this->dbback->get('sell')->result_array();
        return $result;
    }

    public function getUidRealHouseNum($uid)
    {
        $sql = "SELECT id FROM sell where uid='$uid' and esta = 1 and is_real_house = 1";
        $result = $this->dbback->query($sql);
        return $result->num_rows;
    }

    public function getUidRealHouseNumExceptId($uid,$house_id)
    {
        $sql = "SELECT id FROM sell where uid='$uid' and is_real_house = 1 and id!=$house_id";
        $result = $this->dbback->query($sql);
        return $result->num_rows;
    }

    public function insertReal_House_Set_log($uid,$rowid,$type,$operation_status=null)
    {
        $data           =array();
        $data['uid']    =$uid;
        $data['tbl']    ='sell';
        $data['rowid']  =$rowid;
        $data['type']    =$type;
        $data['source']  =0;
        $data['ctime']   =time();
        $data['ip']      =get_ip();
        $data['reason'] = $operation_status; //ԭ
        $data['operatetime'] = time();
        //print_r($data);die;
        $this->db->insert('real_house_set_log', $data);
        if($this->db->insert_id())
        {
            $rs =array();
            $rs['is_real_house']    =$type;
            $res = $this->real_vr_option($uid,$rowid,$type);
            $newre = array_merge($rs,$res);
            $this->db->where('id', $rowid);
            $this->db->update('sell', $newre);
        }
    }

    /**
     * @param $uid id
     * @param $rowid Դid
     * @param $type 0 ȡ淿Դ1淿Դ
     */
    public function real_vr_option($uid,$rowid,$type,$source=0){


        $rs =array();
        //ȡ淿ԴʱҪȥ

        $this->load->model('broker_model');
        $session_info = $this->broker_model->get_user_session();
        $uid = $session_info['uid'];

        $real = $this->dbback->from('broker')->where(array('uid'=>$uid,'real_status !='=>0))->get()->row_array();
        //ֻзԴǷĿ  ͨĿʱ
        if(!$type && $real){

            $vrapps['shot_status'] = 5;
            $this->db->where(array('broker_id'=>$uid,'house_id'=>$rowid))->where_in('shot_status',array(1,2,7,8))->update('vr_applay',$vrapps);
            $rs['vr_model_id'] = 'vr_id_empty';
            $rs['isvr'] = 0;

            if($source){
                $this->db->where('id', $rowid)->update('sell', $rs);
            }
            return $rs;
        }else{
            //淿Դʱ⵱ǰķԴǷѱVR
            $vrapp = $this->db->from('vr_applay')->where(array('broker_id'=>$uid,'house_id'=>$rowid,'vr_model_id !='=>''))->order_by('save_time','desc')->get()->row_array();
            if($vrapp){
                if($vrapp['vr_model_id'] != 'vr_id_empty'){
                    $rs['vr_model_id'] = $vrapp['vr_model_id'];
                    $rs['isvr'] = 1;
                    if($source){
                        $this->db->where('id', $rowid)->update('sell', $rs);
                    }
                }
            }
            return $rs;
        }
    }


    public function insertReal_House_Set_log2($uid,$rowid,$type,$operation_status = null)
    {


        $data           =array();
        $data['uid']    =$uid;
        $data['tbl']    ='sell';
        $data['rowid']  =$rowid;
        $data['type']    =$type;
        $data['source']  =0;
        $data['ctime']   =time();
        $data['ip']      =get_ip();
        $data['reason'] = $operation_status;
        $data['operatetime'] = time();
        //print_r($data);die;
        $this->db->insert('real_house_set_log', $data);

    }


    public function getUidRealHouseInfo($rowid)
    {
        $this->dbback->select("id,uid,blockid,subfloor,floor,totalfloor,room,hall,toilet,buildarea");
        $this->dbback->where('id = '.intval($rowid));
        $result = $this->dbback->get('sell')->row_array();


        $uid        =$result['uid'];
        $blockid    =$result['blockid'];
        $subfloor   =$result['subfloor'];
        $floor      =$result['floor'];
        $totalfloor =$result['totalfloor'];
        $room       =$result['room'];
        $hall       =$result['hall'];
        $toilet     =$result['toilet'];
        $buildarea_start  =$result['buildarea']-1;
        $buildarea_end  =$result['buildarea']+1;




        $this->dbback->select("id");
        $this->dbback->where('uid = '."'".$uid."'".' and is_real_house =1'.' and blockid ='.$blockid.' and subfloor ='.$subfloor.' and floor ='.$floor.' and totalfloor ='.$totalfloor.' and room ='.$room.' and hall ='.$hall.' and toilet ='.$toilet.' and buildarea >='.$buildarea_start.' and buildarea<='.$buildarea_end);
        $val = $this->dbback->get('sell')->row_array();
        if(!empty($val))
        {
            return 1;
        }else
        {
            return 0;
        }
    }



    public function insertCreditImage($tbl,$rowid,$arr)
    {
        $sql = "delete from credit_image where $tbl='$tbl' and houseid =$rowid ";
        $this->db->query($sql);

        if(!empty($arr))
        {
            foreach ($arr as $key=>$rs)
            {
                $filename  =$rs;
                $sql_insert = "insert into  credit_image (tbl,filename,houseid) values ($tbl,'$filename','$rowid') ";

                $this->db->query($sql_insert);
            }
        }


    }

    public function DeleteCreditImage($tbl,$rowid)
    {
        $sql = "delete from credit_image where $tbl='$tbl' and houseid =$rowid ";
        $this->db->query($sql);
    }


    public function getInfoByRowid($rowid)
    {
        $sql = "SELECT id FROM sell where id='$rowid' and is_real_house = 1 ";
        $result = $this->dbback->query($sql);

        return $result->num_rows;
    }


    public function getCreditImageByRowid($tbl,$rowid)
    {
        $sql = "SELECT filename FROM credit_image where tbl='$tbl' and houseid = $rowid ";
        $result = $this->dbback->query($sql);
        if($result->num_rows) {
            $arr = $result->result_array();
            return $arr;
        }else
        {
            return array();
        }

    }


    //ҳ漤淿Դǩ
    public function getUidRealHouseByOperate($result,$uid,$house_id)
    {
        $uid        =$uid;
        $blockid    =$result['blockid'];
        $subfloor   =$result['subfloor'];
        $floor      =$result['floor'];
        $totalfloor =$result['totalfloor'];
        $room       =$result['room'];
        $hall       =$result['hall'];
        $toilet     =$result['toilet'];
        $buildarea_start  =$result['buildarea']-1;
        $buildarea_end  =$result['buildarea']+1;


        $this->dbback->select("id");
        if($house_id!=0)
        {
            $this->dbback->where('uid = ' . "'" . $uid . "'" . ' and is_real_house =1' . ' and blockid =' . $blockid . ' and subfloor =' . $subfloor . ' and floor =' . $floor . ' and totalfloor =' . $totalfloor . ' and room =' . $room . ' and hall =' . $hall . ' and toilet =' . $toilet . ' and buildarea >=' . $buildarea_start . ' and buildarea<=' . $buildarea_end." and id !=".$house_id);
            $val = $this->dbback->get('sell')->row_array();

        }else {
            $this->dbback->where('uid = ' . "'" . $uid . "'" . ' and is_real_house =1' . ' and blockid =' . $blockid . ' and subfloor =' . $subfloor . ' and floor =' . $floor . ' and totalfloor =' . $totalfloor . ' and room =' . $room . ' and hall =' . $hall . ' and toilet =' . $toilet . ' and buildarea >=' . $buildarea_start . ' and buildarea<=' . $buildarea_end);
            $val = $this->dbback->get('sell')->row_array();
        }
        if(!empty($val))
        {
            return 1;
        }else
        {
            return 0;
        }
    }


    public function updateSocreNum($houseId,$num)
    {
        $where = 'id ='.$houseId;

        $this->db->where($where);
        $data = array();
        $data['scoresum'] = $num;
        $data['lucupdatetime'] = time();


        $this->db->update('sell', $data);
        //die("123");
        //return $result;
    }


    /**
     * ȡԴƺϢ
     * @param int $brokerId
     * @return mixed
     */
    public function getHousebuildingnum($rowid)
    {
        $sql = "SELECT buildingnum,unitnum,roomnum FROM sell where id = $rowid ";
        $result = $this->dbback->query($sql);
        if($result->num_rows) {
            $arr = $result->result_array();
            return $arr;
        }else
        {
            return array();
        }
    }

    /**
     * жϴǷѧⷣѿһ
     * @param $brokerId
     * @return mixed
     */
    public function getPaperScoreRecord($brokerId)
    {
        $this->dbback->select("id");
        $this->dbback->where('score = 100 and broker_id = '.intval($brokerId));
        $study_result = $this->dbback->get('paper_result_log')->row_array();
        return $study_result;
    }

    /**
     * жǷѧⷣѿһ
     * @param $brokerId
     * @return mixed
     */
    public function getPaperTodayScoreRecord($brokerId,$date)
    {
        $this->dbback->select("id");
        $this->dbback->where('paper_time_today = '.$date.' and broker_id = '.intval($brokerId));
        $study_today_result = $this->dbback->get('paper_result_log')->row_array();
        return $study_today_result;
    }

    /**
     * ȡʮ
     * @param $brokerId
     * @return mixed
     */
    public function getRandPaperTitle(){
        $this->dbback->from('paper_title as t');
        $this->dbback->join('paper_title_answer as a','title_id=t.id','left');
        $this->dbback->select("t.id,t.title,a.answer,a.answer_type,a.true_answer_type,a.title_id");
        $this->dbback->where(array('t.type'=>1));
        $result = $this->dbback->get()->result_array();
        return $result;
    }

    /**
     * ȡĿ
     * @return mixed
     */
    public function getTotalPaperTitle(){
        $this->dbback->select("id,title");
        $this->dbback->where(array('type'=>1));
        $this->dbback->order_by('id');
        $paper_total_title = $this->dbback->get('paper_title')->result_array();
        return $paper_total_title;
    }

    /**
     * ȡӦĿµĴ
     * @return mixed
     */
    public function getPaperTitleAnswer($title_id){
        $this->dbback->select("answer,answer_type,true_answer_type");
        $this->dbback->where(array('title_id'=>$title_id));
        $this->dbback->order_by('id');
        $each_title_answer = $this->dbback->get('paper_title_answer')->result_array();
        foreach($each_title_answer as $key=>$value){
            $each_title_answer[$key]['answer_type_en']  = $this->num_contact($value['answer_type']);
        }
        return $each_title_answer;
    }

    //ʶ
    public function num_contact($num){
        $arr = array('A','B','C','D','E','F','G');
        return $arr[$num-1];
    }

    //ȡȷ
    public function get_right_answer($title_id){
        $this->dbback->select("answer_type");
        $this->dbback->where(array('title_id'=>$title_id,'true_answer_type'=>1));
        $right_answer = $this->dbback->get('paper_title_answer')->row_array();
        return $right_answer['answer_type'];
    }

    /**
     * ȡĿ
     * @return mixed
     */
    public function getPaperInfo($title_id){
        $this->dbback->from('paper_title as t');
        $this->dbback->join('paper_title_answer as a','title_id=t.id','left');
        $this->dbback->select("t.id,t.title,a.answer,a.answer_type,a.true_answer_type");
        $this->dbback->where(array('t.type'=>1,'t.id'=>$title_id));
        $result = $this->dbback->get()->result_array();
        foreach($result as $key=>$value){
            $result[$key]['answer_type_en']  = $this->num_contact($value['answer_type']);
        }
        return $result;
    }

    /**
     * 뿼Լ¼
     * @param $data
     * @return mixed
     */
    public function insertPaperResult($data)
    {
        if ($this->db->insert('paper_result_log', $data))
        {
            return $this->db->insert_id();
        }
    }

    /**
     * ͨѧⷣ¾˱
     * @param $id
     * @param $data
     * @return mixed
     */
    public function updateBrokerFree($brokerId, $data)
    {
        $this->db->where('uid', $brokerId);
        $result = $this->db->update('broker', $data);
        return $result;
    }

    /**
     * ͨѧⷣ¾˱
     * @param $id
     * @param $data
     */
    public function updateBrokerStatus($brokerId, $data)
    {
        $this->db->where('uid', $brokerId);
        $result = $this->db->update('real_house_account', $data);
        return $result;
    }

    /**
     * ȡ˿ԴϢ
     * @param $id
     * @return mixed
     */
    public function getBrokerWrongTitle($broker_id)
    {
        $this->dbback->select("*");
        $this->dbback->where(array('broker_id'=>intval($broker_id),'paper_time_today'=>date('Ymd',time())));
        $result = $this->dbback->get('paper_result_log')->row_array();
        return $result;
    }

    /**
     * ȡѧⷣʹõļ¼
     * @param $id
     * @return mixed
     */
    public function getBrokerUselog($broker_id)
    {
        $this->dbback->select("*");
        $this->dbback->where(array('broker_id'=>$broker_id,'type'=>0));
        $result = $this->dbback->get('paper_times_use_log')->row_array();
        return $result;
    }


    public function getBrokerRealStatus($uid)
    {
        $sql = "SELECT real_status FROM broker WHERE uid=$uid and real_status>=1";
        $result= $this->db->query($sql)->row_array();

        return $result['real_status'];
    }


}
