<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of market_bid_house_manage
 *
 * @author Administrator
 */
class market_bid_rent_manage extends MY_Controller {

    private $uid;
    private $info;
    
    private $house;
    
    private $brokerLevel;
    
    private $bidBlockWords;
    
    private $arrBlockId;
    
    private $arrHotSearchWords;
    
    private $bidBehavior = array(
		1 => 'ɹ', 2 => 'ʧ', 3 => 'δͶ',
		4 => 'δͶ', 5 => 'Ͷ', 6 => 'Ͷ'
	);
    
    private $growthBrokerCredit;
    private $growthBrokerBidRent;
    
    public function __construct($type = NULL) {
        parent::__construct($type);
        $this->initUserInfo();
        $this->checkAuth();
        $this->load->library('TabPage');
        $this->house = $this->config->item('house');
        $this->growthBrokerCredit = new GrowthBrokerCredit($this->broker);
        $this->initGrowthBrokerBidRent();
        $this->load->helper('common_url');
    }


    private function initUserInfo() {
        $info = $this->broker_model->get_user_session();

        $groupId = $info['package_id']; //ײ
        //$brokerType = $info['groupid'];//or
        $gbe = new GrowthBrokerExp(array('id' => $info['uid'], 'groupid' => $groupId));
        $gbc = new GrowthBrokerCredit(array('id' => $info['uid'], 'groupid' => $groupId));
        $this->load->model('payment_model');
        $info['payment_url'] = $this->payment_model->get_module_url('recharge');   
        //ȼ
        $info['level'] = $gbe->getLevel(2);
        //
        $info['exp'] = $gbe->getExp();
        //
        /*
          $allLevel = $this->allLevel();
          $info['nextLevel'] = $this->nextLevel($info['level'],$allLevel);
          $growthExpDayLimit = $this->getGroupDayMaxExp($groupId);
          $info['level_day'] = $this->calUpgradeDays($info['nextLevel'],$growthExpDayLimit,$info['exp']);
         */
        //
        $info['credit'] = $gbc->getValidCredit();
        $this->info = $info;
        $this->uid = $info['uid'];
        
        $broker['id'] = $this->uid;
        $broker['level'] = 'LV'.$this->info['level'];
        $broker['credit'] = $this->info['credit'];
        $broker['groupid'] = $groupId;
        $broker['is_pay'] = $this->info['is_pay'];
        $this->broker = $broker;
    }

    /**
     * ʼɳϵ
     */
    private function initGrowthBrokerBidRent() {
        $growthConfig = $this->config->item('growth');
        $mode = $growthConfig['mode'];
        $this->growthBrokerBidRent = new GrowthBrokerBidRent($this->broker, $this->growthBrokerCredit,$mode);
        $this->growthBrokerBidRent->setCheckStar(true);
        $additionalScore = $growthConfig['additionalScore']['house'];
        $this->growthBrokerBidRent->setAdditionalScore($additionalScore);
    }

    public function index() {
        exit;
    }

    public function all() {
//        if(GB_CITY == 'wh'){
//            $this->jump('/', 'Ͷѹرգ');
//        }
        $brokerLevel = $this->getBrokerLevel();
        $check = $this->checkBidLevel($brokerLevel);
		$broker_new_info =$this->broker_model->get_broker_info_by_uid($this->uid);//20160226 add
        if($check!==true || intval($broker_new_info[0]['starlevel'])<3) {//鲻ͨת
            //$page_text = "&nbsp;<span style='color:green;'>{$check}</span>&nbsp;Ϳʹô˹Ŷ <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ȥɣͣ";
			 $page_text = "&nbsp;<span style='color:green;'>3</span>&nbsp;Ϳʹô˹Ŷ <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ȥɣͣ";
            $this->jump('/', $page_text, 4000);
        }

		//Ȩ֤
		$this->checkJoinBlacklistAuth();

        $viewData['brokerLevel'] = $brokerLevel;
        $tab = 'all';
        $viewData['js'] = load_js('common/js/jquery.jcountdown.js');
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        //Դַ
        $addHouseUrl = '#';//$addSellHouseUrl;
        //޸ķԴַ
        $modfiyHouseUrl = '#';//$modfiySellHouseUrl;
        
        $arrBroker = array('id' => $this->uid);
        
        $searchWhere = array('esta' => 1, 'uid' => $arrBroker['id'], 'agentcode' => 'B000');
        
        $keywords = $this->input->get("keywords");
        $infotype = $this->input->get('infotype');
        if ($infotype) {
            $searchWhere['infotype'] = $infotype;
        }
        $viewData['infotype'] = $infotype;
        $viewData['infotypeSelect'] = $this->widget('imitateSelect',
                array('label'=>'Դ','value'=>$infotype,'key'=>'infotype','options'=>$this->house['infotype']));
        
        $k_id = $this->input->get("k_id")?$this->input->get("k_id"):1;
        if ($k_id == 1 && $keywords != '') {
            $searchWhere['blockshowname'] = " LIKE '%$keywords%'";
        } else if ($k_id == 2 && $keywords != '') {
            $searchWhere['id'] = $keywords;
        }
        //<dd><a class="link" href="####" oid="1">С</a></dd>
        //<dd><a class="link" href="####" oid="2">Դ</a></dd>
        $viewData['k_idSelect'] = $this->widget('imitateSelect',
                array('label'=>'С','value'=>$k_id,'key'=>'k_id','options'=>array('1'=>'С','2'=>'Դ'),'def'=>false));
        $viewData['keywords'] = $keywords;
        //
        $growthCredit = new GrowthCredit();
        $brokerCredit = $growthCredit->findByBrokerId($this->uid);
        $brokerCredit['credit'] = $brokerCredit['credit'] == '' ? 0 : $brokerCredit['credit'] - $brokerCredit['frozen'];
               
        $growthBrokerBidRent = $this->growthBrokerBidRent;//new GrowthBrokerBidHouse($arrBroker, $growthBrokerCredit);

        $growthBidPeriods = new GrowthBidPeriods();
        $cBidPeriods = $growthBidPeriods->currentBidPeriods(3);
        if(!$cBidPeriods) {
            show_404('');
        }
        $viewData['cBidPeriods'] = $cBidPeriods;

        //type 1,Сʣ2,Ѵʣ3,
        $growthBidRent = new GrowthBidRent();
        
        $viewData['arrBlockId'] = $this->getBidBlockId($growthBidRent,$cBidPeriods['id']);
        $viewData['arrHotSearchWords'] = $this->getHotSearchWords($growthBidRent,$cBidPeriods['id']);
        $viewData['bidBlockWords'] = $this->getBlockWordLevel();
        $viewData['bidHotSearchWords'] = $this->getHotSearchWordsLevel();
        
        //ԷԴΪ
        $rows_all = $growthBrokerBidRent->findHouseCountNew($searchWhere);
		
		$rows_all = is_array($rows_all) ? 0 : $rows_all;
		
		
        $per_page = 5;
        $pageSegment = 4;
        $page = $this->input->get('page')?$this->input->get('page'):1;
        $queryArray = array();
        $queryArray['infotype'] = $infotype;
        $queryArray['k_id'] = $k_id;
        if($keywords) {
            $queryArray['keywords'] = $keywords;
        }
        $queryString = http_build_query($queryArray);
        $base_url = '/market_bid_rent_manage/all/?'.$queryString;
        $data_info = array();
        if ($rows_all > 0) {
           $start = ($page-1)*$per_page;
           $limit =$per_page;
           $houseInfo = $growthBrokerBidRent->findHouseListNew($searchWhere, 'creattime', 'DESC', $start, $limit);
           $data_info = $growthBrokerBidRent->findBidHouseRecordList($cBidPeriods, $houseInfo);
           if ($data_info) {
               foreach($data_info as &$v) {
                   $v['content'] = "{$v['address']}{$v['room']}"
                    . "{$v['hall']}" . " {$v['buildarea']}O "
                    . "{$v['price']}{$this->house['priceunit'][$v['priceunit']]}";
               }
           }
        }
        $viewData['bidBehavior'] = $this->bidBehavior;
        $viewData['rows_all'] = $rows_all;
        $viewData['data_info'] = $data_info;
        $viewData['info'] = $this->info;
        $viewData['person'] = $this->widget('person');
		$viewData['hotword'] = $this->widget('hotword');
        $viewData['tab'] = $this->overViewTab('all');//tabҳ
        $viewData['house'] = $this->house;
        $viewData['self'] = $this;
        $viewData['page'] = $this->page($rows_all,$per_page,$pageSegment,$base_url);
		$viewData['google_analytics'] = get_ga_js_code('/Ӫ/ԴͶ/ȫԴ/');
        $this->view('market', 'market_bid_rent_manage/all', $viewData);
    }
    
    public function on() {
        
        $brokerLevel = $this->getBrokerLevel();
        $check = $this->checkBidLevel($brokerLevel);
        if($check!==true) {//鲻ͨת
            $page_text = "&nbsp;<span style='color:green;'>{$check}</span>&nbsp;Ϳʹô˹Ŷ <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ȥɣͣ";
            $this->jump('/', $page_text, 4000);
        }

        //Ȩ֤
		$this->checkJoinBlacklistAuth();


        $viewData['brokerLevel'] = $brokerLevel;
        
        $tab = 'on';
        $viewData['js'] = load_js('common/js/jquery.jcountdown.js');
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        //Դַ
        $addHouseUrl = '#';//$addSellHouseUrl;
        //޸ķԴַ
        $modfiyHouseUrl = '#';//$modfiySellHouseUrl;
        
        $arrBroker = array('id' => $this->uid);
        //
        $growthCredit = new GrowthCredit();
        $brokerCredit = $growthCredit->findByBrokerId($this->uid);
        $brokerCredit['credit'] = $brokerCredit['credit'] == '' ? 0 : $brokerCredit['credit'] - $brokerCredit['frozen'];
               
        $growthBrokerBidRent = $this->growthBrokerBidRent;//new GrowthBrokerBidHouse($arrBroker, $growthBrokerCredit,'','');
        //$growthBrokerBidRent->setCheckStar(true);
        $growthBidPeriods = new GrowthBidPeriods();
        $cBidPeriods = $growthBidPeriods->currentBidPeriods(3);
        if(!$cBidPeriods) {
            show_404('');
        }
        $viewData['cBidPeriods'] = $cBidPeriods;

        //type 1,Сʣ2,Ѵʣ3,
        $growthBidRent = new GrowthBidRent();
        
        $viewData['arrBlockId'] = $this->getBidBlockId($growthBidRent,$cBidPeriods['id']);
        $viewData['arrHotSearchWords'] = $this->getHotSearchWords($growthBidRent,$cBidPeriods['id']);
        $viewData['bidBlockWords'] = $this->getBlockWordLevel();
        $viewData['bidHotSearchWords'] = $this->getHotSearchWordsLevel();
        
        //ԾͶм¼Ϊ
        $rows_all = $growthBrokerBidRent->findBidOnHouseRecordCount();
        
        $per_page = 5;
        $pageSegment = 4;
        $page = $this->input->get('page')?$this->input->get('page'):1;
        $queryArray = array();
        $queryString = http_build_query($queryArray);
        $base_url = '/market_bid_rent_manage/on/?'.$queryString;
        
        $data_info = array();
        if ($rows_all > 0) {
           $start = ($page-1)*$per_page;
           $limit =$per_page;
           $bidRecord = $growthBrokerBidRent->findBidOnHouseRecord('utime', 'DESC', $start, $limit);
           $data_info = $growthBrokerBidRent->findBidOnHouseRecordList($cBidPeriods, $bidRecord);
           if ($data_info) {
               foreach($data_info as &$v) {
                   if ($v['esta'] != 1) {continue;}
                   $v['content'] = "{$v['address']}{$v['room']}"
                    . "{$v['hall']}" . " {$v['buildarea']}O "
                    . "{$v['price']}{$this->house['priceunit'][$v['priceunit']]}";
               }
           }
        }
        $viewData['bidBehavior'] = $this->bidBehavior;
        $viewData['rows_all'] = $rows_all;
        $viewData['data_info'] = $data_info;
        $viewData['info'] = $this->info;
        $viewData['person'] = $this->widget('person');
		$viewData['hotword'] = $this->widget('hotword');
        $viewData['tab'] = $this->overViewTab('on');//tabҳ
        $viewData['house'] = $this->house;
        $viewData['self'] = $this;
        $viewData['page'] = $this->page($rows_all,$per_page,$pageSegment,$base_url);
		$viewData['google_analytics'] = get_ga_js_code('/Ӫ/ԴͶ/ڲķԴ/');
        $this->view('market', 'market_bid_rent_manage/on', $viewData);
    }
    
    public function history() {
        $tab = 'all';
        $viewData['js'] = load_js('common/js/jquery.jcountdown.js');
        $viewData['css'] = load_css('zsb/css/v1.0/style1.css');
        //Դַ
        $addHouseUrl = '#';//$addSellHouseUrl;
        //޸ķԴַ
        $modfiyHouseUrl = '#';//$modfiySellHouseUrl;
        
        $arrBroker = array('id' => $this->uid);
        
        $searchWhere = array('esta' => 1, 'uid' => $arrBroker['id'], 'agentcode' => 'B000');
        

        $infotype = $this->input->get('infotype');
        if ($infotype) {
            $searchWhere['infotype'] = $infotype;
        } 
        $viewData['infotypeSelect'] = $this->widget('imitateSelect',
                array('label'=>'Դ','value'=>$infotype,'key'=>'infotype','options'=>$this->house['infotype']));
        $viewData['infotype'] = $infotype;
        
        $keywords = $this->input->get("keywords");
        $k_id = $this->input->get("k_id")?$this->input->get("k_id"):1;
        if ($k_id == 1 && $keywords != '') {
            $searchWhere['blockshowname'] = " LIKE '%$keywords%'";
        } else if ($k_id == 2 && $keywords != '') {
            $searchWhere['id'] = $keywords;
        }
        $viewData['keywords'] = $keywords;
        //<dd><a class="link" href="####" oid="1">С</a></dd>
        //<dd><a class="link" href="####" oid="2">Դ</a></dd>
        $viewData['k_idSelect'] = $this->widget('imitateSelect',
                array('label'=>'С','value'=>$k_id,'key'=>'k_id','options'=>array('1'=>'С','2'=>'Դ'),'def'=>false));
        $viewData['keywords'] = $keywords;
        //
        $growthCredit = new GrowthCredit();
        $brokerCredit = $growthCredit->findByBrokerId($this->uid);
        $brokerCredit['credit'] = $brokerCredit['credit'] == '' ? 0 : $brokerCredit['credit'] - $brokerCredit['frozen'];
               
        

        $growthBidPeriods = new GrowthBidPeriods();
        $cBidPeriods = $growthBidPeriods->currentBidPeriods(3);
        if(!$cBidPeriods) {
            show_404('');
        }
        $viewData['cBidPeriods'] = $cBidPeriods;

        //type 1,Сʣ2,Ѵʣ3,
        $growthBidRent = new GrowthBidRent();

        $viewData['bidBlockWords'] = $this->getBlockWordLevel();
        $viewData['bidHotSearchWords'] = $this->getHotSearchWordsLevel();
        
        $growthBrokerBidRent = $this->growthBrokerBidRent;
        //ԷԴΪ
        
        $rows_all = $growthBrokerBidRent->findBidHistoryHouseRecordCount($searchWhere);
        $per_page = 5;
        $pageSegment = 4;
        $page = $this->input->get('page')?$this->input->get('page'):1;
        $queryArray = array();
        $queryArray['infotype'] = $infotype;
        $queryArray['k_id'] = $k_id;
        if($keywords) {
            $queryArray['keywords'] = $keywords;
        }
        $queryString = http_build_query($queryArray);
        $base_url = '/market_bid_rent_manage/history/?'.$queryString;
        $data_info = array();
        if ($rows_all > 0) {
           $start = ($page-1)*$per_page;
           $limit =$per_page;
           $bidRecord = $growthBrokerBidRent->findBidHistoryHouseRecord($searchWhere, 'utime', 'DESC', $start, $limit);
           $data_info = $growthBrokerBidRent->findBidHistoryHouseRecordList($bidRecord);
           if ($data_info) {
               foreach($data_info as &$v) {
                   if ($v['esta'] != 1) {continue;}
                   $v['content'] = "{$v['address']}{$v['room']}"
                    . "{$v['hall']}" . " {$v['buildarea']}O "
                    . "{$v['price']}{$this->house['priceunit'][$v['priceunit']]}";
               }
           }
        }
        $viewData['bidBehavior'] = $this->bidBehavior;
        $viewData['rows_all'] = $rows_all;
        $viewData['data_info'] = $data_info;
        $viewData['info'] = $this->info;
        $viewData['person'] = $this->widget('person');
		$viewData['hotword'] = $this->widget('hotword');
        $viewData['tab'] = $this->overViewTab('history');//tabҳ
        $viewData['house'] = $this->house;
        $viewData['page'] = $this->page($rows_all,$per_page,$pageSegment,$base_url);
		$viewData['google_analytics'] = get_ga_js_code('/Ӫ/ԴͶ/Ͷʷ/');
        $this->view('market', 'market_bid_rent_manage/history', $viewData);
    }

	//ȡⷿѴ
	public function getHotWordData()
	{
		$this->load->model('hotword_model');
		$result = $this->hotword_model->getHotWordData(2);
		
		return $result;
	}
    
    private function getBidBlockId($growthBidRent,$cBidPeriodsId) {
        $arrBidBlock = $growthBidRent->findPeriodsBlock($cBidPeriodsId);
        $arrBlockId = array();
        if ($arrBidBlock) {
            foreach ($arrBidBlock as $v) {
                $arrBlockId[] = $v['block_id'];
            }
        }
        $this->arrBlockId = $arrBlockId;
        return $arrBlockId;
    }
    /**
     * ʹøſǩҳ
     * @param type $curPage
     * @return type
     */
    private function overViewTab($curPage) {
        $tabData = array();
        //$allTab = array('all' => 'ȫԴ', 'on' => 'ҲķԴ', 'history' => 'Ͷʷ');
        $tabData['all'] = array('url'=>'/market_bid_rent_manage/all/','name'=>'ȫԴ');
        $tabData['on'] = array('url'=>'/market_bid_rent_manage/on/','name'=>'ҲķԴ');
        $tabData['history'] = array('url'=>'/market_bid_rent_manage/history/','name'=>'Ͷʷ');

		$documentation = $this->config->item('documentation');

        $rightBtns = array();
        $rightBtns[] = array('url'=>$documentation['bid_house_rule'],'name'=>'ԴͶ˵');
        return $this->tabpage->generate($tabData,$curPage,$rightBtns);
    }
    
    //ȡͶʵȼ
    private function getBlockWordLevel() {
        //ȡͶʺѴʵĵȼ
        $growthBidRentLevel = new GrowthBidRentLevel();
        $bidHouseLevel = $growthBidRentLevel->findAll();
        $bidBlockWords = array();
        if ($bidHouseLevel) {
            foreach ($bidHouseLevel as $v) {
                 if ($v['type'] == 1) {
               $bidBlockWords = explode(',', $v['levels']);
                 }
            }
        }
        $this->bidBlockWords = $bidBlockWords;
        return $bidBlockWords;
    }
    //Ѵʵĵȼ
    private function getHotSearchWordsLevel() {
        $growthBidRentLevel = new GrowthBidRentLevel();
        $bidHouseLevel = $growthBidRentLevel->findAll();
        $bidHotSearchWords = array();
        if ($bidHouseLevel) {
            foreach ($bidHouseLevel as $v) {
                if ($v['type'] == 2) {
                $bidHotSearchWords = explode(',', $v['levels']);
                }
            }
        }
        $this->bidHotSearchWords = $bidHotSearchWords;
        return $bidHotSearchWords;
    }
    
    private function getHotSearchWords($growthBidRent,$cBidPeriodsId) {
        $arrBidHotSearch = $growthBidRent->findPeriodsHotSearch($cBidPeriodsId);
        $arrHotSearchWords = array();
        if ($arrBidHotSearch) {
            foreach ($arrBidHotSearch as $v) {
                $arrHotSearchWords[] = $v['keyword'];
            }
        }
        $this->arrHotSearchWords = $arrHotSearchWords;
        return $arrHotSearchWords;
    }
    
    private function getBrokerLevel() {
        //˳ɳֵȼ  
        $growthExp = new GrowthExp();
        $brokerExp = $growthExp->findOneByBrokerId($this->uid);
        $brokerExp['exp'] = !isset($brokerExp['exp']) || $brokerExp['exp'] == '' ? 0 : $brokerExp['exp'];
        $growthLevel = new GrowthLevel();
        $brokerLevel = $growthLevel->findOneByExp($brokerExp['exp']);
        $this->brokerLevel = $brokerLevel;
        return $brokerLevel;
    }
    
    /**
     * Բĵȼ
     */
    private function checkBidLevel($brokerLevel) {
        
        //жȨ
        $brokerLevelNum = intval(substr($brokerLevel['name'], 2));
        //˲ȼȨ
        $growthBidLowLevel = new GrowthBidLowLevel();
        $lowLevel = $growthBidLowLevel->findLevelByType(3);
        $lowLevelId = intval(substr($lowLevel, 2));
        if ($brokerLevelNum < $lowLevelId || $brokerLevelNum == '') {
            return $lowLevel;
        } else {
            return true;
        }
    }
    
    private function hasGetLoginScore() {
        //ȡ
        $growthCreditDayCount = new GrowthCreditDayCount();
        $ctime = date('Y-m-d');
        $brokerCreditDayLoginActivity = $growthCreditDayCount->findByTimeWayAliasBrokerId($ctime, 'loginActivity', $_SESSION['broker']['uid']);
        return $isBrokerCreditLogin = count($brokerCreditDayLoginActivity) > 0 ? true : false;
    }
    
    public function generateBidRentUrl($houseId,$blockId,$tabName='on') {
        $error = 0;
        $result = '';
        //$brokerLevel,$bidBlockWords,$arrBlockId;
        $brokerLevel = $this->brokerLevel;
        $arrBlockId = $this->arrBlockId;
        $bidBlockWords = $this->bidBlockWords;
        if (!in_array($brokerLevel['name'], $bidBlockWords)) {
                $error = 1;
                $result = $bidBlockWords[0];
        } else if (!in_array($blockId, $arrBlockId)) {//$row['block_id'];//$row['house_id'];
                $error = 2;
        }
        if (!$error) {
                $url = '<a href="/market_bid_rent/block/'.$tabName.'/'.$houseId.'" class="link_fun">С</a>'; 
               // $url = '<span class="noneblock" error = "' . $error 
                 //. '" result="' .$result .'">С</span>'; 
        } else {
                $url = '<span class="noneblock" error = "' . $error 
                 . '" result="' .$result .'">С</span>'; 
        }
        return $url;
    }
    
    public function generateBidRentUrlHot($houseId,$content,$tabName='on') {
        $error = 0;
        $result = '';
        $brokerLevel = $this->brokerLevel;
        $arrHotSearchWords = $this->arrHotSearchWords;
        $bidHotSearchWords = $this->bidHotSearchWords;
        $hotSearchWords = implode('|', $arrHotSearchWords);
        if (!in_array($brokerLevel['name'], $bidHotSearchWords)) {
                $error = 1;
                $result = $bidHotSearchWords[0];
        } else if (!preg_match("/{$hotSearchWords}/", $content)) {
                $error = 2;
        }
        if (!$error) {
                return  '<a href="/market_bid_rent/hotword/'.$tabName.'/'.$houseId.'" class="link_fun">Ѵ</a>';
        } else {
                return '<span class="nonehotsearch" style="color:#999;" house_id="'.$houseId .'" error = "'.$error.'" result="'.$result .'">Ѵ</span>';
        }
    }
    
    private function widget($name,$data=null) {
        switch ($name) {
            case 'person':
				// 2016-1-14 Ǽ -----------start -------->
				$info = $this->broker_model->get_user_session();
				
				$broker_new_info =$this->broker_model->get_broker_info_by_uid($info['uid']);
				// 2016-1-14 Ǽ -----------end -------->
				
				$documentation = $this->config->item('documentation');

                $data = array(
					'info'=>  $this->info,
					'introUrl'=>$documentation['what_credit'],
					'broker_new_info' => $broker_new_info,
					'functionSwitch' => $this->config->item('functionSwitch')   //ܿ	
				);
                $person = $this->load->view('widget/person', $data, true);
                return $person;
                break;
            case 'imitateSelect':
                $value = $data['value'];
                if($value) {
                    $data['name'] = $data['options'][$value];
                } else {
                    $data['name'] = '';
                }
                if(!isset($data['def'])) {
                    $data['def'] = true;
                }
                $widget = $this->load->view('widget/imitateSelect', $data, true);
                return $widget;
                break;
			case 'hotword':
                $data = array('info'=> $this->getHotWordData(),'title' => 'ⷿ');
                $widget = $this->load->view('widget/hotword', $data, true);
                return $widget;
                break;
            default:
                break;
        }
    }
    
    private function page($total,$per_page,$pageSegment,$base_url) {
        //ҳ	

        $this->load->library('pagination');
        $config['use_page_numbers'] = TRUE;
        $config['full_tag_open'] = '<div class="picPreviewPag">';
        $config['full_tag_close'] = '</div>';
        //ҳ
        $config['first_link'] = 'ҳ';
        $config['first_tag_open'] = '<span class="prev">';
        $config['first_tag_close'] = '</span>';
        //ĩҳ
        $config['last_link'] = 'ĩҳ';
        $config['last_tag_open'] = '<span class="next">';
        $config['last_tag_close'] = '</span>';
        //һҳ
        $config['next_link'] = 'һҳ&gt;';
        $config['next_tag_open'] = '<span class="next">';
        $config['next_tag_close'] = '</span>';
        //һҳ
        $config['prev_link'] = '&lt;һҳ';
        $config['prev_tag_open'] = '<span class="prev">';
        $config['prev_tag_close'] = '</span>';
        //ǰҳ
        $config['cur_tag_open'] = '<span class="lin current">';
        $config['cur_tag_close'] = '</span>';
        //ҳ
        $config['num_tag_open'] = '<span class="lin">';
        $config['num_tag_close'] = '</span>';
        $config['anchor_class'] = 'class="xx"';
        
        $config['base_url'] = $base_url;//
        $config['total_rows'] = $total;
        $config['per_page'] = $per_page;
        $config['uri_segment'] = $pageSegment;
        $config['num_links'] = 3;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'page';
        $this->pagination->initialize($config); 

        return $this->pagination->create_links();
    }
    
    private function checkAuth() {
        if($this->info['is_pay'] != payStatus){
            $this->jump('/', 'ǰײûд˹ܵȨޣϵͻͨ');
            exit;
        }
    }


	
	//Ȩ֤
    private function checkJoinBlacklistAuth(){
        $this->load->model('complain_model');
        $complainList = $this->complain_model->getLastBidBlackList($this->user_arr['uid']);
        if($complainList['isJoin']){
            $endtime = $complainList['end_time'];
            $page_text = "ܱǸľͶԴΪٷԴȡ븶ƹʸ<br/> {$endtime}";
            $this->jump('/', $page_text, 4000);
            return;            
        }
    }
}

?>
