<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ҵ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright       Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * 
 *
 * ļ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          fisher
 */
class Broker_base_model extends MY_Model {
    /**
    * UID
    *
    * @access private
    * @var integer
    */
    private $_uid = 0;
    
    /**
    * KEY
    *
    * @access private
    * @var string
    */
    private $_mem_key;
    
    /**
    * Constructor
    */
    public function __construct()
    {

        parent::__construct(1,1,2);

		$this->_mem_key = GB_CITY.'_broker_base_model';
    }
    
    /**
    * set_uid
    *
    * þUID
    *
    * @access	public
    * @param	int     $uid UID
    * @return	void
    */
    public function set_uid($uid)
    {  
		
        $this->_uid = intval($uid);
    }

    /**
    * get_uid
    *
    * ȡUID
    *
    * @access	public
    * @param	void
    * @return	int     $uid UID
    */
    public function get_uid()
    {   
        return $this->_uid;
    }

    /**
    * check_uid
    *
    * ȨޣĿǰڲʹãuidǷ
    *
    * @access	protected
    * @param	void
    * @return	int     $uid UID
    */
    protected function check_uid()
    {   
        return $this->_uid > 0 ? true : false;
    }

    /**
    * get_broker_info
    *
    * þϢ
    *
    * @access	public
    * @param	void
    * @return	array   ˻Ϣ
    */
    public function get_broker_info()
    {   
        if($this->check_uid())
        {	
            $mem_key = $this->_mem_key . '_get_broker_info_by_uid_'.$this->_uid;
			
			$cache = $this->mc->delete($mem_key);
            $cache = $this->mc->get($mem_key);
			
            if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
            {
                $arr_data = $cache['data'];
            }
            else
            {
                //ѯֶ
                //$this->dbback->select("uid,username,truename,agentcode,telno,expiredate,postlimit,groupid,is_warn,valid_flag,smallphoto,package_id,festa,is_pay,master,real_limit,nofee_num,isreal,favtag_num,regdate,password,qq,email,idno,selfdesc,skill,starlevel,usetime");
                if(GB_CITY == 'nj'){
                    $this->dbback->select("uid,username,truename,agentcode,telno,expiredate,postlimit,groupid,is_warn,valid_flag,smallphoto,package_id,festa,is_pay,master,nofee_num,favtag_num,regdate,password,qq,email,idno,selfdesc,skill,starlevel,usetime,real_status,alipay_acount");
                }else
                {
                    $this->dbback->select("uid,username,truename,agentcode,telno,expiredate,postlimit,groupid,is_warn,valid_flag,smallphoto,package_id,festa,is_pay,master,nofee_num,favtag_num,regdate,password,qq,email,idno,selfdesc,skill,starlevel,usetime,alipay_acount");
                }
                //ѯ
                $this->dbback->where("uid = '".$this->_uid."'");
                //ѯ
                $arr_data = $this->dbback->get('broker')->row_array();
				//ȡǰ˿ͻϢ
				if(!empty($arr_data['master']))
				{
					$this->dbback->select("truename,telno");
					//ѯ
					$this->dbback->where("authname = '".$arr_data['master']."'");
					//ѯ
					$master_data = $this->dbback->get('home_auth')->row_array();
					$arr_data['master_name'] = $master_data['truename'];
					$arr_data['master_telno'] = $master_data['telno'];
				}
                $arr_data['agent_url'] = str_replace('(*)', $arr_data['uid'], GB_BROKER_SHOP);
                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$arr_data), 600);
            }
            return $arr_data;
        }
    }
    
    /**
     * get_broker_detail
     * ȡϸϢ
     * @param void
     * @return array
     */
    public function get_broker_detail()
    {	
        $arr_data = array();
        $arr_data = $this->get_broker_info();

        return $arr_data;
    }

    /**
    * encrypt_broker_pwd
    *
    * ܾ
    *
    * @access	protected
    * @param	string  $password 
    * @return	array   ˻Ϣ
    */
    protected function encrypt_broker_pwd($password, $key = '')
    {   
        return md5($key.$password);
    }

    /**
    * log_broker_login
    *
    * 龭˵½
    *
    * @access	public
    * @param	array   $data ־
    * @param	string  $tbl ־
    * @return	array   ˻Ϣ
    */
    public function log_broker_login($data, $tbl = 'log_login')
    {   
        if(is_array($data) && !empty($data) && $tbl != '')
        {
            $this->db->insert($tbl, $data);
        }
    }
    
    /**
     * get_info_by_username
     * 
     * ݾ˵ûȡϢ
     * @access public
     * @param string $username ʺ
     * @return array Ϣ
     */
    public function get_info_by_username($username)
    {
        //ѯֶ
        $this->dbback->select("uid,username,truename,agentcode,telno,expiredate,postlimit,groupid,valid_flag,smallphoto,package_id");
        //ѯ
        $this->dbback->where("username = '".$username."'");
        //ѯ
        $arr_data = $this->dbback->get('broker')->row_array();

        return $arr_data;
    }

    /**
     * get_info_by_username
     *
     * ݾ˵ûȡϢ
     * @access public
     * @param string $username ʺ
     * @return array Ϣ
     */
    public function get_enter_num_by_uid($uid)
    {

        $logintime =time()-3600;
        //ѯֶ
        $this->dbback->select("id");
        //ѯ
        $this->dbback->where("uid = '".$uid."' and logintime>=$logintime");
        //ѯ
        $arr_data = $this->dbback->get('log_login')->row_array();
        $num      =count($arr_data);
        return $num;
    }
    
        /*
     * insert_info_sms
     * ϢϢݿ
     * @access public
     * @param int $uid
     * @param string $telno
     * @param int $validcode
     * @param string $tbl
     */
    public function insert_info_sms($data)
    {
        if(is_array($data)&&!empty($data))
        {
           $result = $this->db->insert('info_sms', $data);
            return $result;
        }
    }
    
    /**
     * get_broker_shop
     * ˵Ϣ
     * @access public
     * @param int $uid
     * @return array
     */
    public function get_broker_shop($uid){
        $this->dbback->select("skin_title, announce, skin_color");
         //ѯ
         $this->dbback->where("uid = '".$uid."'");
         //ѯ
         $arr_data = $this->dbback->get('broker')->row_array();
         return $arr_data;
    }
    
    /**
     * set_broker_info
     * Ϣ
     * @access public
     * @param int $uid ûid
     * @param array $data
     * @retrun void
     */
    public function set_broker_info($uid,$data){
        $tbl = "broker";

        $data_string = array();
        if(GB_CITY == 'nj' && (!empty($data['telno']) || !empty($data['idno'])))
        {
            $this->dbback->select("*");
            $this->dbback->where("uid = '".$uid."'");
            $data_string = $this->dbback->get('broker')->row_array();
        }

        $cond_where = array('uid'=>$uid);
        $this->db->where($cond_where);
        $this->db->update($tbl, $data);
        $rows = $this->db->affected_rows();

        if(GB_CITY == 'nj' && (!empty($data['telno']) || !empty($data['idno'])))
        {
            $url = 'http://esfadmin.house365.com/module/broker_manage/curl_sync_crm_broker.php';
            $ch = curl_init();
            $t_url = "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_TIMEOUT, 1);
            curl_setopt($ch, CURLOPT_REFERER, $t_url);
            curl_setopt($ch,CURLOPT_RETURNTRANSFER, 1);

            $returnVal = curl_exec($ch);
            curl_close($ch);
        }

        return $rows;
    }
}
/* End of file broker_model.php */
/* Location: ./models/broker_model.php */