<?php !defined('APP_DIR') ? die('acceess not defined') : '';
/**
 * @author gehaifeng
 *
 */
class BM_broker extends BM {
    
    private $_dao_broker = 'broker';
    private $_dao_agency = 'agency';
    private $_dao_freeze_record = 'broker_freeze_record';
    private $_dao_freeze_total = 'broker_freeze_total';
    private $_dao_star_level_record = 'broker_star_level_record';
    
    public function get($id, $city='nj'){
        $cache_f = "{$city}/broker/detail/$id";
		fcache::del($cache_f);
        $data = fcache::get($cache_f);
        if (!$data){
            $data = $this->dao($this->_dao_broker)->get($id);
            fcache::set($cache_f, '', $data,86400);
        }
        return $data;
    }
    
    public function edit($data,$city='nj'){
        $data = $this->dao($this->_dao_broker)->edit($data);
        $cache_f = "{$city}/broker/detail/{$data['uid']}";
        fcache::del($cache_f);
    }
    
    public function agencyByCode($ag_code,$city='nj'){
        $cache_f = "{$city}/agency/detail/code/$ag_code";
        $data = fcache::get($cache_f);
        if (!$data){
            $data = $this->dao($this->_dao_agency)->get(array(
                'where' => array(
                    'agentcode' => $ag_code,
                ),
            ));
            fcache::set($cache_f, '', $data,86400*30);
        }
        return $data;
    }
    
    public function freeze_record($data){
        $this->dao($this->_dao_freeze_record)->add($data);
        
        $d = $this->dao($this->_dao_freeze_total)->get(array(
            'where' => array(
                'uid' => $data['uid'],
            ),
        ));
        if ($d){
            $d['num'] = $d['num']+=1;
            $this->dao($this->_dao_freeze_total)->edit($d);
        }else {
            $d = array(
                'uid' => $data['uid'],
                'num' => 1,
                'ctime' => time(),
            );
            $this->dao($this->_dao_freeze_total)->add($d);
        }
    }
    
    public function add_star_level_record($data){
        $this->dao($this->_dao_star_level_record)->add($data);
    }

	public function get_all($searchCrond = array(),$city='nj')
	{
		$data = $this->dao('broker')->get_all($searchCrond);
		return $data;
	}
}