<?php
/**
 * ˳ֵ¼
 * @author sun
 */
class PaymentRechargeRecordTest {
    
    /**
     * ݿ 
     * @var TINY_ADODB 
     */    
    private $db;
    
    /**
     * ݿ
     * @var type 
     */
    private $dbback;
    
    /**
     * 
     * @var type 
     */
    private $mc;

    /**
     * ı 
     * @var String 
     */
    private $table;

    private $credit;
    /**
     * 캯ʼdb memcache ȡ
     * @param string $table ʹĬֵ
     */
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = 'payment_housebean_recharge_record';
        $this->table_success = 'payment_housebean_recharge_success_record';
		$this->table_success_job = 'payment_housebean_recharge_success_record_job';
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * ѯ䷶Χ
     * @param int $start ʼֵ
     * @param int $limit ÿҳʾ
     * @return string
     */
    private function getLimitCond($start, $limit) {
        $start = $start > 0 ? $start : 0;
        $limit_cond = ($start == 0 && $limit == 0) ? '' : ' LIMIT '
                      . $start . ' , ' . $limit;
        return $limit_cond;
    }
    
    /**
     * ֶ֤ǷϷ
     * @param type $field
     * @return type
     */
    private function validateFiled($field) {
        return in_array($field, $this->fields);
    }
    
    /**
     * 
     * @param string $orderField ֶ
     * @param string $order 
     * @return string
     */
    private function getOrder($orderField, $order = 'ASC') {
        $strOrder = '';
        if ($this->validateFiled($orderField)) {
            $strOrder = "ORDER BY $orderField $order";
        }
        return $strOrder;
    }

    /**
     * þ˵ǰֵ顣
     * @return array  
     */
    public function getBrokerCredit($brokerId) {
        $credit = new GrowthCredit();
        return $credit->findByBrokerId($brokerId);
    }
    
    /**
     * ֵ¼
     * @param int $brokerId ˱
     * @param int $active_type ײ
     * @param int $price ۸
     * @param int $price ۸
     * @param int $type ȡ; Ϊֵ
     * @param string $transaction_id ׺
     * @param string $program ֵ
     * @param int $source Դ
     * @param int $num 
     * @param string $invoice Ʊ̧ͷ
     * @return int
     */
    public function insert($brokerId, $active_type, $price, $bank_name,
            $transaction_id, $program, $source, $num, $invoice, $type = 1) {
        $fieldsValue = array();
        $creditOne = $this->getBrokerCredit($brokerId);
        $fieldsValue['broker_id'] = $brokerId;
        $sql = SqlCombinHelper::select_sql('broker', 'agentcode',
                'uid = ' . $brokerId);
        $fieldsValue['agentcode'] = $this->dbback->getOne($sql);
        $fieldsValue['active_type'] = $active_type;
        $fieldsValue['price'] = $price;
        $fieldsValue['bank_name'] = $bank_name;
        $fieldsValue['type'] = $type;
        $fieldsValue['transaction_id'] = $transaction_id;
        $fieldsValue['program'] = $program;
        $fieldsValue['source'] = $source;
        $fieldsValue['num'] = $num;
        $fieldsValue['remain_num'] = $creditOne['credit'];
        $fieldsValue['invoice'] = $invoice;
        $fieldsValue['status'] = 0;
        $fieldsValue['ip'] = GetIp();
        $fieldsValue['discard'] = 0;
        $fieldsValue['ctime'] = date('Y-m-d H:i:s');
        $sql = SqlCombinHelper::insert_sql($this->table, $fieldsValue);
        $this->db->execute($sql);
        return $this->db->Insert_ID();
    }

    /**
     * ֧ɹݵɹ
     * @param int $id ¼
     */
    public function copyRechargeSuccessRecord($id) 
    {
        $fields = implode(',', $this->fields);
        $sql = 'INSERT INTO ' . $this->table_success . ' (' . $fields 
             . ') SELECT * FROM ' . $this->table . ' where id = ' . $id;
        return $this->db->execute($sql);
    }
    
    /**
     * ֧
     * @param array $fieldValues 
     * @param int $id 
     * @param int $brokerId ˱
     * @return boolean
     */
    public function update($fieldValues, $id, $brokerId) {
        $sql = SqlCombinHelper::update_sql($this->table, $fieldValues,
                "id = {$id} and broker_id = {$brokerId} and status <> 1");
        return $this->db->execute($sql);
    }
    
    /**
     * ȡֵб
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param int $type ȡ
     * @param int $source Դ
     * @param int $start ʼ
     * @param int $pagesize ÿҳ
     * @param string $order 
     * @return array
     */
    public function getListBy($brokerId, $starttime, $endtime, $type = 1, 
            $source = null, $start = null, $pagesize = null, $order = null) {
        $where = '';
        $where .= "broker_id = $brokerId and type = $type and ctime >= '$starttime'"
                . " and ctime <= '$endtime'";
        //Դ 1 PC 2 APP
        if ($source != null && $source != '0') {
            $where .= ' and source = ' . $source;
        }
        if($start !== null && $pagesize !== null) {
            $limit = $this->getLimitCond($start, $pagesize);
        } else {
            $limit = '';
        }
		if($order !== null){
		    $order = $this->getOrder('ctime', $order);
        } else {
            $order = $this->getOrder('id', 'desc');
        }
        $where .= ' ' . $order . ' ' . $limit;
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $where);
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ȡֵ
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param int $type ȡ
     * @param int $source Դ
     * @return int
     */
    public function getCountBy($brokerId, $starttime, $endtime,
            $type, $source = null) {
        $where = '';
        $where .= "broker_id = $brokerId and type = $type and ctime >= '$starttime'"
                . " and ctime <= '$endtime'";
        //Դ 1 PC 2 APP
        if ($source != null && $source != '0') {
            $where .= ' and source = ' . $source;
        }
        $sql = SqlCombinHelper::count_sql($this->table, $where);
        return $this->dbback->getOne($sql);
    }
    
    /**
     * ȡֵ
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param int $type ȡ
     * @param int $source Դ
     * @return int
     */
    public function getSumBy($brokerId, $starttime, $endtime,
            $type, $source = null) {
        $where = '';
        $where .= "broker_id = $brokerId and type = $type and ctime >= '$starttime'"
                . " and ctime <= '$endtime'";
        //Դ 1 PC 2 APP
        if ($source != null && $source != '0') {
            $where .= ' and source = ' . $source;
        }
        $sql = SqlCombinHelper::sum_sql($this->table, 'num', $where);
		//echo $sql;
        return $this->dbback->getOne($sql);
    }
    
    /**
     * ݱid;˱Żȡһֵ¼
     * @param int $id 
     * @param int $brokerId ˱
     * @return array
     */
    public function getOneByIdAndBrokerId($id, $brokerId, $status) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, 
                "id = {$id} and broker_id = {$brokerId} and status = $status");
        return $this->dbback->getRow($sql);
    }

    public function getAllSuccessById($id) {
        $sql = SqlCombinHelper::select_sql($this->table_success, $this->fields, 
                "id > {$id} and status = 1 and invoice <> '' order by id asc limit 10");
        return $this->dbback->getAll($sql);
    }

	public function successJobInsert($data = array())
	{
        if(empty($data))
		{
			return '0';
		}

        $sql = SqlCombinHelper::insert_sql($this->table_success_job, $data);
        $this->db->execute($sql);
        return $this->db->Insert_ID();
    }
}
