<?php
/**
 * ˳ֵ¼
 * @author sun
 */
class PayRechargeRecord {
    
    /**
     * ݿ 
     * @var TINY_ADODB 
     */    
    private $db;
    
    /**
     * ݿ
     * @var type 
     */
    private $dbback;
    
    /**
     * 
     * @var type 
     */
    private $mc;

    /**
     * ı 
     * @var String 
     */
    private $table;

    private $credit;
    /**
     * 캯ʼdb memcache ȡ
     * @param string $table ʹĬֵ
     */
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = 'pay_housebean_recharge_record';
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * ѯ䷶Χ
     * @param int $start ʼֵ
     * @param int $limit ÿҳʾ
     * @return string
     */
    private function getLimitCond($start, $limit) {
        $start = $start > 0 ? $start : 0;
        $limit_cond = ($start == 0 && $limit == 0) ? '' : ' LIMIT '
                      . $start . ' , ' . $limit;
        return $limit_cond;
    }
    
    /**
     * ֶ֤ǷϷ
     * @param type $field
     * @return type
     */
    private function validateFiled($field) {
        return in_array($field, $this->fields);
    }
    
    /**
     * 
     * @param string $orderField ֶ
     * @param string $order 
     * @return string
     */
    private function getOrder($orderField, $order = 'ASC') {
        $strOrder = '';
        if ($this->validateFiled($orderField)) {
            $strOrder = "ORDER BY $orderField $order";
        }
        return $strOrder;
    }

    /**
     * þ˵ǰֵ顣
     * @return array  
     */
    public function getBrokerCredit($brokerId) {
        $credit = new GrowthCredit();
        return $credit->findByBrokerId($brokerId);
    }
    
    /**
     * ֵ¼
     * @param int $brokerId ˱
     * @param int type ȡ; Ϊֵ
     * @param string $orderId 
     * @param string $program ֵ
     * @param int $source Դ
     * @param int $num 
     * @param string $invoice Ʊ̧ͷ
     * @return int
     */
    public function insert($brokerId, $type, $orderId, $program, 
            $source, $num, $invoice) {
        $fieldsValue = array();
        $creditOne = $this->getBrokerCredit($brokerId);
        $fieldsValue['broker_id'] = $brokerId;
        $fieldsValue['type'] = 1;
        $fieldsValue['orderid'] = $orderId;
        $fieldsValue['program'] = $program;
        $fieldsValue['source'] = $source;
        $fieldsValue['num'] = $num;
        $fieldsValue['remain_num'] = $creditOne['credit'];
        $fieldsValue['invoice'] = $invoice;
        $fieldsValue['status'] = 0;
        $fieldsValue['ip'] = GetIp();
        $fieldsValue['discard'] = 0;
        $fieldsValue['ctime'] = date('Y-m-d H:i:s');
        $sql = SqlCombinHelper::insert_sql($this->table, $fieldsValue);
        $this->db->execute($sql);
        return $this->db->Insert_ID();
    }
    
    //֧״̬
    public function updateStatus() {
        
    }
    
    /**
     * ȡֵб
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param int $type ȡ
     * @param int $source Դ
     * @param int $start ʼ
     * @param int $pagesize ÿҳ
     * @param string $order 
     * @return array
     */
    public function getListBy($brokerId, $starttime, $endtime, $type, 
            $source = null, $start = null, $pagesize = null, $order = null) {
        $where = '';
        $where .= "broker_id = $brokerId and type = $type and ctime >= $starttime"
                . " and ctime <= $endtime";
        //Դ 1 PC 2 APP
        if ($source != null) {
            $where .= ' and source = ' . $source;
        }
        if($start !== null && $pagesize !== null) {
            $limit = $this->getLimitCond($start, $pagesize);
        } else {
            $limit = '';
        }
		if($order !== null){
		    $order = $this->getOrder('ctime', $order);
        } else {
            $order = '';
        }
        $where .= $limit . ' ' . $order;
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $where);
        return $this->dbback->getAll($sql);
    }
    /**
     * ȡֵ
     * @param int $brokerId ˱
     * @param date $starttime ʼʱ
     * @param date $endtime ʱ
     * @param int $type ȡ
     * @param int $source Դ
     * @return int
     */
    public function getCountBy($brokerId, $starttime, $endtime,
            $type, $source = null) {
        $where = '';
        $where .= "broker_id = $brokerId and type = $type and ctime >= $starttime"
                . " and ctime <= $endtime";
        //Դ 1 PC 2 APP
        if ($source != null) {
            $where .= ' and source = ' . $source;
        }
        $sql = SqlCombinHelper::count_sql($this->table, $where);
        return $this->dbback->getOne($sql);
    }
    
}
