<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ۱ϵͳ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright       Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * Rent_demand_model CLASS
 *
 * ࣬ṩ⹺Ϣķ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          sun     
 */
class payment_model  extends MY_Model {
    
    //ֵ
    public $way_alias = 'recharge';
    
    //
    public $module_controll = 'payment';
    
    //ֵ
    public $gate_port = array(
        'zggsyh' => array('image_url' => 'zggsyh.png', 'port' => '0005','newPort' => '700000000000003', 'name' => 'й'),
        'zgjsyh' => array('image_url' => 'zgjsyh.png', 'port' => '1010','newPort' => '700000000000004', 'name' => 'й'),
        'zsyh' => array('image_url' => 'zsyh.png',  'port' => '4007','newPort' => '700000000000010', 'value' => 'zsyh', 'name' => ''),
                /**'zgyzcxyh' => array('image_url' => 'zgyzcxyh.png', 'port' => '0028', 'value' => 'zsyh', 'name' => 'й'),***/
        'zgyh' => array('image_url' => 'zgyh.png', 'port' => '1023','newPort' => '700000000000001', 'value' => 'zgyh', 'name' => 'й'),
        'zgnyyh' => array('image_url' => 'zgnyyh.png', 'port' => '4008','newPort' => '700000000000002', 'value' => 'zgnyyh', 'name' => 'йũҵ'),
        'jtyh' => array('image_url' => 'jtyh.png', 'port' => '0025','newPort' => '700000000000006', 'value' => 'jtyh', 'name' => 'ͨ'),
        'zgmsyh' => array('image_url' => 'zgmsyh.png', 'port' => '0015','newPort' => '700000000000008', 'value' => 'zgmsyh', 'name' => 'й'),
        'zxyh' => array('image_url' => 'zxyh.png', 'port' => '0004','newPort' => '700000000000013', 'value' => 'zxyh', 'name' => ''),
        'xyyh' => array('image_url' => 'xyyh.png', 'port' => '0009','newPort' => '700000000000009', 'value' => 'xyyh', 'name' => 'ҵ'),
        'zggdyh' => array('image_url' => 'zggdyh.png', 'port' => '0027','newPort' => '700000000000005', 'value' => 'zggdyh', 'name' => 'й'),
        'pfyh' => array('image_url' => 'pfyh.png', 'port' => '1022','newPort' => '700000000000007', 'value' => 'pfyh', 'name' => 'ַ'),
        'alipay' => array('name' => '֧', 'display' => 0),
        'wxpay' => array('name' => '΢', 'display' => 0),
    );
    
    //׼¼TAB
    public $transaction_tab = array(
        'detail' => array('name' => 'ϸ', 'module' => 'transaction_detail'), 
        'expend' => array('name' => 'ļ¼', 'module' => 'transaction_expend'), 
        'get' => array('name' => 'ȡ¼', 'module' => 'transaction_get'),
        'recharge' => array('name' => 'ֵ¼', 'module' => 'recharge_record')
    );
    
    //б־ɵһά
    private function format_gate_key()
    {
        return array_keys($this->gate_port);
    }
    
    /**
     * ʼ
     */
    public function __construct() 
    {   
        parent::__construct();
    }
    
    //ȡ
    public function get_recharge_active()
    {
        $paymentRechargeActive = new PaymentRechargeActive();
        return $paymentRechargeActive->getAll();
    }
    
    /**
     * ȡʹ֧
     * @param string $bank_name 
     * @return string ֧ӿ
     */
    public function get_pay_api($bank_name)
    {
        $gate_key = $this->format_gate_key();
        $pay_api = '';
        if ( in_array( $bank_name,array('wxpay','alipay') ) )
        {
            $pay_api = $bank_name;
        }
        else
        {
            $pay_api = 'chinapay';
        }
        return $pay_api;
    }
    
    /**
     * 
     * @param string $bank_name 
     * @return boolean
     */
    public function check_pay_way($bank_name)
    {
        $gate_key = $this->format_gate_key();
        return in_array($bank_name, $gate_key) ?  true : false;
    }
    
    /**
     * ѡǮ
     * @param array $price Ǯײ
     * @param int $type 
     * @return boolean
     */
    public function check_price($price, $type)
    {
        $price_key = array_keys($price);
        return in_array($type, $price_key) ?  true : false;
    }
    
    /**
     * ȡ󷵻صĽַ
     * @param string $str
     * @return string
     */
    public function get_check_result_str($str) 
    {
        return '<script type="text/javascript">alert("' . $str 
                . '");window.close();</script>';
    }
    
    /**
     * жǷμӻ
     * @param date $active_time μӵʱ
     * @return boolean true μӣ false μ
     */
    public function is_active($active_time) 
    {
        return strtotime($active_time) >= time() ? true : false;
    }
    
    /**
     * ȡ˵ĵȼͷֵ
     * @param array $broker 
     * @return array
     */
    public function get_broker_base($broker) {
        $broker_base = array('id' => $broker['uid'], 
            'groupid' => $broker['groupid']
        );
        $gbe = new GrowthBrokerExp($broker_base);
        $gbc = new GrowthBrokerCredit($broker_base);
        return array('credit' => $gbc->getValidCredit(), 
            'level' => $gbe->getLevel(2));
    }
    
    /**
     * ȡ֧ĸģurlַ
     * @param string ģ鹦
     */
    public function get_module_url($module = null)
    {
        $url = '/' . $this->module_controll . '/';
        switch ($module)
        {
            case 'recharge': //ֵҳ
                $url .= $module . '/';
                break;
            case 'recharge_record': //ֵ¼
                $url .= 'transaction/recharge/';
                break;
            case 'transaction_detail': //ϸ
                $url .= 'transaction/';
                break;
            case 'transaction_expend': //
                $url .= 'transaction/expend/';
                break;
            case 'transaction_get': //ȡ
                $url .= 'transaction/get/';
                break;
            case 'agreement': //֧Э
                $url .= 'agreement/';
                break;
            default: 
        }
        return $url;
    }
   
    //ȡTAB
    public function get_transaction_tab()
    {
		$functionSwitch = $this->config->item('functionSwitch');
        $transaction_tab = $this->transaction_tab;

        foreach($transaction_tab as $k => $v)
        {
			if($k == 'recharge' && empty($functionSwitch['payment']))
			{
				unset($transaction_tab[$k]);
				continue;
			}

            $transaction_tab[$k]['url'] = $this->get_module_url($v['module']);
        }
        return $transaction_tab;
    }
}
