<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Loupan_model extends MY_Model {

    private $tbl = 'new_block';
    /**
     * key
     * @var string
     */
    private $_mem_key ;

    //캯
    public function __construct()
    {
        parent::__construct(1, 1, 1);

        $this->_mem_key = GB_CITY.'_new_block';
    }

    /**ȡСϢ
     * @param $district
     * @return mixed
     */
    public function getBlockInfoByDistrict($district)
    {

        $mem_key = $this->_mem_key.'_district2'.$district;
        $this->mc->delete($mem_key);
        $cache = $this->mc->get($mem_key);
        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $result = $cache['data'];

        }
        else {
            $this->dbback->select("id,blockname,claim_uid,claim_status");
            $this->dbback->where("district = '$district' and lock_build_contribution='0'");
            $result = $this->dbback->get('new_block')->result_array();
            foreach ($result as $key =>$rs)
            {
                $id             =$rs['id'];
                $claim_status   =$rs['claim_status'];
                if($claim_status==2)
                {
                    //$this->update_new_block_status($id,$claim_status);
                }
                $num=0;
                //$num =$this->get_no_check_build_num($id);
                $result[$key]['num'] =$num;

            }
            $this->mc->add( $mem_key , array('is_ok'=>1 , 'data'=>$result) , 60);

        }

        return $result;

    }

    private function get_no_check_build_num($id)
    {
        $this->dbback->select("id");
        $this->dbback->where("new_block_id = $id and status = 0");
        $build_arr = $this->dbback->get('new_block_building_check_manage')->result_array();
        return count($build_arr);
    }

    /**ͨ¥Ƿ¥һ
     * @param $id
     * @param $status
     */

    private function update_new_block_status($id,$claim_status)
    {
        $this->dbback->select("buildid");
        $this->dbback->where("projectid = '$id' and is_delete = 0");
        $build_arr = $this->dbback->get('block_build')->result_array();

        if(!empty($build_arr))
        {
            $build_str ='';
            foreach ($build_arr as $key =>$rs)
            {
                $buildid    =$rs['buildid'];
                $build_str  .=$buildid.',';
            }
            $build_str =rtrim($build_str,',');


            $this->dbback->select("claim_uid");
            $this->dbback->where("id = '$id'");

            $manage_arr = $this->dbback->get('new_block')->result_array();
            $claim_uid  =$manage_arr[0]['claim_uid'];


            $this->dbback->select("id");
            $this->dbback->where("buildid in ($build_str) and uid=$claim_uid and status =1");
            $manage_arr = $this->dbback->get('new_block_building_check_manage')->result_array();

            $manage_num = count($manage_arr);

            if($manage_num !=count($build_arr))
            {
                $this->db->where('id',$id);
                $data['claim_uid']    =0;
                $data['claim_status'] =0;
                $this->db->update('new_block',$data);
            }

        }


    }

    /**ȡ¥Ϣ
     * @param $id
     * @return mixed
     */
    public function getBlockInfoById($id)
    {
        $this->dbback->select("blockname,contribution_open_time,contribution_end_time,contribution_days,claim_uid,lock_build_contribution");
        $this->dbback->where("id = '$id'");
        $result = $this->dbback->get('new_block')->result_array();
        return $result;

    }

    /**¥Ϣ
     * @param $data
     */

    public function setBlockClaimById($data)
    {
        $this->db->where('id',$data['id']);
        $this->db->update('new_block',$data);

    }

    /**־
     * @param $insert_data
     */
    public function addBlockUid($insert_data)
    {

        $this->insert('new_block_uid_log', $insert_data);
    }

    public function insert($tbl, $insert_data)
    {

        if ($this->db->insert($tbl, $insert_data))
        {

            return $this->db->insert_id();
        }
    }


    /**ǷС
     * @param $uid
     * @return mixed
     */

    public function getBlockInfoByUid($uid)
    {
        $this->dbback->select("id,blockname,contribution_open_time,contribution_end_time,contribution_days");
        $this->dbback->where("claim_uid = '$uid' and claim_status=1");
        $result = $this->dbback->get('new_block')->result_array();
        return $result;

    }

    /**ȡ¥Ϣ
     * @param $blockid
     * @return array
     */

    public function getBuildingByBlockId($blockid,$uid)
    {
        //  $sql = "select buildid,buildname from block_build where projectid = ".$blockid." and is_delete = 0 group by buildname ORDER BY buildid asc";

        $this->dbback->select("buildid,buildname");
        $this->dbback->where("projectid = '$blockid' and is_delete = 0 group by buildname ORDER BY buildid asc");
        $result = $this->dbback->get('block_build')->result_array();

        foreach ($result as $key =>$rs)
        {

            $buildid        =   $rs['buildid'];
            $time           =time();
            $this->dbback->select("*");
            $this->dbback->where("buildid = '$buildid'   ORDER BY id desc");
            $val = $this->dbback->get('new_block_building_check_manage')->result_array();
            if(empty($val))
            {
                $result[$key]['status'] =99;
            }
            else
            {
                $result[$key]['status'] =$val[0]['status'];
            }
            $result[$key]['uid'] =$val[0]['uid'];
        }
        return $result;

    }

    /**ȡ¥
     * @param $buildid
     * @return mixed
     */
    public function getbuildname($buildid)
    {
        $this->dbback->select("buildid,buildname");
        $this->dbback->where("buildid = '$buildid'");
        $result = $this->dbback->get('block_build')->result_array();
        return $result[0]['buildname'];
    }

    /**ȡϢ
     * @param $uid
     * @return mixed
     */

    public function getbrokerinfo($uid)
    {
        $this->dbback->select("username,truename,telno");
        $this->dbback->where("uid = '$uid'");
        $result = $this->dbback->get('broker')->result_array();
        return $result;
    }


    /**
     * 뾭ύ¥ͼƬ
     * @param $val
     * @param $buildid
     * @param $uid
     */
    function insert_building_images($val,$buildid,$uid,$build_manage_id)
    {
        $data               =array();
        $data['uid']        =$uid;
        $brokerInfo         =$this->getbrokerinfo($uid);
        $data['username']   =$username    =$brokerInfo[0]['username'];
        $data['truename']   =$truename    =$brokerInfo[0]['truename'];
        $data['telno']      =$telno       =$brokerInfo[0]['telno'];

        $data['buildid']    =$buildid;
        $buildinginfo       =$this->getProjectInfo($buildid);

        $projectid          =$buildinginfo[0]['projectid'];
        $building_num       =$buildinginfo[0]['buildname'];
        $data['building_num']=$building_num;
        $data['new_block_id']=$projectid;

        $new_block_id        =$projectid;
        $new_block_info     =$this->getBlockInfoById($projectid);
        $data['blockname']  =$blockname     =$new_block_info['0']['blockname'];
        $data['date_add']   =$date_add      =time();
        $data['building_img_type']   =$building_img_type  =$this->match_info($val);
        $data['img ']       =$img    =$this->get_image_url($val);
        $data['build_manage_id']      =$build_manage_id;
        $this->insert('new_block_image_check_manage', $data);


    }

    /**ȡ¥Ϣ
     * @param $buildid
     * @return mixed
     */
    private function getProjectInfo($buildid)
    {
        $this->dbback->select("projectid,buildname");
        $this->dbback->where("buildid = '$buildid'");
        $result = $this->dbback->get('block_build')->result_array();
        return $result;


    }
    private function match_val($val)
    {
        //echo $val;
        if(preg_match('/hao*/',$val))
        {

            $str =explode('=',$val);

            $str =urldecode($str[1]);
            return $str;
        }elseif (preg_match('/new_block_id*/',$val))
        {
            $str =explode('=',$val);
            $str =urldecode($str[1]);
            return $str;
        }



    }

    /**ȡͼƬ
     * @param $val
     * @return int
     */
    private function match_info($val)
    {
        //echo $val;
        if(preg_match('/zhengmian*/',$val))
        {
            return 1;
        }elseif (preg_match('/cemian*/',$val))
        {
            return 2;
        }elseif (preg_match('/zhoubian*/',$val))
        {
            return 3;
        }elseif (preg_match('/hao*/',$val))
        {
            return 4;
        }



    }

    /**ȡͼƬַ
     * @param $val
     * @return mixed
     */
    private function get_image_url($val)
    {
        $data   =explode('=',$val);
        return $data[1];
    }

    /**¥¼
     * @param $buildid
     * @param $uid
     */
    public function insert_building_check_manage($buildid,$uid,$is_new)
    {
        $data               =array();
        $data['uid']        =$uid;
        $brokerInfo         =$this->getbrokerinfo($uid);
        $data['username']   =$username    =$brokerInfo[0]['username'];
        $data['truename']   =$truename    =$brokerInfo[0]['truename'];
        $data['telno']      =$telno       =$brokerInfo[0]['telno'];

        $data['buildid']    =$buildid;
        $buildinginfo       =$this->getProjectInfo($buildid);

        $projectid          =$buildinginfo[0]['projectid'];
        $building_num       =$buildinginfo[0]['buildname'];
        $data['building_num']=$building_num;
        $data['new_block_id']=$projectid;

        $new_block_id        =$projectid;
        $new_block_info     =$this->getBlockInfoById($projectid);
        $data['blockname']  =$blockname     =$new_block_info['0']['blockname'];
        $data['date_add']   =$date_add      =time();
        $data['is_new']      =$is_new;

        $this->db->insert('new_block_building_check_manage', $data);
        return $this->db->insert_id();



    }

    /**
     * @param $buildid
     * @param $uid
     */
    public function update_new_block_uid_log($new_block_id,$uid)
    {
        $this->db->where("new_block_id =$new_block_id AND uid=$uid order by id desc limit 1");
        $arr['status']    =2;
        $this->db->update('new_block_uid_log',$arr);
    }


    /**
     * @param $data_val
     * @param $new_block_id
     * @param $error_str
     */
    public function addErrorRead($data_val,$error_str,$uid)
    {
        $img =array();
        $img0 =$img1 ='';
        foreach ($data_val as $key =>$rs)
        {
            if(preg_match('/hao*/',$rs))
            {
                $str =explode('=',$rs);
                $img[$key] =urldecode($str[1]);
            }elseif (preg_match('/new_block_id*/',$rs))
            {
                $str =explode('=',$rs);
                $new_block_id =$str[1];
            }

        }

        $img0 =$img[1];
        if(!empty($img[1]))
        {
            $img1 =$img[2];
        }

        $data                   =array();
        $data['uid']            =$uid;
        $brokerInfo             =$this->getbrokerinfo($uid);
        $data['username']       =$username    =$brokerInfo[0]['username'];
        $data['truename']       =$truename    =$brokerInfo[0]['truename'];
        $data['telno']          =$telno       =$brokerInfo[0]['telno'];

        $new_block_info         =$this->getBlockInfoById($new_block_id);
        $bulidname              =$new_block_info[0]['blockname'];
        $data['bulidname']      =$bulidname;
        $data['new_block_id']   =$new_block_id;

        $data['img0']   =$img0;
        if($img1) {
            $data['img1'] = $img1;
        }
        $data['desc']   =iconv('utf-8','gbk',$error_str);

        $data['date_add']   =$date_add      =time();

        $this->db->insert('new_block_report_error', $data);
        //echo $this->db->insert_id();die;
        return $this->db->insert_id();
    }


    /*
     * 10ֲ ظύ
     */
    public function check_add_error($uid)
    {
        //error_reporting(E_ALL);
        //ini_set('display_errors', TRUE);
        //ini_set('display_startup_errors', TRUE);
        $time  =time()-30;
       // $this->db->select("*");

        //$this->db->where("uid=$uid");
        $sql ="select * from new_block_report_error where uid=$uid and  date_add>=$time";
        $query	=	$this->db->query($sql) or die(mysqli_error());

        $re =$query->result_array();

        if(!empty($re))
        {

            exit('ظύ');
        }

    }

    /*
     * 10ֲ ظύ
     */
    public function check_building_check_manage($buildid,$uid)
    {
        $time  =time()-30;
        $this->dbback->select("*");

        $this->dbback->where("buildid = '$buildid' and uid=$uid and date_add>=$time");
        $result = $this->dbback->get('new_block_building_check_manage')->result_array();
        if(!empty($result))
        {
            exit('ظύ');
        }

    }

    /**ȡ¥Ϣ
     * @param $uid
     */
    public function getMyErrorReport($uid,$offset,$limit){

        $status  = array('0'=>'','1'=>'ͨ','2'=>'δͨ');
        $this->dbback->select("bulidname,type,building_num,date_add,status,desc,remark");
        $this->dbback->where("uid = '$uid'");
        $this->dbback->order_by('date_add','DESC');
        $this->dbback->limit($limit,$offset);
        $result = $this->dbback->get('new_block_report_error')->result_array();

//        echo $this->dbback->last_query();die;
        $result_new =array();
        if($result){
            for($i=0;$i<count($result);$i++){
                $result_new[$i]['blockname']    = $result[$i]['bulidname'];
                $result_new[$i]['type']    = 'Ϣ';
                $result_new[$i]['building_num']    = $result[$i]['desc'];
                $result_new[$i]['date_add']= date('Y-m-d H:i:s',$result[$i]['date_add']);
                $result_new[$i]['status']  = $status[$result[$i]['status']];

                if(!$result[$i]['remark']){
                    $result_new[$i]['remark']= '-';
                }else
                {
                    $result_new[$i]['remark']  = $result[$i]['remark'];
                }
                unset($result[$i]['desc']);
                unset($result[$i]['bulidname']);
            }
        }


        return $result_new;
    }

    /**ȡ¥Ϣ
 * @param $uid
 */
    public function getMyContribution($uid,$offset,$limit){
        $type    = array('0'=>'¥ͼƬ','1'=>'¥');
        $status  = array('0'=>'','1'=>'ͨ','2'=>'δͨ');
        $this->dbback->select("blockname,is_new,building_num,date_add,status,remark");
        $this->dbback->where("uid = '$uid'");
        $this->dbback->order_by('date_add','DESC');
        $this->dbback->limit($limit,$offset);
        $result = $this->dbback->get('new_block_building_check_manage')->result_array();
//        echo $this->dbback->last_query();die;
        $result_new =array();
        if($result){
            for($i=0;$i<count($result);$i++){
                $result_new[$i]['blockname']    = $result[$i]['blockname'];
                $result_new[$i]['type']         = $type[$result[$i]['is_new']];
                $result_new[$i]['building_num']         = $result[$i]['building_num'];
                $result_new[$i]['status']           = $status[$result[$i]['status']];
                $result_new[$i]['date_add']= date('Y-m-d H:i:s',$result[$i]['date_add']);
                if(!$result[$i]['remark']){
                    $result_new[$i]['remark']= '-';
                }else
                {
                    $result_new[$i]['remark']    = $result[$i]['remark'];
                }
                unset($result[$i]['is_new']);
            }
        }
        //print_r($result_new);die;
        return $result_new;
    }
    /**ȡ¥Ϣ
     * @param $uid
     */
    public function getMyExplain($uid,$offset,$limit){
//        $type    = array('0'=>'¥ͼƬ','1'=>'Ϣ');
        $status  = array('0'=>'δͨ','1'=>'ύ','2'=>'','3'=>'δͨ','4'=>'ͨ','5'=>'չʾ');

        $this->dbback->select("new_block_id,blockname,explain_time,explain_type");
        $this->dbback->where("uid = '$uid'");
        $this->dbback->order_by('explain_time','DESC');
        $this->dbback->limit($limit,$offset);
        $result = $this->dbback->get('new_block_offer_manage')->result_array();
//        echo $this->dbback->last_query();die;
        $explain_result = array();
        if($result){
            for($i=0;$i<count($result);$i++){
                $new_block_id = $result[$i]['new_block_id'];
                $this->dbback->select("reason_desc");
                $this->dbback->where("uid = '$uid' and new_block_id='$new_block_id'");
                $this->dbback->order_by('create_time','DESC');
                $this->dbback->limit('1');
                $explain_result[$i]['blockname']  = $result[$i]['blockname'];
                $explain_result[$i]['type']       = 'ά';
                $explain_result[$i]['building_num']  = '-';
                if(!$result[$i]['explain_time']){
                    $explain_result[$i]['date_add']= '-';
                }else{
                    $explain_result[$i]['date_add']= date('Y-m-d H:i:s',$result[$i]['explain_time']);
                }
                $explain_result[$i]['status']  = $status[$result[$i]['explain_type']];
                $reason_result = $this->dbback->get('new_block_offer_audit')->result_array();
                if($reason_result[0]['reason_desc']){
                    $explain_result[$i]['remark']  = $reason_result[0]['reason_desc'];
                }else{
                    $explain_result[$i]['remark']  = '-';
                }
//                print_r($reason_result);die;
            }
        }
        return $explain_result;
    }
    /**ȡ¥Ϣ
     * @param $uid
     */
    public function getMyContributionTotal($uid){
        $this->dbback->select("*");
        $this->dbback->where("uid = '$uid'");
        $result = $this->dbback->get('new_block_building_check_manage')->result_array();
        if($result){
            $result_count = count($result);
        }else{
            $result_count = 0;
        }
        return $result_count;
    }


    /**ȡ¥άϢ
     * @param $uid
     */
    public function getMyExplainTotal($uid){
        $this->dbback->select("*");
        $this->dbback->where("uid = '$uid'");
        $result = $this->dbback->get('new_block_offer_manage')->result_array();
        if($result){
            $result_count = count($result);
        }else{
            $result_count = 0;
        }
        return $result_count;
    }

    /**ȡ¥άϢ
     * @param $uid
     */
    public function getErrorReportTotal($uid){
        $this->dbback->select("*");
        $this->dbback->where("uid = '$uid'");
        $result = $this->dbback->get('new_block_report_error')->result_array();
        if($result){
            $result_count = count($result);
        }else{
            $result_count = 0;
        }
        return $result_count;
    }


    function read_loupan($uid)
    {

        $this->dbback->select("explain_switch");
        $this->dbback->where("uid = '$uid'  AND explain_switch=1 AND is_open_zsb=0");
        $result = $this->dbback->get('new_block_offer_manage')->result_array();

        if(empty($result))
        {
            $explain_switch =0;
        }else
        {
            $explain_switch =$result[0]['explain_switch'];
        }
        return $explain_switch;

    }

    function read_loupan_block_id($new_block_id)
    {

        $this->dbback->select("explain_switch");
        $this->dbback->where("new_block_id = '$new_block_id' AND explain_switch=1 AND is_open_zsb=0");
        $result = $this->dbback->get('new_block_offer_manage')->result_array();

        if(empty($result))
        {
            $explain_switch =0;
        }else
        {
            $explain_switch =$result[0]['explain_switch'];
        }
        return $explain_switch;

    }

    /**
     * @param $new_block_id
     *
     */
    private function getReadInfo($new_block_id)
    {
        $this->dbback->select("*");
        $this->dbback->where("block_id = '$new_block_id'");
        $result = $this->dbback->get('new_block_read')->result_array();
        if(empty($result))
        {
            $num =0;
        }else
        {
            $num =1;
        }
        return $num;
    }

    public function setReadLoupan($data,$new_block_id)
    {

        $num =$this->getReadInfo($new_block_id);
        if($num)
        {
            $this->db->where('block_id',$new_block_id);
            $this->db->update('new_block_edit',$data);
        }
        else{
            $data['block_id']           =$new_block_id;
            $this->db->insert('new_block_edit',$data);
        }

        $this->db->where("new_block_id =$new_block_id AND explain_switch=1 AND is_open_zsb=0");
        $arr['is_open_zsb']    =1;
        $arr['explain_type']   =2;
        $this->db->update('new_block_offer_manage',$arr);

    }

    /**ȡСΪ$buildnameǷ
     * ڷ1ڷ0
     * @param $new_block_id
     * @param $buildname
     * @return int
     */
    function get_block_build_name_info($new_block_id,$buildname)
    {
        $this->dbback->select("*");

        $this->dbback->where("projectid = '$new_block_id' and buildname='$buildname'");

        $result = $this->dbback->get('block_build')->result_array();

        if(!empty($result))
        {
            return 1;
        }
        else
        {
            $data                           =array();
            $data['projectid']              =$new_block_id;
            $data['buildname']              =$buildname;
            $data['updatetime']             =time();
            $data['export_time']            =time();
            $data['is_zsb_add']             =1;
            $this->db->insert('block_build',$data);
            return $this->db->insert_id();

        }

    }




    function getReadInfoUid($uid)
    {

        $this->dbback->select("*");
        $this->dbback->where("uid = '$uid' and explain_switch=1");
        $result = $this->dbback->get('new_block_offer_manage')->result_array();
        return $result;

    }

    function get_template_info($new_block_id)
    {
        $this->dbback->select("*");
        $this->dbback->where("block_id = '$new_block_id' ");
        $result = $this->dbback->get('new_block_read')->result_array();
        return $result;
    }

    /**Сδϴκ¥ͼƬ£չʾȡ족ť
     * @param $blockid
     * @param $uid
     * @return mixed
     */
    function cancal_button_info($blockid,$uid)
    {

        $result =0;
        $this->dbback->select("*");
        $this->dbback->where("uid = '$uid' and new_block_id=$blockid");
        $arr = $this->dbback->get('new_block_image_check_manage')->result_array();

        $this->dbback->select("*");
        $this->dbback->where("uid = '$uid' and new_block_id=$blockid");
        $arr_new = $this->dbback->get('new_block_report_error')->result_array();



        if(!empty($arr))
        {
            $result=1;
        }elseif($arr_new)
        {
            $result =1;
        }


        return $result;
    }


    function get_new_block_uid_log($uid,$new_block_id)
    {
        $this->dbback->select("*");
        $this->dbback->where("uid = '$uid' and new_block_id=$new_block_id  and status =1" );
        $info    = $this->dbback->get('new_block_uid_log')->result_array();

        if($info)
        {
            $id =$info[0]['id'] ;
            $val_new =array();
            $val_new['status']=0;

            $this->db->where("id =$id and status=0 limit 1");
            $this->db->update('new_block_uid_log',$val_new);
        }

        return $info;
    }


    function add_cancal_log($blockid,$uid)
    {
        $arr                        =array();

        $start_time                 =strtotime(date('Y-m-d 0:0:0'));
        $end_time                   =strtotime(date('Y-m-d 23:59:59'));

        $this->dbback->select("*");
        $this->dbback->where("uid = '$uid' and ctime>=$start_time and ctime <=$end_time and status =1" );
        $info    = $this->dbback->get('new_block_cancal_log')->result_array();

        if(!empty($info)) {
            $arr['status'] = 1;
            $arr['msg'] = iconv('gbk','utf-8','ǰ޷ȡ죬!');

        }
        else
        {

           $data = array();

           $data['uid'] = $uid;

           $brokerInfo                 =$this->getbrokerinfo($uid);
           $data['username']           =$brokerInfo[0]['username'];
           $data['truename']           =$brokerInfo[0]['truename'];
           $data['telno']              =$brokerInfo[0]['telno'];

           $data['new_block_id']       =$blockid;
           $new_block_info             =$this->getBlockInfoById($blockid);
           $data['blockname']          =$new_block_info['0']['blockname'];

           $data['ctime']              =time();
           $data['status'] = 1;
           $new_block_info             =$this->getBlockInfoById($blockid);
           $data['etime']  =$new_block_info['0']['contribution_end_time'];


           $this->db->insert('new_block_cancal_log', $data);




            $this->dbback->select("*");
            $this->dbback->where("uid = '$uid'  and status =0 order by id desc" );
            $info_new    = $this->dbback->get('new_block_uid_log')->result_array();

            $val_new =array();
            $val_new['status']=1;

            $this->db->where('id',$info_new[0]['id']);
            $this->db->update('new_block_uid_log',$val_new);

            $val =array();
            $val['claim_uid']   =0;
            $val['claim_status']=0;
            $this->db->where('id',$blockid);
            $this->db->update('new_block',$val);


            $arr['status'] = 1;
            $arr['msg'] = iconv('gbk','utf-8','ȡС״̬ɹ!');


        }

        return json_encode($arr);


        // $arr['status']  =$status;





    }




}