<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Sell Class
 *
 * ۱ַģ
 *
 * @package     zsb
 * @subpackage      Controllers
 * @category        Controllers
 * @author      liuhu
 */
class Sell_zhou extends MY_Controller {
    
    /**
    * в
    *
    * @access private
    * @var string
    */
    protected  $_city = 'nj';
    
    /**
     * Դģģ
     * @var type 
     */
    private $_house_template_module = 'sell';

    /**
    * ǰûuid
    *
    * @access private
    * @var int
    */
    private  $_uid = 0;

    /**
    * ǰҳ
    *
    * @access private
    * @var string
    */
    private $_current_page = 1;

    /**
    * ÿҳĿ
    *
    * @access private
    * @var int
    */
    private $_limit = 20;

    /**
    * ƫ
    *
    * @access private
    * @var int
    */
    private $_offset = 0;

    /**
    * Ŀ
    *
    * @access private
    * @var int
    */
    private $_total_count = 0;
    
    
    /**
    * 
    *
    * @access public
    * @return void
    */
    public function __construct()
    {     
        parent::__construct();

        //طԴģ
        $this->load->model('sell_model');
        $this->load->helper('common_house_helper');
		
		
        //ɷۺͳȨ @todo
        $is_permission = $this->sell_model->get_public_permission($this->user_arr['package_id']);
		
        if ($is_permission === false) 
        {
            $this->jump(GB_WO_URL);
            exit;
        }
    }

    
    /**
    * ʼҳ
    *
    * @access public
    * @param  int  $current_page
    * @param  int  $page_size
    * @return void
    */
    private function _init_pagination($current_page = 1 , $page_size = 0)
    {
        /** ǰҳ */
        $this->_current_page = ( $current_page && is_numeric( $current_page ) ) ?
                intval( $current_page ) : 1;

        /** ÿҳ */
        $this->_limit = ( $page_size && is_numeric( $page_size ) ) ?
                intval( $page_size ) : $this->_limit;

        /** ƫ */
        $this->_offset = ( $this->_current_page - 1 ) * $this->_limit;

        if($this->_offset < 0)
        {
            redirect(base_url());
        }
    }

    /**
     * ȾԴϢ
     * @param type $data_page
     */
    private function render_publish($data_page = array())
    {
        //ͷ
        $data_page['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/autocomlete.css');
        
        //ҳҪ
        $data_page['page_js'] = load_js('common/js/swf/swfupload.js,'
                . 'zsb/js/v1.0/uploadpic.js,common/js/jquery.validate.min.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.core.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.position.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.widget.js,'
                . 'common/js/jquery_ui_autocomplete/ui/jquery.ui.autocomplete.js,'
                . 'common/js/jquery.ui.mouse.min.js,'
                . 'common/js/jquery.ui.sortable.min.js,zsb/js/v1.0/house_zhou.js');
        $data_page['house'] = $this->config->item('house');
        $data_page['upload_pic_url'] = $this->config->item('base_url') . 'pic/house/';

		// 2016-1-15 Ǽ -----------start -------->
		$uid = $this->user_arr['uid'];
		$this->load->model('broker_zhou_model');
		
		$data_page['house']['broker_new_info'] =$this->broker_zhou_model->get_broker_info_by_uid($uid);
		//print_r($data_page);die;
		// 2016-1-15 Ǽ -----------end -------->
        
        $this->view('house_manage', 'sell_modify_zhou', $data_page);
    }
    
    /**
     * Ĭҳ
     */
    public function index()
    {
        $this->manage();
    }
    
    /**
     * Դҳ
     */
    public function add() 
    { 
        $uid = $this->user_arr['uid'];
        $package_id = $this->user_arr['package_id'];
        $tbl = $this->sell_model->get_tbl();
        //ɷۺͳȨ ӵ__construct
        //жϿǷ Դбҳַת
        $url_manage = $this->sell_model->find_func_url();
        $this->load->model('broker_model');
        $this->load->model('package_model');
        $package = $this->package_model->find_by_id($package_id);
        //жϿײͿ
        $stock_house_num = $this->broker_model->stock_house_num();
        if ($stock_house_num >= $package["package_stock_num"])
        {
            $this->jump($url_manage, "Բ,ѳʺŷԴ("
                    . "{$package['package_stock_num']},$stock_house_num) 
                        뵽ķԴɾڷԴ!");
            return;
        }
        $data_page = array();
        //ȡԴģϢ
        $template_module = $this->_house_template_module;
        $this->load->model('house_template_model');
        //Դģ
        $data_page['template_num'] = $this->house_template_model->
                find_count_by_module($template_module, $uid);
        //ģ > 0 תбתҳ
        if ($data_page['template_num'] > 0)
        {
            //ɱģ
            $data_page['remain_num'] = $this->house_template_model->template_num 
                    - $data_page['template_num'];
            //ģб
            $data_page['template_list'] = $this->house_template_model->
                    find_by_module($template_module, $uid);
            $data_page['url_template_manage'] = $this->house_template_model->
                    find_func_url('manage') . $template_module . '/';
        }
        else
        {
           $data_page['url_template_manage'] = $this->house_template_model->
                    find_func_url('add') . $template_module . '/';
        }
        $data_page['url_template_add'] = $this->house_template_model->
                 find_func_url('add') . $template_module . '/';
        //ȡԴʷСϢ
        $this->sell_model->set_select_fields(array('blockid', 'blockshowname'));
        $data_page['publish_block'] = $this->sell_model->find_publish_block($uid);
        //Դɫ
        $this->load->model('house_feature');
        $data_page['feature_arr'] = $this->house_feature->find_feature($tbl, 1);

        $data_page['feature'] = $this->house_feature->find_house_feature('', $tbl);
        //ͼͨԴӳɳֵķֵ
        $gcep = new GrowthExpWayPackage();
        $starScore = $gcep->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);
        $noStarScore = $gcep->findScoreByWayAliasAndPackageId('pNoStarHouse', $package_id);
        $data_page['star_score'] = $starScore;
        $data_page['no_star_score'] = $noStarScore;
        //ķԴ
        $data_page['allow_publish_infotype'] = $this->sell_model->
                get_public_infotype_permission($package_id);
        //췢öٳɳֵ
        $growthExpDayCount = new GrowthExpDayCount();
        $publishEventArray = array('pQualityHouse','pStarHouse','pNoStarHouse');
        $exp_rank_day = $growthExpDayCount->getExpAndRank($uid, $publishEventArray);
        $data_page['growthDaySum'] = $exp_rank_day['exp'];
        //ǰõΰٷֱ
        $data_page['rankRate'] = $exp_rank_day['rate'];
        //ĵ
        $data_page['documentation'] = $this->config->item('documentation');
        //ҳ
        $data_page['method'] = 'add';
        $data_page['url_house_submit'] = $this->sell_model->find_func_url('insert');
		$data_page['url_house_submit'] ="/sell_zhou/insert/";
        //ͳƴ
        $data_page['page_title'] = 'Դ-';
		$data_page['google_analytics'] = get_ga_js_code('/Դ//');
        //ģ
        $this->render_publish($data_page);
    }
    
    /**
     * 뷿Դ model
     */
    public function insert() 
    {       
        //һȡUID
		$this->load->model('broker_model');
		$session_info = $this->broker_model->get_user_session();
		
        $uid = $this->user_arr['uid'];
        $package_id = $this->user_arr['package_id'];
        $companycode = $this->user_arr['agentcode'];
        $tbl = $this->sell_model->get_tbl();
        $nowtime = time();
        //Ȩ
        //Դбҳַת
        $url_manage = $this->sell_model->find_func_url();
        //ƷԴʱ
        $session_key = $uid . '_last_sell_add_time';
        $session_value = $this->session->userdata($session_key);
        if ($session_value > 0 && $nowtime - $session_value <= 5) {
            $this->session->set_userdata(array($session_key => $nowtime));
            $this->jump($url_manage, "æԺ");
            return;
        } else {
            $this->session->set_userdata(array($session_key => $nowtime));
        }
        $this->load->model('broker_model');
        $this->load->model('package_model');
        $package = $this->package_model->find_by_id($package_id);

        //ֹģύԴ xue 2015-06-16
        //ύ֤
		$post_rand = $this->broker_model->get_rand_post();
        $post_value = $this->input->post($post_rand['post_key'], true);
	   // if($uid==863987){
		   //var_dump($post_rand);
		   //var_dump($post_value);exit();
		//}
        if($post_rand['post_value']!=$post_value){
		    echo "<script>alert('');history.go(-1);</script>";
                exit;		
		}
		
		//360ȫͼƬ
		$imageUrlArr = $this->input->post('imageUrl',true);

        //ġжԴԴǷз񳬹ޣ360ȫͼƬԴ2ͨԴ
        $valid_house_num = $this->broker_model->valid_house_num();
        //$esta = $valid_house_num >= $package["package_valid_num"] ? 2 : 1;
		
		//360ȫԴǩ
		$address = $this->input->post('address', true);
		$remark = $this->input->post('remark');
		$p_sort_arr = $this->input->post('p_sort', true);

		$is360 = 0;
		$imageUrlTotal = 0;
		if(!empty($imageUrlArr))
		{
			$imageUrlTotal = count($imageUrlArr);
		}

		if($imageUrlTotal >= 3 && strlen($address) >= 20 && strlen($remark) >= 60 && !empty($p_sort_arr) && (in_array('0',$p_sort_arr) || in_array('9',$p_sort_arr)) && (in_array('1',$p_sort_arr) || in_array('10',$p_sort_arr)))
		{
			$is360 = 2;
		}
		elseif($imageUrlTotal >= 1)
		{
			$is360 = 1;
		}	
		
		/*if($is360 == '2')
		{
			$esta = ($valid_house_num + 2) <= $package["package_valid_num"] ? 1 : 2;
		}
		else
		{
			$esta = ($valid_house_num + 1) <= $package["package_valid_num"] ? 1 : 2;
		}*/

		$esta = ($valid_house_num + 1) <= $package["package_valid_num"] ? 1 : 2;

		$stock_house_num = $this->broker_model->stock_house_num();
		if ($stock_house_num >= $package["package_stock_num"])
		{
			$this->jump($url_manage, "Բ,ѳʺŷԴ("
					. "{$package['package_stock_num']},$stock_house_num) 
						뵽ķԴɾڷԴ!");
			return;
		}

        if ($esta == 1) //ԴжǷˢ³
        {
            $this->load->model('log_refresh');
            $total_refresh_num = $this->log_refresh->findTodayNumberByBrokerId($uid);
            $esta = $total_refresh_num >= $package["package_refresh_num"] ? 2 : 1;
        }

        /*if ($esta == 2) //ʧЧԴжϿײͿ
        {
            $stock_house_num = $this->broker_model->stock_house_num();
            if ($stock_house_num >= $package["package_stock_num"])
            {
                $this->jump($url_manage, "Բ,ѳʺŷԴ("
                        . "{$package['package_stock_num']},$stock_house_num) 
                            뵽ķԴɾڷԴ!");
                return;
            }
        }*/

        //塢뷿ԴϢ
        //˷ԴĬagentcode
        $agentcode = 'B000';
        $this->load->helper('common_string_helper');
        //Դ
        $fields_values = array();
        /* ǰ̨ͻ֤СıдǷЧСֵ
         * ȡСϢͨpostʽύ
         * update 2012-5-7 xz
         */
        $blockshowname = trim($this->input->post('blockshowname', true));
        if($blockshowname != '')
        {
            $this->load->model('block_model');
            $this->block_model->set_select_fields(array('id','blockname','district','streetid','averprice','esta'));//xue modify 2016-03-14
            $block = $this->block_model->find_by_blockname($blockshowname);

            if( !empty($block)) 
            {
                $blockid = $block['id'];
                $district = $block['district'];
                $streetid = $block['streetid'];
                $blockshowname = $block['blockname'];
				$block_averprice = $block['averprice'];//xue modify 2016-03-14
				$block_esta = $block['esta'];
            }
            else
            {
                echo "<script>alert('СڣСƻССбѡ');history.go(-1);</script>";
                exit;
            }
            $mright = $this->input->post('mright', true);
			 //סլжϼ۸¸30%  xue modify 2016-03-14
			$lctype = $this->input->post('lctype', true);
			if(intval($this->input->post('infotype', true))==1&&$block_esta==2&&$mright=='Ȩ'&&$lctype==1){

                $fields_values['price'] = $this->input->post('price', true);
			    $fields_values['buildarea'] = $this->input->post('buildarea', true) 
                ? $this->input->post('buildarea', true) : 1;
			    //ȡԴ
			    $house_averprice = round(10000 * $fields_values['price'] 
                / $fields_values['buildarea'], 2);

                $min_averprice = $block_averprice*0.7;
                $max_averprice = $block_averprice*1.3;

				if($house_averprice<$min_averprice ){
				   echo "<script>alert('С۸̫ˣף');history.go(-1);</script>";
                   exit;
				 
				 }
			
			}


        }
        else
        {
            echo "<script>alert('дС');history.go(-1);</script>";
            exit;
        }
        /*******************Ϣʼ***************************/
        $fields_values['infotype'] = intval($this->input->post('infotype', true));
        $allow_infotype = $this->sell_model->get_public_infotype_permission($package_id);
        if (!in_array($fields_values['infotype'], $allow_infotype)) 
        {
            echo "<script>alert('ûȨ޷ͷԴѡ');history.go(-1);</script>";
            exit;
        }
        $fields_values['agentcode'] = $agentcode;
        $fields_values['infofrom'] = get_infofrom_by_agentocde($agentcode);
        $fields_values['uid'] = $uid;
        $fields_values['esta'] = $esta;
        $fields_values['district'] = str_replace('"','',$district);
        $fields_values['streetid'] = $streetid;
        $fields_values['blockid'] = $blockid;
        $fields_values['blockshowname'] = csubstr($this->input->post('blockshowname', true), 20);
        $fields_values['price'] = $this->input->post('price', true);
        $fields_values['priceterm'] = $this->input->post('priceterm', true);
        $fields_values['pricetype'] = $this->input->post('pricetype', true);
		$fields_values['taxonlytype'] = $this->input->post('taxonlytype', true);
		$fields_values['is360'] = $is360;
        $fields_values['buildarea'] = $this->input->post('buildarea', true) 
                ? $this->input->post('buildarea', true) : 1;
        if( 3 > $fields_values['buildarea'] || $fields_values['buildarea'] > 150000)
        {
            echo "<script>alert('3-150000ƽ֮');history.go(-1);</script>";
            exit;
        }
        $fields_values['averprice'] = round(10000 * $fields_values['price'] 
                / $fields_values['buildarea'], 2);
        if (500 > $fields_values['averprice'] || $fields_values['averprice'] > 250000) {
            echo "<script>alert('ǰΪ" . $fields_values['averprice'] 
                    . "Ԫ/ƽף۱2000-300000Ԫ/ƽ֮');history.go(-1);</script>";
            exit;
        }
        //ֻҵ סլ  ҡȲ
        if ($fields_values['infotype'] == 1 || $fields_values['infotype'] == 2) 
        {
            $fields_values['room'] = $this->input->post('room', true);
            $fields_values['hall'] = $this->input->post('hall', true);
            $fields_values['toilet'] = $this->input->post('toilet', true);
            $fields_values['kitchen'] = $this->input->post('kitchen', true);
            $fields_values['balcony'] = $this->input->post('balcony', true);
        }
        else
        {
            //ǿΪ0
            $fields_values['room'] = '';
            $fields_values['hall'] = '';
            $fields_values['toilet'] = '';
            $fields_values['kitchen'] = '';
            $fields_values['balcony'] = '';
        }
        //ҵΪ⳵λû¥
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['subfloor'] = '';
            $fields_values['floor'] = '';
            $fields_values['totalfloor'] = '';
            $fields_values['fitment'] = '';
            $fields_values['forward'] = '';
        }
        else
        {
            //¥ж
            $lctype = $this->input->post('lctype', true);
            if ($lctype == 1) //
            { 
                $floor = $this->input->post('floor', true);
                $totalfloor = $this->input->post('totalfloor', true);
                if ($floor > $totalfloor) 
                {
                    //תҳ
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = 0;
                $fields_values['floor'] = $floor;
                $fields_values['totalfloor'] = $totalfloor;
            }   
            if ($lctype == 2) //Ծ
            { 
                $subfloor = $this->input->post('subfloor', true);
                $floor2 = $this->input->post('floor2', true);
                $totalfloor2 = $this->input->post('totalfloor2', true);
                if ($subfloor > $totalfloor2 || $floor2 > $totalfloor2) 
                {
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = $subfloor;
                $fields_values['floor'] = $floor2;
                $fields_values['totalfloor'] = $totalfloor2;
            }
            $fields_values['fitment'] = $this->input->post('fitment', true);
            $fields_values['forward'] = $this->input->post('forward', true);
        }


		//2016-2-25 zhouظԴ -------- start ------------>

	
		$block_remove_limit_num = $this->block_model->get_block_remove_info_by_blockid($blockid);
		if($block_remove_limit_num)
		{
			$publish_limit_num =$block_remove_limit_num;
		}
		else
		{
			$publish_limit_num =10;
		}
		
		$price_start		=$fields_values['price']*0.95;
		$price_end  		=$fields_values['price']*1.05;

		$buildarea_start  =$fields_values['buildarea']-0.5;
		$buildarea_end    =$fields_values['buildarea']+0.5;
		$room		=$fields_values['room'];
		$hall		=$fields_values['hall'];
		$toilet		=$fields_values['toilet'];

		$subfloor	=$fields_values['subfloor'];
		$floor		=$fields_values['floor'];
		$totalfloor	=$fields_values['totalfloor'];



		//ѯԴ
        $cond_where = "uid = '".$uid."' AND esta = 1  AND infofrom = '5' and blockid ='$blockid' and subfloor='$subfloor'  and floor='$floor' and totalfloor='$totalfloor' and room='$room' and hall='$hall' and toilet='$toilet' and buildarea > '$buildarea_start' and buildarea < '$buildarea_end' and price> '$price_start' and price < '$price_end' ";

		//echo $cond_where;die;
		

        //
        $broker_publish_total_count = $this->sell_model->find_count_by($cond_where,'0');
		
		
		if($broker_publish_total_count>=$publish_limit_num)
		{
			
			$broker_publish_data_info = $this->sell_model->find_all_by($cond_where);
			if(count($broker_publish_data_info)>$publish_limit_num)
			{
				$show_limit_num =$publish_limit_num;
			
			}
			else
			{
				$show_limit_num =count($broker_publish_data_info);
			}
			$str_show ="";
			for($i =0;$i<$show_limit_num;$i++)
			{
				$str_show .=$broker_publish_data_info[$i]['id'].',';
			}

			$str_show =rtrim($str_show,',');
			echo "<script>alert('˷Դ뷿Դ " . $str_show 
                    . "ظֹظԴ');history.go(-1);</script>";
            exit;
		
		}
		

		//2016-2-25 zhouظԴ -------- end ------------>

        $fields_values['mright'] = $this->input->post('mright', true);
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['buildyear'] = $this->input->post('buildyear1', true);
        } 
        else
        {
            $fields_values['buildyear'] = $this->input->post('buildyear', true);
        }
        $fields_values['contactor'] = $this->user_arr['truename'];
        $fields_values['telno'] = $session_info['telno'];
        $fields_values['creattime'] = time();
        $fields_values['expiretime'] = $fields_values['infotype'] == 1 ? strtotime("+60 days") : strtotime("+90 days");
        $fields_values['updatetime'] = time();
        $fields_values['lucupdatetime'] = $fields_values['updatetime'];
        $fields_values['ip'] = get_ip();
        /*******************Ϣ***************************/
        
        /*******************Ϣʼ***************************/
        if ($fields_values['infotype'] == 2) 
        {
            $housekind = $this->input->post('housekind', true);
        } 
        else if ($fields_values['infotype'] == 6)
        {
            $housekind = $this->input->post('housekindname', true);
        }
        else
        {
            $fields_values['housekind'] = '';
        }
        if (isset($housekind) && $housekind != '')
        {
            //ҵ λ
            //ҵ ҵʹ
            $fields_values['housekind'] = $housekind;
        }
        //ҵ
        $tradeclass = $this->input->post('tradeclass', true);
        if (isset($tradeclass) && $tradeclass != '')
        {
            $fields_values['tradeclass'] = $tradeclass;
        }
        //ҵ
        $fee = $this->input->post('fee', true);
        if (isset($fee) && $fee != '')
        {
            $fields_values['strata_fee'] = $fee;
        }
        //ʩ
        $baseservice = $this->input->post('baseservice', true);
        if ($baseservice)
        {
            $fields_values['baseservice'] = implode(",", $baseservice);
        }
        $fields_values['ownid'] = trim($this->input->post('ownid', true));
        /*******************Ϣ***************************/
        
        /*******************ϸϢʼ***************************/
        $fields_values['address'] = htmlspecialchars(csubstr(trim(
                filterSpace($this->input->post('address', true))),60));

		//дʹ
		if(!empty($fields_values['address']))
		{
			$this->load->model('ajax_model');
			$sensitive_word = $this->ajax_model->check_sensitive_word($fields_values['address']);
			
			if(!empty($sensitive_word))
			{
				echo "<script>alert('дʣ".$fields_values['address']."');history.go(-1);</script>";
                return;
			}
		}

        $fields_values['remark'] = check_word($this->input->post('remark'),STATIC_BADWORD_URL);
        //Դɫ
        $fields_values['feature'] = '';
        $feature = $this->input->post('feature', true);
		if(count($feature)>3)
		{
			 echo "<script>alert('ǩݹ, ѡ!');history.go(-1);</script>";
                    return;
		}
        if(is_array($feature) && !empty($feature))
        {
            $this->load->model('house_feature');
            $feature_arr = $this->house_feature->find_feature($tbl, $fields_values['infotype']);
            foreach($feature as $val)
            {	
                $val = intval($val);
                if($feature_arr[$val] != '')
                {
                    $fields_values['feature'] .= '$'.$val;
                }
            }
            if($fields_values['feature'] != '')
            {
                $fields_values['feature'] .= '$';
            }
        }
       /*******************ϸϢ***************************/
        //뷿ԴϢطԴ
        $house_id = $this->sell_model->insert($fields_values);
        if ($house_id)
        {
            //жϷԴ۸ǷԤ۸䣬סլж
    		if ($fields_values['blockid'] && $fields_values['infotype']==1){
    		    $_sell = $fields_values;
    		    $_sell['id'] = $house_id;
    	        $check_rs = bm('sellwarning')->checkSellPrice($_sell,'nj');
    		}
			//,⾰,ͼݼ
			$pfile_name = $this->input->post('p_filename', true);

            //Դͼ
            $pic1 = $this->input->post('pic1', true);
            
			/*߼
			if($pic1 != '')
            {
                $pic1 = '';
            }
            else
            {
                $pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) : $pic1;
            }*/

			if(!empty($pic1))
            {
                $pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) : $pic1;
            }
			elseif(!empty($p_sort_arr))
			{
				arsort($p_sort_arr);

				$pic1_key = key($p_sort_arr);

				if(isset($pfile_name[$pic1_key]))
				{
					$pic1 = $pfile_name[$pic1_key];

					$pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) : $pic1;
				}
			}
			elseif(!empty($imageUrlArr))
			{
				$pic1 = current($imageUrlArr);

				$pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) : $pic1;
			}

            //ġԴͼƬ
            $this->load->model('admin_check');
            $pics = array();
            
            if (isset($pfile_name) && $pfile_name != '') 
            {
                $pics = array(
                    'p_filename' => $pfile_name,
                    'p_sort' => $this->input->post('p_sort', true),
                    'p_title' => $this->input->post('p_title', true),
                    'infotype' => $fields_values['infotype']
                );
                $pic_check = $this->sell_model->insert_house_pic($pics,
                $tbl, $house_id, $pic1, $blockid);
                $pic_check_arr = $pic_check['pic_check'];
                //·ͼ
                $this->sell_model->update(array('pic1' => $pic_check['indexpic']), $house_id);
                //ͼƬ
                
                if(isset($pic_check_arr) && is_array($pic_check_arr) 
                        && !empty($pic_check_arr) && $uid > 0)
                {
                    foreach($pic_check_arr as $key => $val)
                    {
                        $infotype = $fields_values['infotype'];
                        $fitment = $fields_values['fitment'];
                        $pic_check_arr[$key]['uid'] = $uid;
                        $pic_check_arr[$key]['housetbl'] = $tbl;
                        $pic_check_arr[$key]['houseid'] = $house_id;
                        $pic_check_arr[$key]['fitment'] = $fitment == "װ" ? 2 : ($fitment == "ë" ? 3 : 1);
                        $pic_check_arr[$key]['infotype'] = $infotype == 3 ? 4 : ($infotype == 4 ? 3 : $infotype);//̡д¥
                        $pic_check_arr[$key]['dateline'] = $nowtime;
                        //˸ҹJOB
                        $this->admin_check->insert_check_pic_sub($pic_check_arr[$key]);
                        //豸ͼƬֻ˿⡢˿
                        if($pic_check_arr[$key]['surface'] == 0 && $pic_check_arr[$key]['from_device'] == 1)
                        {
                            unset($pic_check_arr[$key]);
                        }
                        unset($pic_check_arr[$key]['from_device']);
                        //ͼ˱
                        if($pic_check_arr[$key]['surface'] == 1)
                        {
                            $this->admin_check->insert_check_pic($pic_check_arr[$key]);
                        }
                    }
                }
            }

			//360ȫͼƬ
			if(!empty($pic1) && empty($pic_check['indexpic']))
			{
				 //·ͼ
                $this->sell_model->update(array('pic1' => $pic1), $house_id);
			}

			//360ȫͼƬ
			if(!empty($imageUrlArr))
			{
				//360ȫͼƬҵģ
				$this->load->model('pic_model');

				//360ȫͼƬҵģ
				$this->load->model('admin_check');

				//ͼƬ
				$imageTitle = $this->input->post('imageTitle',true);

				//ͼƬ
				$imageType = $this->input->post('imageType',true);
				
				//SQLװ
				$position = 0;
				foreach($imageUrlArr as $key => $value)
				{
					$position++;

					$title = '';
					if(isset($imageTitle[$key]))
					{
						$title = $imageTitle[$key];
					}

					$roomtype = '0';
					if(isset($imageType[$key]))
					{
						$roomtype = $imageType[$key];
					}

					$filename = '';
					if(preg_match("/\?/", $value))
					{
						$filename = substr($value, 0, strpos($value, '?'));
					}
					
					$addUpload360Data = array(
						'tbl' => '1',
						'rowid' => $house_id,
						'position' => $position,
						'filename' => $filename,
						'title' => $title,
						'sort' => '0',
						'createtime' => time(),
						'flg' => '0',
						'isfrom' => '2',
						'isinfotype' => $fields_values['infotype'],
						'roomtype' => $roomtype
					);
					
					$picId = $this->pic_model->insert_house_panorama_pic($addUpload360Data);

					//ͼ˱
					$surface = '0';
                    if($filename == $pic1)
                    {						
						$surface = '1';
					}

					$addAdmin360PiCheckData = array(
						'uid' => $uid,
						'housetbl' => '1',
						'houseid' => $house_id,
						'fitment' => '0',
						'infotype' => $fields_values['infotype'],
						'pictbl' => 'upload360',
						'picid' => $picId,
						'picurl' => $filename,
						'sort' => '0',
						'roomtype' => $roomtype,
						'surface' => '1',
						'dateline' => time(),
						'file_md5' => ''
					);
					
					$this->admin_check->insert_360_check_pic($addAdmin360PiCheckData);
				}
			}

            //˷Դ
            /***
            $remark = $fields_values['remark'];
            $check_remark = preg_replace("/[\s*\t\n\r&nbsp;]/", "", strip_tags($remark));
            if($check_remark != '')
            {
                $remark_check_arr['uid'] = $uid;
                $remark_check_arr['housetbl'] = $tbl;
                $remark_check_arr['houseid'] = $house_id;
                $remark_check_arr['blockname'] = $blockshowname;
                $remark_check_arr['remark'] = $check_remark;
                $remark_check_arr['dateline'] = $nowtime;
                $remark_check_arr['file_md5'] = md5($check_remark);
                $this->admin_check->insert_check_remark_sub($remark_check_arr);
            }***/
            /**
             * ԷɳֵĲ
             * ÿɳֵޣɳֵԴ
             */
            /**
            $startTime = strtotime(date('Y-m-d',time()));//ʱ
            $growthHouseLog = new GrowthHouseLog();
            $publishHouseNum = $growthHouseLog->findCountBy($uid, $startTime);
            $expControllPackage = new GrowthExpControllPackage();                 
            $upperLimitNum = $expControllPackage->findScoreByWayAliasPackageId(
               'dayHouseNum', $package_id);
            $upperFlag = $publishHouseNum < $upperLimitNum ? 1 : 0;***/
            $gbe  = new GrowthBrokerExp(array('id' => $uid, 'groupid' => $package_id));			
            $gewp = new GrowthExpWayPackage();
            $ghl  = new GrowthHouseLog();
            //жʣͼ жͼ
            $fields_values['id'] = $house_id;
            $this->load->model('sell_star_model');
            $this->sell_star_model->set_houseinfo($fields_values);
            //$this->sell_star_model->set_rowid($house_id);
            $is_star_house = $this->sell_star_model->check_star_standard();
            //־¼Դ״̬
            $logesta = $fields_values['esta'];
            if ($is_star_house || $is360 == '2')
            {
                $exp = $gewp->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);					 
                $inExpStatus = $gbe->increase('pStarHouse','ͼԴ',$exp);
                $ghl->insertHouseGradeLog($house_id, $tbl, 2, $uid);
                $logesta = $fields_values['esta'] == 1 ? 5 : 6;
                //÷ԴΪͼ
                $this->sell_star_model->set_star();
            } 
            else 
            {
                //ͨԴ
                $exp = $gewp->findScoreByWayAliasAndPackageId('pNoStarHouse', $package_id);					 
                $inExpStatus = $gbe->increase('pNoStarHouse','ǶͼԴ',$exp); 
                $ghl->insertHouseGradeLog($house_id, $tbl, 1, $uid);
            }
            $growthMessage = '';
			/*
            if($inExpStatus['status'] == 2 ){
                $growthMessage = "ĳɳֵѴֵ";
            } elseif($inExpStatus['status'] == 1){
                $growthMessage = "ɳֵ+" . $exp;
            }
			*/
			//$growthMessage = '';
            //¼ûΪ
            $this->sell_model->action_log($companycode, $uid, $tbl, $house_id, $logesta);
            if ($fields_values['esta'] == 1) {
                //ˢ·Դ
                refresh_house($uid, $tbl, $house_id);
                $this->sell_model->action_log($companycode, $uid, $tbl, $house_id, 7);
            }
            //мύӿ
            $this->load->library('statistics');
            //ŵ
            $this->load->model('agency_model');
            $relation_info = array();
            $relation_info = $this->agency_model->get_relation_by_agentcode($companycode);
            $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
            $parentcode = '';
            if( is_array($relation_info) && !empty($relation_info))
            {	 
                $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
            }
            else
            {	
                $parentinfo = array();
                $select_array = array('parentcode');
                $this->agency_model->set_select_fields($select_array);
                $parentinfo = $this->agency_model->get_company_info_by_code($companycode);
                $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
            }

            $this->statistics->sub_operatecount($uid,$companycode,1,$house_id,
                    '', $tbl, $domain, $parentcode);
            $page_text = "Դɹ!" . $growthMessage;
            
            //ԴϢ
            if ($check_rs=='freeze house'){
                $page_text = 'ķԴصг۸ѱϵͳԶأҪ۱̨ϵͳءнߣ÷Դ٣˺ŻᱻΪ1ǡ';
            }
        }
        else
        {
            $page_text = "ǸԴʧ!";
        }
        $this->jump($url_manage, $page_text, 3000);
    }


	 /**
     * ʧЧԴ model
     */
    public function insertdisable() 
    {       
        //һȡUID
		$this->load->model('broker_model');
		$session_info = $this->broker_model->get_user_session();		
        $uid = $this->user_arr['uid'];
        $package_id = $this->user_arr['package_id'];
        $companycode = $this->user_arr['agentcode'];
        $tbl = $this->sell_model->get_tbl();
        $nowtime = time();
        //Ȩ
        //Դбҳַת
        $url_manage = $this->sell_model->find_func_url();
        //ƷԴʱ
        $session_key = $uid . '_last_sell_add_time';
        $session_value = $this->session->userdata($session_key);
        if ($session_value > 0 && $nowtime - $session_value <= 5) {
            $this->session->set_userdata(array($session_key => $nowtime));
            $this->jump($url_manage, "æԺ");
            return;
        } else {
            $this->session->set_userdata(array($session_key => $nowtime));
        }
        $this->load->model('broker_model');
        $this->load->model('package_model');
        $package = $this->package_model->find_by_id($package_id);
        //ġжԴԴǷз񳬹
        $valid_house_num = $this->broker_model->valid_house_num();
        $esta = $valid_house_num >= $package["package_valid_num"] ? 2 : 1;
        if ($esta == 1) //ԴжǷˢ³
        {
            $this->load->model('log_refresh');
            $total_refresh_num = $this->log_refresh->findTodayNumberByBrokerId($uid);
            $esta = $total_refresh_num >= $package["package_refresh_num"] ? 2 : 1;
        }
        if ($esta == 2) //ʧЧԴжϿײͿ
        {
            $stock_house_num = $this->broker_model->stock_house_num();
            if ($stock_house_num >= $package["package_stock_num"])
            {
                $this->jump($url_manage, "Բ,ѳʺŷԴ("
                        . "{$package['package_stock_num']},$stock_house_num) 
                            뵽ķԴɾڷԴ!");
                return;
            }
        }
        //塢뷿ԴϢ
        //˷ԴĬagentcode
        $agentcode = 'B000';
        $this->load->helper('common_string_helper');
        //Դ
        $fields_values = array();
        /* ǰ̨ͻ֤СıдǷЧСֵ
         * ȡСϢͨpostʽύ
         * update 2012-5-7 xz
         */
        $blockshowname = trim($this->input->post('blockshowname', true));
        if($blockshowname != '')
        {
            $this->load->model('block_model');
            $this->block_model->set_select_fields(array('id','blockname','district','streetid'));
            $block = $this->block_model->find_by_blockname($blockshowname);

            if( !empty($block)) 
            {
                $blockid = $block['id'];
                $district = $block['district'];
                $streetid = $block['streetid'];
                $blockshowname = $block['blockname'];
            }
            else
            {
                echo "<script>alert('СڣСƻССбѡ');history.go(-1);</script>";
                exit;
            }
        }
        else
        {
            echo "<script>alert('дС');history.go(-1);</script>";
            exit;
        }
        /*******************Ϣʼ***************************/
        $fields_values['infotype'] = intval($this->input->post('infotype', true));
        $allow_infotype = $this->sell_model->get_public_infotype_permission($package_id);
        if (!in_array($fields_values['infotype'], $allow_infotype)) 
        {
            echo "<script>alert('ûȨ޷ͷԴѡ');history.go(-1);</script>";
            exit;
        }
        $fields_values['agentcode'] = $agentcode;
        $fields_values['infofrom'] = get_infofrom_by_agentocde($agentcode);
        $fields_values['uid'] = $uid;
        $fields_values['esta'] = 2;
        $fields_values['district'] = str_replace('"','',$district);
        $fields_values['streetid'] = $streetid;
        $fields_values['blockid'] = $blockid;
        $fields_values['blockshowname'] = csubstr($this->input->post('blockshowname', true), 20);
        $fields_values['price'] = $this->input->post('price', true);
        $fields_values['priceterm'] = $this->input->post('priceterm', true);
        $fields_values['pricetype'] = $this->input->post('pricetype', true);
        $fields_values['buildarea'] = $this->input->post('buildarea', true) 
                ? $this->input->post('buildarea', true) : 1;
        if( 3 > $fields_values['buildarea'] || $fields_values['buildarea'] > 150000)
        {
            echo "<script>alert('3-150000ƽ֮');history.go(-1);</script>";
            exit;
        }
        $fields_values['averprice'] = round(10000 * $fields_values['price'] 
                / $fields_values['buildarea'], 2);
        if (500 > $fields_values['averprice'] || $fields_values['averprice'] > 250000) {
            echo "<script>alert('ǰΪ" . $fields_values['averprice'] 
                    . "Ԫ/ƽף۱2000-300000Ԫ/ƽ֮');history.go(-1);</script>";
            exit;
        }
        //ֻҵ סլ  ҡȲ
        if ($fields_values['infotype'] == 1 || $fields_values['infotype'] == 2) 
        {
            $fields_values['room'] = $this->input->post('room', true);
            $fields_values['hall'] = $this->input->post('hall', true);
            $fields_values['toilet'] = $this->input->post('toilet', true);
            $fields_values['kitchen'] = $this->input->post('kitchen', true);
            $fields_values['balcony'] = $this->input->post('balcony', true);
        }
        else
        {
            //ǿΪ0
            $fields_values['room'] = '';
            $fields_values['hall'] = '';
            $fields_values['toilet'] = '';
            $fields_values['kitchen'] = '';
            $fields_values['balcony'] = '';
        }
        //ҵΪ⳵λû¥
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['subfloor'] = '';
            $fields_values['floor'] = '';
            $fields_values['totalfloor'] = '';
            $fields_values['fitment'] = '';
            $fields_values['forward'] = '';
        }
        else
        {
            //¥ж
            $lctype = $this->input->post('lctype', true);
            if ($lctype == 1) //
            { 
                $floor = $this->input->post('floor', true);
                $totalfloor = $this->input->post('totalfloor', true);
                if ($floor > $totalfloor) 
                {
                    //תҳ
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = 0;
                $fields_values['floor'] = $floor;
                $fields_values['totalfloor'] = $totalfloor;
            }   
            if ($lctype == 2) //Ծ
            { 
                $subfloor = $this->input->post('subfloor', true);
                $floor2 = $this->input->post('floor2', true);
                $totalfloor2 = $this->input->post('totalfloor2', true);
                if ($subfloor > $totalfloor2 || $floor2 > $totalfloor2) 
                {
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = $subfloor;
                $fields_values['floor'] = $floor2;
                $fields_values['totalfloor'] = $totalfloor2;
            }
            $fields_values['fitment'] = $this->input->post('fitment', true);
            $fields_values['forward'] = $this->input->post('forward', true);
        }
        $fields_values['mright'] = $this->input->post('mright', true);
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['buildyear'] = $this->input->post('buildyear1', true);
        } 
        else
        {
            $fields_values['buildyear'] = $this->input->post('buildyear', true);
        }
        $fields_values['contactor'] = $this->user_arr['truename'];
        $fields_values['telno'] = $session_info['telno'];
        $fields_values['creattime'] = time();
        $fields_values['expiretime'] = $fields_values['infotype'] == 1 ? strtotime("+60 days") : strtotime("+90 days");
        $fields_values['updatetime'] = time();
        $fields_values['lucupdatetime'] = $fields_values['updatetime'];
        $fields_values['ip'] = get_ip();
        /*******************Ϣ***************************/
        
        /*******************Ϣʼ***************************/
        if ($fields_values['infotype'] == 2) 
        {
            $housekind = $this->input->post('housekind', true);
        } 
        else if ($fields_values['infotype'] == 6)
        {
            $housekind = $this->input->post('housekindname', true);
        }
        else
        {
            $fields_values['housekind'] = '';
        }
        if (isset($housekind) && $housekind != '')
        {
            //ҵ λ
            //ҵ ҵʹ
            $fields_values['housekind'] = $housekind;
        }
        //ҵ
        $tradeclass = $this->input->post('tradeclass', true);
        if (isset($tradeclass) && $tradeclass != '')
        {
            $fields_values['tradeclass'] = $tradeclass;
        }
        //ҵ
        $fee = $this->input->post('fee', true);
        if (isset($fee) && $fee != '')
        {
            $fields_values['strata_fee'] = $fee;
        }
        //ʩ
        $baseservice = $this->input->post('baseservice', true);
        if ($baseservice)
        {
            $fields_values['baseservice'] = implode(",", $baseservice);
        }
        $fields_values['ownid'] = trim($this->input->post('ownid', true));
        /*******************Ϣ***************************/
        
        /*******************ϸϢʼ***************************/
        $fields_values['address'] = htmlspecialchars(csubstr(trim(
                filterSpace($this->input->post('address', true))),60));
        $fields_values['remark'] = $this->input->post('remark');
        //Դɫ
        $fields_values['feature'] = '';
        $feature = $this->input->post('feature', true);
		if(count($feature)>3)
		{
			 echo "<script>alert('ǩݹ, ѡ!');history.go(-1);</script>";
                    return;
		}
        if(is_array($feature) && !empty($feature))
        {
            $this->load->model('house_feature');
            $feature_arr = $this->house_feature->find_feature($tbl, $fields_values['infotype']);
            foreach($feature as $val)
            {	
                $val = intval($val);
                if($feature_arr[$val] != '')
                {
                    $fields_values['feature'] .= '$'.$val;
                }
            }
            if($fields_values['feature'] != '')
            {
                $fields_values['feature'] .= '$';
            }
        }
       /*******************ϸϢ***************************/
        //뷿ԴϢطԴ
        $house_id = $this->sell_model->insert($fields_values);
        if ($house_id)
        {
            //Դͼ
            $pic1 = $this->input->post('pic1', true);
            if($pic1 != '')
            {
                $pic1 = '';
            }
            else
            {
                $pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) : $pic1;
            }
            //ġԴͼƬ
            $this->load->model('admin_check');
            $pics = array();
            $pfile_name = $this->input->post('p_filename', true);
            if (isset($pfile_name) && $pfile_name != '') 
            {
                $pics = array(
                    'p_filename' => $pfile_name,
                    'p_sort' => $this->input->post('p_sort', true),
                    'p_title' => $this->input->post('p_title', true),
                    'infotype' => $fields_values['infotype']
                );
                $pic_check = $this->sell_model->insert_house_pic($pics,
                $tbl, $house_id, $pic1, $blockid);
                $pic_check_arr = $pic_check['pic_check'];
                //·ͼ
                $this->sell_model->update(array('pic1' => $pic_check['indexpic']), $house_id);
                //ͼƬ
                
                if(isset($pic_check_arr) && is_array($pic_check_arr) 
                        && !empty($pic_check_arr) && $uid > 0)
                {
                    foreach($pic_check_arr as $key => $val)
                    {
                        $infotype = $fields_values['infotype'];
                        $fitment = $fields_values['fitment'];
                        $pic_check_arr[$key]['uid'] = $uid;
                        $pic_check_arr[$key]['housetbl'] = $tbl;
                        $pic_check_arr[$key]['houseid'] = $house_id;
                        $pic_check_arr[$key]['fitment'] = $fitment == "װ" ? 2 : ($fitment == "ë" ? 3 : 1);
                        $pic_check_arr[$key]['infotype'] = $infotype == 3 ? 4 : ($infotype == 4 ? 3 : $infotype);//̡д¥
                        $pic_check_arr[$key]['dateline'] = $nowtime;
                        //˸ҹJOB
                        $this->admin_check->insert_check_pic_sub($pic_check_arr[$key]);
                        //豸ͼƬֻ˿⡢˿
                        if($pic_check_arr[$key]['surface'] == 0 && $pic_check_arr[$key]['from_device'] == 1)
                        {
                            unset($pic_check_arr[$key]);
                        }
                        unset($pic_check_arr[$key]['from_device']);
                        //ͼ˱
                        if($pic_check_arr[$key]['surface'] == 1)
                        {
                            $this->admin_check->insert_check_pic($pic_check_arr[$key]);
                        }
                    }
                }
            }
            //˷Դ
            /***
            $remark = $fields_values['remark'];
            $check_remark = preg_replace("/[\s*\t\n\r&nbsp;]/", "", strip_tags($remark));
            if($check_remark != '')
            {
                $remark_check_arr['uid'] = $uid;
                $remark_check_arr['housetbl'] = $tbl;
                $remark_check_arr['houseid'] = $house_id;
                $remark_check_arr['blockname'] = $blockshowname;
                $remark_check_arr['remark'] = $check_remark;
                $remark_check_arr['dateline'] = $nowtime;
                $remark_check_arr['file_md5'] = md5($check_remark);
                $this->admin_check->insert_check_remark_sub($remark_check_arr);
            }***/
            /**
             * ԷɳֵĲ
             * ÿɳֵޣɳֵԴ
             */
            /**
            $startTime = strtotime(date('Y-m-d',time()));//ʱ
            $growthHouseLog = new GrowthHouseLog();
            $publishHouseNum = $growthHouseLog->findCountBy($uid, $startTime);
            $expControllPackage = new GrowthExpControllPackage();                 
            $upperLimitNum = $expControllPackage->findScoreByWayAliasPackageId(
               'dayHouseNum', $package_id);
            $upperFlag = $publishHouseNum < $upperLimitNum ? 1 : 0;***/
            $gbe  = new GrowthBrokerExp(array('id' => $uid, 'groupid' => $package_id));			
            $gewp = new GrowthExpWayPackage();
            $ghl  = new GrowthHouseLog();
            //жʣͼ жͼ
            $fields_values['id'] = $house_id;
            $this->load->model('sell_star_model');
            $this->sell_star_model->set_houseinfo($fields_values);
			
            //$this->sell_star_model->set_rowid($house_id);
            $is_star_house = $this->sell_star_model->check_star_standard();
            //־¼Դ״̬
			
            $logesta = $fields_values['esta'];
            if ($is_star_house)
            {
                $exp = $gewp->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);					 
                $inExpStatus = $gbe->increase('pStarHouse','ͼԴ',$exp);
                $ghl->insertHouseGradeLog($house_id, $tbl, 2, $uid);
                $logesta = $fields_values['esta'] == 1 ? 5 : 6;
                //÷ԴΪͼ
                $this->sell_star_model->set_star();
            } 
            else 
            {
                //ͨԴ
                $exp = $gewp->findScoreByWayAliasAndPackageId('pNoStarHouse', $package_id);					 
                $inExpStatus = $gbe->increase('pNoStarHouse','ǶͼԴ',$exp); 
                $ghl->insertHouseGradeLog($house_id, $tbl, 1, $uid);
            }
            $growthMessage = '';
            if($inExpStatus['status'] == 2 ){
                $growthMessage = "ĳɳֵѴֵ";
            } elseif($inExpStatus['status'] == 1){
                //$growthMessage = "ɳֵ+" . $exp;
            }
            //¼ûΪ
            $this->sell_model->action_log($companycode, $uid, $tbl, $house_id, $logesta);
            if ($fields_values['esta'] == 1) {
                //ˢ·Դ
                //refresh_house($uid, $tbl, $house_id);
                //$this->sell_model->action_log($companycode, $uid, $tbl, $house_id, 7);
            }
            //мύӿ
            $this->load->library('statistics');
            //ŵ
            $this->load->model('agency_model');
            $relation_info = array();
            $relation_info = $this->agency_model->get_relation_by_agentcode($companycode);
            $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
            $parentcode = '';
            if( is_array($relation_info) && !empty($relation_info))
            {	 
                $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
            }
            else
            {	
                $parentinfo = array();
                $select_array = array('parentcode');
                $this->agency_model->set_select_fields($select_array);
                $parentinfo = $this->agency_model->get_company_info_by_code($companycode);
                $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
            }

            $this->statistics->sub_operatecount($uid,$companycode,1,$house_id,
                    '', $tbl, $domain, $parentcode);
            $page_text = "Դɹ!" . $growthMessage;
        }
        else
        {
            $page_text = "ǸԴʧ!";
        }
        $this->jump($url_manage, $page_text, 3000);
    }
    
    /**
     * չʾԴ޸ҳ
     */
    public function modify($id, $tab = '') 
    {
		
        $uid = $this->user_arr['uid'];
        $package_id = $this->user_arr['package_id'];
        $tbl = $this->sell_model->get_tbl();
        
        //Դбҳַ
        $url_manage_module = $this->sell_model->find_func_url();
        if (!$id)
        {
            $this->jump($url_manage_module, 'Ϸ');
            return;
        }
        //޴˷Դ¼ûתбҳ
        $house_detail = $this->sell_model->find_by_uid_id($uid, $id);
		//print_r($house_detail);die;
        if (!$house_detail)
        {
            $this->jump($url_manage_module, 'ûзѯļ¼');
            return;
        } 
        $data_page = array();
        $this->load->model('block_model');
        //ҷԴİơҷԴСַ
        $block = $this->block_model->base_info_by_id($house_detail['blockid']);
        if ($block) 
        {
            $house_detail['block'] = $block;
        } 
        else
        {
            $this->load->model('street_model');
            $street = $this->street_model->find_by_id($house_detail['streetid']);
            $house_detail['block'] = array(
                'district' => $house_detail['district'],
                'blockname' => $house_detail['blockshowname'],
                'streetid' => $house_detail['streetid'],
                'streetname' => $street['streetname'],
                'address' =>  $house_detail['address'],
                'blockid' => 0
            );
        }
        //ԴͼƬ
        $this->load->model('pic_model');
        //ͼ 2
        $house_detail['house_pic2'] = $this->pic_model->find_house_pic_by($tbl, $id, 2);
        //⾰ͼ 1
        $house_detail['house_pic1'] = $this->pic_model->find_house_pic_by($tbl, $id, 1);
        //ͼ 0
        $house_detail['house_pic0'] = $this->pic_model->find_house_pic_by($tbl, $id, 0);
        $data_page['house_detail'] = $house_detail;
        //Դģ
        $this->load->model('house_template_model');
        $data_page['url_template_add'] = $this->house_template_model->
                 find_func_url('add') . $this->_house_template_module . '/';
        $data_page['method'] = 'modify';
        $data_page['url_house_submit'] = $this->sell_model->find_func_url('update');

		$data_page['url_house_submit'] = '/sell_zhou/update';
        //ͼͨԴӳɳֵķֵ
        $gcep = new GrowthExpWayPackage();
        $starScore = $gcep->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);
        $noStarScore = $gcep->findScoreByWayAliasAndPackageId('pNoStarHouse', $package_id);
        $data_page['star_score'] = $starScore;
        $data_page['no_star_score'] = $noStarScore;
        //ķԴ
        $data_page['allow_publish_infotype'] = $this->sell_model->
                get_public_infotype_permission($package_id);
        //Դɫ
        $this->load->model('house_feature');
        $data_page['feature_arr'] = $this->house_feature->find_feature($tbl, $house_detail['infotype']);
        $data_page['feature'] = $this->house_feature->
                find_house_feature($house_detail['feature'], $tbl);
        $data_page['tab'] = $tab;
        
        //췢öٳɳֵ
        $growthExpDayCount = new GrowthExpDayCount();
        $publishEventArray = array('pQualityHouse','pStarHouse','pNoStarHouse');
        $exp_rank_day = $growthExpDayCount->getExpAndRank($uid, $publishEventArray);
        $data_page['growthDaySum'] = $exp_rank_day['exp'];
        //ǰõΰٷֱ
        $data_page['rankRate'] = $exp_rank_day['rate'];
        //ĵ
        $data_page['documentation'] = $this->config->item('documentation');
        //Ⱦҳ
        $data_page['page_title'] = 'Դ-޸ĳ';
		$data_page['google_analytics'] = get_ga_js_code('/Դ/޸ĳ/');
        $this->render_publish($data_page);
    }
    
    /**
     * ·Դ model
     */
    public function update()
    {
        //һȡUID
		$this->load->model('broker_model');
		$session_info = $this->broker_model->get_user_session();	
        $uid = $this->user_arr['uid'];
        $tbl = $this->sell_model->get_tbl();
        $package_id = $this->user_arr['package_id'];
        $house_id = $this->input->post('id', true);
        //ѯԴû޸֮ǰϢ
        $this->sell_model->set_select_fields(array('isstar', 'esta'));
        $before_info = $this->sell_model->find_by_id($house_id);
        //᷿Դ޸
        if ($before_info['esta'] == 5) 
        {
            echo "<script>alert('᷿Դ޸!');history.go(-1);</script>";
            return;
        }
        //·ԴϢ
        $this->load->helper('common_string_helper');
        //Դ
        $fields_values = array();
        /*******************Ϣʼ***************************/
        $fields_values['infotype'] = intval($this->input->post('infotype', true));
        $allow_infotype = $this->sell_model->get_public_infotype_permission($package_id);
        if (!in_array($fields_values['infotype'], $allow_infotype)) 
        {
            echo "<script>alert('ûȨ޷ͷԴѡ');history.go(-1);</script>";
            exit;
        }
        /***
        $fields_values['district'] = str_replace('"','',$district);
        $fields_values['streetid'] = $streetid;
        $fields_values['blockid'] = $blockid;
        $fields_values['blockshowname'] = csubstr($this->input->post('blockshowname'), 20);***/
        $fields_values['price'] = $this->input->post('price', true);
        $fields_values['priceterm'] = $this->input->post('priceterm', true);
        $fields_values['pricetype'] = $this->input->post('pricetype', true);
        $fields_values['buildarea'] = $this->input->post('buildarea', true) 
                ? $this->input->post('buildarea', true) : 1;
        if(3>$fields_values['buildarea'] || $fields_values['buildarea']>150000)
        {
            echo "<script>alert(3-150000ƽ֮');history.go(-1);</script>";
            exit;
        }
        $fields_values['averprice'] = round(10000 * $fields_values['price'] 
                / $fields_values['buildarea'], 2);
        if (500 > $fields_values['averprice'] || $fields_values['averprice'] > 250000) {
            echo "<script>alert('ǰΪ" . $fields_values['averprice'] 
                    . "Ԫ/ƽף۱2000-300000Ԫ/ƽ֮');history.go(-1);</script>";
            exit;
        }
        //ֻҵ סլ  ҡȲ
        if ($fields_values['infotype'] == 1 || $fields_values['infotype'] == 2) 
        {
            $fields_values['room'] = $this->input->post('room', true);
            $fields_values['hall'] = $this->input->post('hall', true);
            $fields_values['toilet'] = $this->input->post('toilet', true);
            $fields_values['kitchen'] = $this->input->post('kitchen', true);
            $fields_values['balcony'] = $this->input->post('balcony', true);
        }       
        else
        {
            //ǿΪ0
            $fields_values['room'] = '';
            $fields_values['hall'] = '';
            $fields_values['toilet'] = '';
            $fields_values['kitchen'] = '';
            $fields_values['balcony'] = '';
        }
        //ҵΪ⳵λû¥
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['subfloor'] = '';
            $fields_values['floor'] = '';
            $fields_values['totalfloor'] = '';
            $fields_values['fitment'] = '';
            $fields_values['forward'] = '';
        }
        else
        {
            //¥ж
            $lctype = $this->input->post('lctype', true);
            if ($lctype == 1) //
            { 
                $floor = $this->input->post('floor', true);
                $totalfloor = $this->input->post('totalfloor', true);
                if ($floor > $totalfloor) 
                {
                    //תҳ
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = 0;
                $fields_values['floor'] = $floor;
                $fields_values['totalfloor'] = $totalfloor;
            }   
            if ($lctype == 2) //Ծ
            { 
                $subfloor = $this->input->post('subfloor', true);
                $floor2 = $this->input->post('floor2', true);
                $totalfloor2 = $this->input->post('totalfloor2', true);
                if ($subfloor > $totalfloor2 || $floor2 > $totalfloor2) 
                {
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = $subfloor;
                $fields_values['floor'] = $floor2;
                $fields_values['totalfloor'] = $totalfloor2;
            }
            $fields_values['fitment'] = $this->input->post('fitment', true);
            $fields_values['forward'] = $this->input->post('forward', true);
        }


		//2016-2-25 zhouظԴ -------- start ------------>
		
		$blockid =$_POST['block_id'];
		$this->load->model('block_zhou_model');

		$block_remove_limit_num = $this->block_zhou_model->get_block_remove_info_by_blockid($blockid);
		if($block_remove_limit_num)
		{
			$publish_limit_num =$block_remove_limit_num;
		}
		else
		{
			$publish_limit_num =10;
		}
		
		$price_start		=$fields_values['price']*0.95;
		$price_end  		=$fields_values['price']*1.05;

		$buildarea_start  =$fields_values['buildarea']-0.5;
		$buildarea_end    =$fields_values['buildarea']+0.5;
		$room		=$fields_values['room'];
		$hall		=$fields_values['hall'];
		$toilet		=$fields_values['toilet'];

		$subfloor	=$fields_values['subfloor'];
		$floor		=$fields_values['floor'];
		$totalfloor	=$fields_values['totalfloor'];



		//ѯԴ
        $cond_where = "uid = '".$uid."' AND esta = 1  AND infofrom = '5' and blockid ='$blockid' and subfloor='$subfloor'  and floor='$floor' and totalfloor='$totalfloor' and room='$room' and hall='$hall' and toilet='$toilet' and buildarea > '$buildarea_start' and buildarea < '$buildarea_end' and price> '$price_start' and price < '$price_end' and id != $house_id ";

		echo $cond_where;die;
		
		
        //
        $broker_publish_total_count = $this->sell_model->find_count_by($cond_where,'1');
		
		
		echo $broker_publish_total_count."<br/>";
		echo $publish_limit_num;die;
		if($broker_publish_total_count>=$publish_limit_num)
		{

			$this->sell_model->set_select_fields(array('id','isstar', 'esta'));
			$broker_publish_data_info = $this->sell_model->find_all_by($cond_where);
			
			if(count($broker_publish_data_info)>$publish_limit_num)
			{
				$show_limit_num =$publish_limit_num;
			
			}
			else
			{
				$show_limit_num =count($broker_publish_data_info);
			}
			
			$str_show ="";
			for($i =0;$i<$show_limit_num;$i++)
			{
				$str_show .=$broker_publish_data_info[$i]['id'].',';
			}

			$str_show =rtrim($str_show,',');
			echo "<script>alert('˷Դ뷿Դ " . $str_show 
                    . "ظֹظԴ');history.go(-1);</script>";
            exit;
		
		}
		

		//2016-2-25 zhouظԴ -------- end ------------>

        $fields_values['mright'] = $this->input->post('mright', true);
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['buildyear'] = $this->input->post('buildyear1', true);
        } 
        else
        {
            $fields_values['buildyear'] = $this->input->post('buildyear', true);
        }
        $fields_values['contactor'] = $this->user_arr['truename'];
        $fields_values['telno'] = $session_info['telno'];
        $fields_values['ip'] = get_ip();
        /*******************Ϣ***************************/
        
        /*******************Ϣʼ***************************/
        if ($fields_values['infotype'] == 2) 
        {
            $housekind = $this->input->post('housekind', true);
        } 
        else if ($fields_values['infotype'] == 6)
        {
            $housekind = $this->input->post('housekindname', true);
        }
        if (isset($housekind) && $housekind != '')
        {
            //ҵ λ
            //ҵ ҵʹ
            $fields_values['housekind'] = $housekind;
        }
        //ҵ
        $tradeclass = $this->input->post('tradeclass', true);
        if (isset($tradeclass) && $tradeclass != '')
        {
            $fields_values['tradeclass'] = $tradeclass;
        }
        //ҵ
        $fee = $this->input->post('fee', true);
        if (isset($fee) && $fee != '')
        {
            $fields_values['strata_fee'] = $fee;
        }
        //ʩ
        $baseservice = $this->input->post('baseservice', true);
        if ($baseservice)
        {
            $fields_values['baseservice'] = implode(",", $baseservice);
        }
        $fields_values['ownid'] = trim($this->input->post('ownid', true));
        /*******************Ϣ***************************/
        
        /*******************ϸϢʼ***************************/
        $fields_values['address'] = htmlspecialchars(csubstr(trim(
                filterSpace($this->input->post('address', true))),60));
        $fields_values['remark'] = $this->input->post('remark');
        //Դɫ
        $fields_values['feature'] = '';
        $feature = $this->input->post('feature', true);
        if(is_array($feature) && !empty($feature))
        {
            $this->load->model('house_feature');
            $feature_arr = $this->house_feature->find_feature($tbl, $fields_values['infotype']);
            foreach($feature as $val)
            {	
                $val = intval($val);
                if($feature_arr[$val] != '')
                {
                    $fields_values['feature'] .= '$'.$val;
                }
            }
            if($fields_values['feature'] != '')
            {
                $fields_values['feature'] .= '$';
            }
        }
        //Դͼ
        $pic1 = $this->input->post('pic1', true);
        if($pic1 == '')
        {
            $pic1 = '';
        }
        else
        {
            $pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) : $pic1;
        }
       
        //ġԴͼƬ
        $pics = array();
        $pfile_name = $this->input->post('p_filename', true);
        if (isset($pfile_name) && $pfile_name != '') 
        {
            $pics = array(
                'p_filename' => $pfile_name,
                'p_sort' => $this->input->post('p_sort', true),
                'p_title' => $this->input->post('p_title', true),
                'infotype' => $fields_values['infotype']
            );
            $pic_check = $this->sell_model->insert_house_pic($pics,
                    $tbl, $house_id, $pic1, $this->input->post('block_id', true), 1);
            $pic_check_arr = $pic_check['pic_check'];
            //·ͼ
            $fields_values['pic1'] = $pic_check['indexpic'];
        }
        //·ԴϢ
        //update sell set esta = 5 where id in(33899521, 37700775) and uid = 10000040;
        $affected_rows = $this->sell_model->update($fields_values, $house_id, $uid);     
        //öͼǩreal
        $fields_values['id'] = $house_id;
        $fields_values['uid'] =  $this->user_arr['uid'];
        if ($affected_rows > 0)
        {
            /***
            $this->load->model('admin_check');
            $delpic = $this->input->post('delpic', true);
            //ɾͼƬ˿ɾ
            if($delpic != '')
            {
                $delpicarr = explode(",", $delpic);
                if(is_array($delpicarr) && !empty($delpicarr))
                {
                    foreach($delpicarr as $val)
                    {
                        $val = intval($val);
                        if($val)
                        {
                            //òƲ̫жĸ⣬һɾ
                            $this->admin_check->delete_check_pic($tbl, $house_id, $val);
                            $this->admin_check->delete_check_pic_sub($tbl, $house_id, $val);
                        }
                    }
                }
            }***/
            $nowtime = time();
            //ͼƬ
            
            if(isset($pic_check_arr) && is_array($pic_check_arr) 
                    && !empty($pic_check_arr) && $uid > 0)
            {
                $this->load->model('admin_check');
                foreach($pic_check_arr as $key => $val)
                {
                    $infotype = $fields_values['infotype'];
                    $fitment = $fields_values['fitment'];
                    $pic_check_arr[$key]['uid'] = $uid;
                    $pic_check_arr[$key]['housetbl'] = $tbl;
                    $pic_check_arr[$key]['houseid'] = $house_id;
                    $pic_check_arr[$key]['fitment'] = $fitment == "װ" ? 2 : ($fitment == "ë" ? 3 : 1);
                    $pic_check_arr[$key]['infotype'] = $infotype == 3 ? 4 : ($infotype == 4 ? 3 : $infotype);//̡д¥
                    $pic_check_arr[$key]['dateline'] = $nowtime;
                    //˸ҹJOB
                    $this->admin_check->insert_check_pic_sub($pic_check_arr[$key]);
                    //豸ͼƬֻ˿⡢˿
                    if($pic_check_arr[$key]['surface'] == 0 && $pic_check_arr[$key]['from_device'] == 1)
                    {
                        unset($pic_check_arr[$key]);
                    }
                    unset($pic_check_arr[$key]['from_device']);
                    //ͼ˱
                    if($pic_check_arr[$key]['surface'] == 1)
                    {
                        $this->admin_check->insert_check_pic($pic_check_arr[$key]);
                    }
                }
            }
            //жʣͼ жͼ
            $this->load->model('sell_star_model');
            $this->sell_star_model->set_houseinfo($fields_values);
            $is_star_house = $this->sell_star_model->check_star_standard();
            $growthMessage = '';
            if ($is_star_house)
            {
                if ($before_info['isstar'] != 3) {
                    //Դǩļ
                    $gradeLog = $before_info['isstar'] == 3 ? 2 : 1;
                    $ghl  = new GrowthHouseLog();
                    $houseGradeLog = $ghl->findHouseGradeLog($house_id, $tbl, $gradeLog, $uid);
                    if ($houseGradeLog['grade'] == 1)
                    {
                        $gbe  = new GrowthBrokerExp(array('id' => $uid, 'groupid' => $package_id));			
                        $gewp = new GrowthExpWayPackage();
                        $exp = $gewp->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);					 
                        $inExpStatus = $gbe->increase('pStarHouse','ͼԴ',$exp);
                        $ghl->updateHouseGradeLog($house_id, $tbl, 2, $uid);
                        if($inExpStatus['status'] == 2 ){
                            $growthMessage = "ĳɳֵѴֵ";
                        } elseif($inExpStatus['status'] == 1){
                            $growthMessage = "ɳֵ+" . $exp;
                        }
                    }
                    //жԭǷΪͼ
                    if ($before_info['isstar'] != 3)
                    {
                        $this->sell_star_model->set_star();
                    }
                }
            } 
            else 
            {
                //÷ԴΪͼ
                $this->sell_star_model->remove_star(); 
                $this->load->model('sell_tag_model');
                $this->sell_tag_model->set_houseinfo($fields_values);
                //2011-11-30 ͬñǩʧЧ
				$this->sell_tag_model->remove_tag();
                //ȡREAL
                $this->load->model('sell_real_model');
                $this->sell_real_model->set_houseinfo($fields_values);
                $this->sell_real_model->remove_real();
                //ȡ·ֱ
                $this->load->model('sell_nofee_model');
                $this->sell_nofee_model->set_houseinfo($fields_values);
                $this->sell_nofee_model->remove_nofee();
            }
            $page_text = 'Դ޸ĳɹ!' . $growthMessage;
        }
        else 
        {
            $page_text = 'Ǹ޸ķԴϢʧ!';
        }
        //ת֮ǰ޸ĵҳ
        $tab = $this->input->post('tab', true);
        $this->jump($this->sell_model->find_func_url() . $tab, $page_text, 3000);
    }

	 /**
     * ʧЧԴ model
     */
    public function updatedisable()
    {
        //һȡUID
		$this->load->model('broker_model');
		$session_info = $this->broker_model->get_user_session();	
        $uid = $this->user_arr['uid'];
        $tbl = $this->sell_model->get_tbl();
        $package_id = $this->user_arr['package_id'];
        $house_id = $this->input->post('id', true);
        //ѯԴû޸֮ǰϢ
        $this->sell_model->set_select_fields(array('isstar', 'esta'));
        $before_info = $this->sell_model->find_by_id($house_id);
        //᷿Դ޸
        if ($before_info['esta'] == 5) 
        {
            echo "<script>alert('᷿Դ޸!');history.go(-1);</script>";
            return;
        }
        //·ԴϢ
        $this->load->helper('common_string_helper');
        //Դ
        $fields_values = array();
        /*******************Ϣʼ***************************/
        $fields_values['infotype'] = intval($this->input->post('infotype', true));
        $allow_infotype = $this->sell_model->get_public_infotype_permission($package_id);
        if (!in_array($fields_values['infotype'], $allow_infotype)) 
        {
            echo "<script>alert('ûȨ޷ͷԴѡ');history.go(-1);</script>";
            exit;
        }
        /***
        $fields_values['district'] = str_replace('"','',$district);
        $fields_values['streetid'] = $streetid;
        $fields_values['blockid'] = $blockid;
        $fields_values['blockshowname'] = csubstr($this->input->post('blockshowname'), 20);***/
        $fields_values['price'] = $this->input->post('price', true);
        $fields_values['priceterm'] = $this->input->post('priceterm', true);
        $fields_values['pricetype'] = $this->input->post('pricetype', true);
        $fields_values['buildarea'] = $this->input->post('buildarea', true) 
                ? $this->input->post('buildarea', true) : 1;
        if(3>$fields_values['buildarea'] || $fields_values['buildarea']>150000)
        {
            echo "<script>alert(3-150000ƽ֮');history.go(-1);</script>";
            exit;
        }
        $fields_values['averprice'] = round(10000 * $fields_values['price'] 
                / $fields_values['buildarea'], 2);
        if (500 > $fields_values['averprice'] || $fields_values['averprice'] > 250000) {
            echo "<script>alert('ǰΪ" . $fields_values['averprice'] 
                    . "Ԫ/ƽף۱2000-300000Ԫ/ƽ֮');history.go(-1);</script>";
            exit;
        }
        //ֻҵ סլ  ҡȲ
        if ($fields_values['infotype'] == 1 || $fields_values['infotype'] == 2) 
        {
            $fields_values['room'] = $this->input->post('room', true);
            $fields_values['hall'] = $this->input->post('hall', true);
            $fields_values['toilet'] = $this->input->post('toilet', true);
            $fields_values['kitchen'] = $this->input->post('kitchen', true);
            $fields_values['balcony'] = $this->input->post('balcony', true);
        }       
        else
        {
            //ǿΪ0
            $fields_values['room'] = '';
            $fields_values['hall'] = '';
            $fields_values['toilet'] = '';
            $fields_values['kitchen'] = '';
            $fields_values['balcony'] = '';
        }
        //ҵΪ⳵λû¥
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['subfloor'] = '';
            $fields_values['floor'] = '';
            $fields_values['totalfloor'] = '';
            $fields_values['fitment'] = '';
            $fields_values['forward'] = '';
        }
        else
        {
            //¥ж
            $lctype = $this->input->post('lctype', true);
            if ($lctype == 1) //
            { 
                $floor = $this->input->post('floor', true);
                $totalfloor = $this->input->post('totalfloor', true);
                if ($floor > $totalfloor) 
                {
                    //תҳ
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = 0;
                $fields_values['floor'] = $floor;
                $fields_values['totalfloor'] = $totalfloor;
            }   
            if ($lctype == 2) //Ծ
            { 
                $subfloor = $this->input->post('subfloor', true);
                $floor2 = $this->input->post('floor2', true);
                $totalfloor2 = $this->input->post('totalfloor2', true);
                if ($subfloor > $totalfloor2 || $floor2 > $totalfloor2) 
                {
                    echo "<script>alert('¥㲻Сڵǰ¥!');history.go(-1);</script>";
                    return;
                }
                $fields_values['subfloor'] = $subfloor;
                $fields_values['floor'] = $floor2;
                $fields_values['totalfloor'] = $totalfloor2;
            }
            $fields_values['fitment'] = $this->input->post('fitment', true);
            $fields_values['forward'] = $this->input->post('forward', true);
        }
        $fields_values['mright'] = $this->input->post('mright', true);
        if ($fields_values['infotype'] == 6)
        {
            $fields_values['buildyear'] = $this->input->post('buildyear1', true);
        } 
        else
        {
            $fields_values['buildyear'] = $this->input->post('buildyear', true);
        }
        $fields_values['contactor'] = $this->user_arr['truename'];
        $fields_values['telno'] = $session_info['telno'];
        $fields_values['ip'] = get_ip();

		$fields_values['esta'] = 2;
        /*******************Ϣ***************************/
        
        /*******************Ϣʼ***************************/
        if ($fields_values['infotype'] == 2) 
        {
            $housekind = $this->input->post('housekind', true);
        } 
        else if ($fields_values['infotype'] == 6)
        {
            $housekind = $this->input->post('housekindname', true);
        }
        if (isset($housekind) && $housekind != '')
        {
            //ҵ λ
            //ҵ ҵʹ
            $fields_values['housekind'] = $housekind;
        }
        //ҵ
        $tradeclass = $this->input->post('tradeclass', true);
        if (isset($tradeclass) && $tradeclass != '')
        {
            $fields_values['tradeclass'] = $tradeclass;
        }
        //ҵ
        $fee = $this->input->post('fee', true);
        if (isset($fee) && $fee != '')
        {
            $fields_values['strata_fee'] = $fee;
        }
        //ʩ
        $baseservice = $this->input->post('baseservice', true);
        if ($baseservice)
        {
            $fields_values['baseservice'] = implode(",", $baseservice);
        }
        $fields_values['ownid'] = trim($this->input->post('ownid', true));
        /*******************Ϣ***************************/
        
        /*******************ϸϢʼ***************************/
        $fields_values['address'] = htmlspecialchars(csubstr(trim(
                filterSpace($this->input->post('address', true))),60));
        $fields_values['remark'] = $this->input->post('remark');
        //Դɫ
        $fields_values['feature'] = '';
        $feature = $this->input->post('feature', true);
        if(is_array($feature) && !empty($feature))
        {
            $this->load->model('house_feature');
            $feature_arr = $this->house_feature->find_feature($tbl, $fields_values['infotype']);
            foreach($feature as $val)
            {	
                $val = intval($val);
                if($feature_arr[$val] != '')
                {
                    $fields_values['feature'] .= '$'.$val;
                }
            }
            if($fields_values['feature'] != '')
            {
                $fields_values['feature'] .= '$';
            }
        }
        //Դͼ
        $pic1 = $this->input->post('pic1', true);
        if($pic1 == '')
        {
            $pic1 = '';
        }
        else
        {
            $pic1 = preg_match("#\?#", $pic1) ? substr($pic1, 0, strpos($pic1, '?')) : $pic1;
        }
       
        //ġԴͼƬ
        $pics = array();
        $pfile_name = $this->input->post('p_filename', true);
        if (isset($pfile_name) && $pfile_name != '') 
        {
            $pics = array(
                'p_filename' => $pfile_name,
                'p_sort' => $this->input->post('p_sort', true),
                'p_title' => $this->input->post('p_title', true),
                'infotype' => $fields_values['infotype']
            );
            $pic_check = $this->sell_model->insert_house_pic($pics,
                    $tbl, $house_id, $pic1, $this->input->post('block_id', true), 1);
            $pic_check_arr = $pic_check['pic_check'];
            //·ͼ
            $fields_values['pic1'] = $pic_check['indexpic'];
        }
        //·ԴϢ
        //update sell set esta = 5 where id in(33899521, 37700775) and uid = 10000040;
        $affected_rows = $this->sell_model->update($fields_values, $house_id, $uid);     
        //öͼǩreal
        $fields_values['id'] = $house_id;
        $fields_values['uid'] =  $this->user_arr['uid'];
        if ($affected_rows > 0)
        {
            /***
            $this->load->model('admin_check');
            $delpic = $this->input->post('delpic', true);
            //ɾͼƬ˿ɾ
            if($delpic != '')
            {
                $delpicarr = explode(",", $delpic);
                if(is_array($delpicarr) && !empty($delpicarr))
                {
                    foreach($delpicarr as $val)
                    {
                        $val = intval($val);
                        if($val)
                        {
                            //òƲ̫жĸ⣬һɾ
                            $this->admin_check->delete_check_pic($tbl, $house_id, $val);
                            $this->admin_check->delete_check_pic_sub($tbl, $house_id, $val);
                        }
                    }
                }
            }***/
            $nowtime = time();
            //ͼƬ
            
            if(isset($pic_check_arr) && is_array($pic_check_arr) 
                    && !empty($pic_check_arr) && $uid > 0)
            {
                $this->load->model('admin_check');
                foreach($pic_check_arr as $key => $val)
                {
                    $infotype = $fields_values['infotype'];
                    $fitment = $fields_values['fitment'];
                    $pic_check_arr[$key]['uid'] = $uid;
                    $pic_check_arr[$key]['housetbl'] = $tbl;
                    $pic_check_arr[$key]['houseid'] = $house_id;
                    $pic_check_arr[$key]['fitment'] = $fitment == "װ" ? 2 : ($fitment == "ë" ? 3 : 1);
                    $pic_check_arr[$key]['infotype'] = $infotype == 3 ? 4 : ($infotype == 4 ? 3 : $infotype);//̡д¥
                    $pic_check_arr[$key]['dateline'] = $nowtime;
                    //˸ҹJOB
                    $this->admin_check->insert_check_pic_sub($pic_check_arr[$key]);
                    //豸ͼƬֻ˿⡢˿
                    if($pic_check_arr[$key]['surface'] == 0 && $pic_check_arr[$key]['from_device'] == 1)
                    {
                        unset($pic_check_arr[$key]);
                    }
                    unset($pic_check_arr[$key]['from_device']);
                    //ͼ˱
                    if($pic_check_arr[$key]['surface'] == 1)
                    {
                        $this->admin_check->insert_check_pic($pic_check_arr[$key]);
                    }
                }
            }
            //жʣͼ жͼ
            $this->load->model('sell_star_model');
            $this->sell_star_model->set_houseinfo($fields_values);
            $is_star_house = $this->sell_star_model->check_star_standard();
            $growthMessage = '';
            if ($is_star_house)
            {
                if ($before_info['isstar'] != 3) {
                    //Դǩļ
                    $gradeLog = $before_info['isstar'] == 3 ? 2 : 1;
                    $ghl  = new GrowthHouseLog();
                    $houseGradeLog = $ghl->findHouseGradeLog($house_id, $tbl, $gradeLog, $uid);
                    if ($houseGradeLog['grade'] == 1)
                    {
                        $gbe  = new GrowthBrokerExp(array('id' => $uid, 'groupid' => $package_id));			
                        $gewp = new GrowthExpWayPackage();
                        $exp = $gewp->findScoreByWayAliasAndPackageId('pStarHouse', $package_id);					 
                        $inExpStatus = $gbe->increase('pStarHouse','ͼԴ',$exp);
                        $ghl->updateHouseGradeLog($house_id, $tbl, 2, $uid);
                        if($inExpStatus['status'] == 2 ){
                            $growthMessage = "ĳɳֵѴֵ";
                        } elseif($inExpStatus['status'] == 1){
                            $growthMessage = "ɳֵ+" . $exp;
                        }
                    }
                    //жԭǷΪͼ
                    if ($before_info['isstar'] != 3)
                    {
                        $this->sell_star_model->set_star();
                    }
                }
            } 
            else 
            {
                //÷ԴΪͼ
                $this->sell_star_model->remove_star(); 
                $this->load->model('sell_tag_model');
                $this->sell_tag_model->set_houseinfo($fields_values);
                //2011-11-30 ͬñǩʧЧ
				$this->sell_tag_model->remove_tag();
                //ȡREAL
                $this->load->model('sell_real_model');
                $this->sell_real_model->set_houseinfo($fields_values);
                $this->sell_real_model->remove_real();
                //ȡ·ֱ
                $this->load->model('sell_nofee_model');
                $this->sell_nofee_model->set_houseinfo($fields_values);
                $this->sell_nofee_model->remove_nofee();
            }
            $page_text = 'Դ޸ĳɹ!' . $growthMessage;
        }
        else 
        {
            $page_text = 'Ǹ޸ķԴϢʧ!';
        }
        //ת֮ǰ޸ĵҳ
        $tab = $this->input->post('tab', true);
        $this->jump($this->sell_model->find_func_url() . $tab, $page_text, 3000);
    }

    /**
     * ɾԴķԴ״̬Ϊɾupdate
     */
    public function delete()
    {
        //delete from  sell where id = 33899521 and uid = 10000040;
        $this->sell_model->delete(33899521, 10000040);
    }
    
    
    /**
     * Դбҳ
     *
     * @access public
     * @param  string $esta Դ״ַ̬
	 * @param  int $page תҳ(תʹ)
     * @return void
     */
    public function manage( $house_esta = 'active' , $page = 1)
    {   
        //post
        $post_param = $this->input->post( NULL , TRUE );
        
        /** ҳ */
        $page = isset($post_param['page']) ? intval($post_param['page']) : intval($page);
		

        $this->_init_pagination($page);
        
        //˺Ϣ
        $uid = $this->user_arr['uid'];//˺
        $package_id = $this->user_arr['package_id'];//ײ

        /*** Ϣ ****/
        $broker_info = array();
        $this->load->model('broker_model');
        $this->broker_model->set_uid($uid);
        $broker_info = $this->user_arr;
        
        //ͻ
        if( isset($broker_info) && isset($broker_info['master']) && $broker_info['master'] != '')
        {
            $broker_info['accout_manager'] = $this->broker_model->get_account_manager($broker_info['master']);
        }
        
        //Դ
        $house = $this->config->item('house');
        $house['roomcategory'] = array( 
                                '1' => 'Ƕͼ' , '2' => 'ͼ', '3' => '', 
                                '4' => 'REAL' , '5' => '·ֱ'
                                );
        //طԴ
        $this->load->model('sell_model');
        $esta_arr = array(); //Դ״̬
        $esta_arr = $this->sell_model->get_house_esta();
        /* 'active' => 1 , 'invalid' => 2 , 'delete' => 4 , 'frozen' => 5 */
        $esta = (isset($house_esta) && isset($esta_arr[$house_esta]) && $house_esta != 'delete' ) ? 
                $esta_arr[$house_esta] : 1 ;
        
        //ѯԴ
        $cond_where = "uid = '".$uid."' AND esta = $esta  AND infofrom = '5' ";
        //ύɵĲѯ
        $cond_where_ext = $this->_get_cond_str($post_param);
        $cond_where .= $cond_where_ext;
        
        //ֶ
        $roomorder = isset($post_param['roomorder']) ? $post_param['roomorder'] : array();
        $order_arr = $this->_get_orderby_arr($roomorder);

        //
        $this->_total_count = $this->sell_model->find_count_by($cond_where);

        //ҳ
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;
        
        //ȡԴ
        $data_info = array ();
        if($this->_total_count > 0 )
        {
            $select_fields = array ('id','ownid','infotype','infofrom','agentcode','uid','esta','district','address',
             'streetid','blockid','isreal','blockshowname','buildyear','buildarea',
              'subfloor','floor','totalfloor','room','hall','toilet','kitchen','balcony',
              'forward','price','averprice','priceterm','pricetype','fitment','contactor',
               'telno','creattime','updatetime','expiretime','isstar','istag','nofee');
            $this->sell_model->set_select_fields($select_fields);
            $data_info = $this->sell_model->find_all_by( $cond_where , $this->_offset ,
                    $this->_limit , $order_arr['order_key'] , $order_arr['order_by'] );
        }
        $row_num =  count($data_info);
          
        //·ֱ
        $this->load->model('sell_nofee_model');
        
        //ԤԼ
        $reserve_info = array();
		$publish_block = array();
        //ضַReal
        $this->load->model('sell_real_model');
        $broker_info['limit_apply_real_num'] = $this->sell_real_model->get_today_apply_num();  
        $broker_info['apply_real_num'] = $this->sell_real_model->apply_real_num_today($uid , 1);
        if( $row_num > 0 )
        {   
            //ظ
            $this->load->helper('common_url');
            $this->load->helper('common_house');
			$this->load->helper('common_string');
            
            //
            $yesterday = date( 'Ymd' , time() - 86400 );
            
            //ʵͳ(ԭмṩͳ)
            $this->load->library( 'statistics');
            
            //ضͼ
            $this->load->model('sell_star_model');

            if( $house_esta == 'active')
            {
                //ˢ־
                $this->load->model('log_refresh');
                
                //ؼ
                $this->load->model('sell_tag_model');
            
                //ԤԼģ
                $this->load->model('reserve_model');
                $this->reserve_model->set_uid($uid);
                
                //Ͷ
                $growthBidPeriods = new GrowthBidPeriods();
                
                //Сר
                $periodsBlockExpert = $growthBidPeriods->currentBidPeriods(1);
                
                //ȡһСרҵȼ
                $bidBlockExpertPeriodsId = $periodsBlockExpert['id'];
                $growthBidBlockExpert = new GrowthBidBlockExpert();

                //˾ͶԴ
                $grow_bid_house_record = new GrowthBidHouseRecordFinish();
                $bidHouseRecord = $grow_bid_house_record->getBidFinishByBorkerId($uid);
            }
			
			if($house_esta == 'active' || $house_esta == 'invalid')
			{
				//ҷС
				$block_fields = array('blockid','blockshowname');
				$this->sell_model->set_select_fields($block_fields);
				$publish_block = $this->sell_model->find_publish_block($uid , $house_esta);
			}


            //᷿Դ
            if( $house_esta == 'frozen')
            {
                $this->load->model('sell_freeze_model');
                $house['freeze_esta'] = $this->sell_freeze_model->get_freeze_esta();
            }

            //ԴϢ
            $house_info = array();
            for( $i = 0 ; $i < $row_num ; $i ++ )
            {   
                //Դַ
                $data_info[$i]['info_url'] =  get_sellinfo_url($data_info[$i]['id']);

				//ԴСַ
				$data_info[$i]['block_url'] =  get_blockinfo_url($data_info[$i]['blockid']);

				//Դַ
				$data_info[$i]['address_str'] =  csubstr($data_info[$i]['address'],60);

				//
				$data_info[$i]['buildarea'] =  strip_end_0($data_info[$i]['buildarea']);

				//۸
				$data_info[$i]['price'] =  strip_end_0($data_info[$i]['price']);

				//¥
				if(empty($data_info[$i]['subfloor']))
				{
					$data_info[$i]['floor_str'] = $data_info[$i]['floor'].'/'.$data_info[$i]['totalfloor']; 
				}
				else
				{
					$data_info[$i]['floor_str'] = $data_info[$i]['subfloor'].'-'.$data_info[$i]['floor'].'/'.$data_info[$i]['totalfloor'];
				}
                
                //Դ޸ĵַ
                $data_info[$i]['modify_url'] =  $this->sell_model->get_modify_house_url($data_info[$i]['id']);
                
                //ǷΪͼԴ
                $this->sell_star_model->set_houseinfo($data_info[$i]);
                $data_info[$i]['is_star_result'] = $this->sell_star_model->is_star();
                
                //Դҳ
                if( $house_esta == 'active')
                {
                    //ǷΪƷԴ
                    $this->sell_tag_model->set_houseinfo($data_info[$i]);
                    $data_info[$i]['is_tag_result'] = $this->sell_tag_model->is_tag();
                    
                    //Ʊ׼
                    if($data_info[$i]['is_tag_result'] === FALSE)
                    {
                        $data_info[$i]['tag_standard'] = $this->sell_tag_model->check_tag_standard();
						$data_info[$i]['house_tag_info'] = array();
						$data_info[$i]['tag_exipire_days'] = '';
                    }
                    else
					{
						//Ʊǩʣ
						$data_info[$i]['house_tag_info'] = $this->sell_tag_model->get_tag_record();

						if(isset($data_info[$i]['house_tag_info']) && !empty($data_info[$i]['house_tag_info']))
						{
							$data_info[$i]['tag_exipire_days'] = 
							$this->sell_tag_model->tag_exipire_days($data_info[$i]['house_tag_info']['expiretime']);
						}
					}	

                    //Ƿ·ֱ
                    $this->sell_nofee_model->set_houseinfo($data_info[$i]);
                    $data_info[$i]['is_nofee_result'] = $this->sell_nofee_model->is_nofee();
                    
                    //·ֱ۱׼
                    if($data_info[$i]['is_nofee_result'] === FALSE)
                    {   
                        $data_info[$i]['nofee_standard'] = $this->sell_nofee_model->check_nofee_standard();
                    }

                    //ǷReal
                    $this->sell_real_model->set_houseinfo($data_info[$i]);
                    $data_info[$i]['is_real_result'] =  $this->sell_real_model->is_real();
                    
                    //REAL׼
                    if($data_info[$i]['is_real_result'] === FALSE)
                    {   
                        $data_info[$i]['real_standard'] = $this->sell_real_model->check_real_standard();
                    }
                    
                    //ˢ´
                    $data_info[$i]['refresh_num'] = 
                    $this->log_refresh->refresh_num_by_id( $data_info[$i]['id'],'sell', $data_info[$i]['updatetime']);
					
                    //ǷɹμӾͶ
                    $data_info[$i]['is_bidhouse_result'] = FALSE;
                    if (is_array($bidHouseRecord) && !empty($bidHouseRecord)) 
                    {
                        foreach($bidHouseRecord as $v) 
                        {   
                            if($v['house_id'] == $data_info[$i]['id'] )
                            {
                                $data_info[$i]['is_bidhouse_result'] = TRUE;
                            }
                        }
                    }

					//ǷھͶԴ
					$periodsHouse = $growthBidPeriods->currentBidPeriods(2);
					if ($periodsHouse['status'] == 1) //Ͷ
					{
						//ȡ˾ͶķԴ
						$growth_bid_house_on = GrowthBidRecordFactory::getRecordClassByTime('house', $periodsHouse['status']);
						$bid_house_on = $growth_bid_house_on->getBidHouseByBrokerId($uid, $periodsHouse['id']);
						if (isset($bid_house_on) && !empty($bid_house_on)) {
							$bid_house_on = SqlCombinHelper::changeToKeyArray($bid_house_on, 'house_id');
						} else {
							$bid_house_on = array(); 
						}
					}

                    //Сרҵȼ
                    /*$memkey = "nj_block_heat_" . $bidBlockExpertPeriodsId . '_' . $data_info[$i]['blockid'];
                    $cache = $this->mc->get($memkey);
                    $blockLevelInfo = array();
                    if ($cache['isok'] == 1 ) 
                    {
                        $blockLevel = $cache['data'];
                    } 
                    else 
                    {
                        $conf = "bid_periods_id = $bidBlockExpertPeriodsId AND block_id=".$data_info[$i]['blockid'];
                        $blockLevelInfo = $growthBidBlockExpert->findOneBy($conf);
                        $blockLevel = isset($blockLevelInfo['broker_level']) ? 
                                $blockLevelInfo['broker_level'] : '';
                       $this->mc->add($memkey, array('isok'=>1,'data'=>$blockLevel),  3600);
                    }

                    if ( isset($blockLevel) && $blockLevel != '') 
                    {   
                        $bidBlockLevels = rtrim(str_replace('LV', '', $blockLevel), ',');
                        $minBidBlockLevel = min(explode(',', $bidBlockLevels));
                        $data_info[$i]['block_level'] = $minBidBlockLevel;
                    }
                    else 
                    {
                        $data_info[$i]['block_level'] = '';
                    }*/
					//ԴǷھͶ
                    if (isset($bid_house_on) && !empty($bid_house_on) 
                        && isset($bid_house_on[$data_info[$i]['id']])) 
                    {
                        $data_info[$i]['is_bidon_house'] = TRUE;
                    }
                }
                
                //
                $data_info[$i]['exipire_days'] = to_expire_day_new($data_info[$i]['expiretime']);
                
                //յ
               // $data_info[$i]['click_num_y'] = 
                   // $this->statistics->get_fidclickcount( $yesterday , $data_info[$i]['id'] , 'sell');//xue
                 // $data_info[$i]['click_num_y'] = 0;

				 

				$fid_click_count_key = "nj_statistics_get_fidclickcount_new".$yesterday."_sell_".$data_info[$i]['id'];
				//echo $fid_click_count_key;echo "<br/>";
				$fid_click_count = $this->mc->get($fid_click_count_key);
			
				
				if($fid_click_count === false) {
				   $click_id_arr[$i] = $data_info[$i]['id'];
				   $house_key[$data_info[$i]['id']] = $i;
				   //echo "12312";exit();
					
				}else{
				   $data_info[$i]['click_num_y'] = $fid_click_count;
				}




                //var_dump($data_info[$i]['click_num_y']);exit();
                if( $house_esta == 'frozen')
                {
                    //Ϣ
                    $this->sell_freeze_model->set_select_fields(array('id','esta','rowid','reason','freezetime'));
                    $data_info[$i]['freeze_info'] = $this->sell_freeze_model->get_freeze_by_rowid($data_info[$i]['id']);
                }
                
                $arr_rowid[] = $data_info[$i]['id'];
            }
            
            //ѯԴԤԼ
            if( $house_esta == 'active')
            {
                $reserve_info = $this->reserve_model->get_project_by_rowids('sell' , $arr_rowid);
            }
        }



		//ȡԴյ
		if(is_array($click_id_arr)&&!empty($click_id_arr)){

			foreach($click_id_arr as $key=>$value){
				$fids .= $value.",";
			}
			$fids = rtrim($fids,",");
			
			$click_data_str = $this->statistics->getfidsclickcountnew( $yesterday , $fids , 'sell');
			$click_data_str = rtrim($click_data_str,'}');
			$click_data_str = ltrim($click_data_str,'{');
			$click_data_arr = explode(",",$click_data_str);
			
			foreach($click_data_arr as $value){
				$house_click = explode("=",$value);
                $click_house_id= trim($house_click[0]);
				$click_house_num= trim($house_click[1]);
				//Դݵı
                $iid = $house_key[$click_house_id];				
				$data_info[$iid]['click_num_y'] = $click_house_num;
				$fid_click_count_key = "nj_statistics_get_fidclickcount_new".$yesterday."_sell_".$click_house_id;
				//echo $fid_click_count_key;echo "<br/>";
			    $this->mc->set($fid_click_count_key,$click_house_num,6000);	
			}

		}

		
		


        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }
        
        /*** ˽ʹͳ ***/
        $statistic_data = array();
        $this->load->model('statistics_model' ,'stat');
        $this->load->model('broker_package_model','broker_package');
        //ײͷԴ
        $post_limit = intval($this->user_arr['postlimit']);
        //
        $statistic_data['sell_count'] = $this->stat->sellCount($uid);
        //
        $statistic_data['rent_count'] = $this->stat->rentCount($uid);
        $house_count = $statistic_data['sell_count'] + $statistic_data['rent_count'];

		//ǰͼ
        $statistic_data['sellCountStar'] = $this->stat->sellCountStar($uid);
        $statistic_data['rentCountStar'] = $this->stat->rentCountStar($uid);
		
        //ʣײ
        $statistic_data['package_valid_num_limit'] = $post_limit > $house_count ? 
                $post_limit - $house_count : 0;
        $package_info = array();
        $package_info = $this->broker_package->find_by_id($package_id);
		$broker_info['package_info'] = $package_info;
        //
        $statistic_data['package_stock_num'] = $package_info['package_stock_num'];
        //ǰ淿Դ
        $statistic_data['stock_house_num'] = $this->broker_model->stock_house_num();
        //ʣ
        $statistic_data['package_stock_num_limit'] = 
        $statistic_data['package_stock_num'] >=  $statistic_data['stock_house_num']?
        $statistic_data['package_stock_num'] - $statistic_data['stock_house_num'] : 0;

        //ˢ
        $statistic_data['refresh_limit'] = $this->stat->refreshNumber($package_id);
        $statistic_data['refresh_today'] = $this->stat->refreshNumberToday($uid);
        $this->load->model('reserve_model');
        //ԤԼδִи
        $statistic_data['refresh_not_do'] = $this->reserve_model->get_reserve_remain_num();
        if ($statistic_data['refresh_not_do'] >= $statistic_data['refresh_limit']) 
        {
            $statistic_data['refresh_not_do'] = $statistic_data['refresh_limit'] - $statistic_data['refresh_today'];
        }
        //˴߼ΪԤԼδִִ֮͵ˢ
        $need2reserveRefreshNum = $statistic_data['refresh_limit'] - $statistic_data['refresh_today'];
        $statistic_data['refresh_not_do'] = $statistic_data['refresh_not_do'] >= $need2reserveRefreshNum ? $need2reserveRefreshNum : $statistic_data['refresh_not_do'];
        $statistic_data['refresh_remain'] = $statistic_data['refresh_limit'] - $statistic_data['refresh_today'] - $statistic_data['refresh_not_do'];
        $statistic_data['refresh_remain'] = $statistic_data['refresh_remain'] > 0 ? $statistic_data['refresh_remain'] : 0;

        //Ʊǩʹ

        if($package_info['package_tag_num'] > 0)
        {
			
            $statistic_data['tag_limit'] = $this->stat->jtLabelNumber($package_id);
			
            $statistic_data['tag_count_today'] = $this->stat->jtLabelCount($uid);


            $statistic_data['tag_remain'] = $statistic_data['tag_limit'] > $statistic_data['tag_count_today'] ? $statistic_data['tag_limit'] - $statistic_data['tag_count_today'] : 0;
        }
        else
        {
            $statistic_data['tag_limit'] = '--';
            $statistic_data['tag_count_today'] = '--';
            $statistic_data['tag_remain'] = '--';
        }

        //·ֱ
        if($broker_info['nofee_num'] > 0)
        {
            $statistic_data['nofee_limit'] = $this->sell_nofee_model->get_nofee_num_limit($uid);
            $statistic_data['nofee_today'] = $this->sell_nofee_model->get_nofee_num_by_uid($uid);
            $statistic_data['nofee_limit'] = $statistic_data['nofee_limit'] > $statistic_data['nofee_today'] ?
            $statistic_data['nofee_limit'] - $statistic_data['nofee_today'] : 0;
        }
        else
        {
            $statistic_data['nofee_limit'] = '--';
            $statistic_data['nofee_today'] = '--';
            $statistic_data['nofee_limit'] = '--';
        }

        //Real
        if($broker_info['real_limit'] > 0)
        {
            $statistic_data['real_limit'] = $this->stat->real_num_limit($uid);
            $statistic_data['real_today'] = $this->stat->real_num_today($uid);
            $statistic_data['real_remain'] = $statistic_data['real_today'] <= $statistic_data['real_limit'] ? 
            $statistic_data['real_limit'] - $statistic_data['real_today'] : 0 ;
        }
        else
        {
            $statistic_data['real_limit'] = '--';
            $statistic_data['real_today'] = '--';
            $statistic_data['real_remain'] = '--';
        }

		//᷿Դ
		$cond_where_forzen = "uid = '".$uid."' AND esta = 5  AND infofrom = '5'";
		$statistic_data['forzen_house_num'] = $this->sell_model->find_count_by($cond_where_forzen);
        /*** ˽ʹͳƽ ***/
        
        //˽ˢ³ɳֵ
        $growthExpDayCount = new GrowthExpDayCount();
        $refreshEventArray = array('refreshHouse');
        $exp_rank_day = $growthExpDayCount->getExpAndRank($uid, $refreshEventArray);
        $statistic_data['growthDaySum'] = $exp_rank_day['exp'];
        //ǰõΰٷֱ
        $statistic_data['rankRate'] = $exp_rank_day['rate'];
        
        /** ҳʼ */
        $data['page_title'] = 'Դ-';


		// 2015-7-9 Ӷ᷿ԴͼƬcss-jsʽ  ----start ---->
      
		$data['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/autocomlete.css');

		$data['js'] = load_js('zsb/js/v1.0/js2.js,zsb/js/v1.0/cp.js,common/js/swf/swfupload.js,'
                . 'zsb/js/v1.0/upload_real.js');   //ҪصJS
      

		// 2015-7-9 Ӷ᷿ԴͼƬcss-jsʽ  ----end ---->
		
        $data['house']  = $house;
        $data['post_param']  = $post_param;
		$data['publish_block']  = $publish_block;
        $data['data_info']  = $data_info;
        $data['reserve_info']  = $reserve_info;
        $data['broker_info']  = $broker_info;
        $data['statistic_data']  = $statistic_data;//ʹͳ
        $data['upload_pic_url'] = $this->config->item('base_url') . 'pic/common/';
        $data['documentation'] = $this->config->item('documentation');//ĵ
        $data['page']  = $this->_current_page;
        $data['pagination'] = $pagination;
        $data['total_count'] = $this->_total_count;
		switch ($house_esta){
			case 'active' :
				$ga_title = 'Դ';
				break;
			case 'invalid' :
				$ga_title = 'ʧЧԴ';
				break;
			case 'frozen' :
				$ga_title = 'Υ淿Դ';
				break;
		}
		$data['google_analytics'] = get_ga_js_code('/Դ//'.$ga_title.'/');
        //
        $this->load->library('guide');
        $data['guide_show'] = $this->guide->check_guide($uid, 'zsb_refresh');
        
		// 2016-1-15 Ǽ -----------start -------->
		$uid = $this->user_arr['uid'];
		
		$this->load->model('broker_zhou_model');
		
		$data['broker_new_info'] =$this->broker_zhou_model->get_broker_info_by_uid($uid);
		//print_r($data_page);die;
		// 2016-1-15 Ǽ -----------end -------->
		
		// 2016-2-15 ȡ360ҳ -----------start -------->
		$data['broker_remind_set'] =$this->broker_zhou_model->get_broker_remind_set_by_uid($uid);
		
		// 2016-2-15 ȡ360ҳ -----------end -------->

        //ģ
        $template_name = $esta == 1 ? 'sell_manage_zhou' : 'sell_manage_'.$house_esta.'_zhou';
		
		//echo $template_name;die;
        $this->view( 'house_manage' , $template_name , $data);
    }
    
    
    /* бҳԴ
     * @param   string $actiontype 
     * @param   string $rowid_str Դ
     * @param   int $page ҳ
     * @param   string $referer תҳ
    */
    public function do_action()
    {   
		die("ddd");
        //
        $actiontype = $this->input->post( 'actiontype' , TRUE );
        
        //Դ
        $rowid_str = $this->input->post( 'actionid' , TRUE );
        $rowid = $this->input->post( 'rowid' , TRUE );
        
        //ǰҳ
        $page = $this->input->post( 'pg' , TRUE );
        
        //תַ
        $referer = $this->input->post( 'referer' , TRUE );
        $referer = (isset($referer) && $referer != '')  ? $referer : $_SERVER['HTTP_REFERER'];
        
        //ԴַתΪ
        $arr_id = explode( ',' , $rowid_str );
        
        //˺uid
        $uid = $this->user_arr['uid'];
        //ŵ˺
        $agentcode = $this->user_arr['agentcode'];
        
        //Դ
        $tbl = 'sell';
        
        //ַ
        switch ($actiontype) 
        {
            case 'invalid_house':
                $invalid_num = 0;
                
                //ʼԴ
                $this->load->model('sell_operate_model');
                
                /*** 1ʧЧԴ ***/
                $invalid_num = $this->sell_operate_model->invalid_house($arr_id);
                if( $invalid_num > 0 )
                {   
                    //мͳ
                    $this->load->library('statistics');
                    
                    //طԴ
                    $this->load->model('sell_tag_model');
                    
                    //Real
                    $this->load->model('sell_real_model');
					
                    //ŵ
                    $this->load->model('agency_model');
                    $relation_info = array();
                    $relation_info = $this->agency_model->get_relation_by_agentcode($agentcode);
                    $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
                    $parentcode = '';
                    if( is_array($relation_info) && !empty($relation_info))
                    {	 
                        $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
                    }
                    else
                    {	
                        $parentinfo = array();
                        $select_array = array('parentcode');
                        $this->agency_model->set_select_fields($select_array);
                        $parentinfo = $this->agency_model->get_company_info_by_code($agentcode);
                        $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
                    }
                    
                    foreach( $arr_id as $rowid )
                    {   
                        /*** 2ʧЧǩReal ****/
                        $house_info = array('id'=> $rowid);
                        $this->sell_tag_model->set_houseinfo($house_info);
                        $this->sell_tag_model->remove_tag();
                        
                        $this->sell_real_model->set_houseinfo($house_info);
                        $this->sell_real_model->remove_real();
                        
                        /*** 3ȡԤԼˢ ***/
                        $this->load->model('reserve_model');
                        $result = $this->reserve_model->delete_projecthouse($uid , $tbl , $rowid);
                        
                        /*** 4ͨӿύ־мoperatetype 1: 2ˢ 3ɾ 4ʧЧ 5ٷ ***/
                        $msg = 4;
                        $this->statistics->sub_operatecount( $uid , $agentcode , $msg , $rowid , '' , $tbl , $domain , $parentcode );
						
                        /*** 5ύԴ־MYSQL(־ѯ),[$msg:4-ʧЧԴ] ***/
                        $this->sell_model->action_log( $agentcode , $uid , $tbl , $rowid , $msg);
                    }
                    $page_text = 'ɹʧЧ'.$invalid_num.'Դ';
                }
                else
                {
                    $page_text = 'ʧЧԴʧ';
                }
                break;
            case 'multi_delete_house':
                $delete_num = 0;
                
                //ʼԴ
                $this->load->model('sell_operate_model');
                
                /*** 1ɾԴ ***/
                $delete_num = $this->sell_operate_model->delete_house($arr_id);
                if( $delete_num > 0 )
                {   
                    //мͳ
                    $this->load->library('statistics');
                    
                    //ŵ
                    $this->load->model('agency_model');
                    $relation_info = array();
                    $relation_info = $this->agency_model->get_relation_by_agentcode($agentcode);
                    $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
                    $parentcode = '';
                    if( is_array($relation_info) && !empty($relation_info))
                    {	 
                        $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
                    }
                    else
                    {	
                        $parentinfo = array();
                        $select_array = array('parentcode');
                        $this->agency_model->set_select_fields($select_array);
                        $parentinfo = $this->agency_model->get_company_info_by_code($agentcode);
                        $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
                    }
                    
                    foreach( $arr_id as $rowid )
                    {   
                        $tbl = 'sell';
                        /*** 4ͨӿύ־мoperatetype 1: 2ˢ 3ɾ 4ʧЧ 5ٷ ***/
                        $this->statistics->sub_operatecount( $uid , $agentcode , 3 , $rowid , '' , $tbl , $domain , $parentcode );
                        
                        /*** 5ύԴ־MYSQL(־ѯ),[$msg:4-ʧЧԴ] ***/
                        $this->sell_model->action_log( $agentcode , $uid , $tbl , $rowid , 0);
                    }
                    $page_text = 'ɹɾ'.$delete_num.'Դ';
                }
                else
                {
                    $page_text = 'ɾ˷Դʧܡ';
                }
                break;    
            case 'refresh':
                if(is_array($arr_id) && !empty($arr_id) )
                {
                    $errornum = 0;
                    
                    //ˢºļ
                    $this->load->helper('common_house');
                    
                    //ײID
                    $package_id = $this->user_arr['package_id'];
                    
                    //ˢ
                    $package_info = array();
                    $this->load->model('package_base_model');
                    $this->package_base_model->set_select_fields(array('package_refresh_num'));
					$package_info = $this->package_base_model->find_by_id($package_id);
                    $refresh_limit =  intval($package_info['package_refresh_num']);

                    //ˢ
                    $this->load->model("log_refresh");
                    $refreshnum = $this->log_refresh->findTodayNumberByBrokerId($uid);



                    //ˢ  xue modify 2015-04-10 
					if(count($arr_id)==1){
					    $cb = refresh_house( $uid ,$tbl , $arr_id[0]);                        
                        if( trim($cb) == 'error')
                        {
                            $errornum ++ ;
                            unset( $arr_id[$key] );
                        }
                        else
                        {   
                            $msg = 7;/*** ύԴ־MYSQL(־ѯ),[$msg:7-ˢ·Դ] ***/
                            $this->sell_model->action_log( $agentcode , $uid , $tbl , $arr_id[0] , $msg);
                        }
					}else{
                        //ˢ
						foreach( $arr_id as $key => $value ){
							$house_ids .= $value.",";
							
						}
                        $house_ids = rtrim($house_ids,",");

                        $cb = refresh_house_s($uid,$tbl,$house_ids);
						$cb = json_decode($cb,true);
						if(is_array($cb['data'])&&!empty($cb['data'])){
							foreach($cb['data'] as $key=>$val){
							   if( $val['status'] == -1){
									$errornum ++ ;
									unset( $arr_id[$key] );
								}
								else
								{   
									$msg = 7;/*** ύԴ־MYSQL(־ѯ),[$msg:7-ˢ·Դ] ***/
									$this->sell_model->action_log( $agentcode , $uid , $tbl , $val['hid'] , $msg);
								}							
							}
						
						
						}
					
					}

					//modify xue end

                    
                    $errornum = intval($errornum);
                    $sum = count($arr_id);
                    
                    //˳ɳϵ
                    if( $sum > 0 )
                    {   
                        $arrBroker = array(
                            'id' => $uid,
                            'groupid' => $package_id,
                        );
                        
                        $ctime = date('Y-m-d');
						//ɳֵ
                        $gbe  = new GrowthBrokerExp($arrBroker);		
                        $gewp = new GrowthExpWayPackage();
						$exp = 0;	
                        $exp = $gewp->findScoreByWayAliasAndPackageId('refreshHouse',$package_id);

                        if( $sum > 1)
                        {
							$log_tip = 'ˢ·Դ';
							$exp = $exp * $sum;
                        }
                        else
                        {
							$log_tip = 'ˢµԴ';
                        }
                        $inExpStatus = $gbe->increase('refreshHouse' , $log_tip ,$exp);
                        
                        if($inExpStatus['status'] == 2)
                        {
                            $growthMessage = "<div style='text-align:center;margin:0px 10px;'>"
                                    . "ĳɳֵѴֵ</div>";
                        }
                        else if($inExpStatus['status'] == 1)
                        {
                            $growthMessage = "<div style='text-align:center;margin:0px 10px;'>"
                                    . "ɳֵ+".$exp."</div>";
                        }
                        
                        //ˢ
                        $this->load->model('log_refresh');
                        $this->log_refresh->findTodayNumberByBrokerId( $uid , 1);
                    }
                    
                    //ʣˢ
                    $refresh_left = 0;
                    $refresh_left = intval($refresh_limit) - intval($refreshnum) - intval($sum) ;
                    if( $sum > 0 && $errornum == 0) 
                    {   
                        $page_text = 'ɹˢ'.$sum.'Դ';
                        $page_text .= "ʣˢ".$refresh_left."Ρ";
                        $page_text .= $growthMessage;
                    }
                    else if($sum > 0 && $errornum > 0)
                    {
                        $page_text = 'ɹˢ'.$sum.'Դ';
                        $page_text .= "ʣˢ".$refresh_left."Ρ";
                        $page_text .= $growthMessage;
                    }
                    else if ($sum == 0 && $errornum > 0 && $refresh_left > 0) 
                    {
                        $page_text = "ԲѡķԴˢ´Ѿﵽޡ";
                    }
                    else if($sum == 0 && $errornum > 0)
                    {
                        $page_text = 'Բˢ³';
                    }
                    else
                    {
                        $page_text = 'ˢʧ';
                    }
                }
                break;
            }

            $this->jump( $referer , $page_text , 1000);
    }
    
    
    /**
     * üƷԴ
     */
    public function house_tag_set()
    {   
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
		
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        
        //֤Դźύ֤
        if( intval($rowid) > 0 && md5('HOUSE365_TAG_SET_'.$rowid) == $secret_key )
        {
            //˺uid
			
            $uid = $this->user_arr['uid'];
			
            //ʼԴ
            $this->load->model('sell_model');
            $houseinfo = array();
            $houseinfo = $this->sell_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {
                //طԴ
                $this->load->model('sell_tag_wang_model');
                $this->sell_tag_wang_model->set_houseinfo($houseinfo);

                //˷ԴǷüƷԴı׼
                $result = $this->sell_tag_wang_model->check_tag_standard();

                if( isset($result) && $result['is_ok'] == 1 )
                {
                    $set_result = $this->sell_tag_wang_model->set_tag();
                    
                    if($set_result)
                    {
                        $result['is_ok'] = 1;
                        $result['msg'] = 'ǩóɹ';
                        
                        //ñǩ
                        $this->load->model('statistics_model');
                        $this->statistics_model->jtLabelCount( $uid , 1);
                    }
                    else
                    {
                        $result['is_ok'] = 0;
                        $result['msg'] = 'ǩʧ';
                    }
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * ·ֱ
     */
    public function house_nofee_set()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        
        //֤Դźύ֤
        if( intval($rowid) > 0 && md5('HOUSE365_NOFEE_SET_'.$rowid) == $secret_key )
        {   
            //˺uid
            $uid = $this->user_arr['uid'];

            //ʼԴ
            $this->load->model('sell_model');
            $houseinfo = array();
            $houseinfo = $this->sell_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo))
            {
                //طԴ
                $this->load->model('sell_nofee_model');
                $this->sell_nofee_model->set_houseinfo($houseinfo);

                //˷ԴǷüƷԴı׼
                $result = $this->sell_nofee_model->check_nofee_standard();

                if( isset($result) && $result['is_ok'] == 1 )
                {
                    $set_result = $this->sell_nofee_model->set_nofee();
                    
                    if($set_result)
                    {
                        $result['is_ok'] = 1;
                        $result['msg'] = '·ֱ۱ǩóɹ';
                    }
                    else
                    {
                        $result['is_ok'] = 0;
                        $result['msg'] = '·ֱ۱ǩʧ';
                    }
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * REAL
     */
    public function house_real_set()
    {
        $after = $this->input->post( 'after' , TRUE );
        $p_filename = $this->input->post( 'p_filename' , TRUE );
        $pic_title = $this->input->post( 'pic_title' , TRUE );
        //֤ʽ 0 
        $pic_type = $this->input->post( 'pic_type' , TRUE );
        
        //Դ
        $rowid = $this->input->post( 'rowid' , TRUE );
        $secret_key = $this->input->post( 'secret_key' , TRUE );
        $result = array();
        
        //֤Դźύ֤
        if( intval($rowid) > 0 && md5('HOUSE365_REAL_SET_'.$rowid) == $secret_key )
        {   
            //˺uid
            $uid = $this->user_arr['uid'];
            $isreal = $this->user_arr['isreal'];
            
            //ж
            if( $isreal == '1' || $pic_title != '' || !empty($p_filename) )
            {
                //ʼԴ
                $this->load->model('sell_model');
                $houseinfo = array();
                $houseinfo = $this->sell_model->find_by_id($rowid);

                if( is_array( $houseinfo ) && !empty($houseinfo) )
                {   
                    //طԴ
                    $this->load->model('sell_real_model');
                    $this->sell_real_model->set_houseinfo($houseinfo);

                    //˷ԴǷüƷԴı׼
                    $result = $this->sell_real_model->check_real_standard();
                    if( isset($result) && $result['is_ok'] == 1 )
                    {   
                        if(is_array($pic_type) && !empty($pic_type))
                        {
                            if(isset($pic_type[0]) && $pic_type[0] == '1' )
                            {   
                                //ǵڶַʽ÷֤
                                $this->sell_real_model->set_pic_title($pic_title);
                                $this->sell_real_model->set_pic_url($p_filename[0]);
                            }
                            else if( isset($pic_type[0]) && $pic_type[0] == 2)
                            {
                                //ַʽίЭ
                                $this->sell_real_model->set_real_pics($p_filename);
                            }
                        }

                        //REAL
                        $set_result = $this->sell_real_model->set_real();

                        if($set_result)
                        {
                            $result['is_ok'] = 1;
                            $result['msg'] = 'Realóɹ';
                            
                            //REALѴڵREAL¼
                            $this->sell_real_model->apply_real_num_today( $uid , 1);
                            $this->sell_real_model->get_real_num_by_uid( $uid , 1);
                        }
                        else
                        {
                            $result['is_ok'] = 0;
                            $result['msg'] = 'Realʧ';
                        }
                    }
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ԴϢ';  
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'real֮һ';
            }
        }
        else
        {
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }

	 /**
     * ò
     */
    public function noremind_set()
    {

        $uid = $this->input->get( 'uid' , TRUE );
		
        $result = array();

        $this->load->model('broker_zhou_model');
		
		$data =$this->broker_zhou_model->add_remind_record($uid);
       
        if($data)
        {   
            $result['is_ok'] = 1;
            $result['msg'] = 'ҳóɹ';
        }
        else
        {
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }


	 /**
     * 
     */
    public function remind_set()
    {
		$result['is_ok'] = 1;
		$result['msg'] = 'ҳóɹ';
        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }



    
    
    /**
     * üƷԴ
     */
    public function house_tag_cancel()
    {
		
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_TAG_SET_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

            //ʼԴ
            $this->load->model('sell_model');
            $houseinfo = array();
            $this->sell_model->set_select_fields(array('id','uid','esta','istag'));
            $houseinfo = $this->sell_model->find_by_id($rowid);
           
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            { 
                //طԴ
                $this->load->model('sell_tag_wang_model');
                $this->sell_tag_wang_model->set_houseinfo($houseinfo);
				//print_r($this->sell_tag_wang_model);die;
                $set_result = $this->sell_tag_wang_model->remove_tag();
                
                if($set_result)
                {
                    $result['is_ok'] = 1;
                    $result['msg'] = 'ȡǩɹ';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ȡǩʧ';
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * ȡƷԴ
     */
    public function house_nofee_cancel()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_NOFEE_SET_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

            //ʼԴ
            $this->load->model('sell_model');
            $houseinfo = array();
            $this->sell_model->set_select_fields(array('id','uid','esta','istag'));
            $houseinfo = $this->sell_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {
                //طԴ
                $this->load->model('sell_nofee_model');
                $this->sell_nofee_model->set_houseinfo($houseinfo);
                $set_result = $this->sell_nofee_model->remove_nofee();
                
                if($set_result)
                {
                    $result['is_ok'] = 1;
                    $result['msg'] = 'ȡ·ֱ۱ǩɹ';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ȡ·ֱ۱ǩʧ';
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * ȡReal
     */
    public function house_real_cancel()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_REAL_SET_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

            //ʼԴ
            $this->load->model('sell_model');
            $houseinfo = array();
            $this->sell_model->set_select_fields(array('id','uid','esta','istag'));
            $houseinfo = $this->sell_model->find_by_id($rowid);
            
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {
                //طԴREAL
                $this->load->model('sell_real_model');
                $this->sell_real_model->set_houseinfo($houseinfo);
                $set_result = $this->sell_real_model->remove_real();
                
                if($set_result)
                {
                    $result['is_ok'] = 1;
                    $result['msg'] = 'ȡREALɹ';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ȡREALʧ';
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
   
    /**
     * Դ
     */
    public function active_house()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_ACTIVE_HOUSE_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];
            $package_id = $this->user_arr['package_id'];
			$agentcode = $this->user_arr['agentcode'];
            
            $this->load->model('broker_model');
            $this->load->model('package_model');
            $package = $this->package_model->find_by_id($package_id);
            
			//2016-2-25 zhouظԴ -------- start ------------>
			$re_houseinfo = $this->sell_model->find_by_id($rowid);
			
			$blockid =$re_houseinfo['blockid'];
			$this->load->model('block_zhou_model');

			$block_remove_limit_num = $this->block_zhou_model->get_block_remove_info_by_blockid($blockid);
			if($block_remove_limit_num)
			{
				$publish_limit_num =$block_remove_limit_num;
			}
			else
			{
				$publish_limit_num =2;
			}
			
			$price_start		=$re_houseinfo['price']*0.95;
			$price_end  		=$re_houseinfo['price']*1.05;

			$buildarea_start	=$re_houseinfo['buildarea']-0.5;
			$buildarea_end		=$re_houseinfo['buildarea']+0.5;
			$room				=$re_houseinfo['room'];
			$hall				=$re_houseinfo['hall'];
			$toilet				=$re_houseinfo['toilet'];

			$subfloor			=$re_houseinfo['subfloor'];
			$floor				=$re_houseinfo['floor'];
			$totalfloor			=$re_houseinfo['totalfloor'];



			//ѯԴ
			$cond_where = "uid = '".$uid."' AND esta = 1  AND infofrom = '5' and blockid ='$blockid' and subfloor='$subfloor'  and floor='$floor' and totalfloor='$totalfloor' and room='$room' and hall='$hall' and toilet='$toilet' and '$buildarea_start' < buildarea < '$buildarea_end' and '$price_start' < price < '$price_end' ";

			
			

			//
			$broker_publish_total_count = $this->sell_model->find_count_by($cond_where,'1');
			
			if($broker_publish_total_count>=$publish_limit_num)
			{

			
				$broker_publish_data_info = $this->sell_model->find_all_by($cond_where);
				
				if(count($broker_publish_data_info)>$publish_limit_num)
				{
					$show_limit_num =$publish_limit_num;
				
				}
				else
				{
					$show_limit_num =count($broker_publish_data_info);
				}
				$str_show ="";
				for($i =0;$i<$show_limit_num;$i++)
				{
					$str_show .=$broker_publish_data_info[$i]['id'].',';
				}

				$str_show =rtrim($str_show,',');
				$result['is_ok'] = 5;
                $result['msg'] = '˷Դ뷿Դ '.$str_show . 'ظֹظԴ';
				$result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
				print_r(json_encode($result));
       
				exit;
			
			}
		

			//2016-2-25 zhouظԴ -------- end ------------>

            //жԴԴǷз񳬹
            $valid_house_num = $this->broker_model->valid_house_num();
            if($valid_house_num < $package["package_valid_num"])
            {
                //ʼԴ
                $this->load->model('sell_model');
                $houseinfo = array();
                $this->sell_model->set_select_fields(array('id','esta'));
                $houseinfo = $this->sell_model->find_by_id($rowid);

                if( is_array( $houseinfo ) && !empty($houseinfo)    )
                {
                    //طԴ
                    $this->load->model('sell_operate_model'); 
                    $set_result = $this->sell_operate_model->active_house($rowid);

                    if($set_result)
                    {	
                        //ŵ
                        $this->load->model('agency_model');
                        $relation_info = array();
                        $relation_info = $this->agency_model->get_relation_by_agentcode($agentcode);
                        $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
                        $parentcode = '';
                        if( is_array($relation_info) && !empty($relation_info))
                        {	 
                            $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
                        }
                        else
                        {	
                            $parentinfo = array();
                            $select_array = array('parentcode');
                            $this->agency_model->set_select_fields($select_array);
                            $parentinfo = $this->agency_model->get_company_info_by_code($agentcode);
                            $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
                        }

                        $tbl = 'sell';
						/***ύԴ־MYSQL(־ѯ),[$msg:3-Դٷ] ***/
						$this->sell_model->action_log( $agentcode , $uid , $tbl , $rowid , 3);

                        //мͳ
                        $this->load->library('statistics');
                        /***ͨӿύ־мoperatetype 1: 2ˢ 3ɾ 4ʧЧ 5ٷ ***/
                        $this->statistics->sub_operatecount( $uid , $agentcode , 5 , $rowid , '' , $tbl , $domain , $parentcode );

                        $result['is_ok'] = 1;
                        $result['msg'] = 'Դɹ';
                    }
                    else
                    {
                        $result['is_ok'] = 0;
                        $result['msg'] = 'Դʧ';
                    }
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ԴϢ';  
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'Դ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * ɾԴ
     */
    public function delete_house()
    {
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        $result = array();
        
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_DELETE_HOUSE_'.$rowid) == $secret_key )
        {
            //˺uid
            $uid = $this->user_arr['uid'];

			//ŵ˺
			$agentcode = $this->user_arr['agentcode'];

            //ʼԴ
            $this->load->model('sell_model');
            $houseinfo = array();
            $this->sell_model->set_select_fields(array('id','esta'));
            $houseinfo = $this->sell_model->find_by_id($rowid);
           
            if( is_array( $houseinfo ) && !empty($houseinfo)    )
            {	
                //طԴ
                $this->load->model('sell_operate_model'); 
                $set_result = $this->sell_operate_model->delete_house($rowid);
				
                if($set_result)
                {	
                    //ŵ
                    $this->load->model('agency_model');
                    $relation_info = array();
                    $relation_info = $this->agency_model->get_relation_by_agentcode($agentcode);
                    $domain = isset($relation_info['cat_id']) ? $relation_info['cat_id'] : 0;
                    $parentcode = '';
                    if( is_array($relation_info) && !empty($relation_info))
                    {	 
                        $parentcode = isset($relation_info['parentcode']) ? $relation_info['parentcode'] : '';
                    }
                    else
                    {	
                        $parentinfo = array();
                        $select_array = array('parentcode');
                        $this->agency_model->set_select_fields($select_array);
                        $parentinfo = $this->agency_model->get_company_info_by_code($agentcode);
                        $parentcode = isset($parentinfo['parentcode']) ? $parentinfo['parentcode'] : '';
                    }

                    $tbl = 'sell';
                    //мͳ
                    $this->load->library('statistics');
                    /***ͨӿύ־мoperatetype 1: 2ˢ 3ɾ 4ʧЧ 5ٷ ***/
                    $this->statistics->sub_operatecount( $uid , $agentcode , 3 , $rowid , '' , $tbl , $domain , $parentcode );

                    /***ύԴ־MYSQL(־ѯ),[$msg:0-ɾԴ] ***/
                    $this->sell_model->action_log( $agentcode , $uid , $tbl , $rowid , 0);

                    $result['is_ok'] = 1;
                    $result['msg'] = 'ɾԴɹ';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ɾԴʧ';
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'ԴϢ';  
            }
        }
        else
        {   
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * Դ
     */
    function house_appeal()
    {   
        //Դ
        $rowid = $this->input->get( 'rowid' , TRUE );
        $reason = $this->input->get( 'reason' , TRUE );
        $secret_key = $this->input->get( 'secret_key' , TRUE );
		
		$p_filenames = $this->input->get( 'p_filenames' , TRUE );
		
	
		$pics_arr =explode(',',substr($p_filenames,0,strlen($p_filenames)-1));
		
        $result = array();
        //֤Դźύ֤
        if( intval($rowid) > 0  &&  md5('HOUSE365_SELL_APPEAL_'.$rowid) == $secret_key )
        {
            if ( $reason != "" ) 
            {
                $data_info = array(); $data_pic_info = array();
                $reason = urldecode($reason);
                $data_info['appeal'] = iconv( "UTF-8" , "GBK" , $reason);
                $data_info['appealtime'] = time();
                $data_info['esta'] = 2;
				$data_pic_info['pics_arr']= $pics_arr;
				//$data_pic_info['titles_arr']= $titles_arr;
			
                $this->load->model('Sell_freeze_zhou_model');
                $app_result = FALSE;
                $app_result = $this->Sell_freeze_zhou_model->house_appeal ( $rowid , $data_info);
				
				if(is_array($pics_arr) &&  $pics_arr[0])
				{
					$pic_result = FALSE;
					$pic_result = $this->Sell_freeze_zhou_model->house_pic_insert ( 'sell',$rowid , $data_pic_info);
				}
				else
				{
					$pic_result = $this->Sell_freeze_zhou_model->house_pic_delete ('sell',$rowid);
					$pic_result = TRUE;
				}
                if($app_result && $pic_result)
                {
                    $result['is_ok'] = 1;
                    $result['msg'] = 'ύɹԱһʱ䴦';
                }
                else
                {
                    $result['is_ok'] = 0;
                    $result['msg'] = 'ύʧܣµͷ'; 
                }
            }
            else
            {
                $result['is_ok'] = 0;
                $result['msg'] = 'д';
            }
        }
        else
        {
            $result['is_ok'] = 0;
            $result['msg'] = ''; 
        }
        
        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * ݱύȡѯ
     */
    private function _get_cond_str( $form_param )
    {   
        $cond_where = '';
        
        //Դ
        if( isset($form_param['infotype']) && !empty($form_param['infotype']) )
        {
           $cond_where .= " AND infotype = '".intval($form_param['infotype'])."'";
        }
        
        //Դ۸
        if ( isset($form_param["price_sell"]) && !empty($form_param["price_sell"]) ) 
        {   
            switch($form_param["price_sell"])
            {
                case 1:	
                    $cond_where .= " AND price <= '40' ";
                    break;
                case 2:
                    $cond_where .= " AND price > '40' and price <= '60' ";
                    break;
                case 3:
                    $cond_where .= " AND price > '60' and price <= '90' ";
                    break;
                case 4:
                    $cond_where .= " AND price > '90' and price <= '120' ";
                    break;
                case 5:
                    $cond_where .= " AND price > '120' and price <= '150' ";
                    break;
                case 6:
                    $cond_where .= " AND price > '150' and price <= '200' ";
                    break;
                case 7:
                    $cond_where .= " AND price > '200' and price <= '300' ";
                    break;
                case 8:
                    $cond_where .= " AND price > '300' and price <= '500' ";
                    break;
                case 9:
                    $cond_where .= " AND price > '500'";
                    break;
            }       
        }
        
        //
        if (isset($form_param["buildarea"]) && !empty($form_param["buildarea"])) 
        {
            switch($form_param["buildarea"])
            {
                case 1:	
                    $cond_where .= " AND buildarea <= '40' ";
                    break;
                case 2:
                    $cond_where .= " AND buildarea > '40' AND buildarea <= '60' ";
                    break;
                case 3:
                    $cond_where .= " AND buildarea > '60' AND buildarea <= '80' ";
                    break;
                case 4:
                    $cond_where .= " AND buildarea > '80' AND buildarea <= '100' ";
                    break;
                case 5:
                    $cond_where .= " AND buildarea > '100' AND buildarea <= '120' ";
                    break;
                case 6:
                    $cond_where .= " AND buildarea > '120' AND buildarea <= '144' ";
                    break;
                case 7:
                    $cond_where .= " AND buildarea > '144'  AND  buildarea <= '200' ";
                    break;
                case 8:
                    $cond_where .= " AND buildarea > '200'  AND  buildarea <= '400' ";
                    break;
                case 9:
                    $cond_where .= " AND buildarea > '400' ";
                    break;
            }       
        }
        
        //
        if (isset($form_param['roomtype']) && !empty($form_param['roomtype'])) 
        {
            switch ($form_param['roomtype']) 
            {
              case 1:
                    $cond_where .= " AND  room = '1'";
                    break;
              case 2:
                    $cond_where .= " AND   room = '2' ";
                    break;
              case 3:
                    $cond_where .= " AND  room = '3' ";
                    break;
              case 4:
                    $cond_where .= " AND  room = '4' ";
                    break;
              case 5:
                    $cond_where .= " AND  room >= '5' ";
                    break;
            }
        }
        
        //ؼ
        if (isset($form_param['keywords']) && !empty($form_param['keywords']) && $form_param['k_id']) 
        {   
            $keyword = trim(strip_tags($form_param['keywords']));
            switch ($form_param['k_id']) 
            {
                case 1:
                    $cond_where .= " AND blockshowname LIKE '%".$keyword."%'";
                    break;
                case 2:
                    $cond_where .= " AND id = '".$keyword."'";
                    break;
                case 3:
                    $cond_where .= " AND ownid = '".$keyword."'";
                    break;
            }
        }

		//С
		if (isset($form_param['blockid']) && !empty($form_param['blockid']) && $form_param['blockid'] > 0) 
        {	
			$blockid = intval($form_param['blockid']);
			$cond_where .= " AND blockid = '".$blockid."'";
		}

        //ȫԴ
        if ( isset($form_param['roomcategory']) && !empty($form_param['roomcategory']) ) 
        {
            switch ($form_param['roomcategory']) 
            {
                case 1:
                    $cond_where .= ' AND  isstar = 0 ';
                    break;
                case 2:
                    $cond_where .= ' AND  isstar = 3 ';
                    break;
                case 3:
                    $cond_where .= ' AND  istag = 1 ';
                    break;
                case 4:
                    $cond_where .= ' AND  isreal = 1 ';
                    break;
                case 5: //·ֱ
                    $cond_where .= ' AND  nofee = 1 ';
                    break;
            }
        }
        return $cond_where;
    }


    //ȡַ
    private function _get_orderby_arr( $order_val ) 
    {   
        $arr_order = array();
        
        switch ($order_val) 
        {
            case 1:
                $arr_order['order_key'] = 'updatetime' ;
                $arr_order['order_by'] = 'DESC';
                break;
            case 2:
                $arr_order['order_key'] = 'updatetime' ;
                $arr_order['order_by'] = 'ASC';
                break;
            case 3:
                $arr_order['order_key'] = 'creattime' ;
                $arr_order['order_by'] = 'DESC';
                break;
            case 4:
                $arr_order['order_key'] = 'creattime' ;
                $arr_order['order_by'] = 'ASC';
                break;
            case 5:
                $arr_order['order_key'] = 'price' ;
                $arr_order['order_by'] = 'ASC';
                break;
            case 6:
                $arr_order['order_key'] = 'price' ;
                $arr_order['order_by'] = 'DESC';
                break;
            case 7:
                $arr_order['order_key'] = 'buildarea' ;
                $arr_order['order_by'] = 'ASC';
                break;
            case 8:
                $arr_order['order_key'] = 'buildarea' ;
                $arr_order['order_by'] = 'DESC';
                break;
            default:
                $arr_order['order_key'] = 'updatetime' ;
                $arr_order['order_by'] = 'DESC';
        }

        return $arr_order;
    }
    

    /**
     * swfuploadϴļ
     */
    public function swf_upload()
    {
        $this->load->view('pic_inc');
    }
}
/* End of file sell.php */
/* Location: ./application/zsb/controllers/sell.php */