<?php
/**
 *۱˻ BrokerCredit
 *Fisher 2012-10-31
**/

class BrokerCredit
{
	var $uid;	//UID
	var $db;	//ݿ
	var $credit_arr = array(
			'plus_open' 	  => array('title'=>'˿ڿͨ',			'sign'=>'+', 'credit'=>200),
			'plus_identity'	  => array('title'=>'֤',			'sign'=>'+', 'credit'=>300),
			'plus_card' 	  => array('title'=>'Ƭ֤',			'sign'=>'+', 'credit'=>200),
			'plus_login' 	  => array('title'=>'¼',				'sign'=>'+', 'credit'=>15),
			'plus_answer' 	  => array('title'=>'ظʴ',			'sign'=>'+', 'credit'=>10),
			'plus_bestanswer' => array('title'=>'Ѵ',			'sign'=>'+', 'credit'=>20),
			'plus_login_mobile'=> array('title'=>'ͻ˵¼',		'sign'=>'+', 'credit'=>50),
			'plus_isstar'	  => array('title'=>'ͼԴ',		'sign'=>'+', 'credit'=>100),
			'plus_isstar_mobile'=> array('title'=>'ͻ˷ͼ',	'sign'=>'+', 'credit'=>200),
			'plus_blockimg'	  => array('title'=>'Сͼ¼',		'sign'=>'+', 'credit'=>200),
			'plus_windowback' => array('title'=>'ַ',		'sign'=>'+', 'credit'=>0),
			'plus_operate'	  => array('title'=>'ϵͳ',			'sign'=>'+', 'credit'=>0),
			'plus_block'	  => array('title'=>'Сר',	'sign'=>'+', 'credit'=>500),
			'plus_birthday'   => array('title'=>'ջȡ',		'sign'=>'+', 'credit'=>2000),
			'plus_refresh_mobile'=> array('title'=>'ͻˢ',	'sign'=>'+', 'credit'=>200),
			'plus_block_supply' => array('title'=>'С()',	'sign'=>'+', 'credit'=>2000),
			'minus_block_supply' => array('title'=>'С()',	'sign'=>'-', 'credit'=>2000),
			'minus_block'	  => array('title'=>'ɹСר',	'sign'=>'-', 'credit'=>500),
			'minus_frozen'	  => array('title'=>'᷿Դ',			'sign'=>'-', 'credit'=>100),
			'minus_window'	  => array('title'=>'չʾͶ',		'sign'=>'-', 'credit'=>0, 'viewcredit'=>-2),
			'minus_operate'	  => array('title'=>'ϵͳ',		'sign'=>'-', 'credit'=>0)
	);

	var $no_settlement = array('plus_open', 'plus_identity', 'plus_card','plus_answer','plus_bestanswer');	//¶ˮĲ
	var $allow_lesszero_arr = array('minus_frozen');	//ʹС0Ĳ

	var $time = 0; //ʱ
	var $brokercredit = 0; //˵ǰ
	var $groupid = 0;	//Ȩ

	/**
	* BrokerCredit 췽
	*
	* @param int $uid
	*/
	function BrokerCredit($uid)
	{
		global $db;
		$this->uid = $uid;
		$this->db = $db;
		$this->time = time();
		$this->groupid = $this->getBrokerGroupid();
	}

	/**
	* dealCredit ˻֣лֲô˷
	*
	* @param str $kind
	* @param arr $params  op_credit,operator,reason/rowid,tbl
	* @return bool
	*/
	function dealCredit($kind, $params = array())
	{

		//Ѿ˵ЧĻֲ
		if( $this->groupid == 1 && isset($this->credit_arr[$kind]) )
		{
			//ʼ
			$credit = $this->credit_arr[$kind]['credit'];
			//ȡײͻ
			$package = $this->getBrokerPackageInfo();

			switch($kind)
			{
				//˵¼ӷ(ÿһ)
				case 'plus_login' :		
				case 'plus_login_mobile':
										$brokerlogintime = $this->getBrokerLoginTimeByKind($kind);	//ȡ¼ʱ
										$credit = date('Ymd') != $brokerlogintime ? $this->credit_arr[$kind]['credit'] : 0;
										break;
				//ֻͻˢ·Դ(ÿһ)
				case 'plus_refresh_mobile' :
										$logtime = $this->getLastCreditLogTimeByKind($kind);
										$credit  = date('Ymd') != $logtime ? $this->credit_arr[$kind]['credit'] : 0;
										break;
                		//ջ
				case 'plus_birthday' :	$birthday = $this->getBrokerBirthday();	//ȡһλȡջʱ
										$credit = date('Ymd') != $birthday ? $this->credit_arr[$kind]['credit'] : 0;
										break;

				//ֶ޸ľ˻
				case 'plus_operate' :
				case 'minus_operate':

				//չʾ
				case 'plus_windowback' :
				case 'minus_window' :	$credit = intval($params['op_credit']);
										break;

				//ͼ
				case 'plus_isstar' :	
				case 'plus_isstar_mobile' :
										$monthisstarcredit = $this->getMonthIsstarCredit();
										//µĶͼԴֳ
										if($monthisstarcredit >= $package['isstar_credit_upper_limit'])
										{
											$credit = 0;
										}
										else
										{
											//ӷֳʱֻӳʱķ
											$tempcredit = $package['isstar_credit_upper_limit'] - $monthisstarcredit;
											$credit = $tempcredit > $credit ? $credit : $tempcredit;
										}
										break;

				//ֻܼӷһ
				case 'plus_open' :		$package['credit_upper_limit'] = 200;
				case 'plus_identity' :
				case 'plus_card' :		$check = $this->getCreditLogByKind($kind);
										$credit = $check > 0 ? 0 : $this->credit_arr[$kind]['credit'];
										break;

				//һֲ
				default :				$credit = $this->credit_arr[$kind]['credit'];
										break;
			}

			//ЧĻֱ仯
			if( $credit > 0 )
			{
				//ʼ˵ǰ
				$this->brokercredit = $this->getBrokerCredit();
				//㾭»
				$new_brokercredit = 0;
				$sign = $this->credit_arr[$kind]['sign'] == '+' ? 1 : -1;
				$new_brokercredit = $sign * $credit + $this->brokercredit;
				//ӷֵ»ִײͻ
				if($sign == 1 && $new_brokercredit > $package['credit_upper_limit'])
				{
					//ǰִײͻ
					if($this->brokercredit > $package['credit_upper_limit'])
					{
						$credit = 0;
					}
					else
					{
						//ӷֳʱֻӳʱķ
						$credit = $package['credit_upper_limit'] - $this->brokercredit;
						$this->brokercredit = $package['credit_upper_limit'];
					}
				}
				//ֲ¾˻ֿɱΪֻ֣ǰ̨ʾ0
				else
				{
					$this->brokercredit = $new_brokercredit;
				}


				//ӷӣֻضʹС0
				if($sign == -1 && $this->brokercredit < 0 && !in_array($kind, $this->allow_lesszero_arr))
				{
					return false;
				}

				//ЧĻֱ仯
				if($credit > 0)
				{
					$this->doCredit($kind, $credit, $params);
					return true;
				}
			}
		}
		return false;
	}

	/**
	* doCredit ִо˻ֲ
	*
	* @param str $kind
	* @param int $credit
	* @param arr $params  operator,reason/rowid,tbl
	*/
	function doCredit($kind, $credit, $params = array())
	{
		$this->addCreditLog($kind, $credit);	//Ӿ˻ˮ˱¼
		$this->updateBrokerCredit($this->brokercredit); //¾˻

		//TRUEʾ¶Ƚв¼ֶ
		$no_settlement = in_array($kind, $this->no_settlement) ? true : false;
		$kind = $kind =='plus_isstar_mobile' ? 'plus_isstar' : $kind;
		$this->updateCreditSettlement($kind, $credit, $no_settlement);	//¾˻¶Ƚ¼

		//ֶ޸ľ˻ֵĲ¼
		if( in_array($kind, array('plus_operate', 'minus_operate')) )
		{
			$this->addCreditOperateLog($kind, $credit, $params['operator'], $params['reason']);
		}
		//Ӿ˷ͼԴӻֵĲ¼
		if($kind == 'plus_isstar')
		{
			$this->addIsstarCreditLog($params['rowid'], $params['tbl']);
		}
	}

	/**
	* getCreditLogByKind Ͳһּ¼
	*
	* @param str $kind
	* @return integer
	*/
	function getCreditLogByKind($kind)
	{
		$kind = trim($kind);
        $num = $this->db->GetOne("select count(*) from log_credit where lc_uid='".$this->uid."' and lc_kind='".$kind."' ");
		return intval($num);
	}


	/**
	* getCreditLogTimeByKind Ͳһּ¼
	*
	* @param str $kind
	* @return integer
	*/
	function getLastCreditLogTimeByKind($kind)
	{
		$kind = trim($kind);
		$log_time = 0;
		$sql = " SELECT lc_time FROM log_credit WHERE lc_uid = '".$this->uid."' AND lc_kind ='".$kind."' ORDER BY lc_time DESC LIMIT 1 ";
        $lc_time = $this->db->GetOne($sql);

		$login_date = date('Ymd', $lc_time);

		return $login_date;
	}


	/**
	* dealCreditWindowback ַ
	*
	* @param int $rowid
	* @param str $tbl
	*/
	function dealCreditWindowback($rowid, $tbl)
	{
		$q = "SELECT keys_integral,	display FROM w_broker_house WHERE rowid='".$rowid."' and uid='".$this->uid."' and tbl='".$tbl."' and esta=1 and credit_type = 1 ";
		$w_arr=$this->db->GetRow($q);
		$backcredit = $w_arr['keys_integral'] + $w_arr['display'] * $this->credit_arr['minus_window']['viewcredit'];
		$backcredit = $backcredit <= 0 ? 0 : $backcredit;

		if($backcredit > 0)
		{
			$this->dealCredit('plus_windowback', array('op_credit'=>$backcredit));
		}

	}

	/**
	* addIsstarCreditLog ¼ͼԴӻ
	*
	* @param int $rowid
	* @param int $tbl
	*/
	function addIsstarCreditLog($rowid, $tbl)
	{
		$wc = array();
		$wc['kind'] = 'p_20';
		$wc['uid'] = $this->uid;
		$wc['indate'] = date('Y-m-d',$this->time);
		$wc['title'] = 'ͼԴ';
		$wc['rowid'] = $rowid;
		$wc['tbl'] = $tbl;
		$q = insert_sql("broker_plus",$wc);
		$rs = $this->db->Execute($q);
	}

	/**
	* getBrokerGroupid ȡGroupid
	*
	* @return integer
	*/
	function getBrokerGroupid()
	{
		$groupid = $this->db->GetOne("select groupid from broker where uid='".$this->uid."'");
		return intval($groupid);
	}

	/**
	* checkIsstarCreditLog ݷԴŻȡ÷ԴĶͼԴӻ
	*
	* @param int $rowid
	* @param int $tbl
	* @return integer
	*/
	function checkIsstarCreditLog($rowid, $tbl)
	{
		$rowid = intval($rowid);
		$tbl = trim($tbl);

        $num = $this->db->GetOne("select count(*) from broker_plus where uid='".$this->uid."' and rowid='".$rowid."' and tbl='".$tbl."'");
		return intval($num);
	}

	/**
	* getMonthIsstarCredit ȡ˵·ͼõĻ
	*
	* @return integer
	*/
	function getMonthIsstarCredit()
	{
		$time = strtotime(date('Y-m', $this->time).'-1 00:00:00');
		//$sum = $this->db->GetOne("SELECT SUM(lc_value) FROM log_credit WHERE lc_uid = '".$this->uid."' AND lc_kind = 'plus_isstar' AND lc_time >= '".$time."' ");
		$sum = $this->db->GetOne("SELECT ls_plus_isstar FROM log_credit_settlement WHERE ls_uid = '".$this->uid."' AND ls_time = '".$time."'");

		return intval($sum);
	}

	/**
	* getBrokerPackageInfo ȡײ
	*
	* @return array
	*/
	function getBrokerPackageInfo()
	{
		$sql = "SELECT bp.isstar_credit_upper_limit, bp.credit_upper_limit FROM broker_package bp LEFT JOIN broker b ON bp.package_id = b.package_id WHERE b.uid = '".$this->uid."'";
		return $this->db->GetRow($sql);
	}

	/**
	* addCreditOperateLog ֶ޸ľ˻ˮ˱¼
	*
	* @param str $kind
	* @param int $credit
	* @param str $operator
	* @param str $reason
	*/
	function addCreditOperateLog($kind, $credit, $operator, $reason)
	{
		$this->db->Execute("INSERT INTO log_credit_operate (lo_uid, lo_value, lo_kind, lo_operator, lo_reason, lo_time) VALUES ('".$this->uid."','".$credit."','".$kind."','".$operator."','".$reason."','".$this->time."')");
	}

	/**
	* updateBrokerCredit ¾˻
	*
	* @param int $credit
	*/
	function updateBrokerCredit($credit)
	{
		$this->db->Execute("UPDATE broker SET credit = '$credit' WHERE uid = '".$this->uid."'");
	}

	/**
	* getBrokerLoginTime ȡ¼ʱ
	*
	* @return str Ymd
	*/
	function getBrokerLoginTime()
	{
		$brokerlogintime = $this->db->GetOne("SELECT logintime FROM broker WHERE uid = '".$this->uid."'");
		return date('Ymd', $brokerlogintime);
	}
	

	/**
	* getBrokerLoginTimeByKind ݵ¼ȡ¼ʱ
	*
	* @return str Ymd
	*/
	function getBrokerLoginTimeByKind($login_kind)
	{	
		if($login_kind =='plus_login'){
			$kind_cond  = " AND kind = 'brokercp' ";
		}elseif($kind =='plus_login_mobile'){
			$kind_cond  = " AND kind IN('android','iphone') ";
		}
		
		$sql = "SELECT logintime FROM log_login WHERE uid = '".$this->uid."' ".$kind_cond." ORDER BY logintime DESC LIMIT 1";
		$brokerlogintime = $this->db->GetOne($sql);

		return date('Ymd', $brokerlogintime);
	}


	/**
	* getBrokerBirthday ȡ¼ʱ
	*
	* @return str Ymd
	*/
	function getBrokerBirthday()
	{
		$brokerbirthday = $this->db->GetOne("SELECT lc_time FROM log_credit WHERE lc_uid = '".$this->uid."' and lc_kind='plus_birthday' order by lc_id desc");
		return date('Ymd', $brokerbirthday);
	}

	/**
	* getBrokerCredit ȡ˻
	*
	* @param bool $doview	//ΪTRUEʱСΪ0
	* @return integer
	*/
	function getBrokerCredit($doview = false)
	{
		$brokercredit = $this->db->GetOne("SELECT credit FROM broker WHERE uid = '".$this->uid."'");
		$brokercredit = intval($brokercredit);

		$brokercredit = $doview === true && $brokercredit < 0 ? 0 : $brokercredit;

		return $brokercredit;
	}

	/**
	* addCreditLog Ӿ˻ˮ˱¼
	*
	* @param str $kind
	* @param int $credit
	*/
	function addCreditLog($kind, $credit)
	{
		$this->db->Execute("INSERT INTO log_credit (lc_uid, lc_kind, lc_value, lc_time) VALUES ('".$this->uid."','".$kind."','".$credit."','".$this->time."')");
	}

	/**
	* getCreditLogTotal ȡ˻ˮ˼¼
	*
	* @param int $type  0:ȫʾ 1:ɸͼ 2:ֻͼ
	* @param int $day
	* @return integer
	*/
	function getCreditLogTotal($type, $day = 30)
	{
		$day = intval($day) - 1;
		$startday = $day > 0 ? strtotime("-".$day." day") : strtotime(date('Y-m-d').' 00:00:00');

		$typesql = $type == 1 ? " AND lc_kind = 'plus_isstar' " : ($type == 2 ? " AND lc_kind != 'plus_isstar' " : "");

		$total = $this->db->GetOne("SELECT COUNT(*) FROM log_credit WHERE lc_uid = '".$this->uid."' ".$typesql." AND lc_time >= '".$startday."'");

		return intval($total);
	}

	/**
	* getCreditLog ȡ˻ˮ˼¼
	*
	* @param int $type  0:ȫʾ 1:ɸͼ 2:ֻͼ
	* @param int $perpage
	* @param int $start
	* @param int $day
	* @return array
	*/
	function getCreditLog($type, $perpage = 20, $start = 0, $day = 30)
	{
		$perpage = intval($perpage);
		$start = intval($start);

		$day = intval($day) - 1;
		$startday = $day > 0 ? strtotime("-".$day." day") : strtotime(date('Y-m-d').' 00:00:00');

		$typesql = $type == 1 ? " AND lc_kind = 'plus_isstar' " : ($type == 2 ? " AND lc_kind != 'plus_isstar' " : "");

		$list = $this->db->GetAll("SELECT lc_kind,lc_value,lc_time FROM log_credit WHERE lc_uid = '".$this->uid."' ".$typesql." AND lc_time >= '".$startday."' ORDER BY lc_id DESC LIMIT ".$start.",".$perpage." ");

		$result = array();
		$i = 0;
		foreach($list as $row)
		{
			$result[$i]['time'] = $row['lc_time'];
			$result[$i]['kind'] = $this->credit_arr[$row['lc_kind']]['title'];
			$result[$i]['credit'] = $this->credit_arr[$row['lc_kind']]['sign'].$row['lc_value'];
			$i++;
		}
		return $result;
	}

	/**
	* updateCreditSettlement ¾˻¶Ƚ¼
	*
	* @param str $kind
	* @param bool $no_settlement
	* @return array
	*/
	function updateCreditSettlement($kind, $credit, $no_settlement)
	{
		$credit = intval($credit);
		$time = strtotime(date('Y-m', $this->time).'-1 00:00:00');

		$row = $this->db->GetRow("SELECT ls_id FROM log_credit_settlement WHERE ls_uid = '".$this->uid."' AND ls_time = '".$time."'");

		if($row)
		{
			if($no_settlement)
			{
				$sql = "UPDATE log_credit_settlement SET ls_credit = '".$this->brokercredit."' WHERE ls_id = '".$row['ls_id']."' ";
			}
			else
			{
				$sql = "UPDATE log_credit_settlement SET ls_credit = '".$this->brokercredit."', ls_".$kind." = ls_".$kind." + '".$credit."' WHERE ls_id = '".$row['ls_id']."' ";
			}
		}
		else
		{
			if($no_settlement)
			{
				$sql = "INSERT INTO log_credit_settlement (ls_uid, ls_time, ls_credit) VALUES ('".$this->uid."', '".$time."', '".$this->brokercredit."') ";
			}
			else
			{
				$sql = "INSERT INTO log_credit_settlement (ls_uid, ls_time, ls_credit, ls_".$kind.") VALUES ('".$this->uid."', '".$time."', '".$this->brokercredit."', '".$credit."') ";
			}
		}

		$this->db->Execute($sql);

		return $nowcredit;
	}

	/**
	* getCreditSettlementLog ȡ˻¶Ƚ¼
	*
	* @param int $month
	* @return array
	*/
	function getCreditSettlementLog($month = 5)
	{
		$month = intval($month);
		$month = $month > 0 ? $month : 5;
		$starttime = strtotime("-".$month." month");

		$list = $this->db->GetAll("SELECT * FROM log_credit_settlement WHERE ls_uid = '".$this->uid."' AND ls_time >= '".$starttime."' ORDER BY ls_id DESC LIMIT 6 ");

		return $list;
	}
}
?>