<?php

/**
 * @author applelor
 * @version ڣ2011.3.8
 */

class Broker_brokercp {
	var $brokerTable;
	var $stateField;
	var $stateArr;
	var $primaryKey;
	var $house;


    public function __construct()
    {
    	$this->house = new House_brokercp();
    	$this->brokerTable = 'broker';
		$this->stateField = 'valid_flag';
		$this->primaryKey = 'uid';
    	$this->stateArr  = array(
    		'valid'=>1,
    		'invalid'=>0
    	);
    }

    /*
     * @use ľЧ
     * @param $brokerIds ID
     */
    function valid($brokerIds){
		$rt = false;
    	if($brokerIds){
			$rt = changeState($this->brokerTable,$this->stateField,$this->stateArr['valid'],$this->primaryKey,$brokerIds);
    	}
    	return $rt;
    }

    /*
     * @use ľЧ
     * @param $brokerIds ID
     */
    function invalid($brokerIds){
		if(is_array($brokerIds)){
			$rt = true;
    		foreach ($brokerIds as $bid){
				$rs = $this->invalidOnlyOne($bid);
				if($rs===false){
					$rt = false;
				}
			}
		}else{
			$rt = $this->invalidOnlyOne($brokerIds);
		}
    	return $rt;
    }

	private function invalidOnlyOne($bid){
		if($bid){
			$stateInfo = $this->getState($bid);
			$rt = changeState($this->brokerTable,$this->stateField,$this->stateArr['invalid'],$this->primaryKey,$bid);
			if($rt){
				if($stateInfo ==1){
					$this->valid2Invalid($bid);
				}
			}
			return $rt;
		}else{
			return false;
		}
	}

    /*
     * @use ľЧЧ
     * @param $brokerId ID
     */
	private function valid2Invalid($brokerId){
    	global $db;
		$rentHouseId = array();
		$sql = "SELECT ".$this->house->primaryKey." FROM ".$this->house->rentTable." where ".$this->house->foreignKey." = '$brokerId' AND  ".$this->house->stateField." = ".$this->house->stateArr['valid']." and infofrom = '5'" ;
    	if($rs = $db->GetAll($sql)){
	    	foreach ($rs as $row){
	    		$rentHouseId[] = $row[$this->house->primaryKey];
	    	}
    	}
		if($rentHouseId){
			$this->house->invalid($rentHouseId,'rent');
		}

		$sellHouseId = array();
		$sql = "SELECT ".$this->house->primaryKey." FROM ".$this->house->sellTable." where ".$this->house->foreignKey." = '$brokerId' AND ". $this->house->stateField." = ".$this->house->stateArr['valid']." and infofrom = '5'" ;
    	if($rs = $db->GetAll($sql)){
	    	foreach ($rs as $row){
	    		$sellHouseId[] = $row[$this->house->primaryKey];
	    	}
    	}
		if($sellHouseId){
			$this->house->invalid($sellHouseId,'sell');
		}
    }

    /*
     * @use ľЧЧ
     * @param $brokerId ID
     */
 	private function invalid2Valid($brokerId){


    }

	/*
     * @use ȡ˵״̬
     * @param $brokerIds id
     */
    function getState($brokerIds){
  		global $db;
		$sql = "SELECT $this->stateField FROM $this->brokerTable WHERE $this->primaryKey = $brokerIds";
		$rs = $db->GetOne($sql);
    	return $rs;
    }

	/*
     * @use ȡµķԴ
     * @param $sort ȡĸ͵ķԴ

    function getHouseIds($bid,$sort=false,$sellOrRent='sell'){
    	global $db;
		$rt = array();
    	$addSql = (is_numeric($sort)?in_array($sort, $this->house->stateArr):false)?" AND ". $this->house->stateField." = $sort ":" ";
    	$sql = "SELECT ".$this->house->primaryKey." FROM ".$this->house->$sellOrRent." where ".$this->house->foreignKey." = '$bid' $addSql ";
    	if($rs = $db->GetAll($sql)){
	    	foreach ($rs as $row){
	    		$rt[] = $row[$this->house->primaryKey];
	    	}
    	}
		$sql = "SELECT ".$this->house->primaryKey." FROM ".$this->house->rentTable." where ".$this->house->foreignKey." = '$bid' $addSql ";
    	if($rs = $db->GetAll($sql)){
	    	foreach ($rs as $row){
	    		$rt[] = $row[$this->house->primaryKey];
	    	}
    	}
    	return $rt;
    }*/
}


?>
