<?php

/**
 * core\lib\growth\GrowthExp.php
 */

/**
 * ˳ɳֵ
 *
 * @author sun
 */
class GrowthExp {
    
    /**
     * ݿ
     */
    private $db;

    /**
     * ݿ
     */
    private $dbback;

    /**
     * 
     */
    private $mc;
    
    /**
     * ı
     * @var string
     */
    private $table;
    
    /**
     * ˵ı
     * @var string
     */
    private $table_broker;
    
    /**
     * аֶ
     * @var array
     */
    private static $fields = array('id','broker_id','exp','status');
    
    private static $fields_broker = array('username', 'truename');

    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = 'growth_exp';
        $this->table_broker = 'broker';
    }
    
    /**
     * ݾ˱Żȡһֵ¼
     * @param int $brokerId ˱
     * @return array һֵݵ 
     */
    public function findOneByBrokerId($brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields,
                "broker_id = $brokerId");
        return $this->db->getRow($sql);
    }

    /**
     * ݾ˱Żȡеľֵ¼
     * @return mixed
     */
    public function findAllByBrokerId($brokerId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields,
                "broker_id = $brokerId");
        return $this->dbback->getAll($sql);
    }

    /**
     * ݾ˱þֵ
     * @param int $brokerId ˱
     * @param int $score ֵ
     * @return boolean ʧܷfalse ɹtrue
     */
    public function setExpToOneByBrokerId($brokerId, $score) {
        $arrField['exp'] =  $score;
        $sql = SqlCombinHelper::update_sql($this->table, $arrField, 
                "broker_id = $brokerId");
        return $this->db->execute($sql);
    }

    /**
     * ݾ˱þֵ
     * @param array $arrBrokerId ˱
     * @param int $score ֵ
     * @return boolean ʧܷfalse ɹtrue
     */
    public function setExpByBrokerId($arrBrokerId, $score) {
        $strBrokerId = implode(',', $arrBrokerId);
        $arrField['exp'] =  $score;
        $sql = SqlCombinHelper::update_sql($this->table, $arrField, 
                "broker_id IN ($strBrokerId)");
        return $this->db->execute($sql);
    }

    /**
     * ݾ˱Ӽپֵ
     * @param int $brokerId ˱
     * @param int $score ֵ
     * @return boolean ɹtrueʧܷfalse
     */
    public function addExpToOneBrokerId($brokerId, $score) {
        $score = $score > 0 ? '+' . $score : $score;
        $arrField['exp'] =   $score;
        $sql = SqlCombinHelper::updateSelf_sql($this->table, $arrField, 
                "broker_id = $brokerId");      
        return $this->db->execute($sql);
    }
    
    /**
     * ݾӼپֵ
     * @param array $arrBrokerId ˱
     * @param int $score ֵ
     * @return boolean ɹtrueʧܷfalse
     */
    public function addExpBrokerId($arrBrokerId, $score) {
        $strBrokerId = implode(',', $arrBrokerId);
        $score = $score > 0 ? '+' . $score : $score;
        $arrField['exp'] =   $score;
        $sql = SqlCombinHelper::updateSelf_sql($this->table, $arrField, 
                "broker_id IN ($strBrokerId)");
        return $this->db->execute($sql);
    }
    
    /**
     * һ
     * @param int $brokerId ˱
     * @param int $score ֵ
     * @param int $status ״̬Ĭֵ1 
     * @return boolean ɹtrueʧܷfalse
     */
    public function insertData($brokerId, $score, $status=1) {
        $arrFieldsValue = array();
        $arrFieldsValue['broker_id'] = $brokerId;
        $arrFieldsValue['exp'] = $score;
        $arrFieldsValue['status'] = $status;
        $sql = SqlCombinHelper::insert_sql($this->table, $arrFieldsValue);
        return $this->db->execute($sql);
    }
    
    /**
     * ɾ
     * @param array $arrBrokerId ˱
     * @return boolean
     */
    public function delOneDataByBrokerId($brokerId) {
        $sql = SqlCombinHelper::delete_sql($this->table, 
                "broker_id = $brokerId");
        return $this->db->execute($sql);
    }

    /**
     * ɾ
     * @param array $arrBrokerId ˱
     * @return boolean
     */
    public function delMutilDataByBrokerId($arrBrokerId) {
        $strBrokerId = implode(',', $arrBrokerId);
        $sql = SqlCombinHelper::delete_sql($this->table, 
                "broker_id IN ($strBrokerId)");
        return $this->db->execute($sql);
    }
    
    /**
     * еֶμϱΪǰ׺
     * @param string $tablename 
     * @param array $arrFields  еֶ
     * @return array  array($tablename.$arrFields[0])
     */
    private function getRelatedTblNField($tablename, $arrFields) {
        $arrCombinFields = array();
        foreach($arrFields as $key => $value) {
            $arrCombinFields[] = $tablename . '.' . $value;
        }
        return $arrCombinFields;
    }
    
    /**
     * ƴװgrow_expbrokerΪѯֶΣ
     * @return string
     */
    private function getInnerSearchByBetweenTable() {
        $searchField = '';
        $searchField .= implode(',', $this->getRelatedTblNField(
                $this->table_broker, self::$fields_broker));
        $brkerFields = implode(',', $this->getRelatedTblNField(
                $this->table, self::$fields));
        $searchField = $searchField . ',' . $brkerFields;
        return $searchField;
    }
    
    /**
     * ڴɳֵ˵
     * @param int $down_exp ɳֵޱֵ
     * @param int $up_exp ɳֵޱֵ
     * @return int ˵Ŀ
     */
    public function findBrokerNumByBetweenExp($down_exp, $up_exp) {
        $sql = SqlCombinHelper::innerCount_sql($this->table_broker, $this->table,
                "{$this->table_broker}.uid = {$this->table}.broker_id",
                        "{$this->table_broker}.valid_flag =1 AND {$this->table}.exp "
                        . ">= $down_exp AND {$this->table}.exp <= $up_exp");
        return $this->dbback->getOne($sql);
    }
    
    /**
     * شڴ˳ɳֵ˵
     * @param int $exp ɳֵ
     * @return int ˵Ŀ
     */
    public function findBrokerNumByGlExp($exp) {
        $sql = SqlCombinHelper::innerCount_sql($this->table_broker, $this->table,
                "{$this->table_broker}.uid = {$this->table}.broker_id",
                        "{$this->table_broker}.valid_flag =1 AND {$this->table}.exp "
                        . ">= $exp");
        return $this->dbback->getOne($sql);
    }
    
    /**
     * Сڴ˳ɳֵ˵
     * @param int $exp ɳֵ
     * @return int ˵Ŀ
     */
    public function findBrokerNumByLtExp($exp) {
        $sql = SqlCombinHelper::innerCount_sql($this->table_broker, $this->table,
                "{$this->table_broker}.uid = {$this->table}.broker_id",
                        "{$this->table_broker}.valid_flag =1 AND {$this->table}.exp "
                        . "<= $exp");
        return $this->dbback->getOne($sql);
    }
    
    /**
     * ڴɳֵ
     * @param int $down_exp ɳֵޱֵ
     * @param int $up_exp ɳֵޱֵ
     * @return array 
     */
    public function findAllBrokerByBetweenExp($down_exp, $up_exp) {
        $searchField = $this->getInnerSearchByBetweenTable();
        $sql = SqlCombinHelper::innerSelect_sql($this->table_broker, $this->table,
                $searchField, "{$this->table_broker}.uid = {$this->table}.broker_id",
                        "{$this->table_broker}.valid_flag =1 AND {$this->table}.exp "
                        . ">= $down_exp AND {$this->table}.exp <= $up_exp");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * شڴ˳ɳֵ
     * @param int $exp ɳֵ
     * @return array 
     */
    public function findAllBrokerByGlExp($exp) {
        $searchField = $this->getInnerSearchByBetweenTable();
        $sql = SqlCombinHelper::innerSelect_sql($this->table_broker, $this->table,
                $searchField, "{$this->table_broker}.uid = {$this->table}.broker_id",
                        "{$this->table_broker}.valid_flag =1 AND {$this->table}.exp "
                        . ">= $exp");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * Сڴ˳ɳֵ
     * @param int $exp ɳֵ
     * @return array 
     */
    public function findAllBrokerByLtExp($exp) {
        $searchField = $this->getInnerSearchByBetweenTable();
        $sql = SqlCombinHelper::innerSelect_sql($this->table_broker, $this->table,
                $searchField, "{$this->table_broker}.uid = {$this->table}.broker_id",
                        "{$this->table_broker}.valid_flag =1 AND {$this->table}.exp "
                        . "<= $exp");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * о˺ͻϢɳֵ 
     * @return array
     */
    public function findAllBrokerAndExpInfo() {
        $searchField = $this->getInnerSearchByBetweenTable();
        $sql = SqlCombinHelper::innerSelect_sql($this->table_broker, $this->table,
                $searchField, "{$this->table_broker}.uid = {$this->table}.broker_id",
                        "{$this->table_broker}.valid_flag =1");
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ¼
     * @param array $exps
     * @return type
     */
    public function insertMutl(array $exps) {
        $sql = SqlCombinHelper::insertMutil_sql($this->table, $exps);
        $this->db->execute($sql);
        return $this->db->Affected_Rows();
    }
    
    public function emptyTable() {
        $sql = "TRUNCATE TABLE $this->table";
        $this->db->Execute($sql);
    }
    /**
     * ر
     */
    public function getTable() {
        return $this->table;
    }
}
