<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ۱ϵͳ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * House_demands_model CLASS
 *
 * 󹺹࣬ṩϢķ(鿴ƥ䡢ɾȲ)
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz     
 */

//ظ
load_m("house_demands_base_model");

class House_demands_model extends House_demands_base_model{
  
    /**
    * Constructor
    */
    public function __construct() 
    {
        parent::__construct(0,1,0);
    }
    
    
    /**
    * ݾ˱Żȡ˳ۻ߳ⷿԴаϢ
    *
    * @access	public
    * @param	void
    * @return	array  ԴϢҪѯֶ
    */
    private function _get_streetinfo_by_uid ()
    {
        //˷ԴİϢ[ȡԴ࣬ȡзԴ漰İϢ]
        $street_info = array();
        
        //ԴϢ
        $tbl_house = $this->get_tbl_house();
        
        //$this->load->model('sell');
        
        //$this->sell->sell_model->
		
		$street_info = array('80','90','95');
         
        return $street_info;
    }
    
    
    /**
    * get_demands_num_by_uid
    *
    * ݾ˱Żȡ뾭˷ԴƥϢ
    *
    * @access	public
    * @return	int   Ϣ
    */
    public function get_demands_num_by_uid( )
    {   
        //ԴϢ
        $demands_num = 0;
        
        //˷ԴİϢ[ȡԴ࣬ȡзԴ漰İϢ]
        $street_info = $this->_get_streetinfo_by_uid();

        //ϢΪգֱӷؿ
        if( empty( $street_info ) )
        {
            return  $demands_num;
        }
        
        //ĬϵĲѯ
        $limit_time = time() + 86400;
		$cond_where = "esta = 1 AND allow_match = 1 AND "
                . "( infofrom = '0' OR infofrom = '5' ) AND "
                . "expiretime > $limit_time";
        
        //жǷڰϢ
        if( is_array($street_info) && !empty($street_info) )
        {
            $str_streetid = implode( ',' , $street_info ) ;
            $cond_where .= " AND ( street IN (".$str_streetid.") "
                    . "OR street1 IN (".$str_streetid.") "
                    . "OR street2 IN (".$str_streetid.") )";
        }
        else
        {
            $cond_where .= ' AND 1 = 0';
        }
       
        $demands_num = $this->get_demands_num( $cond_where );
        
        return $demands_num ;
    }
    
    
    /**
    * get_demands_list_by_uid
    *
    * ݾ˱Żȡ뾭˷ԴƥϢϢб
    *
    * @access	public
    * @param	int     $offset ƫ,ĬֵΪ0
    * @param	int     $pagesize ÿȡĬֵΪ10
    * @param	string  $order_key ֶΣĬֵ
    * @param	string  $order_by  򡢽ĬϽ
    * @return	array   ƥϢ
    */
    public function get_demands_list_by_uid( $offset = 0 , $limit = 10 , $order_key = 'creattime' , $order_by = 'DESC' )
    {   
        //ԴϢ
        $arr_data = array();
        
        //˷ԴİϢ[ȡԴ࣬ȡзԴ漰İϢ]
        $street_info = $this->_get_streetinfo_by_uid();
        
        //ϢΪգֱӷؿ
        if( empty( $street_info ) )
        {
            return  $arr_data;
        }
        
        //ĬϵĲѯ
        $limit_time = time() + 86400;
		$cond_where = "esta = 1 AND allow_match = 1 AND "
                . "( infofrom = '0' OR infofrom = '5' ) AND "
                . "expiretime > $limit_time";
        
        //жǷڰϢ
        if( is_array( $street_info ) && !empty( $street_info ) )
        {
            $str_streetid = implode( ',' , $street_info ) ;
            $cond_where .= " AND ( street IN (".$str_streetid.") "
                    . "OR street1 IN (".$str_streetid.") "
                    . "OR street2 IN (".$str_streetid.") )";
        }
        else
        {
            $cond_where .= ' AND 1 = 0 ';//ϢΪ
        }
       
        $arr_data = $this->get_demands_list( $cond_where , $offset , $limit , $order_key , $order_by );
        
        return $arr_data ;
    }
    
    
    /**
    * get_demands_num
    *
    * ȡϢ
    *
    * @access	public
    * @param	string  $cond_where ѯ
    * @return	int   Ϣ
    */
    public function get_matched_num ( $cond_where = '' )
    {
        $matched_num = 0;
        
        //Դƥ
        $tbl_match = $this->get_tbl_match();
        
        //û򷵻0
        if( !in_array( $tbl_match , array( 'buy_match' , 'rentwanted_match' ) ) )
        {
           return $matched_num ;
        }
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }
        
        //ѯ
        $matched_num = $this->dbback->get( $tbl_match )->num_rows();

        return  intval( $matched_num );
    }
    
    
    /**
    * get_matched_num_by_uid
    *
    * ȡƥ󹺡Ϣ
    *
    * @access	public
    * @param	int   $days ڵƥ¼
    * @return	int   Ϣ
    */
    public function get_matched_num_by_uid( $days = 30 )
    {   
        $matched_num = 0;
        
        $uid = $this->get_uid();
        
        //ѯƥϢ
        $start_time = time() - 86400 * $days;
        $cond_where = "infofrom = 5 AND match_uid = '".$uid."' AND creattime > $start_time";
        
        //ȡƥϢ
        $matched_num = $this->get_matched_num( $cond_where );
        
        return $matched_num;
    }
    
    
    /**
    * get_matched_ids_by_uid
    *
    * ȡƥ󹺡Ϣ
    *
    * @access	public
    * @param	int     $days ڵƥ¼
    * @param	string  $order_key ֶΣĬֵ
    * @param	string  $order_by  򡢽ĬϽ
    * @return	array   ƥ󹺡Ϣ
    */
    public function get_matched_ids_by_uid( $days = 30 , $order_key = 'creattime' , $order_by = 'DESC' )
    {   
        $arr_ids = array();
        
        $uid = $this->get_uid();
        
        if( $uid <= 0)
        {
           return  $arr_ids;
        }
        
        //ѯƥϢ
        $start_time = time() - 86400 * $days;
        $cond_where = "infofrom = 5 AND match_uid = '".$uid."' AND creattime > $start_time";
        
        //ȡƥı
        $arr_ids = $this->get_matched_ids( $cond_where , $order_key = 'creattime' , $order_by = 'DESC');
        
        return $arr_ids;
    }
    
    
    /**
    * get_matched_list_by_uid
    *
    * ȡƥ󹺡Ϣ
    *
    * @access	public
    * @param	int     $days ڵƥ¼
    * @param	int     $offset ƫ,ĬֵΪ0
    * @param	int     $limit ÿȡĬֵΪ10
    * @param	string  $order_key ֶΣĬֵ
    * @param	string  $order_by  򡢽ĬϽ
    * @return	int   Ϣ
    */
    public function get_matched_list_by_uid( $days = 30 , $offset = 0 , $limit = 10 , $order_key = 'creattime' , $order_by = 'DESC' )
    {   
        //ƥϢ
        $matched_info = array();
        
        //ƥϢ
        $tbl_matched = $this->get_tbl_match();
        
        //δֱӷؿ
        if( $tbl_matched == '' )
        {
            return  $arr_data;
        }
        
        //ѯѾƥ
        $arr_ids = array();
        $arr_ids = $this->get_matched_ids_by_uid( $days , $order_key , $order_by );
        
        if( is_array($arr_ids) && !empty($arr_ids) )
        {
            $want_ids_str = '';
            foreach( $arr_ids as $key => $value)
            {
                $want_ids_str .= $want_ids_str != '' ? ','.$value['want_id'] : $value['want_id'];
            }
            $cond_where = "id IN(".$want_ids_str.") ";
            
            //ƥ󹺷ԴϢ
            $matched_info = $this->get_matched_list($cond_where, $offset, $limit, $want_ids_str, $order_by);
        }
        
        return $matched_info ;
    } 
}
/* End of file sell_demands_model.php */
/* Location: ./zsb/model/sell_demands_model.php */