<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Rent_star_base_model CLASS
 *
 * ͼ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz
 */

//ظ
load_m("rent_attr_model");

class Rent_star_base_model extends Rent_attr_model {
    
    /**
     * ͼʶӦֵ
     * @var const
     */
    const  ISSTAR_VALUE = 3;
    
    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct(0,0,0);
    }
    
    /**
     * ضͼ־ֵ
     */
    public function get_isstar_value()
    {
        return self::ISSTAR_VALUE;
    }
    
    
    /**
     * жϷԴǷΪͼԴ
     *
     * @access	public
     * @return	boolean   ǷΪͼԴ
     */
    public function is_star()
    {   
        $is_star = FALSE;
        
        $house_info = $this->init_houseinfo();
        
        if( is_array( $house_info ) && !empty( $house_info ) )
        {
            $is_star = self::ISSTAR_VALUE == $house_info['isstar'] 
                    ? TRUE : FALSE;
        }
        
        return $is_star;
    }
    
    
    /**
     * öͼԴ
     *
     * @access  protected
     * @return  boolean  Ƿóɹ
     */
    public function set_star()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $row_id = isset($house_info['id']) ? intval($house_info['id']) : 0;
        
        if( $row_id > 0 )
        {   
            $update_info = array();
            
            //ҪõķԴֵ
            $update_info['isstar'] = self::ISSTAR_VALUE;
            
            //öͼԴ
            $result = $this->update_house_atrr_val( $update_info , $row_id );
        }
        
        return $result;
    }
    
    
    /**
     * ȥͼԴ
     *
     * @access  public
     * @return  boolean  Ƿóɹ
     */
    public function remove_star()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
        
        if( $rowid > 0 )
        {   
            $update_info = array();
            
            //ҪõķԴֵ
            $update_info['isstar'] = 0;
            
            //öͼԴ
            $result = $this->update_house_atrr_val( $update_info , $rowid );
        }
        
        return $result;
    }
    
    
    /**
     * ǷԴǷ϶ͼԴ׼
     *
     * @access  protected
     * @return  boolean  Ƿ϶ͼԴ׼
     */
    public function check_star_standard()
    {   
        $tbl = 'rent';
        $is_star = FALSE;
        
        $houseinfo = $this->init_houseinfo();
        
        //1շѾ˲оͷ
        $this->load->model('broker_model');
        
        $this->broker_model->set_uid($houseinfo['uid']);
        $broker_info = $this->broker_model->get_broker_info();
        
        if( $broker_info['groupid'] == 2 || $broker_info['smallphoto'] == '')
        {
            return $is_star;
        }
        
        //2Դ20ּ
        if( strlen( $houseinfo['address'] ) < 20)
        {
            return $is_star;
        }
        
        //3Դ
        if( strlen( $houseinfo['remark'] ) < 60 )
        {
            return $is_star;
        }

        //4ϷԴͼƬ
        $pic_info = array();
        $this->load->model('pic_model');
        $pic_info = $this->pic_model->find_house_pic_by($tbl , $houseinfo['id'] , 2);
        
        //ͼ
        $pic_indoor = 0;
        
        if( is_array( $pic_info ) && isset( $pic_info ) )
        {   
            $pic_indoor = count( $pic_info );//
        }
        
        //ͼ
        $pic_indoor_limit = 3;
        if( $pic_indoor >= $pic_indoor_limit )
        {
            $is_star = TRUE;
        }
        
        return $is_star;
    }
}
/* End of file rent_attr_base_model.php */
/* Location: ./applications/models/rent_attr_base_model.php */