<?php
/**
 * 
 *
 * @author sun
 */
class PayBrokerHousebean {
    
    /**
     * ֶ
     * @var object 
     */ 
    private $credit;
    
    /**
     * ¼
     * @var object 
     */
    private $housebeanRecord;
    
    /**
     * 
     * @var object 
     */
    private $housebeanWay;
    
    /**
     * 
     * @var array
     */
    private $broker;
    
    public function __construct($broker = array()) {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->credit = new GrowthCredit();
        $this->housebeanRecord = new PayHousebeanRecord();
        $this->housebeanWay = new PayHousebeanWay();
        $this->broker = $broker;
    }
    
    /**
     * չ涨ĸʽʾĲ0
     * @param int $value ֵ
     * @param int $length 
     * @return string
     */
    private function formatValue($value, $length) {
        return sprintf("%0{$length}d", $value);
    }
    
    /**
     * Ķźλ
     * 1-9999
     */
    private function randValue() {
        return rand(1, 9999);
    }
    
    /**
     * ȡ
     * ?ʱ14λ+ʹ2λ+4λ
     * @param string $wayAlias 
     */
    public function getOrderId($wayAlias) {
        //ʹ
        $type = $this->housebeanWay->getTypeByWayAlias($wayAlias);
        $formatType = $this->formatValue($type, 2);
        //
        $randValue = $this->formatValue($this->randValue(), 4);
        //
        return date('YmdHis') . $formatType . $randValue;
    }
    
    /**
     * ȡ˱
     * @return int
     */
    private function getBrokerId() {
        return $this->broker['id'];
    }
    
    /**
     * ȡ·
     * @param string $wayAlias 
     * @return int
     */
    private function getNumByWayAlias($wayAlias) {
        return $this->housebeanWay->getNumByWayAlias($wayAlias);
    }
    
    /**
     * ȡϢ
     * @param string $wayAlias 
     * @return int
     */
    private function getDescriptionByWayAlias($wayAlias) {
        //δӶ
        return $this->housebeanWay->getDescriptionByWayAlias($wayAlias);
    }
    
    /**
     * ӷ
     * @param string $wayAlias ȡķʽ
     * @param string $description ȡʽԶ
     * @param int $num 
     * @param string $orderId 
     * @return array
     */
    public function increase($wayAlias, $description = null,
            $num = null, $ishidden = 1, $orderId = null) {
        $brokerId = $this->getBrokerId();
        //Դ
        $source = PayHousebeanSource::getSource();
        //ж
        if ($wayAlias == null) {
            return array('status' => false, 'msg' => 'wayAliasֶβΪ');
        }
        //
        if($num == null) {
            $num = $this->getNumByWayAlias($wayAlias);
        } else {
            $num = abs($num);
        }
        //
        if($description == null) {
            $description = $this->getDescriptionByWayAlias($wayAlias);
        }
        //
        if ($orderId == null) {
            $orderId = $this->getOrderId($wayAlias);
        }
        //ӷ
        $updateNumStatus = $this->credit->addCreditToOne($brokerId, $num);
        if ($updateNumStatus) {
            //Ӽ¼
            $this->housebeanRecord->insert($brokerId, $orderId, $wayAlias, 
                    $source, $num, $description, $ishidden);
            $arrRtnResult['status'] = 1;
            $arrRtnResult['num'] = $num;
        } else {
            $arrRtnResult['status'] = 0;
            $arrRtnResult['msg'] = 'ӷʧ';
        }
        return $arrRtnResult;
    }
    
    /**
     * ٷ
     * @param string $wayAlias ȡķʽ
     * @param string $description ȡʽԶ
     * @param int $num 
     * @param string $orderId 
     * @return array
     */
    public function reduce($wayAlias,$description = null, 
            $num = null, $ishidden, $orderId = null) {
        $brokerId = $this->getBrokerId();
        //Դ
        $source = PayHousebeanSource::getSource();
        //ж
        if ($wayAlias == null) {
            return array('status' => false, 'msg' => 'wayAliasֶβΪ');
        }
        //
        if($num == null) {
            $num = $this->getNumByWayAlias($wayAlias);
        } else {
            $num = '-'. abs($num);
        }
        //
        if($description == null) {
            $description = $this->getDescriptionByWayAlias($wayAlias);
        }
        //
        if ($orderId == null) {
            $orderId = $this->getOrderId($wayAlias);
        }
        //ӷ
        $updateNumStatus = $this->credit->addCreditToOne($brokerId, $num);
        if ($updateNumStatus) {
            //Ӽ¼
            $this->housebeanRecord->insert($brokerId, $orderId, $wayAlias, 
                    $source, $num, $description, $ishidden);
            $arrRtnResult['status'] = 1;
            $arrRtnResult['num'] = $num;
        } else {
            $arrRtnResult['status'] = 0;
            $arrRtnResult['msg'] = '۳ʧ';
        }
        return $arrRtnResult;
    }
    
    /**
     * ߷
     * @param int $num  
     * @param int $brokerId ˱
     * @param string $wayAlias ȡķʽ
     * @param string $description 
     * @return true or false
     */
    public function frozen($num, $brokerId, $wayAlias, $ishidden, $description='') {
        //Դ
        $source = PayHousebeanSource::getSource();
        if($num > 0) { 
            $x = -$num;
        } else if($num < 0) {
            $x =  abs($num);
        }
        //
        $orderId = $this->getOrderId($wayAlias);
        if($brokerId === null) { $brokerId = $this->getBrokerId();}
        $status = $this->credit->frozen($brokerId, $num);
        //Ӽ¼
        $this->housebeanRecord->insert($brokerId, $orderId, $wayAlias, $source, 
                $x, $description, $ishidden);
        return $status;
    }
}
