<?php

/**
 * @author applelor
 * @version ڣ2011.3.8
 */

class Picture {
	var $picTable;
	var $stateField;
	var $stateArr;
	var $primaryKey;
	var $foreignKey;
	var $picAddressField;
	var $extraField;
	var $up;


    public function __construct()
    {
    	$this->picTable = 'upload';
		$this->stateField = 'flg';
		$this->primaryKey = 'id';
		$this->foreignKey = 'rowid';
		$this->extraField = 'tbl';
		$this->picAddressField = 'filename';
		$this->up = new UploadFile();
    	$this->stateArr  = array(
    		'check'=>1,
    		'uncheck'=>0,
    		'hide'=> 2,
    		'freeze'=>3
    	);
    }

	/*
     * @use ͼƬδ
     * @param $picIds ͼƬID
	 *
	 *     */
	function uncheck($picIds){
		$rt = false;
		if($picIds)
			$rt = changeState($this->picTable,$this->stateField,$this->stateArr['uncheck'],$this->primaryKey,$picIds);
		return $rt;
    }

	/*
     * @use ͼƬ
     * @param $picIds ͼƬID
     */
	function check($picIds){
		$rt = false;
		if($picIds)
			$rt = changeState($this->picTable,$this->stateField,$this->stateArr['check'],$this->primaryKey,$picIds);
		return $rt;
    }

	/*
     * @use ͼƬ
     * @param $picIds ͼƬID
     */
	function hide($picIds){
		$rt = false;
		if($picIds)
			$rt = changeState($this->picTable,$this->stateField,$this->stateArr['hide'],$this->primaryKey,$picIds);
		return $rt;
    }

	/*
     * @use ͼƬ
     * @param $picIds ͼƬID
     */
	function freeze($picIds){
		$rt = false;
		if($picIds)
			$rt = changeState($this->picTable,$this->stateField,$this->stateArr['freeze'],$this->primaryKey,$picIds);
		return $rt;
    }

    /*
     * @use ɾͼƬ
     * @param $picIds ͼƬID
     */
    function delete($picIds){
    	global $db;
    	if(is_array($picIds)){
    		$picStrs = implode(',',$picIds);
    		$sql = "SELECT $this->primaryKey,$this->picAddressField FROM $this->picTable WHERE $this->primaryKey IN ($picStrs)";
    		$rs = $db->GetAll($sql);
    		if($rs){
    			foreach ($rs as $row){
		    		$this->up->remove($row[$this->picAddressField]);
		    		$db->Execute("DELETE FROM $this->picTable WHERE $this->primaryKey=".$row[$this->primaryKey]);
    			}
    		}
    	}else{
    		$sql = "SELECT $this->picAddressField FROM $this->picTable WHERE $this->primaryKey ='$picIds'";
    		$rs = $db->GetOne($sql);
    		if($rs){
		    		$this->up->remove($rs);
		    		$db->Execute("DELETE FROM $this->picTable WHERE $this->primaryKey=".$picIds);
    		}
    	}
    	return true;
    }

    /*
     * @use ȡͼƬ״̬
     * @param $picIds ͼƬID
     */
    function getState($picIds){
    	global $db;
    	if(is_array($picIds)){
    		$picStrs = implode(',',$picIds);
    		$sql = "SELECT $this->primaryKey,$this->stateField FROM $this->picTable WHERE $this->primaryKey IN ($picStrs)";
    		$rs = $db->GetAll($sql);
    		if($rs){
    			return $rs;
    		}else{
    			return false;
    		}
    	}else{
    		$sql = "SELECT $this->stateField FROM $this->picTable WHERE $this->primaryKey = '$picIds'";
    		$rs = $db->GetOne($sql);
    		return $rs;
    	}
    }

    /*
     * @use ÷ԴĬͼƬ
     * @param $picId ͼƬId
     * @param $houseId ԴId
     * @param $type sell | rent 
     */
    function setDefault($picId,$houseId,$type='sell'){
    	global $db;
		if(is_numeric($picId)&&is_numeric($houseId)){
			$sql = "SELECT $this->primaryKey,$this->stateField,$this->picAddressField FROM $this->picTable WHERE $this->primaryKey = '$picId'";
    		$rs = $db->GetAll($sql);
    		if($rs){
				$state = $rs[0][$this->stateField];
				$pic = $rs[0][$this->picAddressField];
    		}

			if($state&&$state!=$this->stateArr['hide']&&$state!=$this->stateArr['freeze']){
				$sql = "UPDATE $type SET pic1 = '$pic' WHERE id='$houseId'";
				$rs = $db->Execute($sql);
				if($rs){
					return true;
				}else{
					return false;
				}
			}else{
				return false;
			}

		}
		return false;
    }

}

?>
