<?php
/**
 *۱˻ BrokerCredit
 *Fisher 2012-1-29
 * xz  update 2012-7-13
**/

class BrokerCredit
{
	var $uid;			//UID
	var $db;			//ݿ
	var $credit_arr;	//˻ֹ
	var $esta_Module;	//ģǷЧ

	//¶ˮĲ
	var $no_settlement = array('plus_open', 'plus_identity', 'plus_card','plus_smallphoto','plus_locCertificate','plus_pubCertificate');
	var $allow_lesszero_arr = array('minus_frozen');//ʹС0Ĳ
	var $time = 0;			//ʱ
	var $brokercredit = 0;	//˵ǰ
	var $groupid = 0;		//Ȩ
	var $ispay = 0;			//Ƿ񸶷

	/**
	* BrokerCredit 췽
	*
	* @param int $uid
	*/
	function BrokerCredit($uid)
	{
		global $db,$credit_arr,$config_BrokerCredit;

		$this->uid = $uid;
		$this->db = $db;
		$credit_arr['plus_open']['redit'] = $this->getBrokerOpenCredit();
		$this->credit_arr =  $credit_arr;
		$this->esta_Module = $config_BrokerCredit;
		$this->time = time();
		$this->groupid = $this->getBrokerGroupid();
		$this->ispay =  $this->getBrokerPay();
	}

	/**
	* dealCredit ˻֣лֲô˷
	*
	* @param str $kind
	* @param arr $params  op_credit,operator,reason/rowid,tbl
	* @return bool
	*/
	function dealCredit($kind, $params = array())
	{
		//ģǷЧЧֱӷfalse
		if( !($this->esta_Module) || empty($this->esta_Module)  ){
			return false;
		}

		//Ѿ˵ЧĻֲ
		if( ( $this->ispay==0 && isset($this->credit_arr[$kind]) ))
		{

			//ʼ
			$credit = $this->credit_arr[$kind]['credit'];
			//ȡײͻ
			$package = $this->getBrokerPackageInfo();
			switch($kind)
			{
				//˵¼ӷ
				case 'plus_login' :		$brokerlogintime = $this->getBrokerLoginTime();	//ȡ¼ʱ
										$credit = date('Ymd') != $brokerlogintime ? $this->credit_arr[$kind]['credit'] : 0;//˵¼޸
										break;

				//ֶ޸ľ˻
				case 'plus_operate' :
				case 'minus_operate':

				//չʾ
				case 'plus_windowback' :
				case 'minus_window' :	$credit = intval($params['op_credit']);
										break;

				//ͼ
				case 'plus_isstar' :
										$dayisstarcredit = $this->getDayIsstarCredit();//ѼӶͼ
										//յĶͼԴֳ
										if($dayisstarcredit >= $package['isstar_credit_limit_day']){
											$credit_day = 0;
										}else{
											//ӷֳʱֻӳʱķ
											$tempcredit = $package['isstar_credit_limit_day'] - $dayisstarcredit;
											$credit_day = $tempcredit > $credit ? $credit : $tempcredit;
										}

										$monthisstarcredit = $this->getMonthIsstarCredit();//ѼӶͼ
										//µĶͼԴֳ
										if($monthisstarcredit >= $package['isstar_credit_upper_limit']){
											$credit_month = 0;
										}else{
											//ӷֳʱֻӳʱķ
											$tempcredit = $package['isstar_credit_upper_limit'] - $monthisstarcredit;
											$credit_month = $tempcredit > $credit ? $credit : $tempcredit;
										}
										//жеСһ
										$credit = $credit_month >= $credit_day ? $credit_day : $credit_month;
										break;

				//ֻܼӷһ
				case 'plus_open' :		$check = $this->getCreditLogByKind($kind);
										$credit = $check > 0 ? 0 : $package[$kind];//˿˺ŻֺȨ
										break;
				case 'plus_identity' :
				case 'plus_smallphoto' :
				case 'plus_localCertificate' :
				case 'plus_publicCertificate' :
				case 'plus_card' :		$check = $this->getCreditLogByKind($kind);
										$credit = $check > 0 ? 0 : $this->credit_arr[$kind]['credit'];
										break;

				//һֲ
				default :				$credit = $this->credit_arr[$kind]['credit'];
										break;
			}
			//ЧĻֱ仯
			if( $credit > 0 )
			{
				//ʼ˵ǰ
				$this->brokercredit = $this->getBrokerCredit();
				//㾭»
				$new_brokercredit = 0;
				$sign = $this->credit_arr[$kind]['sign'] == '+' ? 1 : -1;
				$new_brokercredit = $sign * $credit + $this->brokercredit;

				//ӷֵ»ִײͻ
				if($sign == 1 && $new_brokercredit > $package['credit_upper_limit']){
					//ǰִײͻ
					if($this->brokercredit > $package['credit_upper_limit']){
						$credit = 0;
					}else{
						//ӷֳʱֻӳʱķ
						$credit = $package['credit_upper_limit'] - $this->brokercredit;
						$this->brokercredit = $package['credit_upper_limit'];
					}
				}else{		//ֲ¾˻ֿɱΪֻ֣ǰ̨ʾ0
					$this->brokercredit = $new_brokercredit;
				}


				//ӷӣֻضʹС0
				if($sign == -1 && $this->brokercredit < 0 && !in_array($kind, $this->allow_lesszero_arr))
				{
					return false;
				}

				//ЧĻֱ仯
				if($credit > 0)
				{
					$this->doCredit($kind, $credit, $params);
					return true;
				}
			}
		}
		return false;
	}

	/**
	* doCredit ִо˻ֲ
	*
	* @param str $kind
	* @param int $credit
	* @param arr $params  operator,reason/rowid,tbl
	*/
	function doCredit($kind, $credit, $params = array())
	{
		$this->addCreditLog($kind, $credit);	//Ӿ˻ˮ˱¼
		$this->updateBrokerCredit($this->brokercredit); //¾˻

		//TRUEʾ¶Ƚв¼ֶ
		$no_settlement = in_array($kind, $this->no_settlement) ? true : false;
		$this->updateCreditSettlement($kind, $credit, $no_settlement);	//¾˻¶Ƚ¼

		//ֶ޸ľ˻ֵĲ¼
		if( in_array($kind, array('plus_operate', 'minus_operate')) )
		{
			$this->addCreditOperateLog($kind, $credit, $params['operator'], $params['reason']);
		}
		//Ӿ˷ͼԴӻֵĲ¼
		if($kind == 'plus_isstar')
		{
			$this->addIsstarCreditLog($params['rowid'], $params['tbl']);
		}
	}

	/**
	* getCreditLogByKind Ͳһּ¼
	*
	* @param str $kind
	* @return integer
	*/
	function getCreditLogByKind($kind)
	{
		$kind = trim($kind);
        $num = $this->db->GetOne("SELECT count(*) FROM log_credit WHERE lc_uid='".$this->uid."' and lc_kind='".$kind."' ");
		return intval($num);
	}

	/**
	* dealCreditWindowback ַ
	*
	* @param int $rowid
	* @param str $tbl
	*/
	function dealCreditWindowback($rowid, $tbl)
	{
		$q = "SELECT keys_integral,	display FROM w_broker_house WHERE rowid='".$rowid."' and uid='".$this->uid."' and tbl='".$tbl."' and esta=1 and credit_type = 1 ";
		$w_arr = $this->db->GetRow($q);
		$backcredit = $w_arr['keys_integral'] + $w_arr['display'] * $this->credit_arr['minus_window']['viewcredit'];
		$backcredit = $backcredit <= 0 ? 0 : $backcredit;

		if($backcredit > 0)
		{
			$this->dealCredit('plus_windowback', array('op_credit'=>$backcredit));
		}

	}

	/**
	* addIsstarCreditLog ¼ͼԴӻ
	*
	* @param int $rowid
	* @param int $tbl
	*/
	function addIsstarCreditLog($rowid, $tbl)
	{
		$wc = array();
		$wc['kind'] = 'p_20';
		$wc['uid'] = $this->uid;
		$wc['indate'] = date('Y-m-d',$this->time);
		$wc['title'] = 'ͼԴ';
		$wc['rowid'] = $rowid;
		$wc['tbl'] = $tbl;
		$q = insert_sql("broker_plus",$wc);
		$rs = $this->db->Execute($q);
	}

	/**
	* getBrokerGroupid ȡGroupid
	*
	* @return integer
	*/
	function getBrokerGroupid()
	{
		$groupid = $this->db->GetOne("select groupid from broker where uid='".$this->uid."'");
		return intval($groupid);
	}


	/**
	* getBrokerPay ȡǷ񸶷
	*
	* @return integer
	*/
	function getBrokerPay()
	{
		$ispay = $this->db->GetOne("select is_pay from broker where uid='".$this->uid."'");
		return intval($ispay);
	}

	/**
	* checkIsstarCreditLog ݷԴŻȡ÷ԴĶͼԴӻ
	*
	* @param int $rowid
	* @param int $tbl
	* @return integer
	*/
	function checkIsstarCreditLog($rowid, $tbl)
	{
		$rowid = intval($rowid);
		$tbl = trim($tbl);

        $num = $this->db->GetOne("select count(*) from broker_plus where uid='".$this->uid."' and rowid='".$rowid."' and tbl='".$tbl."'");
		return intval($num);
	}

	/**
	* getMonthIsstarCredit ȡ˵·ͼõĻ
	*
	* @return integer
	*/
	function getMonthIsstarCredit()
	{
		$time = strtotime(date('Y-m', $this->time).'-1 00:00:00');
		$sum = $this->db->GetOne("SELECT ls_plus_isstar FROM log_credit_settlement WHERE ls_uid = '".$this->uid."' AND ls_time = '".$time."'");

		return intval($sum);
	}


	/**
	* getDayIsstarCredit ȡ˵շͼõĻ
	*
	* @return integer
	*/
	function getDayIsstarCredit()
	{
		$starttime = strtotime(date('Y-m-d', $this->time).'00:00:00');
		$endtime = $this->time;
		$sql = "SELECT COUNT(*) FROM log_credit WHERE lc_uid = ".$this->uid." AND "
				."lc_kind = 'plus_isstar' AND lc_time BETWEEN ".$starttime." AND ".$endtime." ";
		$sum = $this->db->GetOne($sql);
		$sum = $sum*($this->credit_arr['plus_isstar']['credit']);
		return intval($sum);
	}

	/**
	* getBrokerPackageInfo ȡײ
	*
	* @return array
	*/
	function getBrokerPackageInfo()
	{
		$sql = "SELECT 	bg.plus_open,bg.isstar_credit_limit_day,bg.isstar_credit_upper_limit, bg.credit_upper_limit FROM "
				."broker_group bg LEFT JOIN broker b ON bg.id = b.groupid WHERE b.uid = '".$this->uid."'";
		return $this->db->GetRow($sql);
	}


	/**
	* getBrokerPackageInfo ȡ˿ͨ˺ͻ
	*
	* @return int
	*/
	function getBrokerOpenCredit()
	{
		$sql = "SELECT 	bg.plus_open FROM broker_group bg LEFT JOIN broker b ON bg.id = b.groupid WHERE b.uid = '".$this->uid."'";
		$credit =  $this->db->GetOne($sql);
		return intval($credit);
	}

	/**
	* addCreditOperateLog ֶ޸ľ˻ˮ˱¼
	*
	* @param str $kind
	* @param int $credit
	* @param str $operator
	* @param str $reason
	*/
	function addCreditOperateLog($kind, $credit, $operator, $reason)
	{
		$this->db->Execute("INSERT INTO log_credit_operate (lo_uid, lo_value, lo_kind, lo_operator, lo_reason, lo_time) VALUES ('".$this->uid."','".$credit."','".$kind."','".$operator."','".$reason."','".$this->time."')");
	}

	/**
	* updateBrokerCredit ¾˻
	*
	* @param int $credit
	*/
	function updateBrokerCredit($credit)
	{
		$this->db->Execute("UPDATE broker SET credit = '$credit' WHERE uid = '".$this->uid."'");
	}

	/**
	* getBrokerLoginTime ȡ¼ʱ
	*
	* @return str Ymd
	*/
	function getBrokerLoginTime()
	{
		$brokerlogintime = $this->db->GetOne("SELECT logintime FROM broker WHERE uid = '".$this->uid."'");
		return date('Ymd', $brokerlogintime);
	}

	/**
	* getBrokerCredit ȡ˻
	*
	* @param bool $doview	//ΪTRUEʱСΪ0
	* @return integer
	*/
	function getBrokerCredit($doview = false)
	{
		//ģǷЧЧֱӷ0
		if( !($this->esta_Module) || empty($this->esta_Module)  ){
			return 0;
		}
		$brokercredit = $this->db->GetOne("SELECT credit FROM broker WHERE uid = '".$this->uid."'");
		$brokercredit = intval($brokercredit);

		$brokercredit = $doview === true && $brokercredit < 0 ? 0 : $brokercredit;

		return $brokercredit;
	}

	/**
	* addCreditLog Ӿ˻ˮ˱¼
	*
	* @param str $kind
	* @param int $credit
	*/
	function addCreditLog($kind, $credit)
	{
		$this->db->Execute("INSERT INTO log_credit (lc_uid, lc_kind, lc_value, lc_time) VALUES ('".$this->uid."','".$kind."','".$credit."','".$this->time."')");
	}

	/**
	* getCreditLogTotal ȡ˻ˮ˼¼
	*
	* @param int $type  0:ȫʾ 1:ɸͼ 2:ֻͼ
	* @param int $day
	* @return integer
	*/
	function getCreditLogTotal($type, $day = 30)
	{
		$day = intval($day) - 1;
		$startday = $day > 0 ? strtotime("-".$day." day") : strtotime(date('Y-m-d').' 00:00:00');

		$typesql = $type == 1 ? " AND lc_kind = 'plus_isstar' " : ($type == 2 ? " AND lc_kind != 'plus_isstar' " : "");

		$total = $this->db->GetOne("SELECT COUNT(*) FROM log_credit WHERE lc_uid = '".$this->uid."' ".$typesql." AND lc_time >= '".$startday."'");

		return intval($total);
	}

	/**
	* getCreditLog ȡ˻ˮ˼¼
	*
	* @param int $type  0:ȫʾ 1:ɸͼ 2:ֻͼ
	* @param int $perpage
	* @param int $start
	* @param int $day
	* @return array
	*/
	function getCreditLog($type, $perpage = 20, $start = 0, $day = 30)
	{
		$perpage = intval($perpage);
		$start = intval($start);

		$day = intval($day) - 1;
		$startday = $day > 0 ? strtotime("-".$day." day") : strtotime(date('Y-m-d').' 00:00:00');

		$typesql = $type == 1 ? " AND lc_kind = 'plus_isstar' " : ($type == 2 ? " AND lc_kind != 'plus_isstar' " : "");
		$sql = "SELECT lc_kind,lc_value,lc_time FROM log_credit WHERE lc_uid = '".$this->uid."' ".$typesql." AND lc_time >= '".$startday."' ORDER BY lc_id DESC LIMIT ".$start.",".$perpage." ";

		$list = $this->db->GetAll($sql);

		$result = array();
		$i = 0;

		if(!empty($list)){
			foreach($list as $row)
			{
				$result[$i]['time'] = $row['lc_time'];
				$result[$i]['kind'] = $this->credit_arr[$row['lc_kind']]['title'];
				$result[$i]['credit'] = $this->credit_arr[$row['lc_kind']]['sign'].$row['lc_value'];
				$i++;
			}
		}

		return $result;
	}

	/**
	* updateCreditSettlement ¾˻¶Ƚ¼
	*
	* @param str $kind
	* @param bool $no_settlement
	* @return array
	*/
	function updateCreditSettlement($kind, $credit, $no_settlement)
	{
		$credit = intval($credit);
		$time = strtotime(date('Y-m', $this->time).'-1 00:00:00');

		$row = $this->db->GetRow("SELECT ls_id FROM log_credit_settlement WHERE ls_uid = '".$this->uid."' AND ls_time = '".$time."'");

		if($row)
		{
			if($no_settlement)
			{
				$sql = "UPDATE log_credit_settlement SET ls_credit = '".$this->brokercredit."' WHERE ls_id = '".$row['ls_id']."' ";
			}
			else
			{
				$sql = "UPDATE log_credit_settlement SET ls_credit = '".$this->brokercredit."', ls_".$kind." = ls_".$kind." + '".$credit."' WHERE ls_id = '".$row['ls_id']."' ";
			}
		}
		else
		{
			if($no_settlement)
			{
				$sql = "INSERT INTO log_credit_settlement (ls_uid, ls_time, ls_credit) VALUES ('".$this->uid."', '".$time."', '".$this->brokercredit."') ";
			}
			else
			{
				$sql = "INSERT INTO log_credit_settlement (ls_uid, ls_time, ls_credit, ls_".$kind.") VALUES ('".$this->uid."', '".$time."', '".$this->brokercredit."', '".$credit."') ";
			}
		}

		$this->db->Execute($sql);

		return $nowcredit;
	}

	/**
	* getCreditSettlementLog ȡ˻¶Ƚ¼
	*
	* @param int $month
	* @return array
	*/
	function getCreditSettlementLog($month = 5)
	{
		$month = intval($month);
		$month = $month > 0 ? $month : 5;
		$starttime = strtotime("-".$month." month");

		$list = $this->db->GetAll("SELECT * FROM log_credit_settlement WHERE ls_uid = '".$this->uid."' AND ls_time >= '".$starttime."' ORDER BY ls_time DESC LIMIT 6 ");

		return $list;
	}
}
?>