<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('display_errors',false);
error_reporting(0);

/**
 * Pay Class
 *
 * ۱֧ģ
 *
 * @package     zsb
 * @subpackage      Controllers
 * @category        Controllers
 * @author      sun
 */
class Payment extends MY_Controller {
    
   /**
    * 
    * @access public
    * @return void
    */
    public function __construct()
    {     
        parent::__construct();

		$functionSwitch = $this->config->item('functionSwitch');
		if($this->router->fetch_method() == 'recharge' && empty($functionSwitch['payment']))
		{
			$this->jump('/', 'ûȨޣ');
		}

		$this->functionSwitch = $functionSwitch;

        //֧ģ
        $this->load->model('payment_model');
		/****start****/
        $this->load->model('broker_model');
        $this->is_prohibit = $this->broker_model->is_prohibit($this->user_arr['agentcode']);
		//$this->is_prohibit = false;
        /*****end****/
    }
    
    /**
     * ҳ
     */
    public function index() 
    {
        //˲
        $info = $this->user_arr;
        //ȡ;˻ֺ͵ȼ
        $credit_level = $this->payment_model->get_broker_base($info);

        $info['credit'] = $credit_level['credit'];
        $info['level'] = $credit_level['level'];
        //
        $info['documentation'] = $this->config->item('documentation');
        //ֵҳ
        $info['recharge_url'] = $this->payment_model->get_module_url('recharge');
        //ֵ¼ҳ
        $info['recharge_record_url'] = $this->payment_model->get_module_url('recharge_record');
        //ϸ
        $info['transaction_detail_url'] = $this->payment_model->get_module_url('transaction_detail');
        //ȡ6׼¼
        $paymentHousebeanRecord = new PaymentHousebeanRecord();    
        /******start******/          
        $paymentHousebeanWay = new PaymentHousebeanWay();
        if($this->is_prohibit){           
            //ȡ;
            $infofroms = $paymentHousebeanWay->getByMethod(); 
            $search_infofrom = array_keys(SqlCombinHelper::changeToKeyArray($infofroms, 'alias'));
            unset($search_infofrom[0]);//recharge
            unset($search_infofrom[2]);//loginActivity
            unset($search_infofrom[4]);//telBuying            
            $transaction_record = $paymentHousebeanRecord->getNewByWayAlias($info['uid'],$search_infofrom, 6);
            
        }else{
            $transaction_record = $paymentHousebeanRecord->getNewBy($info['uid'], 6);
        }
        /******end******/  
        if (isset($transaction_record) && !empty($transaction_record))
        {
            $info['credit'] = $transaction_record[0]['remain_num'];
            //ʵƷ
            
            foreach($transaction_record as $k => $v)
            {
                $transaction_record[$k]['name'] = $paymentHousebeanWay->
                        getNameByWayAlias($v['way_alias']);
                $transaction_record[$k]['source'] = PaymentHousebeanSource
                        ::getSourcedescription($v['source']);
            }
        }
        else
        {
            $transaction_record = array();
        }

        //ѽ׼¼ҳ
        $info['transaction_record'] = $transaction_record;
        //ͷ
        $data_page['page_title'] = '֧-ҳ';
        $data_page['css'] = load_css('zsb/css/v1.0/style1.css');
        if ($info['smallphoto'] == '')
        {
            $info['smallphoto'] = STATIC_SOURCE_URL . '/zsb/images/v1.0/defaultface.jpg';
        }
			
		// 2016-1-14 Ǽ -----------start -------->
		
		$broker_new_info =$this->broker_model->get_broker_info_by_uid($info['uid']);
        $expire_housebeannum =$this->broker_model->check_broker_expire_housebeannum($info['uid']);

		// 2016-1-14 Ǽ -----------end -------->
        $data_page['info'] = $info;
		$data_page['broker_new_info'] = $broker_new_info;
		$data_page['is_prohibit'] = $this->is_prohibit;//
        $data_page['expire_housebeannum'] = $expire_housebeannum;
		$data_page['functionSwitch'] = $this->functionSwitch;
		$data_page['google_analytics'] = get_ga_js_code('/֧/ҳ/');
        $this->view('payment', 'payment_index', $data_page);
    }
    
    //ֵҳ
    public function recharge($id = null)
    {
        //ȡ֧ʧ֧ܺ
        $info = $this->user_arr;
        $payMethod = $this->config->item('payMethod');
        if ($id) 
        {
            //ѯ¼ idǷ ʵֵ¼
            $paymentRechargeRecord = new PaymentRechargeRecord();
            $recharge = $paymentRechargeRecord->getOneByIdAndBrokerId($id, $info['uid'], 0);
            if (!$recharge) 
            {
                echo $this->payment_model->get_check_result_str('ûд˳ֵ¼');
                return;
            }
            $select_active = $recharge['active_type'];
            $info['price'] = $recharge['price'];
            $info['bank_name'] = $recharge['bank_name'];
            $info['id'] = $recharge['id'];
            $info['type'] = $recharge['active_type'];
            $info['invoice'] = $recharge['invoice'];
        }
        else
        {
            //Ĭѡеһײͼ
            $select_active = 1;
            $info['bank_name'] = 'zggsyh';
            //ͨ΢֧Ĭѡ΢֧
            if(in_array('wxpay',$payMethod)){
                $info['bank_name'] = 'wxpay';
            }elseif(in_array('alipay',$payMethod)){
                $info['bank_name'] = 'alipay';
            }
        }

		// 2016-1-14 Ǽ -----------start -------->


		$broker_new_info =$this->broker_model->get_broker_info_by_uid($info['uid']);

		// 2016-1-14 Ǽ -----------end -------->

        //ȡ;˻ֺ͵ȼ
        $credit_level = $this->payment_model->get_broker_base($info);
        $info['credit'] = $credit_level['credit'];
        $info['level'] = $credit_level['level'];
        //ͷ
        $data_page['page_title'] = '֧-ֵ';
        $data_page['js'] = load_js('common/js/jquery.validate.min.js');
        $data_page['page_js'] = load_js('zsb/js/v1.0/pay.js');
        $data_page['css'] = load_css('zsb/css/v1.0/style1.css');
        //
        $info['bank'] = $this->payment_model->gate_port;
        //$info['active'] = $this->payment_model->get_recharge_active();
        //ȡ֧Ϣ
        $payment_config = $this->config->item('payment');
        //жϽǷμŻݻ
        $info['is_active'] = $this->payment_model->is_active($payment_config['active']['endtime']);
        //
        $info['documentation'] = $this->config->item('documentation');
        //֧Э
        $info['payment_agreement'] = $this->payment_model->get_module_url('agreement');;
        //֧
        $info['payment_config'] = $payment_config;
        //ɳֵתҳ
        $info['recharge_record'] = $this->payment_model->get_module_url('recharge_record');
        $info['select_active'] = $select_active;
        //֧ʽ
        $info['payMethod'] = $payMethod;
        $data_page['info'] = $info;
		$data_page['broker_new_info'] = $broker_new_info;
		$data_page['google_analytics'] = get_ga_js_code('/֧/ֵ/');
        $this->view('payment', 'payment_recharge', $data_page);
    }
    
    //֧
    public function pay($id = null) 
    {
        //˲
        $info = $this->user_arr;
        //Ҫ֤
        $rtn_status = array(
            'check_price' => false, 'check_pay_way' => false, 
            'exist_id' => false
        );
        //ȡ֧Ϣ
        $payment_config = $this->config->item('payment');
        //ײ ۸
        $type = $this->input->post('type');
        if ($type == 0) 
        {
            $price = $this->input->post('else_num');
            /*۸5Ϊ*/
            if ($price >= 5 && preg_match('/^[1-9]\d*$/', $price)) {
                $rtn_status['check_price'] = true;
            }
        } else {
            //Ǯķʽ
            $rtn_status['check_price'] = $this->payment_model->check_price(
                    $payment_config['price'], $type);
            $price = $payment_config['price'][$type];
        }

		
        //$price = '0.01';
        //Ǯ֤
        if ($rtn_status['check_price'] == false) 
        {
            echo $this->payment_model->get_check_result_str('ֵ');
            return;
        }
        //֧
        $bank_name = $this->input->post('back_name');

        //֧ʽ
        $rtn_status['check_pay_way'] = $this->payment_model->check_pay_way($bank_name);
        if ($rtn_status['check_pay_way'] == false)
        {
            echo $this->payment_model->get_check_result_str('֧');
            return;
        }
        //жϽǷμŻݻ
        $is_active = $this->payment_model->is_active($payment_config['active']['endtime']);
        //ֵ
        $program = 'ֵ' . $price . 'Ԫ';
        if ($is_active) 
        {
            $program .= ',' . $payment_config['active']['percentage'] . '';
        }
        //Ʊ̧ͷ
        $invoice = $this->input->post('invoice', true);
        //Դ
        $source = PaymentHousebeanSource::getSource();
        //ʵֵ¼
        $paymentRechargeRecord = new PaymentRechargeRecord();
        //жǷѾϢ ֱӲ飬֮Ҫ
        if ($id == null) { //û
            //ֵ¼$brokerId, $orderId, $program, 
            //$source, $num, $invoice, $type = 1
            //׺
            $transaction_id = PaymentTransactionId::getTransactionId(
                    $this->payment_model->way_alias);
            $id = $paymentRechargeRecord->insert($info['uid'], $type, $price, $bank_name,
                        $transaction_id, $program, $source, 0, $invoice);
        } else {
            // idǷ
            $recharge = $paymentRechargeRecord->getOneByIdAndBrokerId($id, $info['uid'], 0);
            if (!$recharge) 
            {
                echo $this->payment_model->get_check_result_str('ûд˳ֵ¼');
                return;
            }
             //׺
            $transaction_id = $recharge['transaction_id'];
            $field_values = array(
                'active_type' => $type, 'price' => $price,
                'program' => $program, 'invoice' => $invoice,
                'bank_name' => $bank_name
            );
            //ѡĲ
            $paymentRechargeRecord->update($field_values, $id, $info['uid']);
        }
        if (!$id) {return;}
        //ж֧֧ӿ
        $pay_api = $this->payment_model->get_pay_api($bank_name);
        //֧Ĺ
        $bank_base_url = $this->config->item('base_url') . $this->payment_model->module_controll;
        $bank_transfer_para = $pay_api . '/' . $info['uid'] . '/' . $id . '/';
        $return_url = $bank_base_url . '/success/' . $bank_transfer_para;
        $notify_url = $bank_base_url . '/notify/' . $bank_transfer_para;

        /*עѲԴɾ߼ϳжϣҪǺϷվϾվuidһ©
		if($info['uid']=='816039' || $info['uid']=='835248')
		{
			$price = '0.01';
		}
        */

		//$price = '0.01';

        if ($pay_api == 'chinapay')//
        {
            //֤ѡеײͼ
            $para = array(
                'transaction_id' => $transaction_id,
                'price' => $price,
                'bg_ret_url' => $notify_url,
                'page_ret_url' =>$return_url,
                'ord_desc' => 'esf_zsb_housebean',
            );
			
			
			if(GB_CITY == 'hf')
			{
				$para['MerId'] = '481601604090501';
				$para['bank_gate_id'] = $this->payment_model->gate_port[$bank_name]['newPort'];//ȡغ
				$chinapayVersion = 'new';
			}
			else
			{
				$para['bank_gate_id'] = $this->payment_model->gate_port[$bank_name]['port'];//ȡغ
				$chinapayVersion = 'old';
			}

            $this->load->library('payment/chinapay/ChinaPay', array('chinapayVersion' => $chinapayVersion), 'cp');
            echo $this->cp->dopay($para, 'POST');
        }
        else if ($pay_api == 'alipay') //֧
        {
            /*
             * ǰ߼
            //֤ѡеײͼ
            $para = array(
                'transaction_id' => $transaction_id,
                'price' => $price,
                'bg_ret_url' => $return_url,
                'page_ret_url' =>$notify_url,
                'ord_desc' =>  'esf_zsb_housebean',
                'ip' => GetIP(),
            );
            $this->load->library('payment/alipay/Alipay', '', 'ap');
            echo $this->ap->dopay($para, 'POST');
            */
            $this->load->library('payment/alipayNew/lib/Encryption');
            $res['data'] = array();
            //
            //$price = 0.01;
            //$notify_url = 'http://esfadmin.house365.com/notify_hf.php';
            // ҵ
            $bizContent = array(
                "timeout_express"	=>	"30m",
                "product_code"		=>	"FAST_INSTANT_TRADE_PAY",
                "total_amount"		=>	$price,
                "subject"			=>	iconv('GBK','UTF-8//IGNORE','۱ֵ'),
                //"subject"			=>	"۱ֵ",
                "out_trade_no"		=>	$transaction_id
            );
            $bizContent = json_encode($bizContent);
            // 
            $sParam = array(
                'app_id'			=>	APP_ID,
                'method'			=>	"alipay.trade.page.pay",
                'charset'			=>	"utf-8",
                'sign_type'			=>	"RSA",
                'sign'				=>	"",
                'timestamp'			=>	date("Y-m-d H:i:s",time()),
                'version'			=>	"1.0",
                'notify_url'		=>	$notify_url,
                'return_url'		=>	$return_url,
                'biz_content'		=>	$bizContent
            );

            $encpt = new Encryption();		// ʵ֧֧
            /** ˽Կ */
            $encpt->setRsaPriKeyFile(PRIVATE_KEY);
            $content = $encpt->requestAlipay($sParam);
            echo $content;exit;
        }
        else if ($pay_api == 'wxpay') //΢
        {
            $info = $this->user_arr;
            //ȡ;˻ֺ͵ȼ
            $credit_level = $this->payment_model->get_broker_base($info);
            $info['credit'] = $credit_level['credit'];
            $info['level'] = $credit_level['level'];
            $broker_new_info =$this->broker_model->get_broker_info_by_uid($info['uid']);
            $data_page['broker_new_info'] = $broker_new_info;
            $info['documentation'] = $this->config->item('documentation');
            $data_page['info'] = $info;
            $data_page['page_title'] = '֧-ֵ';
            $data_page['js'] = load_js('common/js/jquery.validate.min.js');
            $data_page['page_js'] = load_js('zsb/js/v1.0/pay.js');
            $data_page['css'] = load_css('zsb/css/v1.0/style1.css');
            //֤ѡеײͼ
            $para = array(
                'transaction_id' => $transaction_id,
                'price' => $price,
                'bg_ret_url' => $return_url,
                'page_ret_url' =>$notify_url,
                'ord_desc' =>  'esf_zsb_housebean',
                'id' => $id,
                'ip' => GetIP(),
            );
            $data_page['para'] = $para;
            $data = $this->getWxPayCode($id);

            if($data['status'] == 0 || empty($data["url"])){
                echo $this->payment_model->get_check_result_str($data['msg']);
                return;
            }
            $data_page['url'] = $data["url"];
            $data_page['google_analytics'] = get_ga_js_code('/֧/ֵ/');
            $this->view('payment', 'payment_wxpay', $data_page);
        }
    }
    //ajaxˢ¶ά
    public function refreshWxPayCode(){
        $this->load->model('ajax_model');
        $id = intval($_REQUEST['id']);
        $data = $this->getWxPayCode($id);
        echo $this->ajax_model->array_to_json($data);
    }
    //ȡ΢֧ά
    private function getWxPayCode($id){
        $info = $this->user_arr;
        $paymentRechargeRecord = new PaymentRechargeRecord();
        $recharge = $paymentRechargeRecord->getOneByIdAndBrokerId($id, $info['uid'], 0);
        $data = array('status' => 0);
        if (!$recharge) {
            $this->load->model('ajax_model');
            echo $this->ajax_model->array_to_json($data);exit;
        }
        //֧Ĺ
        $bank_base_url = $this->config->item('base_url') . $this->payment_model->module_controll;
        $bank_transfer_para = 'wxpay/' . $info['uid'] . '/' . $id . '/';
        $notify_url = $bank_base_url . '/notify/' . $bank_transfer_para;
        $transaction_id = $recharge['transaction_id'];
        $price = $recharge['price'];
        $this->load->library('payment/wxpay/NativePay');
        $notify = new NativePay();
        $input = new WxPayUnifiedOrder();
        $input->SetBody(iconv('gbk','utf-8','۱ֵ'));
        $input->SetOut_trade_no($transaction_id);
        $input->SetTime_start(date("YmdHis"));
        $input->SetTime_expire(date("YmdHis", time() + 70));
        if($info['uid'] == 2515 && false){
            $input->SetTotal_fee(1);
        }else{
            $input->SetTotal_fee($price*100);
        }
        $input->SetNotify_url($notify_url);
        $input->SetTrade_type("NATIVE");
        $input->SetProduct_id("365365");
        $result = $notify->GetPayUrl($input);

        if($result['return_code'] == 'FAIL' || $result['result_code'] == 'FAIL' || empty($result["code_url"])){
            $msg = !empty($result['err_code_des']) ? iconv('utf-8','gbk',$result['err_code_des']): '֧';
            $data['msg'] = $msg;
            return $data;
        }
        $data['status'] = 1;
        //$data['url'] = 'http://paysdk.weixin.qq.com/example/qrcode.php?data='.urlencode($result["code_url"]);
//        $data['url'] = 'https://api.qrserver.com/v1/create-qr-code/?size=298x298&data='.urlencode($result["code_url"]);
        $data['url']    = 'http://newrent.house365.com/api/common/get-qr-code?size=298&margin=0&url='.urlencode($result['code_url']);
        return $data;
    }
    //ҳ
    public function transaction($tab = 'detail')
    {
        //֤ҳtabǷϷ Զתҳҳ
        if (!in_array($tab, array_keys($this->payment_model->transaction_tab))) {
            $this->jump($this->payment_model->get_module_url('transaction_detail'),
                    'Ϸ');
            return;
        }
        //˲
        $info = $this->user_arr;
        //ȡ;˻ֺ͵ȼ
        $credit_level = $this->payment_model->get_broker_base($info);
        $info['credit'] = $credit_level['credit'];
        $info['level'] = $credit_level['level'];
        $paymentHousebeanWay = new PaymentHousebeanWay();

        //
        $info['source'] = $this->input->post('source');
        $info['infofrom'] = $this->input->post('infofrom');
        $info['start_time'] = $this->input->post('start_time');
        $info['end_time'] = $this->input->post('end_time');
        $page = $this->input->post('page');
        $info['page'] = (!isset($page) || $page == '') ? 1 
                : $this->input->post('page');
        //
        $sources = PaymentHousebeanSource::$sourceDescription;
        $sources[0] = 'ȫ';
        ksort($sources);
        $info['sources'] = $sources;
        //һҳչʾ¼
        $pagesize = 6;
        $start = ($info['page'] - 1) * $pagesize;
        if ($info['start_time'] == '' || $info['end_time'] == '') 
        {
            $info['start_time'] = date('Y-m-d', strtotime('-1 months'));
            $info['end_time'] = date('Y-m-d');
        }
        else
        {
            //жʱ䷶Χһµ
            $start_time = strtotime($info['start_time']);
            $end_time =  strtotime($info['end_time']);
            if ($end_time - $start_time > 2764799)
            {
            $this->jump($this->payment_model->get_module_url('transaction_detail'),
                    'ʱСһ');
                return;
            }
        }
        if ($tab == 'recharge')//ֵҳ
        {
            //ֵ¼
            $paymentRechargeRecord = new PaymentRechargeRecord();
            $infofroms = array(array('name' => 'ֵ', 'alias' => 'recharge'));
            $info['recharge_num'] = $paymentRechargeRecord->getSumBy($info['uid'],
                    $info['start_time'], $info['end_time'],
            1, $info['source']);
            $total_count = $paymentRechargeRecord->getCountBy($info['uid'], 
                    $info['start_time'], $info['end_time'] . ' 23:59:59',
            1, $info['source']);
            $transaction_record = $paymentRechargeRecord->getListBy($info['uid'],
                    $info['start_time'], $info['end_time'] . ' 23:59:59', 
                    $type = 1, $info['source'],
                    $start, $pagesize);
            if (isset($transaction_record) && !empty($transaction_record))
            {
                foreach($transaction_record as $k => $v)
                {
                    $transaction_record[$k]['source'] = PaymentHousebeanSource
                            ::getSourcedescription($v['source']);
                }
            }
            else
            {
                $transaction_record = array();
            }
        }
        else 
        {

            if ($tab == 'expend') //
            {
                $infofroms = $paymentHousebeanWay->getByMethod('expend');
            }
            else if ($tab == 'get')//ȡ
            {
                $infofroms = $paymentHousebeanWay->getByMethod('get');
            }
            else //ϸ
            {
               $infofroms = $paymentHousebeanWay->getByMethod(); 
            }
            //ʵ¼
            $paymentHousebeanRecord = new PaymentHousebeanRecord();
             //ȡ;
            $search_infofrom = $info['infofrom'] == '' ? 
                    array_keys(SqlCombinHelper::changeToKeyArray($infofroms, 'alias'))
                    : $info['infofrom'];
		
            //ķܺ
            if ($tab == 'expend' || $tab == 'detail')
            {
                if ($tab == 'detail' && is_array($search_infofrom)) 
                {
                    $expend_infofrom = $info['infofrom'] == '' ? 
                            array_keys(SqlCombinHelper::changeToKeyArray(
                        $paymentHousebeanWay->getByMethod('expend'), 'alias'))
                            : $info['infofrom'];
                }
                else
                {
                    
					$total_expend_inforom = array_keys(SqlCombinHelper::changeToKeyArray(
                        $paymentHousebeanWay->getByMethod('expend'), 'alias'));

					$expend_infofrom = in_array($search_infofrom,$total_expend_inforom) ? $search_infofrom : "";



                }
				if($expend_infofrom){
					 $info['expend_num'] = $paymentHousebeanRecord->getSumBy($info['uid'], 
                    $info['start_time'], $info['end_time'] . ' 23:59:59', 'expend', 
                        $info['source'], $expend_infofrom);
				
				}
               
				//if($_GET['xue']==1){
				//		var_dump($expend_infofrom);
				//	}
            }
            //ȡܺ
            if ($tab == 'get' || $tab == 'detail')
            {

                if ($tab == 'detail' && is_array($search_infofrom)) 
                {
                    $get_infofrom = $info['infofrom'] == '' ? 
                            array_keys(SqlCombinHelper::changeToKeyArray(
                        $paymentHousebeanWay->getByMethod('get'), 'alias'))
                            : $info['infofrom'];
                }
                else
                {

					$all_get_infofrom = array_keys(SqlCombinHelper::changeToKeyArray(
                        $paymentHousebeanWay->getByMethod('get'), 'alias'));
					
                    $get_infofrom = in_array($search_infofrom,$all_get_infofrom) ? $search_infofrom : "";
                }
                
				if($get_infofrom){
					 $info['get_num'] = $paymentHousebeanRecord->getSumBy($info['uid'], 
                    $info['start_time'], $info['end_time'] . ' 23:59:59', 'get', 
                        $info['source'], $get_infofrom);
				
				}

               
            }

			/******start******/            
         
			if($this->is_prohibit){
				if($tab == 'expend'){               
					unset($search_infofrom[1]);//telBuying    
					
				}elseif ($tab == 'get') {
					unset($search_infofrom[0]);//recharge
					unset($search_infofrom[2]);//loginActivity               
						
				}else{
					unset($search_infofrom[0]);//recharge
					unset($search_infofrom[2]);//loginActivity
					unset($search_infofrom[4]);//telBuying    
					 
				}
                
            } 
			/******end******/ 
            //

            $total_count = $paymentHousebeanRecord->getCountBy($info['uid'], 
                    $info['start_time'], $info['end_time'] . ' 23:59:59', null, $info['source'], 
                    $search_infofrom);

           //ӦĲ¼
           $transaction_record = $paymentHousebeanRecord->getListBy($info['uid'], 
                   $info['start_time'], $info['end_time'] . ' 23:59:59', null, 
                   $info['source'], $search_infofrom, $start, $pagesize);

            if (isset($transaction_record) && !empty($transaction_record))
            {
                foreach($transaction_record as $k => $v)
                {
                    $transaction_record[$k]['name'] = $paymentHousebeanWay->
                            getNameByWayAlias($v['way_alias']);
                    $transaction_record[$k]['source'] = PaymentHousebeanSource
                            ::getSourcedescription($v['source']);
                }
            }
            else
            {
                $transaction_record = array();
            }
        }
        //ҳ
        $pages  = $total_count > 0 ? ceil($total_count / $pagesize) : 0;
          //Ƿʾҳ
        $pagination = NULL;
        if($total_count > $pagesize)
        {
            $pagination = helper_pagination($info['page'], $pages, $total_count);
        }
        $info['total_count'] = $total_count;

        $info['transaction_record'] = $transaction_record;
        $info['pagination'] = $pagination;
        //ȡ;
        $infofroms = array_merge(array('0' => array('alias' => '0', 'name' => 'ȫ;')), $infofroms);
        $info['infofroms'] = SqlCombinHelper::changeToKeyArray($infofroms, 'alias');
		/******start******/
		if($this->is_prohibit){
			unset($info['infofroms']['recharge']);
			unset($info['infofroms']['loginActivity']);
			unset($info['infofroms']['telBuying']);
		}
	   
		/******end*****/
        //ҳtab
        $info['page_tab'] = $this->payment_model->get_transaction_tab();

		/******start******/
        if($this->is_prohibit){
            unset($info['page_tab']['recharge']);
        }
        /******end*****/

        $info['tab'] = $tab;
        //
        $info['select_time_tab'] = $this->input->post('select_time_tab');
        //ֵҳ
        $info['recharge_url'] = $this->payment_model->get_module_url('recharge');
        //ύҳ
        $info['submit_url'] = $this->payment_model->get_module_url($tab);
        $data_page['info'] = $info;

		// 2016-1-14 Ǽ -----------start -------->
		
		$broker_new_info =$this->broker_model->get_broker_info_by_uid($info['uid']);

		// 2016-1-14 Ǽ -----------end -------->

        //ͷ
        $data_page['page_title'] = '֧-׼¼';
		$data_page['is_prohibit'] = $this->is_prohibit;//
        $data_page['css'] = load_css('zsb/css/v1.0/style1.css');
        $data_page['page_js'] = load_js('common/js/My97DatePicker/WdatePicker.js');
		$data_page['google_analytics'] = get_ga_js_code('/֧/׼¼/');
		$data_page['broker_new_info'] = $broker_new_info;
		$data_page['functionSwitch'] = $this->functionSwitch;

        $this->view('payment', 'payment_transaction', $data_page);
    }
    
    //ֵɹ
    public function success($pay_api = null, $broker_id = null, $id = null) {
        //жϲǷ
        if ($pay_api == '' || $broker_id == '' || $id == '') {
            $this->jump($this->payment_model->get_module_url('recharge'),
                    'Ϸ');
            return;
        }

		//֧ϵͳϢ
		$data = $_POST;

		if(GB_CITY == 'hf')
		{
			$chinapayVersion = 'new';
		}
		else
		{
			$chinapayVersion = 'old';
		}

		//file_put_contents('payment_log_success_777.log', var_export($_POST,true),FILE_APPEND);
        //֤֧ǩ
        if ($pay_api == 'chinapay') //
        {
			$data['Signature'] = urlencode($data['Signature']);

            $this->load->library('payment/chinapay/ChinaPay', array('chinapayVersion' => $chinapayVersion), 'cp');
            $verify_result = $this->cp->success($data);
        }
        if ($pay_api == 'alipay') { //֧
            /*
            $this->load->library('payment/alipay/Alipay', '', 'ap');
            $verify_result = $this->ap->success();
            */
            //°֧GETʽݲ
            $data = $_GET;
            $this->load->library('payment/alipayNew/lib/Encryption');
            $encpt = new Encryption();
            $encpt->setRsaPubKeyFile(PUBLIC_KEY);
            /** ȡĲ */
            $rParam = $encpt->disposeResponseData($data);
            $stringToBeSign = $rParam['stringToBeSigned'];
            $signature = $rParam['signature'];
            /** ֤֧ */
            $result = $encpt->verify($stringToBeSign, $signature);
            if($result && ($data['auth_app_id'] == APP_ID || $data['app_id'] == APP_ID)){
                $verify_result =  true;


                /***** Ի޷صĴ ȥ*****/
                /*
                $paymentRechargeRecord = new PaymentRechargeRecord();
                $recharge = $paymentRechargeRecord->getOneByIdAndBrokerId($id, $broker_id, 0);
                if (!$recharge || $recharge['status'] == 1) {return;}//Ѿ֧
                //ȡ֧Ϣ
                $payment_config = $this->config->item('payment');
                //жϽǷμŻݻ
                $info['is_active'] = $this->payment_model->is_active($payment_config['active']['endtime']);
                //Żݻ ֱ
                $rate = $info['is_active'] ? $payment_config['active']['rate'] : $payment_config['init_rate'];
                //ݶ5Ԫ
                //$price = 5;
                $price = $recharge['price'];
                $num = $rate * $price;
                //ֵͻ
                $growthBrokerCredit = new GrowthBrokerCredit(array('id' => $broker_id));
                $growthBrokerCredit->increase('recharge', null, $num, 1, $recharge['transaction_id']);
                //ֵ
                $program = 'ֵ' . $price . 'Ԫ';
                if ($info['is_active'])
                {
                    $program .= ',' . $payment_config['active']['percentage'] . '';
                }
                $growthCredit = new GrowthCredit();
                $remain_num = $growthCredit->getValidCredit($broker_id);
                $field_values = array(
                    'program' => $program, 'num' => $num,'source'=>1,
                    'remain_num' => $remain_num,
                    'status' => 1, 'ctime' => date('Y-m-d H:i:s')
                );

                //ֵɹ֪ͨϵͳ
                $paymentRechargeRecord->successJobInsert(array('payment_housebean_id' => $id));

                //ѡĲ
                $paymentRechargeRecord->update($field_values, $id, $broker_id);
                $paymentRechargeRecord->copyRechargeSuccessRecord($id);
                */
                /***** Ի޷صĴ ȥ*****/

            }
        }
        //˲
        $info = $this->user_arr;
        if ($verify_result) //֤ɹ
        {
            $paymentRechargeRecord = new PaymentRechargeRecord();
            $recharge = $paymentRechargeRecord->getOneByIdAndBrokerId($id, $broker_id, 1);
            $info['num'] = $recharge['num'];
        }
        else
        {
            $this->jump($this->payment_model->get_module_url('recharge'),
                    'ǩʧ');
            return;
        }
        //ȡ;˻ֺ͵ȼ
        $credit_level = $this->payment_model->get_broker_base($info);
        $info['credit'] = $credit_level['credit'];
        $info['level'] = $credit_level['level'];
        //ͷ
        $data_page['page_title'] = '֧-֧ɹ';
        $data_page['css'] = load_css('zsb/css/v1.0/style1.css');
        //ֵҳ
        $info['recharge_url'] = $this->payment_model->get_module_url('recharge');
        //ֵ¼ҳ
        $info['recharge_record_url'] = $this->payment_model->get_module_url('recharge_record');
        //²Ʒ
        $info['buy_url'] = $this->payment_model->get_module_url();
        $data_page['info'] = $info;
        $this->view('payment', 'payment_success', $data_page);
    }
    
    //̨߳첽ִ
    public function notify($pay_api = null, $broker_id = null, $id = null)
    {
        //жϲǷ
        if ($pay_api == '' || $broker_id == '' || $id == '') {
            $this->jump($this->payment_model->get_module_url('recharge'),
                    'Ϸ');
            return;
        }
		
		//֧ϵͳϢ
		$data = $_POST;

		if(GB_CITY == 'hf')
		{
			$chinapayVersion = 'new';
		}
		else
		{
			$chinapayVersion = 'old';
		}

        //֤֧ǩ
        if ($pay_api == 'chinapay') //
        {
            $this->load->library('payment/chinapay/ChinaPay',array('chinapayVersion' => $chinapayVersion), 'cp');
            $verify_result = $this->cp->notify($data);
        }
        if ($pay_api == 'alipay') //֧
        {
            /*
            $this->load->library('payment/alipay/Alipay', '', 'ap');
            $verify_result = $this->ap->notify();
            */
            //
            $msg = "************************************************ \n";
            $msg .= date('Y-m-d H:i:s').var_export($data,true)." \n";
            $log = dirname(__FILE__)."/notify_alipay";
            file_put_contents($log,$msg,FILE_APPEND );
            $this->load->library('payment/alipayNew/lib/Encryption');
            $encpt = new Encryption();
            $encpt->setRsaPubKeyFile(PUBLIC_KEY);
            /** ȡĲ */
            $rParam = $encpt->disposeResponseData($data);
            $stringToBeSign = $rParam['stringToBeSigned'];
            $signature = $rParam['signature'];
            /** ֤֧ */
            $result = $encpt->verify($stringToBeSign, $signature);
            //Уȷ
            if($result && ( $data['trade_status'] == 'TRADE_SUCCESS' || $data['trade_status'] == 'TRADE_FINISHED' ) && ($data['auth_app_id'] == APP_ID || $data['app_id'] == APP_ID)){
                $verify_result = true;
            }
        }
        if ($pay_api == 'wxpay') //΢֧
        {
            //ini_set('display_errors','On');
            //error_reporting(E_ALL);
            $this->load->library('payment/wxpay/PayNotifyCallBack');
            $notify = new PayNotifyCallBack();
            //΢ŻصԼǩ
            $result = $notify->Handle(false);
            /*
            $msg = "************************************************ \n";
            $msg .= date('Y-m-d H:i:s').var_export($result,true)." \n";
            $log = dirname(__FILE__)."/notify";
            file_put_contents($log,$msg,FILE_APPEND );
            */
            //ǩʧܴ
            if($result['return_code'] != 'SUCCESS'){
                return;
            }
            $verify_result = true;
        }
        if ($verify_result)  //֤ɹ
        {
            $paymentRechargeRecord = new PaymentRechargeRecord();
            $recharge = $paymentRechargeRecord->getOneByIdAndBrokerId($id, $broker_id, 0);
            if (!$recharge || $recharge['status'] == 1) {return;}//Ѿ֧
            if($pay_api == 'wxpay'){
                //κ֧Уȷԣԭ֧֧֧Ͻ
                if($recharge['price'] * 100 != $result['data']['total_fee']){
                    return;
                }
            }
            if($pay_api == 'alipay'){
                if( $recharge['transaction_id'] != $data['out_trade_no']){
                    return;
                }
                //κ֧Уȷԣԭ֧֧֧Ͻ
                if($recharge['price']  != $data['total_amount']){
                    return;
                }
            }
            //ȡ֧Ϣ
            $payment_config = $this->config->item('payment');
            //жϽǷμŻݻ
            $info['is_active'] = $this->payment_model->is_active($payment_config['active']['endtime']);
            //Żݻ ֱ
            $rate = $info['is_active'] ? $payment_config['active']['rate'] : $payment_config['init_rate'];
            //ݶ5Ԫ
            //$price = 5;
            $price = $recharge['price'];
            $num = $rate * $price;
            //ֵͻ
            $growthBrokerCredit = new GrowthBrokerCredit(array('id' => $broker_id));
            $growthBrokerCredit->increase('recharge', null, $num, 1, $recharge['transaction_id']);
            //ֵ
            $program = 'ֵ' . $price . 'Ԫ';
            if ($info['is_active']) 
            {
                $program .= ',' . $payment_config['active']['percentage'] . '';
            }
            $growthCredit = new GrowthCredit();
            $remain_num = $growthCredit->getValidCredit($broker_id);
            $field_values = array(
                'program' => $program, 'num' => $num,'source'=>1,
                'remain_num' => $remain_num,
                'status' => 1, 'ctime' => date('Y-m-d H:i:s')
            );

			//ֵɹ֪ͨϵͳ
			$paymentRechargeRecord->successJobInsert(array('payment_housebean_id' => $id));

            //ѡĲ
            $paymentRechargeRecord->update($field_values, $id, $broker_id);
            $paymentRechargeRecord->copyRechargeSuccessRecord($id);
            //֪ͨ΢
            if($pay_api == 'wxpay'){
                $reply = "<xml>
                                <return_code><![CDATA[SUCCESS]]></return_code>
                                <return_msg><![CDATA[OK]]></return_msg>
                          </xml>";
                echo $reply;
            }
            if($pay_api == 'alipay'){
                echo 'success';
            }
            //ƶύ
            /*
            if ($pay_api != 'chinapay') {
                //˲
                $this->load->model('broker_model');
                $this->broker_model->set_uid($broker_id);
                $info = $this->broker_model->get_broker_info();
                $submit_data = array(
                    'trade_type_id' => 2,
                    'trade_activity' => $this->input->post("subject"),
                    'trade_time' => strtotime($this->input->post("notify_time")),
                    'trade_id' => $this->input->post("trade_no"),
                    'order_id' => $recharge['transaction_id'],
                    'order_amount' => $this->input->post("total_fee") * 100,
                    'user_name' => $info['truename'],
                    'user_tel' => $info['telno'],
                    'order_status' => 1,
                    'alipay_id' => $this->input->post("buyer_email"),
                    'order_city' => 'nj',
                );
                $this->load->helper('common_api_helper');
                curl_post_contents($this->config->item('alipay_mobile_notify_url'), $submit_data);
                echo 'success';
            }
            */
        }
        
    }
    
    //֧Э
    public function agreement() 
    {
        //ͷ
        $data_page['page_title'] = '֧-֧Э-365۱˰';
        $data_page['css'] = load_css('common/css/base.css,zsb/css/v1.0/public.css'
                . ',zsb/css/v1.0/style1.css');
        $this->load->view('payment_agreement', $data_page);
    }

    public function alipay_test()
    {
        //֤ѡеײͼ
        $para = array(
            'transaction_id' => 'ss',
            'price' => 0.01,
            'bg_ret_url' => "http://www.baidu.com",
            'page_ret_url' => "http://www.baidu.com",
            'ord_desc' =>  'esf_zsb_housebean',
            'ip' => GetIP(),
        );
        $this->load->library('payment/alipay/Alipay', '', 'ap');
        echo $this->ap->dopay($para, 'POST');
    }


	//Э
    public function houseagreement() 
    {
        //ͷ
        $data_page['page_title'] = 'Э-Э-365۱˰';
        $data_page['css'] = load_css('common/css/base.css,zsb/css/v1.0/public.css'
                . ',zsb/css/v1.0/style1.css');
        $this->load->view('house_agreement', $data_page);
    }
    public function orderQuery()
    {
        $this->load->library('payment/wxpay/NativePay');
        $out_trade_no = $_REQUEST["out_trade_no"];
        $input = new WxPayOrderQuery();
        $input->SetOut_trade_no($out_trade_no);
        $result = WxPayApi::orderQuery($input);
        $data = array('status' => 0);
        if(!empty($result['trade_state']) && $result['trade_state'] == 'SUCCESS'){
            $data['status'] = 1;
        }
        $this->load->model('ajax_model');
        echo $this->ajax_model->array_to_json($data);
    }
    public function successNew($id)
    {
        if(empty($id)){
            $this->jump($this->payment_model->get_module_url('recharge'),'Ϸ');
            return;
        }
        //˲
        $info = $this->user_arr;
        $broker_new_info =$this->broker_model->get_broker_info_by_uid($info['uid']);
        $data_page['broker_new_info'] = $broker_new_info;
        $paymentRechargeRecord = new PaymentRechargeRecord();
        //˴΢Żصӳ٣ܲѯ֧Ķ
        $recharge = $paymentRechargeRecord->getOneByIdAndBrokerIdNoStatus($id, $info['uid']);
        if(empty($recharge)){
            $this->jump($this->payment_model->get_module_url('recharge'),'Ϸ');
            return;
        }
        $data_page['orderId'] = $recharge['transaction_id'];
        $data_page['price'] = $recharge['price'];
        //ȡ;˻ֺ͵ȼ
        $credit_level = $this->payment_model->get_broker_base($info);
        $info['credit'] = $credit_level['credit'];
        $info['level'] = $credit_level['level'];
        //ͷ
        $info['documentation'] = $this->config->item('documentation');
        $data_page['page_title'] = '֧-֧ɹ';
        $data_page['css'] = load_css('zsb/css/v1.0/style1.css');
        $data_page['info'] = $info;
        $this->view('payment', 'payment_success_new', $data_page);
    }
}
