<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Sell Class
 *
 * ۱󹺡ģ
 *
 * @package     zsb
 * @subpackage      Controllers
 * @category        Controllers
 * @author      liuhu
 */
class House_demands extends MY_Controller {
    
    /**
     * в
     *
     * @access private
     * @var string
     */
    protected  $_city = NULL;

    /**
     * ǰҳ
     *
     * @access private
     * @var string
     */
    private $_current_page = 1;

    /**
     * ÿҳĿ
     *
     * @access private
     * @var int
     */
    private $_limit = 5;

    /**
     * ƫ
     *
     * @access private
     * @var int
     */
    private $_offset = 0;

    /**
     * Ŀ
     *
     * @access private
     * @var int
     */
    private $_total_count = 0;
    
    
    /**
     * 
     *
     * @access public
     * @return void
     */
    public function __construct()
    {   
        parent::__construct();
        
        //عַ
        $this->load->helper('common_string_helper');
    }
    
    
    /**
     * ʼҳ
     *
     * @access public
     * @param  int  $current_page
     * @param  int  $page_size
     * @return void
     */
    private function _init_pagination($current_page = 1 , $page_size = 0)
    {
        /** ǰҳ */
        $this->_current_page = ( $current_page && is_numeric( $current_page ) ) ? intval( $current_page ) : 1;

        /** ÿҳ */
        $this->_limit = ( $page_size && is_numeric( $page_size ) ) ? intval( $page_size ) : $this->_limit;

        /** ƫ */
        $this->_offset = ( $this->_current_page - 1 ) * $this->_limit;

        if($this->_offset < 0)
        {
            redirect(base_url());
        }
    }
    
    //ĬϿ
    public function index()
    {   
        $this->buy();
    }
    
    
    /**
     * 󹺹бҳ
     * 
     * @access pubic
     * @return void
     */
    public function buy()
    {
        $data_arr = array ();

        //ȡ
        $page = $this->input->post('page' , TRUE);

        /** ҳ */
        $this->_init_pagination($page);
        
        $this->load->model('buy_demand_model');
        
        //˺uid
        $broker_uid = $this->user_arr['uid'];
        
        //òѯֶ
        $field_arr = array('id','uid','infotype','address'
                        ,'buildyear1','buildyear2','buildarea1','buildarea2'
                        ,'price1','price2','contactor','remark','creattime'
                        ,'expiretime','room'
                        );
        $this->buy_demand_model->set_search_fields($field_arr);

        //ѯϷԴ
        $this->_total_count = $this->buy_demand_model->get_demand_num_by_uid( $broker_uid );

	//ҳ
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;

        //ѯϢб
        $demands_info = $this->buy_demand_model->get_demand_list_by_uid( $broker_uid , $this->_offset , $this->_limit );
        
        //ƥϢ
        $matched_arr = array();
        
        //ƥ䷿Դ
        $this->load->model('buy_match_model');
        
        //ƥ˵˺
        $this->buy_match_model->set_match_uid($broker_uid);
        
        //ƥ
        $matched_num = $this->buy_match_model->get_count_by_matchuid( 5 );
        if( $matched_num > 0)
        {   
            $this->buy_match_model->set_search_fields(array('want_id'));
            $matched_arr_all = $this->buy_match_model->get_list_by_matchuid( 5 , 0 , $matched_num);
            
            if(is_array($matched_arr_all) && !empty($matched_arr_all))
            {
                foreach ($matched_arr_all as $key => $value)
                {
                    $matched_arr[] = $value['want_id'];
                }
            }
        }

        //ǰʱ
        $now_time = intval (date( 'His' , time())); 
        
        //طԴ
        $house = $this->config->item('house');
        
        $demands_num = count( $demands_info );
        for( $i = 0 ; $i < $demands_num ; $i++ )
        {
            //ÿϢʱ
            $publish_time = intval (date( 'His' , $demands_info[$i]['creattime'] ) );

            //ÿϢƥʱͱƥ俪ʼڵ
            if( $now_time < $publish_time )
            {
                $next_time = date( 'Y-m-d' , time() ).' '.date('H:i:s' ,$demands_info[$i]['creattime']);
            }
            else
            {
                $next_time = date( 'Y-m-d' , time() + 86400 ).' '.date('H:i:s' ,$demands_info[$i]['creattime']);
            }

            // date formate july 30, 2014 10:20:30
            $demands_info[$i]['next_match_time'] =  date('F j, Y H:i:s',strtotime($next_time));

            //ֿʼʱڵ
            $start_time = strtotime( $next_time ) - 86400;

            //ƥ
            $infofrom = '';
            $today_matched_num = $this->buy_match_model->get_count_by_wantid( 5 , $start_time );
            $demands_info[$i]['totday_matched_num'] = intval($today_matched_num);
            
            //Ҫ⴦Ĳ
            $demands_info[$i]['remark'] = csubstr( $demands_info[$i]['remark'] , 80 , 1 );
            $demands_info[$i]['infotype'] = $house['infotype'][$demands_info[$i]['infotype']] != '' 
                                    ? $house['infotype'][$demands_info[$i]['infotype']] : '';
        }
        
        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }

        $data_arr['page_title'] = 'ƥ-';
        $data_arr['template_name'] = 'buy_demands_list';
        $data['page'] = $this->_current_page;
        $data_arr['demands_info'] = $demands_info; //Ϣ
        $data_arr['matched_ids_arr'] = $matched_arr;//ƥϢ
        $data_arr['js'] = load_js('common/js/jquery.jcountdown.js,common/js/ajax_page.js');//ҪصJS
        $data_arr['css'] = load_css('zsb/css/v1.0/style1.css');//Ҫصcss
        $data_arr['perday_matche_limit'] = 20;
        $data_arr['pagination'] =   $pagination;
        
        //ģ
        $this->view( 'house_manage' , 'buy_match_manage' , $data_arr );
    }
    
    
    /**
     * ƥбҳ
     * 
     * @access pubic
     * @return void
     */
    public function buy_matched()
    {
        $data_arr = array ();

        //ȡ
        $page = $this->input->post('page' , TRUE);

        /** ҳ */
        $this->_init_pagination($page);
        
        //uid
        $broker_uid = $this->user_arr['uid'];
        
        //ƥMODEL
        $this->load->model('buy_match_model');
        
        //MODEL
        $this->load->model('buy_demand_model');
        
        //òѯֶ
        $field_arr = array('id','infotype','address','buildyear1'
                    ,'buildyear2','buildarea1','buildarea2'
                     ,'price1','price2','telno','remark'
                    );
        $this->buy_match_model->set_search_fields($field_arr);

        //ѯƥ󹺸
        $this->buy_match_model->set_match_uid( $broker_uid );
        $this->_total_count = $this->buy_match_model->get_count_by_matchuid( 5 );

	//ҳ
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;
        
        //ƥϢ
        $demand_tbl = $this->buy_demand_model->get_tbl();
        $matched_arr = array();
        $matched_arr = $this->buy_match_model->get_demandlist_by_matchuid( $demand_tbl , 5 , $this->_offset , $this->_limit );
        
        //طԴ
        $house = $this->config->item('house');
        $demands_num = count($matched_arr);
        for( $i = 0 ; $i < $demands_num ; $i++ )
        {
            //Ҫ⴦Ĳ
            $matched_arr[$i]['remark'] = csubstr( $matched_arr[$i]['remark'] , 80 , 1 );
            $matched_arr[$i]['infotype'] = $house['infotype'][$matched_arr[$i]['infotype']] != '' 
                                    ? $house['infotype'][$matched_arr[$i]['infotype']] : '';
        }
        
        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination   = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }
        
        $data_arr['page_title'] = 'ƥ-ƥ';
        $data_arr['template_name'] = 'buy_demands_matched_list';
        $data['page'] = $this->_current_page;
        $data_arr['js'] = load_js('common/js/ajax_page.js,zsb/js/v1.0/js2.js');    //ҪصJS
        $data_arr['css'] = load_css('zsb/css/v1.0/style1.css');//Ҫصcss
        $data_arr['matched_info'] = $matched_arr;   //Ϣ
        $data_arr['pagination'] =   $pagination;
        
        //ģ
        $this->view( 'house_manage' , 'buy_match_manage' , $data_arr );
    }
    
    
    /**
     * бҳ
     * 
     * @access pubic
     * @return void
     */
    public function rent()
    {
        $data_arr = array ();

        //ȡ
        $page = $this->input->post('page' , TRUE);

        /** ҳ */
        $this->_init_pagination($page);
        
        $this->load->model('rent_demand_model');
        
        //˺uid
        $broker_uid = $this->user_arr['uid'];
        
        //òѯֶ
        $field_arr = array('id','uid','infotype','address','buildarea1'
            ,'buildarea2','price1','price2','contactor','remark','creattime'
            ,'expiretime','renttype');
        $this->rent_demand_model->set_search_fields($field_arr);

        //ѯϷԴ
        $this->_total_count = $this->rent_demand_model->get_demand_num_by_uid( $broker_uid );

	//ҳ
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;

        //ѯϢб
        $demands_info = $this->rent_demand_model->get_demand_list_by_uid( $broker_uid , $this->_offset , $this->_limit );
        
        //ƥϢ
        $matched_arr = array();
        
        //ƥ䷿Դ
        $this->load->model('rent_match_model');
        
        //ƥ˵˺
        $this->rent_match_model->set_match_uid($broker_uid);
        
        //ƥ
        $matched_num = $this->rent_match_model->get_count_by_matchuid( 5 );
        if( $matched_num > 0)
        {   
            $this->rent_match_model->set_search_fields(array('want_id'));
            $matched_arr_all = $this->rent_match_model->get_list_by_matchuid( 5 , 0 , $matched_num);
            
            if(is_array($matched_arr_all) && !empty($matched_arr_all))
            {
                foreach ($matched_arr_all as $key => $value)
                {
                    $matched_arr[] = $value['want_id'];
                }
            }
        }

        //ǰʱ
        $now_time = intval (date( 'His' , time())); 
        
        //طԴ
        $house = $this->config->item('house');
        
        $demands_num = count( $demands_info );
        for( $i = 0 ; $i < $demands_num ; $i++ )
        {
            //ÿϢʱ
            $publish_time = intval (date( 'His' , $demands_info[$i]['creattime'] ) );

            //ÿϢƥʱͱƥ俪ʼڵ
            if( $now_time < $publish_time )
            {
                $next_time = date( 'Y-m-d' , time() ).' '.date('H:i:s' ,$demands_info[$i]['creattime']);
            }
            else
            {
                $next_time = date( 'Y-m-d' , time() + 86400 ).' '.date('H:i:s' ,$demands_info[$i]['creattime']);
            }

            // date formate july 30, 2014 10:20:30
            $demands_info[$i]['next_match_time'] =  date('F j, Y H:i:s',strtotime($next_time));

            //ֿʼʱڵ
            $start_time = strtotime( $next_time ) - 86400;

            //ƥ
            $infofrom = '';
            $today_matched_num = $this->rent_match_model->get_count_by_wantid( 5 , $start_time );
            $demands_info[$i]['totday_matched_num'] = intval($today_matched_num);
            
            //Ҫ⴦Ĳ
            $demands_info[$i]['remark'] = csubstr( $demands_info[$i]['remark'] , 80 , 1 );
            $demands_info[$i]['infotype'] = $house['infotype'][$demands_info[$i]['infotype']] != '' 
                                    ? $house['infotype'][$demands_info[$i]['infotype']] : '';
        }
        
        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }

        $data_arr['page_title'] = 'ƥ-';
        $data_arr['template_name'] = 'rent_demands_list';
        $data['page'] = $this->_current_page;
        $data_arr['demands_info'] = $demands_info; //Ϣ
        $data_arr['matched_ids_arr'] = $matched_arr;//ƥϢ
        $data_arr['js'] = load_js('common/js/jquery.jcountdown.js,common/js/ajax_page.js');//ҪصJS
        $data_arr['css'] = load_css('zsb/css/v1.0/style1.css');//Ҫصcss
        $data_arr['perday_matche_limit'] = 20;
        $data_arr['pagination'] =   $pagination;
        
        //ģ
        $this->view( 'house_manage' , 'rent_match_manage' , $data_arr );
    }
    
    
    /**
     * ƥбҳ
     * 
     * @access pubic
     * @return void
     */
    public function rent_matched()
    {
        $data_arr = array ();

        //ȡ
        $page = $this->input->post('page' , TRUE);

        /** ҳ */
        $this->_init_pagination($page);
        
        //uid
        $broker_uid = $this->user_arr['uid'];
        
        //ƥMODEL
        $this->load->model('rent_match_model');
        
        //MODEL
        $this->load->model('rent_demand_model');
        
        //òѯֶ
        $field_arr = array('id','infotype','address','renttype',
                    'buildarea1','buildarea2','price1','price2','telno','remark');
        $this->rent_match_model->set_search_fields($field_arr);

        //ѯƥ
        $this->rent_match_model->set_match_uid( $broker_uid );
        $this->_total_count = $this->rent_match_model->get_count_by_matchuid( 5 );

	//ҳ
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;
        
        //ƥϢ
        $demand_tbl = $this->rent_demand_model->get_tbl();
        $matched_arr = array();
        $matched_arr = $this->rent_match_model->get_demandlist_by_matchuid( $demand_tbl , 5 , $this->_offset , $this->_limit );
        
        //طԴ
        $house = $this->config->item('house');
        $demands_num = count($matched_arr);
        for( $i = 0 ; $i < $demands_num ; $i++ )
        {
            //Ҫ⴦Ĳ
            $matched_arr[$i]['remark'] = csubstr( $matched_arr[$i]['remark'] , 80 , 1 );
            $matched_arr[$i]['infotype'] = $house['infotype'][$matched_arr[$i]['infotype']] != '' 
                                    ? $house['infotype'][$matched_arr[$i]['infotype']] : '';
        }
        
        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $pagination = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }
        
        $data_arr['page_title'] = 'ƥ-ƥ';
        $data_arr['template_name'] = 'rent_demands_matched_list';
        $data['page'] = $this->_current_page;
        $data_arr['js'] = load_js('common/js/ajax_page.js,zsb/js/v1.0/js2.js');    //ҪصJS
        $data_arr['css'] = load_css('zsb/css/v1.0/style1.css');//Ҫصcss
        $data_arr['matched_info'] = $matched_arr;   //Ϣ
        $data_arr['pagination'] =   $pagination;
        
        //ģ
        $this->view( 'house_manage' , 'rent_match_manage' , $data_arr );
    }
}
/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */