<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
  |--------------------------------------------------------------------------
  | Base Site URL
  |--------------------------------------------------------------------------
  |
  | URL to your CodeIgniter root. Typically this will be your base URL,
  | WITH a trailing slash:
  |
  |	http://example.com/
  |
  | If this is not set then CodeIgniter will guess the protocol, domain and
  | path to your installation.
  |
 */
$config['base_url'] = 'http://'.GB_CITY.'.zsb.house365.com/';

/*
  |--------------------------------------------------------------------------
  | Index File
  |--------------------------------------------------------------------------
  |
  | Typically this will be your index.php file, unless you've renamed it to
  | something else. If you are using mod_rewrite to remove the page set this
  | variable so that it is blank.
  |
 */
$config['index_page'] = '';

/*
  |--------------------------------------------------------------------------
  | URI PROTOCOL
  |--------------------------------------------------------------------------
  |
  | This item determines which server global should be used to retrieve the
  | URI string.  The default setting of 'AUTO' works for most servers.
  | If your links do not seem to work, try one of the other delicious flavors:
  |
  | 'AUTO'		Default - auto detects
  | 'PATH_INFO'		Uses the PATH_INFO
  | 'QUERY_STRING'	Uses the QUERY_STRING
  | 'REQUEST_URI'		Uses the REQUEST_URI
  | 'ORIG_PATH_INFO'	Uses the ORIG_PATH_INFO
  |
 */
$config['uri_protocol'] = 'AUTO';

/*
  |--------------------------------------------------------------------------
  | URL suffix
  |--------------------------------------------------------------------------
  |
  | This option allows you to add a suffix to all URLs generated by CodeIgniter.
  | For more information please see the user guide:
  |
  | http://codeigniter.com/user_guide/general/urls.html
 */

$config['url_suffix'] = '';

/*
  |--------------------------------------------------------------------------
  | Default Language
  |--------------------------------------------------------------------------
  |
  | This determines which set of language files should be used. Make sure
  | there is an available translation if you intend to use something other
  | than english.
  |
 */
$config['language'] = 'english';

/*
  |--------------------------------------------------------------------------
  | Default Character Set
  |--------------------------------------------------------------------------
  |
  | This determines which character set is used by default in various methods
  | that require a character set to be provided.
  |
 */
$config['charset'] = 'GBK';

/*
  |--------------------------------------------------------------------------
  | Enable/Disable System Hooks
  |--------------------------------------------------------------------------
  |
  | If you would like to use the 'hooks' feature you must enable it by
  | setting this variable to TRUE (boolean).  See the user guide for details.
  |
 */
$config['enable_hooks'] = FALSE;


/*
  |--------------------------------------------------------------------------
  | Class Extension Prefix
  |--------------------------------------------------------------------------
  |
  | This item allows you to set the filename/classname prefix when extending
  | native libraries.  For more information please see the user guide:
  |
  | http://codeigniter.com/user_guide/general/core_classes.html
  | http://codeigniter.com/user_guide/general/creating_libraries.html
  |
 */
$config['subclass_prefix'] = 'MY_';


/*
  |--------------------------------------------------------------------------
  | Allowed URL Characters
  |--------------------------------------------------------------------------
  |
  | This lets you specify with a regular expression which characters are permitted
  | within your URLs.  When someone tries to submit a URL with disallowed
  | characters they will get a warning message.
  |
  | As a security measure you are STRONGLY encouraged to restrict URLs to
  | as few characters as possible.  By default only these are allowed: a-z 0-9~%.:_-
  |
  | Leave blank to allow all characters -- but only if you are insane.
  |
  | DO NOT CHANGE THIS UNLESS YOU FULLY UNDERSTAND THE REPERCUSSIONS!!
  |
 */
$config['permitted_uri_chars'] = 'a-z 0-9~%.:_\-';


/*
  |--------------------------------------------------------------------------
  | Enable Query Strings
  |--------------------------------------------------------------------------
  |
  | By default CodeIgniter uses search-engine friendly segment based URLs:
  | example.com/who/what/where/
  |
  | By default CodeIgniter enables access to the $_GET array.  If for some
  | reason you would like to disable it, set 'allow_get_array' to FALSE.
  |
  | You can optionally enable standard query string based URLs:
  | example.com?who=me&what=something&where=here
  |
  | Options are: TRUE or FALSE (boolean)
  |
  | The other items let you set the query string 'words' that will
  | invoke your controllers and its functions:
  | example.com/index.php?c=controller&m=function
  |
  | Please note that some of the helpers won't work as expected when
  | this feature is enabled, since CodeIgniter is designed primarily to
  | use segment based URLs.
  |
 */
$config['allow_get_array'] = TRUE;
$config['enable_query_strings'] = FALSE;
$config['controller_trigger'] = 'c';
$config['function_trigger'] = 'm';
$config['directory_trigger'] = 'd'; // experimental not currently in use

/*
  |--------------------------------------------------------------------------
  | Error Logging Threshold
  |--------------------------------------------------------------------------
  |
  | If you have enabled error logging, you can set an error threshold to
  | determine what gets logged. Threshold options are:
  | You can enable error logging by setting a threshold over zero. The
  | threshold determines what gets logged. Threshold options are:
  |
  |	0 = Disables logging, Error logging TURNED OFF
  |	1 = Error Messages (including PHP errors)
  |	2 = Debug Messages
  |	3 = Informational Messages
  |	4 = All Messages
  |
  | For a live site you'll usually only enable Errors (1) to be logged otherwise
  | your log files will fill up very fast.
  |
 */
$config['log_threshold'] = 0;

/*
  |--------------------------------------------------------------------------
  | Error Logging Directory Path
  |--------------------------------------------------------------------------
  |
  | Leave this BLANK unless you would like to set something other than the default
  | application/logs/ folder. Use a full server path with trailing slash.
  |
 */
$config['log_path'] = '';

/*
  |--------------------------------------------------------------------------
  | Date Format for Logs
  |--------------------------------------------------------------------------
  |
  | Each item that is logged has an associated date. You can use PHP date
  | codes to set your own date formatting
  |
 */
$config['log_date_format'] = 'Y-m-d H:i:s';

/*
  |--------------------------------------------------------------------------
  | Cache Directory Path
  |--------------------------------------------------------------------------
  |
  | Leave this BLANK unless you would like to set something other than the default
  | system/cache/ folder.  Use a full server path with trailing slash.
  |
 */
$config['cache_path'] = '';

/*
  |--------------------------------------------------------------------------
  | Encryption Key
  |--------------------------------------------------------------------------
  |
  | If you use the Encryption class or the Session class you
  | MUST set an encryption key.  See the user guide for info.
  |
 */
$config['encryption_key'] = '';

/*
  |--------------------------------------------------------------------------
  | Session Variables
  |--------------------------------------------------------------------------
  |
  | 'sess_cookie_name'		= the name you want for the cookie
  | 'sess_expiration'		= the number of SECONDS you want the session to last.
  |   by default sessions last 7200 seconds (two hours).  Set to zero for no expiration.
  | 'sess_expire_on_close'	= Whether to cause the session to expire automatically
  |   when the browser window is closed
  | 'sess_encrypt_cookie'		= Whether to encrypt the cookie
  | 'sess_use_database'		= Whether to save the session data to a database
  | 'sess_table_name'		= The name of the session database table
  | 'sess_match_ip'		= Whether to match the user's IP address when reading the session data
  | 'sess_match_useragent'	= Whether to match the User Agent when reading the session data
  | 'sess_time_to_update'		= how many seconds between CI refreshing Session Information
  |
 */
$config['sess_cookie_name'] = 'ci_session';
$config['sess_expiration'] = 7200;
$config['sess_expire_on_close'] = FALSE;
$config['sess_encrypt_cookie'] = FALSE;
$config['sess_use_database'] = FALSE;
$config['sess_table_name'] = 'ci_sessions';
$config['sess_match_ip'] = FALSE;
$config['sess_match_useragent'] = TRUE;
$config['sess_time_to_update'] = 300;

/*
  |--------------------------------------------------------------------------
  | Cookie Related Variables
  |--------------------------------------------------------------------------
  |
  | 'cookie_prefix' = Set a prefix if you need to avoid collisions
  | 'cookie_domain' = Set to .your-domain.com for site-wide cookies
  | 'cookie_path'   =  Typically will be a forward slash
  | 'cookie_secure' =  Cookies will only be set if a secure HTTPS connection exists.
  |
 */
$config['cookie_prefix'] = "";
$config['cookie_domain'] = "";
$config['cookie_path'] = "/";
$config['cookie_secure'] = FALSE;

/*
  |--------------------------------------------------------------------------
  | Global XSS Filtering
  |--------------------------------------------------------------------------
  |
  | Determines whether the XSS filter is always active when GET, POST or
  | COOKIE data is encountered
  |
 */
$config['global_xss_filtering'] = FALSE;

/*
  |--------------------------------------------------------------------------
  | Cross Site Request Forgery
  |--------------------------------------------------------------------------
  | Enables a CSRF cookie token to be set. When set to TRUE, token will be
  | checked on a submitted form. If you are accepting user data, it is strongly
  | recommended CSRF protection be enabled.
  |
  | 'csrf_token_name' = The token name
  | 'csrf_cookie_name' = The cookie name
  | 'csrf_expire' = The number in seconds the token should expire.
 */
$config['csrf_protection'] = FALSE;
$config['csrf_token_name'] = 'csrf_test_name';
$config['csrf_cookie_name'] = 'csrf_cookie_name';
$config['csrf_expire'] = 7200;

/*
  |--------------------------------------------------------------------------
  | Output Compression
  |--------------------------------------------------------------------------
  |
  | Enables Gzip output compression for faster page loads.  When enabled,
  | the output class will test whether your server supports Gzip.
  | Even if it does, however, not all browsers support compression
  | so enable only if you are reasonably sure your visitors can handle it.
  |
  | VERY IMPORTANT:  If you are getting a blank page when compression is enabled it
  | means you are prematurely outputting something to your browser. It could
  | even be a line of whitespace at the end of one of your scripts.  For
  | compression to work, nothing can be sent before the output buffer is called
  | by the output class.  Do not 'echo' any values with compression enabled.
  |
 */
$config['compress_output'] = FALSE;

/*
  |--------------------------------------------------------------------------
  | Master Time Reference
  |--------------------------------------------------------------------------
  |
  | Options are 'local' or 'gmt'.  This pref tells the system whether to use
  | your server's local time as the master 'now' reference, or convert it to
  | GMT.  See the 'date helper' page of the user guide for information
  | regarding date handling.
  |
 */
$config['time_reference'] = 'local';


/*
  |--------------------------------------------------------------------------
  | Rewrite PHP Short Tags
  |--------------------------------------------------------------------------
  |
  | If your PHP installation does not have short tag support enabled CI
  | can rewrite the tags on-the-fly, enabling you to utilize that syntax
  | in your view files.  Options are TRUE or FALSE (boolean)
  |
 */
$config['rewrite_short_tags'] = FALSE;


/*
  |--------------------------------------------------------------------------
  | Reverse Proxy IPs
  |--------------------------------------------------------------------------
  |
  | If your server is behind a reverse proxy, you must whitelist the proxy IP
  | addresses from which CodeIgniter should trust the HTTP_X_FORWARDED_FOR
  | header in order to properly identify the visitor's IP address.
  | Comma-delimited, e.g. '10.0.1.200,10.0.1.201'
  |
 */
$config['proxy_ips'] = '';

/*
 * ˳ɳϵ
 */
$config['growth']['memcache'] = true;
//douʾģʽ
$config['growth']['mode'] = 'dou';
//׷ӷ
$config['growth']['additionalScore']['block'] = '3';//СרҾͶ
$config['growth']['additionalScore']['house'] = '3';//ԴͶ
$config['growth']['additionalScore']['rent'] = '3';// ⷿͶ
$config['growth']['additionalScore']['school'] = '3';//ѧͶ xue 2014-11-18
//Ĳ
$config['house'] = array(
    "infotype"  => array ('1'=>'סլ', '2'=>'','3'=>'д¥','4'=>'','6'=>'⳵λ','5'=>'ֿ⳧'),
    "infofrom"  => array ('1'=>'[]', '2'=>'нŵ','5'=>''),

    "district" => array(''=>'',''=>'','ɽ'=>'ɽ',''=>'',''=>''),
    "mright" => array ('Ȩ'=>'Ȩ','ʹȨ'=>'ʹȨ'),
    "purpose" =>  array ('ͨסլ'=>'ͨסլ', 'Ԣ'=>'Ԣ',''=>'','סۺ'=>'סۺ'),
    "office_purpose" =>  array ('д¥'=>'д¥','סۺ'=>'סۺ'),
    "store_purpose" =>  array ('淿'=>'淿','ҵ'=>'ҵ', ''=>'',''=>'', 'ֿ'=>'ֿ'),
    "buildtype"  => array (''=>'', 'С߲'=>'С߲', '߲'=>'߲','Ծ'=>'Ծ',''=>'','ű'=>'ű','˫ƴ'=>'˫ƴ','ӱ'=>'ӱ','ƽ'=>'ƽ',''=>''),
    "structure" =>  array ('ש'=>'ש','שľ'=>'שľ','ֻ'=>'ֻ',''=>'',''=>'',''=>''),
    "forward"  => array ('ϱ'=>'ϱͨ͸', ''=>'', ''=>'', ''=>'', ''=>''),
    "baseservice"  => array ('ú/Ȼ'=>'ú/Ȼ', 'ů'=>'ů',''=>'', 'λ'=>'λ', '԰'=>'԰', ''=>'', '¥'=>'¥', '¶̨'=>'¶̨', 'ⷿ'=>'ⷿ'),
    "equipment"  => array (''=>'', ''=>'',''=>'',  'յ'=>'յ', 'ϴ»'=>'ϴ»', 'ˮ'=>'ˮ', 'Ҿ'=>'Ҿ', ''=>'', ''=>'', ''=>''),
    "environment"  => array ('԰'=>'԰' , 'ҽԺ'=>'ҽԺ' , ''=>'', 'Ӿ'=>'Ӿ' , ''=>'', '̳'=>'̳', '˳'=>'˳', ''=>'', '׶԰'=>'׶԰', ''=>''),
    "fitment"  => array ('ë'=>'ë','װ'=>'װ', 'װ'=>'װ','װ'=>'װ'),
    "esta"  => array ('1'=>'','0'=>'','-8'=>'˵','-7'=>'Ȩ','-6'=>'߶Ϣ','-5'=>'ظϢ','-4'=>'Ϣ','-3'=>'贫沵','-2'=>'н鲵', '-1'=>'δ', '2'=>'ʧЧ','3'=>'ɽ','4'=>'ɾ','5'=>'', '-10' => 'ҹ'),
    "chargetag"  => array ('0'=>'ѷ', '1'=>'շѷ'),
    "renttype"   => array (''=>'', ''=>''),
    "rentremark"   => array ('Ů'=>'Ů','ֻ'=>'ֻ','ֻŮ'=>'ֻŮ'),
    "rentday"   => array ('һ'=>'һ',''=>'', 'һ'=>'һ','һ'=>'һ'),
    "personunit"  => array('1'=>'Ԫ/','2'=>'Ԫ/*ƽ','3'=>'Ԫ/*ƽ','4'=>'Ԫ/'),
    "priceunit"   => array ('1'=>'Ԫ/','2'=>'Ԫ/*ƽ', '4' => 'Ԫ/'),
    "shoppriceunit"   => array ('1'=>'Ԫ/','2'=>'Ԫ/*ƽ','3'=>'Ԫ/*ƽ', '4' => 'Ԫ/'),
    "housepriceunit"   => array ('1'=>'Ԫ/', '4' => 'Ԫ/'),
    "wy_unit"   => "Ԫ/&#8226;ƽ",// ҵѵλ
    "payment"   => array ('¸'=>'¸', ''=>'','긶'=>'긶', '긶'=>'긶',''=>''),
    "priceterm"   => array ('1'=>'˫Ը˰','2'=>'ü'),
    "pricetype"   => array ('2'=>'ֵ˰','1'=>'ֵ˰'),
    "taxonlytype"   => array ('2'=>'и˰','1'=>'޸˰'),
    "storetype"   => array ('סլ'=>'סլ', 'ҵ'=>'ҵ', 'ҵ'=>'ҵ', '/ٻ'=>'/ٻ'),
    "villatype"   => array (''=>'', 'ű'=>'ű','˫ƴ'=>'˫ƴ', 'ӱ'=>'ӱ','б'=>'б', ''=>''),
    "skill"      => array('ͨסլ'=>'ͨסլ','ѧ'=>'ѧ','լ'=>'լ','ⷿ'=>'ⷿ','ƵʽԢ'=>'ƵʽԢ','߶'=>'߶','д¥'=>'д¥',''=>'','ҵ'=>'ҵ'),
    "tradeclass" => array ('׼'=>'׼','Ҽ'=>'Ҽ',''=>''),
    "housekindname" => array (''=>'','λ'=>'λ'),
    "price_sell" => array('1'=>'40','2'=>'40-60','3'=>'60-90','4'=>'90-120','5'=>'120-150','6'=>'150-200','7'=>'200-300','8'=>'300-500','9'=>'500'),
    "buildarea" => array('1'=>'40ƽ','2'=>'40-60ƽ','3'=>'60-80ƽ','4'=>'80-100ƽ','5'=>'100-120ƽ','6'=>'120-140ƽ','7'=>'140-200ƽ','8'=>'200-400ƽ','9'=>'400ƽ'),
    "price_rent" => array('1'=>'800Ԫ','2'=>'800-1200Ԫ','3'=>'1200-2000Ԫ','4'=>'2000-3000Ԫ','5'=>'3000-5000Ԫ','6'=>'5000-10000Ԫ','7'=>'10000Ԫ'),
    "roomtype"=>array('1'=>'һ','2'=>'','3'=>'','4'=>'','5'=>'','6'=>''),
    "sell_order" => array ('1'=>'ʱӽԶ','2'=>'ʱԶ','3'=>'ʱӽԶ','4'=>'ʱԶ','5'=>'ܼ۴ӵ͵','6'=>'ܼ۴Ӹߵ','7'=>'С','8'=>'ӴС'),
    "rent_order" => array ('1'=>'ʱӽԶ','2'=>'ʱԶ','3'=>'ʱӽԶ','4'=>'ʱԶ','5'=>'ӵ͵','6'=>'Ӹߵ','7'=>'С','8'=>'ӴС'),
    "rentroom" => array('' => '', '' => '', 'λ' => 'λ'),
);
/**
 * Сר
 */
$config['block_expert']["room"] = 5; //ʷԴ
$config['block_expert']["block_num"] = 4; //Сר
$config['block_expert']["indate"] = 7; //רְʱ
$config['block_expert']["wfen"] = 0; //ͷ
$config['block_expert']["freeze_num"] = 10; //ԱĴ
//The action which do not need to check login, can set in this array.
$config['no_login_check'] = array(
    'login'     =>array('index','cp_enter','ag_enter_set','ag_enter','cp_enter_set','cp_enter',
        'quit','findpw','findpw_code','confirm_validcode','qrCode','qrCodeLogin','get_code','code_login'),
    'valid'     =>array('index'),
    'desktop'   =>array('index'),
    'payment'   =>array('notify', 'agreement'),
    'payment_test'   =>array('notify', 'agreement'),
    'ajax'      =>array('revalidcode','vaild_find_pwd','find_pasword'),
    'pic'=>array('house','common'),
    'pic_wang'=>array('house','common'),
);

//Config the menu on the left of your page.
$config['left_menu']['house_manage'] = array(
    'sell_modify',
    array('sell_manage','sell_manage_invalid','sell_manage_frozen'),
    'rent_modify',
    array('rent_manage','rent_manage_invalid','rent_manage_frozen')
);
$config['left_menu']['ucenter'] = array(
    'ucenter/my_growth',
    array('ucenter/my_information','ucenter/edit_password'),
    'ucenter/my_history',
    array('ucenter/my_message_list', 'ucenter/my_message_detail'),
    // array('loan_index','loan_record'),
    array('complain/complain','complain/my_list'),
    'feedback',
);
$config['left_menu']['market'] = array(
    'market_index',
    //array('tag_index','tag_record'),
    array('tag_record'),
    //array('market/block_expert','market/block_expert_apply_not'),
    array('market_bid_block_expert/index','market_bid_block_expert/history'),
    array('market_bid_house_manage/all','market_bid_house_manage/on','market_bid_house_manage/history','market_bid_house/bid_house'),
    array('market_bid_rent_manage/all','market_bid_rent_manage/on','market_bid_rent_manage/history','market_bid_rent/bid_rent'),
    array('vas/school_house','vas/select_house','vas/great_broker','vas/set_promot_list'),
    array('vas/vas_packing','vas/vas_orderlist','vas/vas_packing_buy','vas/vas_video','vas/vas_show','vas/vas_video_buy','vas/vas_show_buy'),
    'packing_house',
    'personal_house',



);
$config['left_menu']['statics'] = array(
    array('statistics_analysis/today', 'statistics_analysis/history'),
    array('statistics_analysis/log','statistics_analysis/label','statistics_analysis/login_history','statistics_analysis/violation','statistics_analysis/reserve_refresh_log'),
    'statistics_analysis/click',
    'statistics_analysis/refresh');
$config['left_menu']['shop'] = array('shop_house_recommend', 'shop_set_basic');

$config['left_menu']['payment'] = array('payment_index', array('payment_recharge', 'payment_success'), 'payment_transaction');
$config['left_menu']['question'] = array('qa_manage','qa_manage1', 'qa_manage2');
$IpHostAllow =explode('.',GetIp());
if($IpHostAllow['0']=='192' || $IpHostAllow['0']=='127')
{
    $stat_url ="zjj182.house365.com";
}
else
{
    $stat_url ="zjj182.house365.com";
}
//ͳ statistics_plus
$config['statistics'][1]['new']['appName'] = "$stat_url:7778/fzdatamining/HTTP?service=";//"202.102.94.169:7777/datamining/HTTP/?service=";//ͳ
$config['statistics'][1]['new']['city'] = "bh";//ͳ
$config['statistics'][1]['new']['charSet'] = "GBK";//ͳ

$config['statistics'][1]['old']['appName'] = "$stat_url:7778/fzdatamining/HTTP?service=";//"zjj182.house365.com:7777/datamining/HTTP/?service=";//ͳ
$config['statistics'][1]['old']['city'] = "bh";//ͳ
$config['statistics'][1]['old']['charset'] = "GBK";//ͳ

//ͳ statistics
$config['statistics'][2]['new']['appName'] = "$stat_url:100/fzdatamining";//"202.102.94.169:100/datamining";//ͳ
$config['statistics'][2]['new']['city'] = "bh";//ͳ
$config['statistics'][2]['new']['charSet'] = "GBK";//ͳ

$config['statistics'][2]['old']['appName'] = "$stat_url:100/fzdatamining";//"zjj182.house365.com:100/datamining";//ͳ
$config['statistics'][2]['old']['city'] = "bh";//ͳ
$config['statistics'][2]['old']['charset'] = "GBK";//ͳ

$config['statistics']['domain'] = "zjj.stat.house365.com/fzdatamining";//ύͳ

//Ӧù
$config['app_custom_arr'] = array(
    'sell_pulish'=>array('name'=>'','auth'=>'base','url'=>'/sell/add/','icon'=>'fbcs.png','description'=>'ַסլ̡д¥ҵķԴϢ'),
    'sell_manage'=>array('name'=>'','auth'=>'base','url'=>'/sell/manage/active/','icon'=>'glcs.png','description'=>'ѾĶַסլ̡д¥ҵķԴϢ'),
    'rent_pulish'=>array('name'=>'','auth'=>'base','url'=>'/rent/add/','icon'=>'fbcz.png','description'=>'סլ̡д¥ҵķԴϢ'),
    'rent_manage'=>array('name'=>'','auth'=>'base','url'=>'/rent/manage/active/','icon'=>'glcz.png','description'=>'Ѿĳסլ̡д¥ҵķԴϢ'),
    'use_log'=>array('name'=>'ʹ־','auth'=>'base','url'=>'/statistics_analysis/log/','icon'=>'syrz.png','description'=>'¼۱ʹˢ·ԴȲԼԴΥϢļ¼'),
    'click_statistic'=>array('name'=>'ͳ','auth'=>'base','url'=>'/statistics_analysis/click/','icon'=>'djtj.png','description'=>'Դõѵͳƣʱ鿴ơ'),
    'refresh_statistic'=>array('name'=>'ˢͳ','auth'=>'pay','url'=>'/statistics_analysis/refresh/','icon'=>'sxtj.png','description'=>'Դˢ²ʱηֲͳơ'),
    'personal_house'=>array('name'=>'˷Դ','auth'=>'pay','url'=>'/personal_house/sell/','icon'=>'bqgrfy.png','description'=>'ڵĸ˷ԴϢȡҵʷԴϢЧʡ'),
    //'block_expert'=>array('name'=>'СרҾͶ','auth'=>'base','url'=>'/market_bid_block_expert/','icon'=>'xqzj.png','description'=>'СרңζȺع⡣бҳСϡȱƹλȫ'),
    //'bid_house'=>array('name'=>'ַͶ','auth'=>'base','url'=>'/market_bid_house_manage/all/','icon'=>'xqjt.gif','description'=>'ƹ㣬öƼķԴع⡢ǣͻӲͣ'),
    //'bid_rent'=>array('name'=>'ⷿͶ','auth'=>'base','url'=>'/market_bid_rent_manage/all/','icon'=>'zfjt.png','description'=>'ƹ㣬öƼķԴع⡢ǣͻӲͣ'),
    //'to_recharge'=>array('name'=>'ֵ','auth'=>'base','url'=>'/payment/recharge/','icon'=>'torecharge.gif','description'=>'׬̫ࣿ͵ķֱӳֵˬ죡'),
    //'dai_kuan'=>array('name'=>'365','auth'=>'base','url'=>'/my_loan/index/','icon'=>'365daikuan.png','description'=>'ͻݣŻݣɹдŶ'),
    //'complain_reward'=>array('name'=>'ٱн','auth'=>'base','url'=>'/my_complain/complain/','icon'=>'alarm.png','description'=>'ٱͶٷԴͨɵ÷ܾٷԴ'),
    //'tag_sale'=>array('name'=>'ǩ','auth'=>'base','url'=>'/tag_index/index/','icon'=>'bqls.png','description'=>'ǩƱǩʹøδʹñǩµײ㡣'),
);

//ƶ֧ͬϢӿڵַ
$config['alipay_mobile_notify_url'] = 'http://mobileadmin.house365.com/api.php?method=zfbinsert';
//Ͷ
$config['bidBehavior'] = array(
    1 => 'ɹ', 2 => 'ʧ', 3 => 'δͶ',
    4 => 'δͶ', 5 => 'Ͷ', 6 => 'Ͷ'
);

//ĵ
$config['documentation'] = array(
    'what_credit'=>'http://zsb.house365.com/help/?p=954',//yʲôǷ
    'house_title_rule'=>'http://zsb.house365.com/help/?p=485',//Դ˵
    'publish_pic_rule'=>'http://zsb.house365.com/help/?p=922',//yηͼԴ
    'publish_360_pic_rule'=>'http://zsb.house365.com/help/nj/?p=1286',//ηȫԴ
    'pic_rule'=>'http://zsb.house365.com/help/nj/?p=473',//ͼƬ
    'house_template'=>'http://zsb.house365.com/help/nj/?p=36',//Դģʹ˵
    'house_manage_rule'=>'http://zsb.house365.com/help/nj/?cat=10',//Դʹ˵
    'get_exp'=>'http://zsb.house365.com/help/nj/?p=546',//λóɳֵ
    'get_credit'=>'http://zsb.house365.com/help/?p=960',//yȡ˵
    'upgrade_raiders'=>'http://zsb.house365.com/help/nj/?p=598',//
    'bid_house_rule'=>'http://zsb.house365.com/help/?p=949',//yԴͶ˵
    'block_bid'=>'http://zsb.house365.com/help/?p=932',//yСʾͶ鿴ϸ˵
    'hot_search_bid'=>'http://zsb.house365.com/help/?p=939',//yѴʾͶ鿴ϸ˵
    'shop_recommend_rule'=>'http://zsb.house365.com/help/?p=90',//y̷ԴƼ鿴ϸ˵
    'app_zsb' => 'http://app.house365.com/zsb/download.html', //۱app webصַ
    'pay_detail' => 'http://zsb.house365.com/help/?p=1032', //y֧˵
    'often_question' => 'http://zsb.house365.com/help/?p=1034', //yû
    'bank_limit' => 'http://zsb.house365.com/help/?p=1036', //y֧޶
    'recharge_help' => 'http://zsb.house365.com/help/?p=1030', //yֵ
    'refresh_project'=>'http://zsb.house365.com/help/?p=49',//ԤԼʹ
    'school_promot_rule'=>'http://zsb.house365.com/help/nj/?p=1075',//ѧƹ
    'school_example_online'=>'http://nj.sell.house365.com/schoolhouse',//ѧƹʾ
    'great_broker_rule'=>'http://zsb.house365.com/help/nj/?p=1077',//㾭˹
    'greate_broker_example_online'=>'http://nj.sell.house365.com/#greatbroker',//㾭ʾ
    'packing_house_rule'=>'http://zsb.house365.com/help/?p=945',//Դװ
    'packing_hosue_example_online'=>'http://nj.sell.house365.com/',//Դװʾ
    'wenda'=>'http://zsb.house365.com/help/nj/?p=1176',//ʴ
    'complain_rule'=>'http://zsb.house365.com/help/?p=979',//yٱ

    //
    'growth_star' => 'http://zsb.house365.com/help/?p=962', //Ǽ
    'block_expert_rule' => 'http://zsb.house365.com/help/?p=929',//СרҾͶ˵
);

//֧
$config['payment'] = array(
    'init_rate' => 10,
    'price' => array('1' => 10, '2' => 50, '3' => 100, '4' => 500),
    'active' => array('endtime' => '2014-12-31 23:59:59', 'rate' => '12', 'percentage' => '20%')
);

//ԴͶԴװ
$config['packing_house_staus'] = array('1' => '','2' => '','3' => 'ƹ','4' => 'ƹ');
$config['packing_house'] = array('Search' => 'Դװ','Mansionshow'=>'լ','Video'=>'Ƶ');
$config['set_promot_type'] = array('ASchool1','BSchool1','ASchool2','BSchool2','ASchool3','BSchool3','ASchool4','BSchool4','GreatBroker');
//ѧãѧͶƹ㣩
$config['set_promot_school'] = array('91'=>'ѧСѧ','92'=>'·Сѧ','90'=>'·Сѧ','94'=>'·Сѧ');
$config['set_promot_school_type'] = array(
    array('sid'=>'91','name'=>'ѧСѧ','A'=>'ASchool1','B'=>'BSchool1'),
    array('sid'=>'92','name'=>'·Сѧ','A'=>'ASchool2','B'=>'BSchool2'),
    array('sid'=>'90','name'=>'·Сѧ','A'=>'ASchool3','B'=>'BSchool3'),
    array('sid'=>'94','name'=>'·Сѧ','A'=>'ASchool4','B'=>'BSchool4'),
);
//پͶԴٱ
$config['complain_status'] = array('1'=>'','2'=>'ٱɹ','3'=>'ٱʧ');
$config['complain_reason'] = array('1'=>'','2'=>'۸','3'=>'Դѳɽ','4'=>'ͼƬ');
/* End of file config.php */
/* Location: ./application/config/config.php */

//360ȫͼƬ
$config['imageType'] = array(
    '1' => '',
    '2' => '',
    '3' => '',
    '4' => '',
    '5' => '',
    '6' => ''
);

//ģ
$config['templateName']= 'nj';

define('TEMPLATE_NAME', $config['templateName']);
//۱˺ע
define('GB_BROKER_REG' , "http://cq.sell.house365.com/agent_sign_up.php");

/**
 * Ծ˸״̬Ϸ 1ʾշѣ0ʾѡ
 *
 * ĬΪշ״̬
 *
 */
define('payStatus','1');

//ùرյĲ˵
//ҳindexԴhouse_manageͳƷstaticsӪmarket̹shopucenterʴquestion֧payment
//$config['close_menu'] = array('question');

//۱
define('HOT_TEL', "4008908365-811");

//
define('CITY_NAME', "");


//ܿأ1ʾ0ʾر
$config['functionSwitch'] = array(
    'payment' => '0',   //֧
    'question' => '0',  //ʴ
    'tagsale' => '0',    //ǩȨ
    'panorama' => '0',   //ȫͼΥȨ
    'commonImageJoinCheck' => '1',   //ͨͼƬ˱
    'priorityHousebeanConsume' => '0', //ȷĹ
);

// ǷܷȫĬܷ
// 1Ϊܷ0Ϊܷ
$config['is_publish_360'] = 0;
$config['is_open_housebean'] = 0;
// Ƿ֧ģĬ
// 1ΪУ0Ϊû
$config['is_pay'] = 0;

//ԤԼˢ
$config['max_reserve_days'] = 31;

// ȥ˵б
$config['no_menu'] = array(
    'market_index','market_bid_block_expert/index','market_bid_house_manage/all','market_bid_rent_manage/all','vas/vas_packing','complain/complain'
);

// Ӫ
$config['url_market'] = '/personal_house/sell/';

// ǷСҵȨĬ
// 1ΪУ0Ϊû
$config['is_my_prerogative'] = 0;

// ǷмƱǩĬ
// 1ΪУ0Ϊû
$config['is_tag'] = 1;

// ȥҳݹб
$config['no_app'] = array(
    'to_recharge'
);

define('GB_WS_URL' , "http://gl.zsb.house365.com");
$config['upgradeStarLevel'] = 1;

//Ч λ  Ĭֵ10=3650
$config['housebeanExpirationTimeType'] = array(
    'paymentExpireTime' => strtotime(date('Y-m-1', strtotime('+120 month')))-1,  //ֵʱ
    'otherExpireTime' => strtotime(date('Y-m-1', strtotime('+120 month')))-1     //ʱ
);

