<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reserve extends MY_Controller {
    
    /**
    * ˺ű
    *
    * @access private
    * @var string
    */
    private $_uid = 0;
    
    /**
     * ԤԼˢSESSIONKEYֵ
     * @access 
     * @var const
     */
    const SET_SESSION_KEY = 'project_house_set';
    
    /**
    * 
    *
    * @access public
    * @return void
    */
    public function __construct()
    {
        parent::__construct();

        //ԤԼģ
        $this->load->model('reserve_model');
		$this->load->helper('common_house_helper');
		$this->_uid = $this->user_arr['uid'];
        $this->reserve_model->set_uid($this->_uid);

		$this->load->helper('common_string');
    }
    
    
    /**
     * Index Page for this controller.
     */
    public function index()
    {
        $this->project_manage();
    }
    
    /**
     * ԤԼҳ
     * @param string $add_house ʶǷӷʱӷԴԤԼ
     *                           ĬϲӣaddʱӷԴ
     * @param void
     */
    public function project_new( $add_house = '')
    {   
        if($add_house == 'add')
        {
            //ȡSESSIONлԤԼ
            $project_house_session = $this->session->userdata(self::SET_SESSION_KEY);
            if( isset($project_house_session) && !empty($project_house_session) )
            {
                $tbl = $project_house_session['tbl'];
                $actionid = $project_house_session['actionid'];
            }
        }

        $rowid_arr = isset($actionid) && $actionid != false ?  explode(',',$actionid) : array();
        
        $uid = $this->user_arr['uid'];
        $tbl = (isset($tbl) && in_array($tbl,array('sell','rent') ) ) ? $tbl : '';
        //ύõķԴ
        $set_house_num = count($rowid_arr);
        //ЧԴ
        $project_houses_arr = array();
        //ЧԴ
        $project_house_num = 0;
        //ЧԴ
        if( $set_house_num > 0)
        {   
            $this->load->helper('common_url');
            
            //طԴMODEL
            if($tbl == 'sell')
            {
                $this->load->model('sell_model');
            }
            else if($tbl == 'rent')
            {
                $this->load->model('rent_model');
            }

			$house = $this->config->item('house');
            foreach($rowid_arr as $key=>$val)
            {
                $rowid = intval($val);
                if($rowid > 0)
                {   
                    $cond_where = "id = '".$rowid."' AND uid = '".$uid."'";
                    
                    if($tbl == 'sell')
                    {	
						$select_filed = array('esta','blockshowname','room','hall','buildarea','price');
                        $this->sell_model->set_select_fields($select_filed);
                        $house_arr = $this->sell_model->find_one_by($cond_where);
                    }
                    else if($tbl == 'rent')
                    {	
						$select_filed = array('esta','blockshowname','room','hall','buildarea','price','priceunit');
                        $this->rent_model->set_select_fields($select_filed);
                        $house_arr = $this->rent_model->find_one_by($cond_where);
                    }
                    
                    //¼ЧԴϢ
                    if( isset ($house_arr['esta']) && $house_arr['esta'] == 1)
                    {
                        //ԴСȡ
                        $house_arr['tbl'] = $tbl;
                        $house_arr['rowid'] = $rowid;
						$house_arr['price'] = strip_end_0($house_arr['price']);
						$house_arr['buildarea'] = strip_end_0($house_arr['buildarea']);
						$house_arr['price_unit'] = $tbl == 'sell' ? '' : $house['shoppriceunit'][$house_arr['priceunit']];
                        $house_arr['blockshowname'] = $house_arr['blockshowname'];
                        $house_arr['url'] = $tbl == "sell" ? get_sellinfo_url($rowid) : get_rentinfo_url($rowid);
                        $project_houses_arr[]['houseinfo'] = $house_arr;
                    }
                }
            }
            
            //õķԴȫǷЧԴ˸
            $project_house_num = count($project_houses_arr);
        }
        
        /** ҳʼ */
        $data['page_title'] = 'Դ-ԤԼˢ';
        //Ҫصcss
        $data['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/style2.css');
        //ҪصJS
        $data['js'] = load_js('zsb/js/v1.0/js3.js');
        $data['project_house_num'] = $project_house_num;
        $data['project_houses_arr'] = $project_houses_arr;
        $data['house_tbl'] = $tbl;
        $data['project_times_num'] = 0;
		$data['documentation'] = $this->config->item('documentation');//ĵ
        $data['project_times_max_days'] = $this->reserve_model->get_project_times_max_days();
        
        //ģ
        $this->view( 'house_manage' , 'project_new' , $data);
    }
    
    
    /**
     * ԤԼҳ
     * @param int $project_id ԤԼ
     */
    public function project_manage( $project_id = '' )
    {   
        //ԤԼ
        $id = isset($project_id) ? intval($project_id) : 0;
        
        //ݷIDȡ÷
        $project_name = $this->reserve_model->get_projectname_by_pid($id);
        
        //ȡҵȫԤԼˢ·
        $project_arr = $this->reserve_model->get_myprojects(1);
        $project_num = count($project_arr);

        //ûи÷תҳ
        if( $project_name == '' )
        {
            if($project_num == 0)
            {
                $page_text = 'ûùκεԤԼˢ·ӣ';
                $this->jump("/reserve/project_new/", $page_text , 1000);
            }
            else
            {
                $first_project_id = isset($project_arr[0]['id']) ? intval($project_arr[0]['id']) : 0;
                if( $first_project_id > 0)
                {
                    echo "<script>window.location.href='/reserve/project_manage/".$first_project_id."/';</script>";   
                }
                else
                {
                    echo "<script>window.location.href='/reserve/project_new/';</script>";
                }
            }
            exit;
        }
        
        //ݷIDȡ÷ʱ
        $project_times_arr = $this->reserve_model->get_projecttimes_by_pid($id);
        $project_times_num = count($project_times_arr);
        $project_times_str = '';
        
        if($project_times_num > 0)
        {
            foreach($project_times_arr as $key=>$val)
            {   
                $time = date("H:i", strtotime($val['time']));
                $project_times_str .= $time.",";
            }
        }
        
        //ʱ
        $ptime_arr = $this->reserve_model->deal_strtime_2_arr($project_times_arr);
        
        //ݷIDȡ÷뷿Դ
        $project_houses_arr = $this->reserve_model->get_projecthouses_by_pid($id, true);
        $project_houses_num = count($project_houses_arr);
        //˱
        $uid = $this->user_arr['uid'];
        if( $project_houses_num > 0)
        {   
            $this->load->helper('common_url');
			$house = $this->config->item('house');
            foreach( $project_houses_arr as $key=>$val)
            {
                $house_esta = 0;
                if(in_array($val['tbl'], array('sell','rent')) && $val['rowid'] > 0)
                {   
                    $cond_where = "id = '".$val['rowid']."' AND uid = '".$uid."'";
                    if($val['tbl'] == 'sell')
                    {	
						$select_filed = array('esta','blockshowname','room','hall','buildarea','price');
                        $this->load->model('sell_model');
                        $this->sell_model->set_select_fields($select_filed);
                        $house_arr = $this->sell_model->find_one_by($cond_where);
                    }
                    else if($val['tbl'] == 'rent')
                    {	
						$select_filed = array('esta','blockshowname','room','hall','buildarea','price','priceunit');
                        $this->load->model('rent_model');
                        $this->rent_model->set_select_fields($select_filed);
                        $house_arr = $this->rent_model->find_one_by($cond_where);
                    }
                    $house_esta = isset($house_arr['esta']) ? isset($house_arr['esta']) : 2;
                }

                if( $house_esta != 1)
                {
                    unset($project_houses_arr[$key]);
                }
                else
                {	
                    $house_arr['tbl'] = $val['tbl'];
                    $house_arr['rowid'] = $val['rowid'];
					$house_arr['price'] = strip_end_0($house_arr['price']);
					$house_arr['buildarea'] = strip_end_0($house_arr['buildarea']);
					$house_arr['price_unit'] = $val['tbl'] == 'sell' ? '' : $house['shoppriceunit'][$house_arr['priceunit']];
                    $house_arr['url'] = $val['tbl'] == "sell" ? 
                        get_sellinfo_url($val['rowid']) : get_rentinfo_url($val['rowid']);
                    $project_houses_arr[$key]['houseinfo'] = $house_arr;
                }
            }
        }
        
        //
        $data['id'] = $id;
        //
        $data['project_name'] = $project_name;
        //
        $data['project_num'] = $project_num;
        //󷽰
        $project_max_num = $this->reserve_model->get_project_max_num();
        $data['project_max_num'] = $project_max_num;
        //ʱ
        $data['project_times_num'] = $project_times_num;
        //ʱ
        $data['ptime_arr'] = $ptime_arr;
        //ʱַ
        $data['project_times_str'] = $project_times_str;
        //
        $data['project_arr'] = $project_arr;
        //ԴϢ
        $data['project_houses_num'] = count($project_houses_arr);
        $data['project_houses_arr'] = $project_houses_arr;
        
        /** ҳʼ */
        $data['page_title'] = 'Դ-ԤԼˢ';
        //Ҫصcss
        $data['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/style2.css');
        //ҪصJS
        $data['js'] = load_js('zsb/js/v1.0/js3.js');
		//ĵ
		$data['documentation'] = $this->config->item('documentation');
        //ģ
        $this->view( 'house_manage' , 'project_manage' , $data);
    }
    
    
    //ת
    public function do_action()
    {
        $actiontype = $this->input->post('actiontype',TRUE);
        switch ($actiontype)
        {
            case 'project_house_set':
                $this->project_house_set();
                break;
            case 'project_house_cancel':
                $this->project_house_cancel();
                break;
        }
    }
    
    /*
     * ԤԼԴ
     */
    public function project_house_set($id = '')
    {   
        //ȡύϢ
        $tbl = $this->input->post('tbl',TRUE);
        $actionid = $this->input->post('actionid',TRUE);
        $secret_key = $this->input->post('secret_key',TRUE);
        
        //ȡSESSIONлԤԼ
        $app_key = self::SET_SESSION_KEY;
        if(isset($actionid) && $actionid != false)
        {   
            $session_data = array( 'actionid' => $actionid , 'tbl' => $tbl );
            $this->session->set_userdata(array($app_key => $session_data));
        }
        else
        {
            $project_house_session = $this->session->userdata($app_key);
            if( isset($project_house_session) && !empty($project_house_session) )
            {
                $tbl = $project_house_session['tbl'];
                $actionid = $project_house_session['actionid'];;
            }
        }
        
        $rowid_arr = isset($actionid) && $actionid != false ?  explode(',',$actionid) : array();

        //ȡҵȫԤԼˢ·
        $project_arr = $this->reserve_model->get_myprojects(1);
        $project_num = count($project_arr);
        //ûи÷תҳ
        if($project_num == 0)
        {
            $page_text = 'ûùκεԤԼˢ·ӣ';
            $this->jump("/reserve/project_new/", $page_text , 1000);
            exit;
        }
        
        if( isset($id) && $id !='')
        {
            $id = $id;
        }
        else
        {
            $id = isset($project_arr[0]['id']) ? intval($project_arr[0]['id']) : 0;
        }
        
        if( $id <= 0)
        {
            echo "<script>window.location.href='/reserve/project_new/';</script>";
            exit;
        }
        
        //ݷIDȡ÷
        $project_name = $this->reserve_model->get_projectname_by_pid($id);
        
        //ݷIDȡ÷ʱ
        $project_times_arr = $this->reserve_model->get_projecttimes_by_pid($id);
        $project_times_num = count($project_times_arr);
        $project_times_str = '';
        if($project_times_num > 0)
        {
            foreach($project_times_arr as $key=>$val)
            {   
                $time = date("H:i", strtotime($val['time']));
                $project_times_str .= $time.",";
            }
        }  
        //ʱ
        $ptime_arr = $this->reserve_model->deal_strtime_2_arr($project_times_arr);
        
        $uid = $this->user_arr['uid'];
        $set_tbl = (isset($tbl) && in_array($tbl,array('sell','rent') ) ) ? $tbl : '';
        $set_houses_arr = isset($rowid_arr) ? $rowid_arr : array();
        //ύõķԴ
        $set_house_num = count($set_houses_arr);
        $project_houses_arr = array();
        //ЧԴ
        if( $set_house_num > 0)
        {   
            $this->load->helper('common_url');
            
            //طԴMODEL
            if($set_tbl == 'sell')
            {
                $this->load->model('sell_model');
            }
            else if($set_tbl == 'rent')
            {
                $this->load->model('rent_model');
            }

			$house = $this->config->item('house');

            foreach($set_houses_arr as $key=>$val)
            {
                $rowid = intval($val);
                
                if($rowid > 0)
                {   
                    $cond_where = "id = '".$rowid."' AND uid = '".$uid."'";
                    
                    if($set_tbl == 'sell')
                    {	
						$select_filed = array('esta','blockshowname','room','hall','buildarea','price','expiretime');
                        $this->sell_model->set_select_fields($select_filed);
                        $house_arr = $this->sell_model->find_one_by($cond_where);
                    }
                    else if($set_tbl == 'rent')
                    {	
						$select_filed = array('esta','blockshowname','room','hall','buildarea','price','priceunit','expiretime');
                        $this->rent_model->set_select_fields($select_filed);
                        $house_arr = $this->rent_model->find_one_by($cond_where);
                    }
                    
                    //¼ЧԴϢ
                    if( isset ($house_arr['esta']) && $house_arr['esta'] == 1)
                    {
                        //ԴСȡ
                        $house_arr['tbl'] = $set_tbl;
                        $house_arr['rowid'] = $rowid;
						$house_arr['price'] = strip_end_0($house_arr['price']);
						$house_arr['buildarea'] = strip_end_0($house_arr['buildarea']);
						$house_arr['price_unit'] = $set_tbl == 'sell' ? '' : $house['shoppriceunit'][$house_arr['priceunit']];
                        $house_arr['blockshowname'] = $house_arr['blockshowname'];
						//ȡԴʱ
						$days = intval(to_expire_day_new($house_arr['expiretime']));
						$house_arr['expiretime'] = $days;
                        $house_arr['url'] = $set_tbl == "sell" ? get_sellinfo_url($rowid) : get_rentinfo_url($rowid);
                        $project_houses_arr[]['houseinfo'] = $house_arr;
                    }
                }
            }
            
            //õķԴȫǷЧԴ˸
            $project_houses_num = count($project_houses_arr);
            if(  $project_houses_num == 0)
            {
                $url = '/'.$set_tbl.'/manage/';
                $page_text = 'ʧܣԤԼˢµķԴΪЧ';
                $this->jump( $url , $page_text , 2000);
                exit;
            }
        }
        
        //ݷIDȡ÷뷿Դ
        $project_old_houses_arr = $this->reserve_model->get_projecthouses_by_pid($id, true);
        $project_old_houses_num = count($project_old_houses_arr);
        if($project_old_houses_num > 0)
        {	
			$house = $this->config->item('house');
            foreach($project_old_houses_arr as $key=>$val)
            {
                $house_esta = 0;
                if(in_array($val['tbl'], array('sell','rent')) && $val['rowid'] > 0)
                {
                    $cond_where = "id = '".$val['rowid']."' AND uid = '".$uid."'";
                    if($val['tbl'] == 'sell')
                    {	
						$select_filed = array('esta','blockshowname','room','hall','buildarea','price','expiretime');
                        $this->load->model('sell_model');
                        $this->sell_model->set_select_fields($select_filed);
                        $house_arr = $this->sell_model->find_one_by($cond_where);
                    }
                    else if($val['tbl'] == 'rent')
                    {	
						$select_filed = array('esta','blockshowname','room','hall','buildarea','price','priceunit','expiretime');
                        $this->load->model('rent_model');
                        $this->rent_model->set_select_fields($select_filed);
                        $house_arr = $this->rent_model->find_one_by($cond_where);
                    }
                    
                    $house_esta = isset($house_arr['esta']) ? isset($house_arr['esta']) : 2;
                }

                if($house_esta != 1)
                {
                    unset($project_old_houses_arr[$key]);
                }
                else
                {	
                    $house_arr['tbl'] = $val['tbl'];
                    $house_arr['rowid'] = $val['rowid'];
					$house_arr['price'] = strip_end_0($house_arr['price']);
					$house_arr['buildarea'] = strip_end_0($house_arr['buildarea']);
					$house_arr['price_unit'] = $val['tbl'] == 'sell' ? '' : $house['shoppriceunit'][$house_arr['priceunit']];
                    $house_arr['url'] = $val['tbl'] == "sell" ? get_sellinfo_url($val['rowid']) : get_rentinfo_url($val['rowid']);
					//ȡԴʱ
					$days = intval(to_expire_day_new($house_arr['expiretime']));
					$house_arr['expiretime'] = $days;
                    $project_old_houses_arr[$key]['houseinfo'] = $house_arr;
                }
            }
        }
        
        //
        $data['id'] = $id;
        //
        $data['project_name'] = $project_name;
        //÷Դ
        $data['set_tbl'] = $set_tbl;
        //
        $data['project_num'] = $project_num;
        //ԤԼ
        $project_max_num = $this->reserve_model->get_project_max_num();
        $data['project_max_num'] = $project_max_num;
        //
        $data['project_times_max_days'] = $this->reserve_model->get_project_times_max_days();
        //ʱ
        $data['project_times_num'] = $project_times_num;
        //ʱ
        $data['ptime_arr'] = $ptime_arr;
        //ʱַ
        $data['project_times_str'] = $project_times_str;
        //
        $data['project_arr'] = $project_arr;
        //ԴϢ
        $data['project_houses_num'] = isset($project_houses_num) ? $project_houses_num : 0;
        $data['project_houses_arr'] = $project_houses_arr;
        //ѲԤԼķԴϢ
        $data['project_old_houses_arr'] = $project_old_houses_arr;
        $data['project_old_houses_num'] = count($project_old_houses_arr);
        /** ҳʼ */
        $data['page_title'] = 'Դ-ԤԼˢ';
        //Ҫصcss
        $data['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/style2.css');
        //ҪصJS
        $data['js'] = load_js('zsb/js/v1.0/js3.js');
		//ĵ
		$data['documentation'] = $this->config->item('documentation');
        //ԤԼˢ
        $data['max_reserve_days'] = $this->config->item('max_reserve_days');
        //ģ
        $this->view( 'house_manage' , 'project_set' , $data);
    }
    
    
    //ԤԼñ
    public function project_house_set_action()
    {   
        $result = array();
        
        $house_tbl = $this->input->post('house_tbl',TRUE);
        $pid = $this->input->post('pid',TRUE);
        $houses_arr = $this->input->post('housearr',TRUE);
        $secret_key = $this->input->post('secret_key',TRUE);
        $project_day = $this->input->post('project_day',TRUE);
        $oldhousearr = $this->input->post('oldhousearr',TRUE);
		$oldhouse_days =$this->input->post('oldhouse_days',TRUE);
		//print_r($_POST);die;
		//echo $oldhouse_days;die;
        //ӷԴͬʱ޸ѹķԴ
        if(is_array($oldhousearr) && !empty($oldhousearr))
        {
            $old_house_arr = array();
            foreach($oldhousearr as $val)
            {
                $house = explode("-", $val);
                $harr['tbl'] = $house[0];
                $harr['rowid'] = $house[1];
                $harr['starttime'] = $house[2];
                $harr['endtime'] = $house[3];
                $old_house_arr[] = $harr;
            }
            
             $this->reserve_model->update_projecthouses( $pid, $old_house_arr);
        }
        else
        {
            //ɾ÷ȫԴ
            $this->reserve_model->delete_projecthouses($pid);
        }
        $result = $this->reserve_model->add_projecthouses($pid , $house_tbl , $houses_arr, $project_day);
        if($result === TRUE)
        {
            $page_text = 'ӳɹ';
            $this->jump( '/reserve/project_manage/'.$pid.'/', $page_text , 1000);
            exit;
        }
        else
        {
            $page_text = 'Ϣ';
            $this->jump( '/reserve/project_manage/', $page_text , 1000);
            exit;
        }
    }
    
    
    /*
     * ȡԤԼԴ
     */
    public function project_house_cancel()
    {   
        $result = array();
        
        //ȡύϢ
        $tbl = $this->input->post('tbl',TRUE);
        $actionid = $this->input->post('actionid',TRUE);
        $uid = intval($this->user_arr['uid']);
        
        if(isset($actionid) && !empty($actionid))
        {
           $arr_id = explode(',', $actionid) ;
           
            if (is_array($arr_id) && !empty($arr_id)) 
            {
                $result = $this->reserve_model->delete_projecthouse_batch($uid , $tbl, $arr_id);
            }
        }
        
        $url = $tbl == 'rent' ? '/rent/manage/active/' : '/sell/manage/active/';
        if($result === TRUE)
        {
            $page_text = 'ɹȡԤԼˢ';
        }
        else
        {
            $page_text = 'ԤԼˢʧ';
        }
        $this->jump( $url, $page_text , 2000);
        exit;
    }
    
    
    /*
     * ԤԼ
     */
    public function add_project()
    {   
        //
        $project_name = $this->input->post('project_name',TRUE);
        $project_name = isset($project_name) ? trim(strip_tags($project_name)) : '';
        $project_name = $project_name != '' ? $project_name : 'µķ';

        //ʱ
        $project_times = $this->input->post('project_times',TRUE); 
        $project_times = trim($project_times);
        $result = $this->_add_project( $project_name , $project_times );
        
        if(isset($result['is_ok']) && $result['is_ok'] == 1)
        {   
            $url = '/reserve/project_manage/'.$result['project_id'].'/';
            $page_text = $result['msg'];
        }
        else
        {
            $url = '/reserve/project_manage/';
            $page_text = $result['msg'];
        }
        
        $this->jump( $url , $page_text , 3000);
        exit;
    }
    
    
    /**
     * µԤԼ
     * 
     * @param string $project_name 
     * @param string $project_times ʱ
     * @return array ӽ
     */
    private  function _add_project( $project_name , $project_times )
    {   
        $result = array();
        
        //ȡҵȫԤԼˢ·
        $project_arr = $this->reserve_model->get_myprojects(1);

        //ӷ
        $project_num = count($project_arr);

        //󷽰
        $project_max_num = $this->reserve_model->get_project_max_num();
        
        if( $project_num < $project_max_num && trim(strip_tags($project_name)) != '')
        {
            //淽
            $project_id = $this->reserve_model->add_projectname($project_name);
            
            //ʱ
            $result_add  = FALSE;
            if( $project_id > 0 && $project_times != "")
            {
                $result_add = $this->reserve_model->add_projecttimes( $project_id ,  $project_times);
            }
            
            if($result_add === TRUE)
            {
                $result['is_ok'] = '1';
                $result['project_id'] = $project_id;
                $result['msg'] = "ԤԼˢ·'".$project_name."'ӳɹ";
                
                //ԤԼ
                $this->reserve_model->get_myprojects(1);
            }
            else
            {
                $result['is_ok'] = '0';
                $result['msg'] = 'ԤԼӣԤԼˢ·ִʱʧ';
            }
        }
        else if($project_num < $project_max_num && $project_name == '')
        {
            $result['is_ok'] = '0';
            $result['msg'] = 'ԤԼ';
        }
        else
        {   
            $result['is_ok'] = '0';
            $result['msg'] = 'ԤԼˢ·ѳ';
        }
        
        return $result;
    }
    
    
    /*
     * ԤԼͬʱӷԴ
     */
    public function add_project_and_houses()
    {
        //
        $project_name = $this->input->post('project_name',TRUE);
        $project_name = isset($project_name) ? trim($project_name) : 'µķ';
        $houses_arr = $this->input->post('housearr',TRUE);
        $project_times = $this->input->post('project_times',TRUE);
        $secret_key = $this->input->post('secret_key',TRUE);
        $tbl = $this->input->post('house_tbl',TRUE);
        $project_day = $this->input->post('project_day',TRUE); 
        
        //ԤԼˢ·ͷԴ
        $result = array();
        $result = $this->_add_project_and_houses($project_name , $project_times , $tbl ,$houses_arr , $project_day);
        
        if($result['is_ok'] == 1)
        {
            $url = '/reserve/project_manage/'.$result['project_id'].'/';
        }
        else
        {
            $url = '/reserve/project_manage/';
        }
        
        $page_text = $result['msg'];
        $this->jump( $url , $page_text , 3000);
        exit;
    }
    
    /**
     * ԤԼͬʱӷԴ
     * @param string $project_name ԤԼ
     * @param string $project_times ԤԼʱ
     * @param string $tbl ԤԼ
     * @param array $houses_arr ԤԼԴ
     * @param int $project_day  ԤԼ
     * @return array 
     */
    private function _add_project_and_houses( $project_name , $project_times , $tbl ,$houses_arr , $project_day)
    {   
        $result = array();
        
        //ȡҵȫԤԼˢ·
		$project_arr = $this->reserve_model->get_myprojects(1);
		$project_num = count($project_arr);

		if( $project_num < $this->reserve_model->get_project_max_num())
		{
            //淽
            $project_id = $this->reserve_model->add_projectname($project_name);
            
            if( $project_id <= 0 )
            {
                $result['is_ok'] = '0';
                $result['msg'] = 'ԤԼˢ·Ʊʧ';
            }

            //ʱ
            if( $project_id > 0 && $project_times != "")
            {
                $result_add = $this->reserve_model->add_projecttimes($project_id, $project_times);
                
                if( $result_add != TRUE )
                {
                    $result['is_ok'] = '0';
                    $result['msg'] = 'ԤԼˢ·ʱ㱣ʧ';
                }
            }

            if($project_id > 0  && isset($tbl) && in_array($tbl , array('sell','rent'))  )//÷Դ
            {
                $result_add = $this->reserve_model->add_projecthouses($project_id, $tbl, $houses_arr, $project_day);
                
                if( $result_add === TRUE )
                {
                    $result['is_ok'] = '1';
                    $result['project_id'] = $project_id;
                    $result['msg'] = "ԤԼˢ·'".$project_name."'ӳɹ";
                    
                    //ԤԼ
                    $this->reserve_model->get_myprojects(1);
                }
                else
                {
                    $result['is_ok'] = '1';
                    $result['msg'] = 'ԤԼˢ·Դʧ';
                }
            }
		}
        else
        {
            $result['is_ok'] = '0';
            $result['msg'] = 'ԤԼˢ·ѳ';
        }

        return $result;
    }
    
    
    /**
     * ԤԼ
     */
    public function update_project()
    {
        //
        $project_id = $this->input->post('pid',TRUE);
        $project_name = $this->input->post('project_name',TRUE);
        $secret_key = $this->input->post( 'secret_key' , TRUE );
        $project_times = $this->input->post( 'project_times' , TRUE );
        $project_houses = $this->input->post( 'housearr' , TRUE );
        
        $page_text = '';
        if( $project_id > 0 && md5('HOUSE365_PROJECT_UPDATE_'.$project_id) == $secret_key )
        {
            $result = $this->_update_project( $project_id , $project_name , $project_times , $project_houses);
        }
        else
        {
            $result = array('is_ok'=> '0' ,'msg'=>'');
        }

        $page_text = $result['msg'];
        $url = '/reserve/project_manage/'.$project_id.'/';
        $this->jump( $url , $page_text , 1000);
    }
    
    
    /**
     * ԤԼ
     * @param int $project_id 
     * @param string $project_name 
     * @param string $project_times ʱ
     * @param array $project_houses Դ
     * return  array $result
     */
    public function _update_project( $project_id , $project_name , $project_times , $project_houses )
    {   
        $result = array();
        
        $name = $this->reserve_model->get_projectname_by_pid($project_id);
        
        //·
        if($name != $project_name)
        {
           $this->reserve_model->update_projectname($project_id , $project_name);
        }
        
        //ʱ
        if($project_times != '')
        {
            $this->reserve_model->add_projecttimes($project_id , $project_times);
        }
        else
        {
            $this->reserve_model->delete_projecttimes($project_id);
        }

        if(is_array($project_houses) && !empty($project_houses))
        {
            $house_arr = array();
            foreach($project_houses as $val)
            {
                $house = explode("-", $val);
                $harr['tbl'] = $house[0];
                $harr['rowid'] = $house[1];
                $harr['starttime'] = $house[2];
                $harr['endtime'] = $house[3];
                $house_arr[] = $harr;
            }
            
            $this->reserve_model->update_projecthouses($project_id, $house_arr);
        }
        else
        {
            //ɾ÷ȫԴ
            $this->reserve_model->delete_projecthouses($project_id);
        }
        
        //ԤԼ
        $this->reserve_model->get_myprojects(1);
                    
        $result['is_ok'] = '1';
        $result['msg'] = 'ԤԼˢ·ϢѸ';
        
        return $result;
    }
    
    
    /**
     * ɾԤԼ
     */
    public function delete_project()
    {
        //
        $project_id = $this->input->get('project_id',TRUE);
        $secret_key = $this->input->get( 'secret_key' , TRUE );
        
        if( $project_id > 0 && md5('HOUSE365_PROJECT_DELETE_'.$project_id) == $secret_key )
        {
            $result = $this->_delete_project($project_id);
        }
        else
        {
            $result = array('is_ok'=> '0' ,'msg'=>'');
        }

        $result['msg'] = iconv( 'gb2312' , 'utf-8',  $result['msg'] ); 
        print_r(json_encode($result));
        exit;
    }
    
    
    /**
     * ɾԤԼ
     * 
     * @param int $project_id 
     * @return array ɾ
     */
    private function _delete_project($project_id)
    {
        $result = array('is_ok'=> '0' ,'msg'=>'ԤԼɾʧ');
        
        if( $project_id > 0)
        {   
            //ԤԼ󶨷Դ
            $house_num = $this->reserve_model->get_projecthouses_num_by_pid($project_id);

            //1ɾԤԼ󶨵ķԴ
            if( $house_num > 0)
            {
                $result1 = $this->reserve_model->delete_projecthouses($project_id);
            }
            else
            {
                $result1 = TRUE;
            }
            
            if( $result1 === TRUE)
            {   
                //ԤԼʱ䷽
                $times_num = $this->reserve_model->get_projecttimes_num_by_pid($project_id);
                
                //2ɾ趨ʱ
                if( $times_num > 0)
                {
                    $result2 = $this->reserve_model->delete_projecttimes($project_id);
                }
                else
                {
                    $result2 = TRUE;
                }
                
                if($result2 === TRUE)
                {   
                    //3ɾϢ
                    $result3 = $this->reserve_model->delete_project($project_id);
                    
                    if( $result3 === TRUE)
                    {
                        $result['is_ok'] = '1';
                        $result['msg'] = 'ԤԼˢ·Ϣɾ';
                    }
                }
                
                //ԤԼ
                $this->reserve_model->get_myprojects(1);
            }
        }
        return $result;
    }
}
/* End of file reserve.php */
/* Location: ./application/controllers/reserve.php */