<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ƥ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * Sell_match_base_model CLASS
 *
 * ۶ͼ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz
 */
//ظ
load_m("sell_attr_model");

class Sell_real_base_model extends Sell_attr_model {
    
    /**
     * RealʶӦֵ
     * @var const
     */
    const  ISREAL_VALUE = 1;
    
    /**
     * ÿ
     * @var const
     */
    const  APPLY_LIMIT = 4;

	 /**
     * ÿɹ
     * @var const
     */
    const  REAL_LIMIT = 2;
    
    /**
     * realԴ¼
     * @var const
     */
    const  REAL_TBL = 'house_real';
    
    /**
     * realԴͼƬ
     * @var const
     */
    const  REAL_PIC_TBL = 'house_real_pic';
    
    /**
     * real֤
     * @var private
     */
    private  $_pic_title = '';
    
    /**
     * real֤URLַ
     * @var private
     */
    private  $_pic_url = '';
    
    /**
     * realίЭͼƬַ
     * @var const
     */
    private  $_real_pics = array();
	
	/**
	 * ʶ
	 * @var private
	 */
	private  $_mem_key;
    
    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct();
		//var_dump($this->dbback);exit();

		$this->_mem_key = GB_CITY.'sell_real_base_model';
    }
    
    
    /**
     * ȡREALǩӦֵ
     *
     * @access	public
     * @param	string $rowid Դ
     * @return	void
     */
    public function get_isreal_value()
    {
        return self::ISREAL_VALUE;
    }
    
    /**
     * ȡREALǩһõĴ
     *
     * @access	public
     * @param	string $rowid Դ
     * @return	void
     */
    public function get_today_apply_num() 
    {
        return self::APPLY_LIMIT;
    }
    
    /**
     * REAL֤
     *
     * @access	public
     * @param	string $rowid Դ
     * @return	void
     */
    public function set_pic_title( $pic_title )
    {
        $this->_pic_title = strip_tags( $pic_title );
    }
    
    
    /**
     * ȡREAL֤
     *
     * @access	public
     * @return	string ֤
     */
    public function get_pic_title()
    {
        return $this->_pic_title;
    }
    
    
    /**
     * ÷֤ͼƬַ
     *
     * @access	public
     * @param	string $pic_url ͼƬURL
     * @return	void
     */
    public function set_pic_url( $pic_url )
    {
        $this->_pic_url = strip_tags( $pic_url );
    }
    
    
    /**
     * ȡREALַ֤
     *
     * @access	public
     * @return	string REALַ֤
     */
    public function get_pic_url()
    {
        return $this->_pic_url;
    }
    
    
    /**
     * ίЭͼƬURL
     *
     * @access	public
     * @param	array $pic_array ԴͼƬ
     * @return	void
     */
    public function set_real_pics( $pic_array )
    {
        $this->_real_pics = $pic_array;
    }
    
    
    /**
     * ȡԴίЭͼƬURL
     *
     * @access	public
     * @return	array ԴίЭͼƬURL
     */
    public function get_real_pics()
    {
        return $this->_real_pics ;
    }
    
    /**
     * жϷԴǷΪRealԴ
     *
     * @access	public
     * @return	boolean  ǷΪRealԴ
     */
    public function is_real()
    {
        $is_real = FALSE;
        
        $house_info = $this->init_houseinfo();
        
        if( is_array( $house_info ) && !empty( $house_info ) )
        {
            $is_real = self::ISREAL_VALUE == $house_info['isreal'] 
                    ? TRUE : FALSE;
        }
        
        return $is_real;
    }
    
    
    /**
     * RealԴ
     *
     * @access  protected
     * @return  boolean  Ƿóɹ
     */
    public function set_real()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
        $uid = intval($house_info['uid']);

        if( $rowid > 0 && $uid > 0)
        {   
            $result_add = 0;
            //ؾϢ
            $this->load->model('broker_model');
            $this->broker_model->set_uid($uid);
            $broker_info = $this->broker_model->get_broker_info();
            
            //жûǷΪREAL֤ûҪжǷϴ֤ί
            if( $broker_info['isreal'] == 1 || ( /**$this->_pic_title != '' && **/ $this->_pic_url != '') 
                    || (is_array($this->_real_pics) && !empty($this->_real_pics)) )
            {
                //Real¼
				if($broker_info['isreal'] == 1)
				{
					$result_add = $this->_add_real_record( $rowid ,$broker_info['truename'] ,$broker_info['username'] , $uid,
                    $house_info['telno'] ,$house_info['price'] ,$house_info['buildarea'] ,$house_info['blockshowname'],1);
				}
				else
				{
					$result_add = $this->_add_real_record( $rowid ,$broker_info['truename'] ,$broker_info['username'] , $uid,
                    $house_info['telno'] ,$house_info['price'] ,$house_info['buildarea'] ,$house_info['blockshowname']);
				}
            }
            else
            {
                return $result;
            }
            
            //жϷԴǷѾREALͼƬ¼м¼ɾ
            $cond_where = "rowid = $rowid";
            $pic_num = $this->get_house_real_pic_num($cond_where);

            if( $pic_num > 0 )
            {   
                $this->delete_real_pic ( $rowid );
            }
            
            //ͨϴ֤ԼREAL״̬
            if( /**$this->_pic_title != '' &&**/ $this->_pic_url != '' && $result_add > 0)
            {   
                //ӷ֤
                $result_add_pic = $this->_add_pic_rel( $rowid , $this->_pic_title , $this->_pic_url , 1);
                
                if( $result_add_pic )
                {   
                    $update_info = array();
                    $update_info['is_rel'] = 1; 
                    $cond_where = "id = $rowid AND real_esta IN ( 0 , 1 , 4 , 5 )";
                    $this->update_house_real( $update_info , $cond_where);
                }
            }
            else if( is_array($this->_real_pics) && !empty($this->_real_pics) && $result_add > 0 )
            {   
                //Լ
                $pic_num = count($this->_real_pics);
                for($i = 0 ; $i < $pic_num ; $i ++  )
                {
                    $result_add_pic = $this->_add_pic_rel($rowid , '' , $this->_real_pics[$i] , 2);
                    if( $result_add_pic )
                    {   
                        $update_info = array();
                        $update_info['is_contract'] = 1; 
                        $cond_where = "id = $rowid AND real_esta IN ( 0 , 1 , 4 , 5 )";
                        $this->update_house_real( $update_info , $cond_where);
                    }
                }
            }

            if( $result_add > 0)
            {
                $update_info = array();
            
                //ҪõķԴֵ
                $update_info['isreal'] = self::ISREAL_VALUE;
            
                //öͼԴ
                $result = $this->update_house_atrr_val( $update_info , $rowid );

				//REAL
				$this->get_real_num_by_uid($uid , 1);
				$this->apply_real_num_today($uid , 1);
            }
        }
        
        return $result;
    }
    
    
    /**
     * ȡRealԴǩ
     *
     * @access  protected
     * @return  boolean  Ƿȡɹ
     */
    public function remove_real()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
		$uid = intval($houseinfo['uid']);
        
        if( $rowid > 0 )
        {   
			$update_info = array();

			//ҪõķԴֵ
			$update_info['isreal'] = 0;

			//ȡReal
			$result = $this->update_house_atrr_val( $update_info , $rowid );
            
            if( $result === TRUE )
            {   
				//ʧЧREAL¼
				$result_invalid = $this->_invalid_real_by_rowid($rowid,7);

				//REAL
				$this->get_real_num_by_uid($uid , 1);
				$this->apply_real_num_today($uid , 1);
            }
        }
        
        return $result;
    }
    
    
    /**
     * ⷿԴǷRealԴı׼
     *
     * @access  protected
     * @return  boolean  ǷRealԴı׼
     */
    public function check_real_standard()
    {   
        //ԴϢ
        $houseinfo = $this->init_houseinfo();
        $result = array();
        $uid = intval($houseinfo['uid']);
        $this->load->model('broker_model');
        $this->broker_model->set_uid($uid);
        $broker_info = $this->broker_model->get_broker_info();
        
        /*** ˲ٺ ***/
        if( is_array( $broker_info ) && !empty( $broker_info ) )
        {   
            if(isset($broker_info['festa']) && $broker_info['festa'] == 1 )
            {
                //״̬
                $result['is_ok'] = 0;
                $result['msg'] = 'ںУ޷ñǩԴ';
                return  $result;
            }
        }
        else
        {
            //ϢΪ
            $result['is_ok'] = 0;
            $result['msg'] = 'ϢΪ';
            return  $result;
        }
        
        //REAL
        $real_num = 0;
        //$real_limit = intval($broker_info['real_limit']);
        $real_num = $this->get_real_num_by_uid($uid , 1);

        if( $real_num >= self::REAL_LIMIT)
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'REAL';
            return  $result;
        }
        
        //
        $apply_real_num = 0;
        $apply_real_num = $this->apply_real_num_today($uid , 1);
        if( $apply_real_num >= self::APPLY_LIMIT)
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'Real';
            return  $result;
        }
        
        /*** ǶͼԴΪREAL ***/
        $this->load->model('sell_star_base_model');
        $isstar_value = $this->sell_star_base_model->get_isstar_value();
        if( $houseinfo['isstar'] != $isstar_value )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ǶͼԴΪREAL';
            return  $result;
        }
        
        /** ·ֱ **/
        $this->load->model('sell_nofee_base_model');
        $isstar_value = $this->sell_nofee_base_model->get_nofee_value();
        if($houseinfo['nofee'] == 1)
        {
            //·Դ
            $result['is_ok'] = 0;
            $result['msg'] = '·ֱ';
            return  $result; 
        }
        
        //Ч״̬
        if( $houseinfo['esta'] != 1 )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴǼ״̬޷REAL';
            return  $result;
        }
        
        $result['is_ok'] = 1;
        $result['msg'] = 'REAL';
        
        return $result;
    }


	  /**
     * ⷿԴǷRealԴı׼(бҳר)
     *
     * @access  protected
     * @return  boolean  ǷRealԴı׼
     */
    public function check_real_standard_list($real_num,$real_today_num)
    {   
        //ԴϢ
        $houseinfo = $this->init_houseinfo();
        $result = array();
        $uid = intval($houseinfo['uid']);
        $this->load->model('broker_model');
        $this->broker_model->set_uid($uid);
        $broker_info = $this->broker_model->get_broker_info();
        
        /*** ˲ٺ ***/
        if( is_array( $broker_info ) && !empty( $broker_info ) )
        {   
            if(isset($broker_info['festa']) && $broker_info['festa'] == 1 )
            {
                //״̬
                $result['is_ok'] = 0;
                $result['msg'] = 'ںУ޷ñǩԴ';
                return  $result;
            }
        }
        else
        {
            //ϢΪ
            $result['is_ok'] = 0;
            $result['msg'] = 'ϢΪ';
            return  $result;
        }
        
        //REAL
        $real_num = 0;
        //$real_limit = intval($broker_info['real_limit']);
        $real_num = $real_num;

        if( $real_num >= self::REAL_LIMIT)
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'REAL';
            return  $result;
        }
        
        //
        $apply_real_num = 0;
        $apply_real_num = $real_today_num;
        if( $apply_real_num >= self::APPLY_LIMIT)
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'Real';
            return  $result;
        }
        
        /*** ǶͼԴΪREAL ***/
        $this->load->model('sell_star_base_model');
        $isstar_value = $this->sell_star_base_model->get_isstar_value();
        if( $houseinfo['isstar'] != $isstar_value )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ǶͼԴΪREAL';
            return  $result;
        }
        
        /** ·ֱ **/
        $this->load->model('sell_nofee_base_model');
        $isstar_value = $this->sell_nofee_base_model->get_nofee_value();
        if($houseinfo['nofee'] == 1)
        {
            //·Դ
            $result['is_ok'] = 0;
            $result['msg'] = '·ֱ';
            return  $result; 
        }
        
        //Ч״̬
        if( $houseinfo['esta'] != 1 )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴǼ״̬޷REAL';
            return  $result;
        }
        
        $result['is_ok'] = 1;
        $result['msg'] = 'REAL';
        
        return $result;
    }
    
    
    
    /**
     * 鵽Real¼(add 2014/9/10)
     *
     * @access  protected
     * @param   string $cond_where ѯ
	 * @param   int $force_db 0ӿѯ 1ǿѯ 
     * @return  boolean  ǷRealԴı׼
     */
    public function get_real_num_by_cond($cond_where , $force_db = 0)
    {
        $real_num = 0;
       
        if( $cond_where != '')
        {	
			$mem_key = $this->_mem_key.'_get_real_num_by_cond_'.$cond_where.'_'.$force_db;
			if( $force_db == 1 )
            {
                $this->mc->delete($mem_key);
            }
			$cache = $this->mc->get($mem_key);

            if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
            {
                $real_num = $cache['data'];
            }
            else
            {	
				if($force_db == 1)
				{
					$this->db->where($cond_where);
					$real_num = $this->db->count_all_results(self::REAL_TBL);
				}
				else
				{
					$this->dbback->where($cond_where);
					$real_num = $this->dbback->count_all_results(self::REAL_TBL);	
				}

				$this->mc->add($mem_key, array('is_ok'=>1,'data'=>$real_num), 30);
			}
        }
        
        return $real_num;
    }
    
    
    /**
     * UIDѯ˺ͨ˵REAL
     *
     * @access  public
     * @param   int  $uid ˱
     * @param   int  $update_cache ʶ
     * @return  boolean  ˺ͨ˵REAL
     */
    public function get_real_num_by_uid($uid, $update_cache = 0)
    {   
        $real_num = 0;

        if( $uid > 0 )
        {
            $mem_key = $this->_mem_key.'_get_real_num_by_uid_'.$uid;
            if( $update_cache == 1 )
            {
                $this->mc->delete($mem_key);
            }
            $cache = $this->mc->get($mem_key);

            if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
            {
                $real_num = $cache['data'];
            }
            else
            {
                $cond_where = "uid = '".$uid."' AND real_esta IN (0,1)";
                $real_num = $this->get_real_num_by_cond($cond_where , 1);
                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$real_num), 30);
            }
        }
        
        return $real_num;
    }
    
    
    /**
     * REAL
     *
     * @access  public
     * @param   int  $uid ˱
     * @param   int  $update_cache ʶ
     * @return  boolean  REAL
     */
    public function apply_real_num_today( $uid , $update_cache = 0)
    {   
        $today_apply_num = 0;

        if( $uid > 0 )
        {	
            $starttime = strtotime(date('Y-m-d 00:00:00'));
            $endtime = strtotime(date('Y-m-d 23:59:59'));

            $mem_key = $this->_mem_key.'_apply_real_num_today_'.$uid.'_'.$starttime.'_'.$endtime;
            if( $update_cache == 1 )
            {
                $this->mc->delete($mem_key);
            }
            $cache = $this->mc->get($mem_key);

            if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
            {
                $today_apply_num = $cache['data'];
            }
            else
            {
                $cond_where = "uid ='".$uid."' AND createtime >= '".$starttime."' AND createtime <= '".$endtime."' ";
                $today_apply_num = $this->get_real_num_by_cond( $cond_where , 1);

                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$today_apply_num),  300);
            }
        }
        
        return $today_apply_num;
    }
    
    /**
     * REAL¼
     *
     * @access  public
     * @param   int  $uid ˱
     * @return  boolean  Ƿɹ
     */
    private function _add_real_record( $rowid ,$truename ,$username , $uid ,
            $telno ,$price , $buildarea ,$blockshowname,$real_esta = 0)
    {
        $result = 0;
        $time = time();

        $data_info = array();
        $data_info['tbl'] = 'sell';
        $data_info['rowid'] = $rowid;
        $data_info['truename'] = $truename;
        $data_info['username'] = $username;
        $data_info['uid'] = $uid;
        $data_info['telno'] = $telno;
        $data_info['price'] = $price;
        $data_info['buildarea'] = $buildarea;
        $data_info['blockname'] = $blockshowname;
		$data_info['real_esta'] = intval($real_esta);
        $data_info['createtime'] = $time;
        
        $this->db->insert( self::REAL_TBL , $data_info );
        //echo $this->db->last_query();
        $result = ( $this->db->affected_rows() == 1 ) ? $this->db->insert_id() : 0;
        
        return $result;
    }
    
    
    /**
     * ӷ֤¼
     *
     * @access  private
     * @param   int  $rowid Դ
     * @param   int  $pic_title ֤
     * @param   int  $pic_url ֤ͼƬַ
     * @param   int  $kind ͼƬ 1-֤ 2Լ
     * @return  int  ǷɹɹزIDʧܷ 0 
     */
    private function _add_pic_rel( $rowid , $pic_title , $pic_url , $kind)
    {
        $data_info = array();
        $data_info['tbl'] = 'sell';
        $data_info['rowid'] = $rowid;
        $data_info['kind'] = $kind;
        $data_info['pic_url'] = $pic_url;
        $data_info['pic_title'] = $pic_title;
        $data_info['createtime'] = time();
        $this->db->insert( self::REAL_PIC_TBL , $data_info );
        $result = ( $this->db->affected_rows() == 1 ) ? $this->db->insert_id() : 0;
        
        return $result;
    }
    
    
    /**
     * ʧЧRealϢ
     * @param int $rowid Դ
     * @param int $real_esta ʧЧ״̬
     */
    function _invalid_real_by_rowid( $rowid , $real_esta )
    {   
        $result = FALSE;
        
        if( $rowid > 0 )
        {   
            $update_data = array();
            $update_data['real_esta'] = intval($real_esta);
            $update_data['is_rel'] = 0;
            $update_data['is_contract'] = 0;

            $cond_where = "rowid = '".$rowid."' AND tbl = 'sell'";
            $this->db->where($cond_where);
            $this->db->update( self::REAL_TBL, $update_data);
            
            $result = $this->db->affected_rows() > 0 ? TRUE : FALSE;
        }

        return $result;
    }
    
    
    /**
     * REALϢ
     *
     * @access  private
     * @param   array  $update_info Դ
     * @param   string  $cond_where ֤
     * @return  int  Ӱ
     */
    public function update_house_real( $update_info , $cond_where )
    {
        $result = 0;

        if(is_array($update_info) && !empty($update_info) && $cond_where != '')
        {   
            $this->db->where($cond_where);
            $this->db->update(self::REAL_TBL, $update_info);
            $result =  $this->db->affected_rows();
        }

        return $result;
    }
    
    
    /**
     * ȡREALͼƬ
     *
     * @access  private
     * @param   string  $cond_where ѯ
     * @return  int  ͼƬ
     */
    public function get_house_real_pic_num ( $cond_where )
    {
        $real_num = 0;
       
        if( $cond_where != '')
        {
            $this->dbback->where($cond_where);
            $real_num = $this->dbback->count_all_results(self::REAL_TBL);
        }
        
        return $real_num;
    }
    
    
    /**
     * ɾREAL
     *
     * @access  private
     * @param   int  $rowid Դ
     * @return  boolean  ɾǷɹ
     */
    public function delete_real_pic ( $rowid )
    {
        $result = FALSE;
       
        if( $rowid > 0 )
        {   
            $cond_where = "id = $rowid";
            $this->db->where($cond_where);
            $this->db->delete(self::REAL_PIC_TBL);
            
            if ( $this->db->affected_rows() > 0)
            {
                $result = TRUE;
            }
        }
        
        return $result;
    }
}
/* End of file sell_real_base_model.php */
/* Location: ./applications/models/sell_real_base_model.php */