<?php
/**
 * ɳֵȼ
 *
 * @author sun
 */
class GrowthLevel {
    
    /**
     * ݿ
     */
    private $db;

    /**
     * ݿ
     */
    private $dbback;

    /**
     * 
     */
    private $mc;
    
    /**
     * ı
     * @var string
     */
    private $table;
    
    /**
     * аֶ
     * @var array
     */
    private static $fields = array('level_id','name','down_exp','up_exp');
    
    /**
     * ˳ɳֵ
     * @var object
     */
    private $exp;
    
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = ' growth_exp_level';
        $this->exp = new GrowthExp();
    }
    
    /**
     * ʼɳֵȼֵֵ
     * @param type $arrFiled
     * @return type
     */
    public function initData($arrFiled) {
        $sql = SqlCombinHelper::insert_sql($this->table, $arrFiled);
        return $this->db->execute($sql);
    }
    
    /**
     * سɳֵȼ
     * @return array
     */
    public function findAllLevelData() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);
        return $this->dbback->getAll($sql);
    }
    
    /**
     * ݵȼIDŻȡһ¼
     * @param int $levelId ȼID
     * @return array
     */
    public function findOneByLevelId($levelId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "level_id = $levelId");
        return $this->dbback->getRow($sql);
    }
    
    /**
     * ݵȼƻȡһ¼
     * @param string $levelName ȼ
     * @return array
     */
    public function findOneByLevelName($levelName) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, 
                "name = '".$levelName."'");
        return $this->dbback->getRow($sql);
    }
    
    /**
     * ݳɳֵֵȡľ
     * @param type $down_exp ɳֵޱֵ
     * @param type $up_exp ɳֵޱֵ
     * @return int Ŀ
     */
    public function findBrokerNumByBetweenExp($down_exp, $up_exp) {
        $brokerNum = 0;
        if ($down_exp >= 0 && $up_exp >= 0 && $up_exp != null) {
            $brokerNum = $this->exp->findBrokerNumByBetweenExp($down_exp, $up_exp);
        } else if ($down_exp >= 0  && $up_exp == null) {
            $brokerNum = $this->exp->findBrokerNumByGlExp($down_exp);
        } else if ($down_exp == null  && $up_exp >= 0) {
            $brokerNum = $this->exp->findBrokerNumByLeExp($up_exp);
        }
        return $brokerNum;
    }
    
    /**
     * ݵȼIDȡľ
     * @param int $levelId  ȼIDֵ
     * @return array
     */
    public function findBrokerNumByLevelId($levelId) {
        $arrLevelOne = $this->findOneByLevelId($levelId);
        return $this->findBrokerNumByBetweenExp($arrLevelOne['down_exp'], 
                $arrLevelOne['up_exp']);
    }

    /**
     * ݵȼƻȡľ
     * @param string $levelName  ȼ
     * @return array
     */
    public function findbrokerNumByLevelName($levelName) {
        $arrLevelOne = $this->findOneByLevelName($levelName);
        return $this->findBrokerNumByBetweenExp($arrLevelOne['down_exp'], 
                $arrLevelOne['up_exp']);
    }
    
    /**
     * ݳɳֵֵȡľ
     * @param type $down_exp ɳֵޱֵ
     * @param type $up_exp ɳֵޱֵ
     * @return int 
     */
    public function findAllBrokerByBetweenExp($down_exp, $up_exp) {
        $arrBroker = array();
        if ($down_exp >= 0 && $up_exp >= 0 && $up_exp != null) {
            $arrBroker = $this->exp->findAllBrokerByBetweenExp($down_exp, $up_exp);
        } else if ($down_exp >= 0  && $up_exp == null) {
            $arrBroker = $this->exp->findAllBrokerByGlExp($down_exp);
        } else if ($down_exp == null  && $up_exp >= 0) {
            $arrBroker = $this->exp->findAllBrokerByLeExp($up_exp);
        }
        return $arrBroker;
    }

    /**
     * ݵȼIDȡľ
     * @param int $levelId  ȼIDֵ
     * @return array ؾϢ
     */
    public function findAllBrokerByLevelId($levelId) {
        $arrLevelOne = $this->findOneByLevelId($levelId);
        return $this->findAllBrokerByBetweenExp($arrLevelOne['down_exp'], 
                $arrLevelOne['up_exp']);
    }
    
    /**
     * ݵȼƻȡľ
     * @param string $levelName  ȼ
     * @return array ؾϢ
     */
    public function findAllBrokerByLevelName($levelName) {
        $arrLevelOne = $this->findOneByLevelName($levelName);
        return $this->findAllBrokerByBetweenExp($arrLevelOne['down_exp'], 
                $arrLevelOne['up_exp']);
    }
    
    /**
     * ݾ˳ɳֵȡȼ
     * @param int $exp ɳֵ
     * @return string سɳֵӦĵȼ :Lv4
     */
    public function findLevelNameByExp($exp) {
        $arrExpOne = $this->findOneByExp($exp);
        return $arrExpOne['name'];
    }
    
     /**
     * ݾ˳ɳֵһ֮ƥļ¼
     * @param int $exp ɳֵ
     * @return string һ֮ƥļ¼
     */   
    public function findOneByExp($exp) {
        $arrLevelData = $this->findAllLevelData();
        foreach($arrLevelData as $value) {			
            if (($exp >= $value['down_exp'] && $exp <= $value['up_exp']) 
                    || ($value['up_exp'] == 0 && $exp >= $value['down_exp'])) {				
                return $value;
            } 
        }
    }
    
    /**
     * ݾ˳ɳֵһ֮ƥļ¼
     * @param type $exp
     */
    public function findLevelIdByExp($exp) {
        $arrExpOne = $this->findOneByExp($exp);
        return $arrExpOne['level_id'];
    }
    
    /**
     * ݵȼIDȡȼ
     * @param int $exp ɳֵ
     * @return string سɳֵӦĵȼ :Lv4
     */
    public function findLeveNameByLevelId($levelId) {
        $arrLevelRow = $this->findOneByLevelId($levelId);
        return $arrLevelRow['name'];
    }
    
    /**
     * 
     */
    public function emptyTable() {
        $sql = "TRUNCATE TABLE $this->table";
        $this->db->execute($sql);
    }
}
