<?php

/**
 * core\lib\block\BlockLevelInfoFullSetting.php
 */

/**
 * ƶȣδСͼƬСȼ 
 *
 * @author Wxj
 */
class BlockLevelInfoFullSetting {
    
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $dbback;
    /**
     *
     * @var Memcache  
     */
    private $mc;
    /**
     *
     * @var string 
     */
    private $table;
    /**
     *
     * @var array аֶ
     */
    public static $fields = array('id', 'level', 'not_filled_items_number', 'image_number', 'credit_way_alias', 'exp_way_alias');

     /**
     *
     * @var array ּ
     */
    public static $levels = array('1'=>'','2'=>'','3'=>'','4'=>'',);
    /**
     * 캯 ʼdbmemcache
     * @param string $table 
     */
    public function __construct($table = 'block_level_info_full_setting') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = $table;
    }

    /**
     * Сּݣ*,**,***,****4ּ
     * @return array Сȼ
     */
    public function findAll() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);
        $sql .= "order by id asc, level";
        $res = $this->db->getAll($sql);
        if ($res) {
            foreach ($res as $key => $value) {
                $res[$key] = $this->removeNumberKey($value);
            }
        }
        return $res;
    }

    /**
     * ȥмֵΪԪ
     * @param array $arr ֵַֺ
     * @return array ֵ
     */
    private function removeNumberKey($arr) {
        $rarr = array();
        foreach ($arr as $k => $val) {
            if (!is_int($k)) {
                $rarr[$k] = $val;
            }
        }
        return $rarr;
    }

    /**
     * ߸Сȼ
     * @param array $fields Сȼ
     * @return boolean ɹtrueʧܷfalse
     */
    public function save($fields) {
        $keys = array_keys($fields);
        if (array_key_exists('not_filled_items_number', $fields) && array_key_exists('image_number', $fields)) {
            $not_filled_items_number = $fields['not_filled_items_number'];
            $imageNumber = $fields['image_number'];
            $sql = "insert into $this->table (" . implode(",", $keys) . ") value ('" . implode("','", $fields) . "')";
            $sql .= " ON DUPLICATE KEY UPDATE not_filled_items_number='$not_filled_items_number',image_number='$imageNumber'";
            if ($this->db->execute($sql)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * $not_filled_items_number,$imageNumber
     * @param int $not_filled_items_number Ϊnullʱ
     * @param int $imageNumber Ϊnullʱ
     * @return int ظµļ¼Ŀ
     */
    public function update($not_filled_items_number, $imageNumber) {
        
        $fields = array();
        if($not_filled_items_number===null&&$imageNumber===null) {
            return false;
        } else {
            if($not_filled_items_number!==null) {
                $fields['not_filled_items_number'] = $not_filled_items_number;
            }
            if($imageNumber!==null) {
                $fields['image_number'] = $imageNumber;
            }
            $sql = SqlCombinHelper::update_sql($this->table, $fields, '');
            $this->db->execute($sql);
            return $this->db->affected_Rows();
        }
    }

    /**
     * not_filled_items_numberֵ
     * @param int $not_filled_items_number not_filled_items_numberֵ
     * @return int ظµļ¼Ŀ
     */
    public function updatePv($not_filled_items_number) {
        $sql = SqlCombinHelper::update_sql($this->table, array('not_filled_items_number' => $not_filled_items_number));
        $this->db->execute($sql);
        return $this->db->affected_Rows();
    }

    /**
     * ·Դ
     * @param int $imageNumber Դ
     * @return int ظµļ¼Ŀ
     */
    public function updateHouseNumber($imageNumber) {
        $sql = SqlCombinHelper::update_sql($this->table, array('image_number' => $imageNumber));
        $this->db->execute($sql);
        return $this->db->affected_Rows();
    }

    /**
     * ݵȼһֻȡʽı
     * @param int $level Сȼ
     * @param int $type Ĭֵ1, ʾ޸ϣ2ʾ޸ͼƬ
     * @return string  ֻȡʽ
     */
    public function getCreditWayAlias($level,$type = 1) {
        $sql = SqlCombinHelper::select_sql($this->table, 'credit_way_alias', "level = '$level' and type='$type'");
        return $this->dbback->getOne($sql);
    }

    /**
     * ݵȼҾȡʽı
     * @param int $level Сȼ
     * @param int $type Ĭֵ1, ʾ޸ϣ2ʾ޸ͼƬ
     * @return string ȡʽı
     */
    public function getExpWayAlias($level,$type = 1) {
        $sql = SqlCombinHelper::select_sql($this->table, 'exp_way_alias', "level = '$level' and type='$type'");
        return $this->dbback->getOne($sql);
    }
    
    /**
     * Сȼñ
     */
    public function emptyTable() {
        $sql = "TRUNCATE TABLE $this->table";
        $this->db->Execute($sql);
    }
}

?>
