<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ƥ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * sell_nofee_base_model CLASS
 *
 * ַ·ֱ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz
 */
//ظ
load_m("sell_attr_model");
class Sell_nofee_base_model extends Sell_attr_model{
    
    /**
     * RealʶӦֵ
     * @var const
     */
    const  NOFEE_VALUE = 1;

    /**
     * ʶ
     * @var private
     */
    private $_mem_key;
    
    /*
     * 캯
     */
    public function __construct() 
    {
        parent::__construct();

		$this->_mem_key = GB_CITY.'sell_nofee_base_model';
    }
    
    
    /**
     * ȡ·ֱֵ
     * @var const
     */
    public function get_nofee_value()
    {
        return self::NOFEE_VALUE;
    }
    
    /**
     * жϷԴǷΪ·ֱ۷Դ
     *
     * @access	public
     * @return	boolean  ǷΪ·ֱ۷Դ
     */
    public function is_nofee()
    {
        $is_nofee = FALSE;
        
        $house_info = $this->init_houseinfo();
        
        if( is_array( $house_info ) && !empty( $house_info ) )
        {   
            $is_nofee = self::NOFEE_VALUE == $house_info['nofee'] 
                    ? TRUE : FALSE;
        }
        
        return $is_nofee;
    }
    
    
    /**
     * nofeeԴ
     *
     * @access  public
     * @return  boolean  Ƿóɹ
     */
    public function set_nofee()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
        
        if( $rowid > 0 )
        {   
            $update_info = array();
            
            //ҪõķԴֵ
            $update_info['nofee'] = self::NOFEE_VALUE;
            
            //öͼԴ
            $result = $this->update_house_atrr_val( $update_info , $rowid );
        }
        
        return $result;
    }
    
    
    /**
     * nofeeԴ
     *
     * @access  public
     * @return  boolean  Ƿóɹ
     */
    public function remove_nofee()
    {   
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
        
        if( $rowid > 0 )
        {   
            $update_info = array();
            
            //ҪõķԴֵ
            $update_info['nofee'] = 0;
            
            //öͼԴ
            $result = $this->update_house_atrr_val( $update_info , $rowid );
        }
        
        return $result;
    }
    
    
    /**
     * ǷԴǷ·ֱõı׼
     *
     * @access  protected
     * @return  boolean  Ƿ·ֱ۷Դ׼
     */
    public function check_nofee_standard()
    {   
        $result = array();
        
        $houseinfo = $this->init_houseinfo();
        $rowid = $houseinfo['id'];
        $blockid = intval($houseinfo['blockid']);
        $this->load->model('broker_model');
        
        /** ǶͼԴ **/
        $this->load->model('sell_star_base_model');
        $star_value = $this->sell_star_base_model->get_isstar_value();

        if( $houseinfo['isstar'] != $star_value )
        {
            //·Դ
            $result['is_ok'] = 0;
            $result['msg'] = 'ǶͼԴ';
            return  $result; 
        }
        
        /** ·ֱ **/
        $uid = intval($houseinfo['uid']);
        $nofee_limit = $this->get_nofee_num_limit($uid);
        $nofee_today = $this->get_nofee_num_by_uid($uid);
        if( $nofee_limit <= $nofee_today)
        {
            $result['is_ok'] = 0;
            $result['msg'] = '·ֱ';
            return  $result;
        }
        
        /*** ¥̷Դ ***/
        $this->load->model('block_model');
        $nofee_block = $this->block_model->get_nofee_block();
        $nofee_blockid = array();
        if( is_array( $nofee_block ) && !empty( $nofee_block ))
        {
            foreach($nofee_block as $v) {
                $nofee_blockid[] = $v['id'];
            }
        }
        if(!in_array( $blockid , $nofee_blockid ) )
        {
            $result['is_ok'] = 0;
            $result['msg'] = '¥̷Դ';
            return  $result;
        }
        
        /*** üƱǩ ***/
        $this->load->model('sell_tag_base_model');
        $tag_value = $this->sell_tag_base_model->get_istag_value();
        if( $houseinfo['istag'] == $tag_value )
        {
            //·Դ
            $result['is_ok'] = 0;
            $result['msg'] = 'üƱǩ';
            return  $result; 
        }
        
        /*** üƱǩ ***/
        $this->load->model('sell_real_base_model');
        $isreal_value = $this->sell_real_base_model->get_isreal_value();
        if( $houseinfo['isreal'] == $isreal_value )
        {
            //·Դ
            $result['is_ok'] = 0;
            $result['msg'] = 'REALǩ';
            return  $result; 
        }
        
        $this->broker_model->set_uid($houseinfo['uid']);
        $broker_info = $this->broker_model->get_broker_info();
        
        /*** ˲ٺ ***/
        if( is_array( $broker_info ) && !empty( $broker_info ) )
        {
            if( $broker_info['festa'] == 1 )
            {
                //״̬
                $result['is_ok'] = 0;
                $result['msg'] = 'ںУ޷ñǩԴ';
                
                return  $result;
            }
        }
        else
        {
            //ϢΪ
            $result['is_ok'] = 0;
            $result['msg'] = 'ϢΪ';
            return  $result;
        }

        /*** ͼԴ״ֻ̬ΪЧ״̬ ***/
        if( $houseinfo['esta'] != 1 )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴǼ״̬޷·ֱ';
            return  $result;
        }
        
        $result['is_ok'] = 1;
        $result['msg'] = '·ֱ';
        
        return $result;
    }
    
    
    /**
     * UIDѯ·ֱ۷Դĸ
     *
     * @access  public
     * @param   int  $uid ˱
     * @return  boolean  ·ֱ۷Դĸ
     */
    public function get_nofee_num_by_uid($uid)
    {   
        $nofee_num = 0;
        
        if( $uid > 0)
        {	
            $mem_key = $this->_mem_key.'_get_nofee_num_by_uid_'.$uid;
            $cache = $this->mc->get($mem_key);

            if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
            {
                $nofee_num = $cache['data'];
            }
            else
            {
                $this->load->model('sell_base_model');
                $cond_where = "uid = $uid  AND esta IN (1,5) AND  infofrom = '5' AND nofee = '".self::NOFEE_VALUE."'";
                $nofee_num = $this->sell_base_model->find_count_by($cond_where,1);

                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$nofee_num),  10);
            }
        }

        return $nofee_num;
    }
    
    
    /**
     * UIDѯ·ֱ۷Դĸ
     *
     * @access  public
     * @param   int  $uid ˱
     * @return  boolean  ·ֱ۷Դĸ
     */
    public function get_nofee_num_limit($uid)
    {   
        $nofee_num_limit = 0;
        
        if( $uid > 0)
        { 
            $this->load->model('broker_model');
            $this->broker_model->set_uid($uid);
            $broker_info = $this->broker_model->get_broker_info();
            $nofee_num_limit = (is_array($broker_info) && !empty($broker_info)) ?
                    $broker_info['nofee_num'] : 0 ;
        }
        
        return $nofee_num_limit;
    }
}
