<?php
/**
 * ͷ
 */
class PaymentRewardUpload {

    private $dbback;
    
    private $objReader;
    
    private $time;
    
    private $db;
    
    private $mc;


    /**
     *  캯
     * 
     */
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');    
        $this->objReader = PHPExcel_IOFactory::createReader('Excel5');
        $this->time = time();//ȥǰϴʱ 
        $this->tbl_upload = "payment_housebean_reward";
        $this->tbl_upload_false = "payment_housebean_reward_false";
    
    }
    
    /**
     * ϴexcel
     * @return array
     */
    public function uploadexcel($filetempname) {  
      
        //$objReader = PHPExcel_IOFactory::createReader('Excel5');
        $objPHPExcel	= $this->objReader->load($filetempname); 
        $sheet		= $objPHPExcel->getSheet(0); 
        $highestRow	        = $sheet->getHighestRow();           //ȡ 
        $highestColumn	= $sheet->getHighestColumn();	//ȡ

        $objWorksheet	= $objPHPExcel->getActiveSheet();
        $highestRow	        = $objWorksheet->getHighestRow();

        $highestColumn	= $objWorksheet->getHighestColumn();
        $highestColumnIndex = PHPExcel_Cell::columnIndexFromString($highestColumn);//
        $headtitle	        = array();
        $strs	        = array();

        for ($i=0,$row = 2;$row <= $highestRow;$row++,$i++) {            
            //עhighestColumnIndex0ʼ
            for ($col = 0;$col < $highestColumnIndex;$col++){
                    $temp           = $objWorksheet->getCellByColumnAndRow($col,$row)->getValue();     
                    if($temp!='')
                    $strs[$i][$col] = strip_tags($temp);                   
            }          
        }        
        return $strs;
    }
  
    /**
     * ȡļչ
     * @return string
     */
    public function getFileExt($file){
        return strrchr ($file,'.');
    }
    
    /**
     * ͷ¼
     * @param String $activity 
     * @param int $type 
     * @param int $score ͷֵ
     * @param String $filepath ʵ
     * @param int $brokernumber 
     * @return boolean
     */
    public function insertReward($activity,$type,$num,$filepath,$brokernumber,
            $operator) {
        $arrField = array();
        $arrField['event'] = $activity; 
        $arrField['type'] = $type;
        $arrField['num'] = $num;
        $arrField['file'] = $filepath;
        $arrField['number'] = $brokernumber;
        $arrField['status'] = 0;
        $arrField['operator'] = $operator;
        $arrField['ctime'] = date('Y-m-d H:i:s');
        $sql = SqlCombinHelper::insert_sql($this->tbl_upload, $arrField);  
        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }
    }

     /**
     * ȡͼ¼     
     * @return int
     */
    public function getRewardLogNum($where) {       
        $sqlCredit = SqlCombinHelper::count_sql($this->tbl_upload,$where);        
        return $this->dbback->getOne($sqlCredit);
    }
    
    /**
     * ȡͷ¼
     * @param int $where
     * @param int $offset 
     * @param int $length
     * @return array
     */
    public function getRewardLog($where,$offset,$length) {        
        $sqlCredit = SqlCombinHelper::select_sql($this->tbl_upload, "*",$where)." order by id desc limit $offset,$length";
        return $this->dbback->getAll($sqlCredit);
        
    }
    
    /**
     * ȡͷ¼
     * @param int $where
     * @return array
     */
    public function getOneReward($where) {        
        $sqlCredit = SqlCombinHelper::select_sql($this->tbl_upload, "*",$where);      
        return $this->dbback->getRow($sqlCredit);
        
    }

    /**
     * ʧܲ     
     * @return boolean
     */
    public function insertFalseLog($uid,$activityid) {
        $arrField['uid'] = $uid;
        $arrField['activityid'] = $activityid;
        $sqlCredit = SqlCombinHelper::insert_sql($this->tbl_upload_false, $arrField);       
        if($this->db->execute($sqlCredit)) {
            return true;
        } else {
            return false;
        }      
    }

    /**
     * ޸״̬     
     * @return boolean
     */
    public function updateStatus($activityid,$operator) {
        $arrField['operator'] =$operator;
        $arrField['status'] =1;
        $sqlCredit = SqlCombinHelper::update_sql($this->tbl_upload, $arrField, 
                "id = $activityid");      
        if($this->db->execute($sqlCredit)) {
            return true;
        } else {
            return false;
        }      
    }
    
    
    /**
     * طʧ
     * @param int $id
     * @return int
     */
    public function updateFalseNum($id){          
        $arrField['falsenumber'] =  '1';
        $sql = SqlCombinHelper::updateSelf_sql($this->tbl_upload,$arrField,"id = $id");     
        if($this->db->execute($sql)) {
            return true;
        } else {
            return false;
        }            
    }
    
    public function delete($id)
    {
        $sql = SqlCombinHelper::delete_sql($this->tbl_upload, "id = $id and status = 0");
        $sql_false = SqlCombinHelper::delete_sql($this->tbl_upload_false, "activityid = $id");
        if ($this->db->execute($sql)) {
            return $this->db->execute($sql_false);
        } else {
            return false;
        }
    }
}

?>
