<?php

/**
 * core\lib\growth\GrowthExp.php
 */

/**
 * ˳ɳֵ
 *
 * @author sun
 */
class GrowthBidStart {
    
    /**
     * ݿ
     */
    private $db;

    /**
     * ݿ
     */
    private $dbback;

    /**
     * 
     */
    private $mc;
    
    /**
     * ı
     * @var string
     */
    private $table;
    
    /**
     * аֶ
     * @var array
     */
    private static $fields = array('id','way_alias','start_credit');

    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = 'growth_bid_start';
    }
    
    /**
     * 
     * @return array
     */
    public function findAllData() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);
        return $this->dbback->getAll($sql);
    }
    
    /**
     * 
     * @param type $wayAlias
     * @return type
     */
    public function findOneByWayAlias($wayAlias) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, $wayAlias);
        return $this->dbback->getRow($sql);
    }
    
    /**
     * 
     * @param type $wayAlias
     * @return type
     */
    public function findScoreByWayAlias($wayAlias) {
        $arrRow = $this->findOneByWayAlias($wayAlias);
        return $arrRow['start_credit'] == '' ? 0 : $arrRow['start_credit'];
    }

    /**
     * 
     * @param array $fields ݽṹ
     * @return boolean
     */
    public function saveData($fields) {
        $sql = SqlCombinHelper::replace_sql($this->table, $fields);
        return $this->db->execute($sql);
    }
    
}