<?php

/**
 * core\lib\block\BlockLevelStat.php
 */

/**
 * ݵȼݣСȼȶȣƶȣ
 *
 * @author Wxj
 */
class BlockLevelStat {
    /**
     *
     * @var Container dbmemcache
     */
    public $container;
    /**
     *
     * @var BlockLevelHeat Сȶ
     */
    private $blockLevelHeat;
    /**
     *
     * @var BlockLevelInfo Сƶȵȼ
     */
    private $blockLevelInfo;
    
    /**
     *
     * @var int Сȼʱpv 
     */
    private $pvLimit;
    /**
     *
     * @var int СȼʱķԴ 
     */
    private $houseNumberLimit;
    /**
     *
     * @var int СƵȼδĿ
     */
    private $notFillitemsLimit;
    /**
     *
     * @var int СƵȼͼƬ
     */
    private $imageNumberLimit;
    
    /**
     * 캯ʼ
     * @throws Exception ûеȼ쳣
     */
    public function __construct() {
        $this->container = Container::getInstance();
        $this->blockLevelHeat = new BlockLevelHeat();
        $this->blockLevelInfo = new BlockLevelInfo();
        $blockLhSetting = new BlockLevelHeatSetting();
        $blhsData = $blockLhSetting->findAll();
        if($blhsData) {
            $this->pvLimit = $blhsData[0]['pv'];
            $this->houseNumberLimit = $blhsData[0]['house_number'];
        } else {
            throw new Exception('no block level setting');
        }
        $blockLiSetting = new BlockLevelInfoFullSetting();
        $blisData = $blockLiSetting->findAll();
        if($blhsData) {
            $this->notFillitemsLimit = $blisData[0]['not_filled_items_number'];
            $this->imageNumberLimit = $blisData[0]['image_number'];
        } else {
            throw new Exception('no block level setting');
        }
    }
    
    /**
     * pvͷԴСӦĵȼ
     * @param int $pv pv
     * @param int $houseNumber Դ
     * @return string  A,B,C,D֮һ
     */
    public function statToLevelHeat($pv,$houseNumber) {
        if($pv>=$this->pvLimit) {
            if($houseNumber>=$this->houseNumberLimit) {
                return BlockLevelHeatSetting::$levels[1];
            } else {
                return BlockLevelHeatSetting::$levels[2];
            }
        } else {
            if($houseNumber>=$this->houseNumberLimit) {
                return BlockLevelHeatSetting::$levels[3];
            } else {
                return BlockLevelHeatSetting::$levels[4];
            }
        }
    }
    
    /**
     * ѯpvͷԴ
     */
    private function calPvAndHouseNumber() {
        $dbback = $this->container->get('dbback');
        //ϸ
        $stat = strtotime("-2 month");
        $mouth = Date('m',$stat);
        $mouthMaxDay = date("t",$stat);
        $year = date('Y',$stat);
        $datalineStart = $year.$mouth."01";
        $datalineEnd = $year.$mouth.$mouthMaxDay;
        $sql = "select blockid,blockname,SUM(h_pv_num) as pv,SUM(h_num) as house_number,COUNT(blockid) as days from block_stat WHERE dataline>=$datalineStart and dataline<=$datalineEnd  GROUP BY blockid";
        return $dbback->getAll($sql);
    }

    /**
     * СδСͼƬСƽ̶ȵȼ
     * @param int $notFullItemNumber Сδ
     * @param int $imageNumber ͼƬ
     * @return string С̶ȵȼ
     */
    public function blockToLevelInfo($notFullItemNumber,$imageNumber) {
        if($notFullItemNumber>=0&&$notFullItemNumber<=$this->notFillitemsLimit) {
            if($imageNumber>=$this->imageNumberLimit) {
                return BlockLevelInfoFullSetting::$levels[1];
            } else {
                return BlockLevelInfoFullSetting::$levels[2];
            }
        } else {
            if($imageNumber>=$this->imageNumberLimit) {
                return BlockLevelInfoFullSetting::$levels[3];
            } else {
                return BlockLevelInfoFullSetting::$levels[4];
            }
        }
    }
    
    private function blockLevelHeatData($statDate) {
        
    }
    
    /**
     * ˢСȶȵȼ
     */
    public function flushHeat() {
        $statData = $this->calPvAndHouseNumber();
        $levelData = array();
        if($statData) {
            $i = 0;
            $dbback = $this->container->get('dbback');
            foreach ($statData as $value) {
                $temp = array();
                //ʽСûеȼ
                $blockId = $value['blockid'];
                $sql = "select esta from block WHERE id='$blockId'";
                $esta = $dbback->getOne($sql);
                if($esta!=2) {
                    continue;
                }
                $temp['block_id'] = $blockId;
                $pv = intval($value['pv']/$value['days']);
                $house_number = intval($value['house_number']/$value['days']);
                //$temp['pv'] = $pv;
                //$temp['house_number'] = $house_number;
                $temp['level'] = $this->statToLevelHeat($pv, $house_number);
                $levelData[] = $temp;
                /*$i++;
                if($i>10){
                    print_r($settingData);exit;
                }*/
            }
            //print_r($levelData);exit;
            $this->blockLevelHeat->refreshData($levelData);
            
        }
    }
    
    /**
     * ˢСƶȵȼ
     */
    public function flushInfo() {
        //SELECT bi_blockid as block_id,COUNT(id) as image_number FROM block_img GROUP BY bi_blockid LIMIT 0,10
    
        $notLockData = $this->blockNotLockItemNumber();
        $imageNumberData = $this->blockImageNumber();
        $levelData = array();
        $i = 0;
        if($notLockData) {
            foreach ($notLockData as $value) {
                $temp = array();
                $temp['block_id'] = $value['block_id'];
                if($value['lock_flag'] ==1) {
                    $notItemNumber = 0;
                } else {
                    $notItemNumber = $value['not_full_item_number'];
                }
                $image_number = $imageNumberData[$value['block_id']];
                //$temp['not_full_item_number'] = $notItemNumber;
                //$temp['image_number'] = $image_number;
                $temp['level'] = $this->blockToLevelInfo($notItemNumber, $image_number);
                $levelData[] = $temp;
                /**
                if($temp['block_id'] =='410') {
                    echo $notItemNumber;
                    print_r($temp);print_r($value);
                    echo $image_number;
                }
                 */
                /*
                $i++;
                if($i>10){
                    print_r($levelData);exit;
                }*/
            }
            $this->blockLevelInfo->refreshData($levelData);
        }
        
        //print_r($imageNumberData);
    }
    
    /**
     * СвСδ
     * @return array δĿ
     */
    private function blockNotLockItemNumber() {
        $sql = SqlCombinHelper::select_sql("block", "id as block_id,lock_flag,lock_opennum as not_full_item_number", "esta = 2");
        $dbback = $this->container->get('dbback');
        $res = $dbback->getAll($sql);
        return $res;
        $data = array();
        if(is_array($res)&&!empty($res)) {
            foreach ($res as $value) {
                //$temp = array();
                if($value['lock_flag'] ==1) {
                    $data[$value['block_id']] = 0;
                } else {
                    $data[$value['block_id']] = $value['not_full_item_number'];
                }
            }
        }
        //print_r($data);
        return $data;
    }
    
    /**
     * ͨСͼƬСͼƬ
     * @return array СͼƬ
     */
    private function blockImageNumber() {
        $sql = "SELECT bi_blockid as block_id,COUNT(id) as image_number FROM block_img where bi_type in (51,52,53,54,55 ) GROUP BY bi_blockid";
        $dbback = $this->container->get('dbback');
        $res = $dbback->getAll($sql);
        $data = array();
        if(is_array($res)&&!empty($res)) {
            foreach ($res as $value) {
                $data[$value['block_id']] = $value['image_number'];
            }
        }
        return $data;
    }
}


?>
