<?php
/**
 * Դģҵ߼
 *
 * @author sun
 */
class House_template_model extends MY_Model {

    /**
     * ģ
     * @var string
     */
    private $_tbl = 'zsb_template';

    /**
     * ۺͳ12ģ
     * @var int
     */
    public $template_num = 12;

    /**
     * Դģ
     * @var array
     */
    private $_modules = array('sell' => '', 'rent' => '');

    /**
     * ѯֶ
     * @var string
     */
    private $_select_fields = '';

    /**
     * ĳʼ
     */
    public function __construct()
    {
        parent::__construct(1,1,0);
    }

    /**
     * Դģӿڵurlַ
     * @param string $func_name 
     * @return string Ӧurlַ
     */
    public function find_func_url($func_name = 'manage')
    {
        $url = '/house_template/';
        switch ($func_name)
        {
            case 'add': //ӷԴģҳ
                $url .= 'add/';
                break;
            case 'insert': //ģ
                $url .= 'insert/';
                break;
            case 'modify': //޸ķԴģҳ
                $url .= 'modify/';
                break;
            case 'update': //·Դ
                $url .= 'update/';
                break;
            case 'delete': //ɾԴ
                $url .= 'delete/';
                break;
            default :  //Դģбҳ
                $url .= 'manage/';
        }
        return $url;
    }

    /**
     * ȡԴģ
     * @param string $module ģ
     * @return string ģ
     */
    public function find_module_name($module)
    {
        return $this->_modules[$module];
    }

    /**
     * ģ
     * @param string $module ģ
     * @return string ģ
     */
    public function check_module($module)
    {
        $modules = array_keys($this->_modules);
        if (in_array($module, $modules))
        {
            return $module;
        }
        else
        {
            //ģʱĬΪһ
            return $modules[0];
        }
    }

    /**
     * Ҫѯֶ
     * @param array $select_fields Ҫѯֶ
     */
    public function set_select_fields($select_fields)
    {
        $select_fields_str = '';
        if(isset( $select_fields ) && !empty($select_fields))
        {
            $select_fields_str = implode( ',', $select_fields) ;
        }
        $this->_select_fields = $select_fields;
    }

    /**
     * ȡҪѯֶ
     * @return string
     */
    public function get_select_fields()
    {
        return $this->_select_fields;
    }

    /**
     * ־ۺͳֵ
     * @return int 1 = sell 2 = rent
     */
    public function flag($module)
    {
        if ($module == 'sell')
        {
            return 1;
        }
        else if ($module == 'rent')
        {
            return 2;
        }
    }

    /**
     * жٸͬƵģ
     * @param type $template_name ģ
     * @param type $module ģ
     * @param type $uid ˱
     */
    public function find_count_by_name($template_name, $module = 'sell', $uid = '')
    {
        $this->db->where('template_name', ltrim($template_name));
        $this->db->where('flag', $this->flag($module));
        if ($uid)
        {
            $this->db->where('broker_id', $uid);
        }
        return $this->db->count_all_results($this->_tbl);
    }

    /**
     * ĳģ¶ٸģ
     * @param type $module ģ
     * @param type $uid ˱
     */
    public function find_count_by_module($module, $uid = '')
    {
        $this->db->where('flag', $this->flag($module));
        if ($uid)
        {
            $this->db->where('broker_id', $uid);
        }
        return $this->db->count_all_results($this->_tbl);
    }

    /**
     * ݱidȡģϸϢ
     * @param int $id  Դģ
     * @param int $uid ˱
     * @return array  ģϢɵһά
     */
    public function find_by_id($id, $uid = '')
    {
        $this->dbback->where('id', $id);
        if ($uid)
        {
            $this->dbback->where('broker_id', $uid);
        }
        //ѯֶ
        if ($this->_select_fields)
        {
            $this->dbback->select($this->_select_fields);
        }
        return $this->dbback->get($this->_tbl)->row_array();
    }

    /**
     * ģͻȡģб
     * @param type $module ģ
     * @param type $uid ˱
     * @return array ģϢɵĶά
     */
    public function find_by_module($module, $uid = '')
    {
        $this->dbback->where('flag', $this->flag($module));
        if ($uid)
        {
            $this->dbback->where('broker_id', $uid);
        }
        //ѯֶ
        if ($this->_select_fields)
        {
            $this->dbback->select($this->_select_fields);
        }
        $this->dbback->order_by('id', 'desc');
        return $this->dbback->get($this->_tbl)->result_array();
    }

    /**
     * 뷿Դģ
     * @param array $insert_data Դ
     * @return int ɹ زɹķԴid ʧ false
     */
    public function insert($insert_data)
    {
        if ($this->db->insert($this->_tbl, $insert_data))
        {
            return $this->db->insert_id();
        }
        return false;
    }

    /**
     * ·Դģ
     * @param array $update_data Դ
     * @param int $id ģ
     * @param int $uid ˱
     * @return int ظӰ
     */
    public function update($update_data, $id, $uid = '')
    {
        $this->db->where('id', $id);
        if ($uid)
        {
            $this->db->where('broker_id', $uid);
        }
        $this->db->update($this->_tbl, $update_data);
        return $this->db->affected_rows();
    }

    /**
     * ɾԴģ
     * @param int $id ģ
     * @param int $uid ˱
     * @return boolean true ɹ false ʧ
     */
    public function delete($id, $uid = '')
    {
        $this->db->where('id', $id);
        {
            $this->db->where('broker_id', $uid);
        }
        $this->db->delete($this->_tbl);
        if ($this->db->affected_rows() > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

}
