<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of broker_check
 *
 * @author Administrator
 */
class Broker_check extends MY_Model {

    public $uid;
    public $cityflag;
    public $score_baseinfo_limit = 20;  //Ϣ
    public $score_houseMamage_limit = 40; //ԴϢ
    public $score_houseRefresh_limit = 40; //ԴˢϢ
    public $score_min = 0;
    public $tbl_broker;
    public $tbl_certificate;
    public $tbl_sell;
    public $tbl_rent;
    public $tbl_housefreeze;
    public $tbl_picdel;
    public $tbl_refresh;
    public $start_time;
    public $end_time;
    public $brokerInfo = array();
    public $is_cache = 1;

    public function __construct() {
        parent::__construct(0,1,3);
        $this->load->model('broker_model');
        $this->load->model('Statistics','stat');
        $info = $this->broker_model->get_user_session();
        $this->uid = $info['uid'];
        $this->cityflag = 'nj';
        $this->tbl_broker = 'broker';
        $this->tbl_certificate = 'broker_certificate';
        $this->tbl_sell = 'sell';
        $this->tbl_rent = 'rent';
        $this->tbl_housefreeze = 'house_freeze';
        $this->tbl_picdel = 'upload_log';
        $this->tbl_refresh = 'log_refresh';
        $this->brokerInfo = $this->Get_BrokerInfo();
    }

    /**
     * ȡ˻Ϣ
     * @param 
     * @return array ˻Ϣ
     * @author xz 2013-6-20
     * */
    public function Get_brokerScore() {
        $mem_key = $this->cityflag . '_BrokerCheck_BrokerScore_' . $this->uid;
        $temp_brokerScore = $this->mc->get($mem_key);
        if ($temp_brokerScore['is_ok'] == '1') {
            $brokerScore = $temp_brokerScore['data'];
        } else {
            $brokerScore = array();
            //жϾǷǸײͣ򷵻false.
            if ($this->brokerInfo['is_pay'] == 0) {
                $BaseInfo_Score = $this->Get_BaseInfo_Score();
                $HouseMamage_Score = $this->Get_HouseMamage_Score();
                $HouseRefresh_Score = $this->Get_HouseRefresh_Score();
                $total_score = $BaseInfo_Score + $HouseMamage_Score + $HouseRefresh_Score;
                $brokerScore = array(
                    'time' => time(),
                    'total_score' => $total_score,
                    'BaseInfo_Score' => $BaseInfo_Score,
                    'HouseMamage_Score' => $HouseMamage_Score,
                    'HouseRefresh_Score' => $HouseRefresh_Score
                );
            }
            $this->mc->add($mem_key, array('is_ok' => '1', 'data' => $brokerScore),  60);
        }
        return $brokerScore;
    }

    /**
     * ȡ˻Ϣ
     * @param 
     * @return array ˻Ϣ
     * @author xz 2013-6-20
     * */
    public function Get_BrokerInfo() {
        return $this->broker_model->get_broker_info();
    }

    /**
     * ȡ˻Ϣ÷
     * @param 
     * @return int ˻÷
     * @author xz 2013-6-20
     * */
    public function Get_BaseInfo_Score() {

        //ȡͷ÷(ͨ6֣˵4֣޵0)
        $score_photo = 0;
        $valid_flag_photo = $this->Get_SmallPhoto_Status();

        if ($valid_flag_photo == '0') {
            $score_photo = 3;
        } else if ($valid_flag_photo == '1') {
            $score_photo = 6;
        }

        //ȡ֤÷(ͨ6֣˵4֣޵0)
        $score_Idcard = 0;
        $valid_flag_Idcard = $this->Get_Identity_Card_Status();

        if ($valid_flag_Idcard == '0') {
            $score_Idcard = 3;
        } else if ($valid_flag_Idcard == '1') {
            $score_Idcard = 6;
        }

        //ȡƬ֤(ͨ4֣˵2֣޵0)
        $score_Bcard = 0;
        $valid_flag_Bcard = $this->Get_Business_Card_Status();

        if ($valid_flag_Bcard == '0') {
            $score_Bcard = 2;
        } else if ($valid_flag_Bcard == '1') {
            $score_Bcard = 4;
        }

        //ȡҵ֤÷(ͨ4֣˵2֣޵0)
        $score_Cert = 0;
        $valid_flag_Cert = $this->Get_Certification_Status();

        if ($valid_flag_Cert == '0') {
            $score_Cert = 2;
        } else if ($valid_flag_Cert == '1') {
            $score_Cert = 4;
        }

        //ֵ÷
        @$score_baseinfo = $score_photo + $score_Idcard + $score_Bcard + $score_Cert;
        //ߵ÷
        $score_baseinfo = $this->score_baseinfo_limit >= $score_baseinfo ? $score_baseinfo : $this->score_baseinfo_limit;
        //ȡ
        return intval($score_baseinfo);
    }

    /**
     * ȡ˷Դֵ÷
     * @param 
     * @return int ȡ˷Դֵ÷
     * @author xz 2013-6-20
     * */
    public function Get_HouseMamage_Score() {

        //˿
        $postlimit = intval($this->brokerInfo['postlimit']);

        //Դ
        $HouseNum = $this->Get_HouseNum($this->tbl_sell) + $this->Get_HouseNum($this->tbl_rent);

        //ͼԴ
        $StarHouseNum = $this->Get_StarHouseNum($this->tbl_sell) + $this->Get_StarHouseNum($this->tbl_rent);

        //Դʵ÷(=Դ/ЧԴޣ÷=*10)
        $house_score = $postlimit > 0 ? ( $HouseNum / $postlimit ) * 10 : 0;

        //ͼԴʵ÷(ͼ=ͼԴ/ЧԴ÷=ͼ*30)
        $star_house_score = $HouseNum > 0 ? ( $StarHouseNum / $HouseNum ) * 30 : 0;

        //ֵʱ
        $this->start_time = strtotime(date('Y-m-d'));
        $this->end_time = $this->start_time + 86399;

        //Υ淿Դ÷(챻12֣24֣36֣5Ͽ10)
        $Violation_HouseNum = $this->Get_Violation_HouseNum();
        $Violation_House_score = $Violation_HouseNum * ( -2 );
        $Violation_House_score = $Violation_House_score >= -10 ? $Violation_House_score : -10;

        //ɾͼƬ÷(챻һſ1֣2ſ2֣3ſ3֡10żϿ10)
        $Violation_PicNum = $this->Get_Violation_PicNum();
        $Violation_Pic_score = $Violation_PicNum * ( -1 );
        $Violation_Pic_score = $Violation_Pic_score >= -10 ? $Violation_Pic_score : -10;

        $score_HouseMamage = $house_score + $star_house_score + $Violation_House_score + $Violation_Pic_score;

        //СֵΪ0
        $score_HouseMamage = $score_HouseMamage > 0 ? $score_HouseMamage : 0;

        //֤
        $score_HouseMamage = $this->score_houseMamage_limit > $score_HouseMamage ? $score_HouseMamage : $this->score_houseMamage_limit;

        return floor($score_HouseMamage);
    }

    /**
     * ȡ˷Դֵ÷
     * @param 
     * @return int ȡ˷Դֵ÷
     * @author xz 2013-6-20
     * */
    public function Get_HouseRefresh_Score() {

        //˿
        $postlimit = intval($this->brokerInfo['postlimit']);
        $refresh_num = $this->Get_Refresh_Num();

        //ˢ·Դ÷(ˢ=ˢ´/˿ˢ´ޣ÷=ˢ*40)
        $refresh_score = $postlimit > 0 ? ( $refresh_num / ( $postlimit * 3 ) ) * 40 : 0;

        //֤÷
        $refresh_score = $this->score_houseRefresh_limit > $refresh_score ? $refresh_score : $this->score_houseRefresh_limit;
        //ȡ֤֤Ӳᳬ100
        return floor($refresh_score);
    }

    /**
     * ȡͷ֤Ϣ״̬
     * @param 
     * @return string ͷ֤Ϣ״̬
     * @author xz 2013-6-20
     * */
    public function Get_SmallPhoto_Status() {
        $kind = "p_2_2";
        return $this->get_cert_status($kind);
        //$valid_info = array();
        //$sql = "SELECT valid_flag FROM " . $this->tbl_certificate ." WHERE uid = " . $this->uid . " AND kind = 'p_2_2' ";
        //$valid_info = $this->dbback->GetAll($sql);
        /*
        $this->dbback->select("valid_flag")->from($this->tbl_certificate)
                ->where("uid = $this->uid AND kind = 'p_2_2'");
        $query = $this->dbback->get();
        $valid_info = $query->result_array();
        $valid_yx = 0;
        $valid_dl = 0;
        foreach ($valid_info as $value) {
            switch ($value['valid_flag']) {
                case '1':
                    $valid_yx++;
                    break;
                case '0':
                    $valid_dl++;
                    break;
                default:
                    break;
            }
        }
        if ($valid_yx > 0) {
            $valid_flag = 1;
        } elseif ($valid_dl > 0) {
            $valid_flag = 0;
        } else {
            $valid_flag = 2;
        }
        return $valid_flag;
         * 
         */
    }

    /**
     * ȡ֤֤Ϣ״̬
     * @param 
     * @return string ֤֤Ϣ״̬
     * @author xz 2013-6-20
     * */
    function Get_Identity_Card_Status() {
        return $this->get_cert_status("p_2_3");
    }

    /**
     * ȡƬ֤Ϣ״̬
     * @param 
     * @return string ֤֤Ϣ״̬
     * @author xz 2013-6-20
     * */
    public function Get_Business_Card_Status() {
        return $this->get_cert_status("p_3");
    }

    /**
     * ȡȫҵ֤֤Ϣ״̬
     * @param 
     * @return string ȫҵ֤֤Ϣ״̬
     * @author xz 2013-6-20
     * */
    public function Get_Certification_Status() {
        $kind = "p_4_2";
        return $this->get_cert_status($kind);
    }

    /**
     * ȡ˼Դ
     * @param $tbl Դ sell\rent
     * @return int ˼Դ
     * @author xz 2013-6-20
     * */
    public function Get_HouseNum($tbl) {
        if($tbl == 'rent') {
            return $this->stat->rentCount($this->uid);
        }elseif($tbl == 'sell') {
            return $this->stat->sellCount($this->uid);
        }
        /**
        $sql = "SELECT COUNT(*) FROM " . $tbl . " WHERE esta = 1 "
                . " AND agentcode = 'B000' AND uid = $this->uid ";
        $num = $this->dbback->GetOne($sql);
        $this->dbback->select("valid_flag")->from($this->tbl_certificate)
                ->where("uid = $this->uid AND kind = '$kind'");
        $query = $this->dbback->get();
        $valid_info = $query->result_array();
        return intval($num);
         * 
         */
    }

    /**
     * ȡ˶ͼԴ
     * @param $tbl Դ sell\rent
     * @return int ˶ͼԴ
     * @author xz 2013-6-20
     * */
    function Get_StarHouseNum($tbl) {
        if($tbl == 'sell') {
            return $this->stat->sellCountStar($this->uid);
        } elseif($tbl == 'rent') {
            return $this->stat->rentCountStar($this->uid);
        }
        /*
        $sql = "SELECT COUNT(*) FROM $tbl WHERE esta = 1 "
                . " AND agentcode = 'B000' AND uid = $this->uid AND isstar = 3 ";
        $num = $this->dbback->GetOne($sql);

        return intval($num);
         * 
         */
    }

    /**
     * ȡΥ淿Դ
     * @param 
     * @return int Υ淿Դ
     * @author xz 2013-6-20
     * */
    private function Get_Violation_HouseNum() {
        return $this->stat->countViolationHouse($this->uid,$this->start_time,$this->end_time);
        /*
        $cond = " WHERE agentcode = 'B000' AND uid = " . $this->uid;
        $cond .= ' AND freezetime BETWEEN ' . $this->start_time . ' AND ' . $this->end_time;

        $sql = "SELECT COUNT(*) FROM " . $this->tbl_housefreeze . " $cond ";
        $num = $this->dbback->GetOne($sql);

        return intval($num);
         * 
         */
    }

    /**
     * ȡΥͼƬ
     * @param 
     * @return int ΥͼƬ
     * @author xz 2013-6-20
     * */
    private function Get_Violation_PicNum() {
        return $this->stat->countViolationPic($this->uid,  $this->start_time,  $this->end_time);
        /*
        $cond = " WHERE uid = '" . $this->uid . "' AND sort != '99'   ";
        $cond .= " AND optime >= '" . $this->start_time . "' AND optime <= '" . $this->end_time . "'";
        $sql = " SELECT COUNT(*) FROM " . $this->tbl_picdel . " $cond ";
        $num = $this->dbback->GetOne($sql);
        return intval($num);
        */
    }

    /**
     * ȡ˷Դˢ´
     * @param 
     * @return int ˷Դˢ´
     * @author xz 2013-6-20
     * */
    private function Get_Refresh_Num() {
        return $this->stat->refreshNumberToday($this->uid);
        /*
        $day = date('Y-m-d', time());
        $sql = " SELECT SUM(num) FROM $this->tbl_refresh WHERE "
                . " uid = '" . $this->uid . "' AND ymd = '" . $day . "'";
        $refresh_num = $this->dbback->GetOne($sql);
        return intval($refresh_num);
        */
    }
    
    private function get_cert_status($kind) {
        $this->dbback->select("valid_flag")->from($this->tbl_certificate)
                ->where("uid = $this->uid AND kind = '$kind'");
        $query = $this->dbback->get();
        $valid_info = $query->result_array();
        $valid_yx = 0;
        $valid_dl = 0;
        foreach ($valid_info as $value) {
            switch ($value['valid_flag']) {
                case '1':
                    $valid_yx++;
                    break;
                case '0':
                    $valid_dl++;
                    break;
                default:
                    break;
            }
        }
        if ($valid_yx > 0) {
            $valid_flag = 1;
        } elseif ($valid_dl > 0) {
            $valid_flag = 0;
        } else {
            $valid_flag = 2;
        }
        return $valid_flag;
    }

}

?>
