<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Description of market_bid_attention
 *
 * @author Administrator
 */
class market_bid_attention extends MY_Controller {
    //put your code here
    private $uid;
    private $info;
    private $broker;
    /**
     * СרҾͶڴ
     * @var type СרҾͶڴ
     */
    private $cBidPeriodsB;
    /**
     * ԴͶڴ
     * @var type ԴͶڴ
     */
    private $cBidPeriodsH;
   
    /**
     * ⷿԴͶڴ
     * @var type ԴͶڴ
     */
    private $cBidPeriodsR;
    /**
     *
     * @var type 
     */
    private $growthBrokerCredit;
    
    /**
     *
     * @var type 
     */
    private $growthBrokerBidHouse;
    
    /**
     *
     * @var type 
     */
    private $growthBrokerBidRent;
    /**
     *
     * @var type 
     */
    private $growthBrokerBidBlockExpert;
    /**
     * 
     * @param type $type
     */
    public function __construct($type = NULL) {
        parent::__construct($type);
        $this->initUser();
        $this->initBidPeriods();
        $this->growthBrokerCredit = new GrowthBrokerCredit($this->broker);
        $this->initGrowthBrokerBidHouse();
        $this->initGrowthBrokerBidBlockExpert();
        $this->initGrowthBrokerBidRent();
		$this->initGrowthBrokerBidSchoolExpert();
        $this->load->helper('common_url');
    }
    
    public function helper() {
        if($this->check_auth()) {
            $action = $this->input->get('action');
            if($action=='getAttentionNumber') {
                $number = $this->getAttentionNumber();
                return $this->ajaxResponse($number, 'gbk', 'text');
            } else {
                return $this->content();
            }
        } else {
            return $this->ajaxResponse('-1', 'gbk', 'text');
        }
    }
    
    public function cancel() {
        $attentionId = $this->input->get('attention_id');//intval($_GET['attention_id']);
        $re = $this->growthBrokerBidHouse->cancelAttent($attentionId);
        //$re = 1;
        if($re==1) {
            $data['result']= 1;
        } else {
            $data['result']= 0;
        }
        return $this->ajaxResponse($data);
        //echo json_encode($data);
    }


    private function content() {
        $broker = $this->broker;
        $growthBidHelper = new GrowthBidAttentionHelper($broker);
        
        //СרҾͶע
        $attentionNumberB = $this->getAttentionBlockNumber($growthBidHelper,  $this->cBidPeriodsB);
        if ($attentionNumberB > 0) {
            $attentionListB = $this->getAttentionBlockList($this->cBidPeriodsB);
        } else {
            $attentionListB = array();
        }
        //ԴͶע
        $growthBrokerBidHouse = $this->growthBrokerBidHouse;//new GrowthBrokerBidHouse($broker, $growthBrokerCredit);
        $attentionNumberH = $this->getAttentionHouseNumber($growthBidHelper, $this->cBidPeriodsH);
        if($attentionNumberH>0) {
            $attentionListH = $this->getAttentionHouseList($growthBrokerBidHouse, $this->cBidPeriodsH);
        } else {
            $attentionListH = array();
        }
        //ԴͶע
        $growthBrokerBidRent = $this->growthBrokerBidRent;//new GrowthBrokerBidHouse($broker, $growthBrokerCredit);
        $attentionNumberR = $this->getAttentionRentNumber($growthBidHelper, $this->cBidPeriodsR);
        if($attentionNumberR>0) {
            $attentionListR = $this->getAttentionRentList($growthBrokerBidRent, $this->cBidPeriodsR);
        } else {
            $attentionListR = array();
        }
		 //ѧͶע
        $attentionNumberS = $this->getAttentionSchoolNumber($growthBidHelper,  $this->cBidPeriodsS);
        if ($attentionNumberS > 0) {
            $attentionListS = $this->getAttentionSchoolList($this->cBidPeriodsS);
        } else {
            $attentionListS = array();
        }
        
        $attentionNumber = $attentionNumberB + $attentionNumberH + $attentionNumberR+$attentionNumberS;
        $attentionList = array_merge($attentionListB, $attentionListH,$attentionListR,$attentionListS);
        $this->sort($attentionList);
        $data = array();
        $data['attentionList'] = $attentionList;
        $data['attentionNumber'] = $attentionNumber;
        //$this->view(null, 'market_bid_attention/helper', $data);
        $data['css'] = load_css('zsb/css/v1.0/style1.css,zsb/css/v1.0/jquery.mCustomScrollbar.css');
        $data['js'] = load_js('common/js/jquery.jcountdown.js,common/js/jquery.mCustomScrollbar.concat.min.js');
        $data['self'] = $this;
		// echo json_encode($data['attentionList']);exit;
        $this->load->view('market_bid_attention/helper',$data);
    }
    
    private function getAttentionNumber() {
        $isBidDay = $this->isBidDay();
        if (!$isBidDay) {//ǾͶ
            return '-1';
        }
        $growthBidHelper = new GrowthBidAttentionHelper($this->broker);
        //ǾͶڷ-1
        //СרҾͶע
        $attentionNumberB = 0;
        if ($this->cBidPeriodsB) {
            $attentionNumberB = $this->getAttentionBlockNumber($growthBidHelper,  $this->cBidPeriodsB);
        }
        //Դ
        $attentionNumberH = 0;
        if($this->cBidPeriodsH) {
            $attentionNumberH = $this->getAttentionHouseNumber($growthBidHelper, $this->cBidPeriodsH);
        }
        //ⷿԴ
        $attentionNumberR = 0;
        if($this->cBidPeriodsR) {
            $attentionNumberR = $this->getAttentionHouseNumber($growthBidHelper, $this->cBidPeriodsR);
        }

        //ѧר
		//$attentionNumberS = 0;
        //if ($this->cBidPeriodsS) {
        //    $attentionNumberS = $this->getAttentionSchoolNumber($growthBidHelper,  $this->cBidPeriodsS);
       // }

        //$attentionNumber = $attentionNumberB + $attentionNumberH+$attentionNumberR+$attentionNumberS;
		$attentionNumber = $attentionNumberB + $attentionNumberH+$attentionNumberR;
        return $attentionNumber;

    }
    /**
     * עСרҾͶ
     * @param type $growthBidHelper
     * @param type $bidPeriods
     * @return type
     */
    private function getAttentionBlockNumber($growthBidHelper,$bidPeriods) {
        $attentionNumberB = 0;
        //$bidPeriodsIdB = $cBidPeriodsB['id'];
        //$bidPeriodsStatusB = $cBidPeriodsB['status'];
        $bidPeriodsIdB = $bidPeriods['id'];
        $bidPeriodsStatusB = $bidPeriods['status'];
        $startTime = $bidPeriods['start_time'];
        if ($bidPeriodsStatusB == GrowthBidPeriods::BID_PERIODS_STATUS_ON ||
                $bidPeriodsStatusB == GrowthBidPeriods::BID_PERIODS_STATUS_FINISH) {
            if (substr($startTime, 0, 10) == date('Y-m-d')) {
                $attentionNumberB = $growthBidHelper->checkAttention($bidPeriodsIdB);
            }
        }
        return $attentionNumberB;
    }


	 /**
     * עѧרҾͶ
     * @param type $growthBidHelper
     * @param type $bidPeriods
     * @return type
     */
    private function getAttentionSchoolNumber($growthBidHelper,$bidPeriods) {
        $attentionNumberS = 0;
        //$bidPeriodsIdB = $cBidPeriodsB['id'];
        //$bidPeriodsStatusB = $cBidPeriodsB['status'];
        $bidPeriodsIdS = $bidPeriods['id'];
        $bidPeriodsStatusS = $bidPeriods['status'];
        $startTime = $bidPeriods['start_time'];
        if ($bidPeriodsStatusS == GrowthBidPeriods::BID_PERIODS_STATUS_ON ||
                $bidPeriodsStatusS == GrowthBidPeriods::BID_PERIODS_STATUS_FINISH) {
            if (substr($startTime, 0, 10) == date('Y-m-d')) {
                $attentionNumberS = $growthBidHelper->checkAttention($bidPeriodsIdS);
            }
        }
        return $attentionNumberS;
    }
    
    /**
     * עԴͶ
     * @param type $growthBidHelper
     * @param type $cBidPeriods
     * @return type
     */
    private function getAttentionHouseNumber($growthBidHelper,$cBidPeriods) {
        $attentionNumberH = 0;
        $bidPeriodsIdH = $cBidPeriods['id'];
        $bidPeriodsStatusH = $cBidPeriods['status'];
        $startTime = $cBidPeriods['start_time'];
        if ($bidPeriodsStatusH == GrowthBidPeriods::BID_PERIODS_STATUS_ON ||
                $bidPeriodsStatusH == GrowthBidPeriods::BID_PERIODS_STATUS_FINISH) {
            if (substr($startTime, 0, 10) == date('Y-m-d')) {
                $attentionNumberH = $growthBidHelper->checkAttention($bidPeriodsIdH);
            }
        }
        return $attentionNumberH;
    }
    
    /**
     * עԴͶ
     * @param type $growthBidHelper
     * @param type $cBidPeriods
     * @return type
     */
    private function getAttentionRentNumber($growthBidHelper,$cBidPeriods) {
        $attentionNumberR = 0;
        $bidPeriodsIdR = $cBidPeriods['id'];
        $bidPeriodsStatusR = $cBidPeriods['status'];
        $startTime = $cBidPeriods['start_time'];
        if ($bidPeriodsStatusR == GrowthBidPeriods::BID_PERIODS_STATUS_ON ||
                $bidPeriodsStatusR == GrowthBidPeriods::BID_PERIODS_STATUS_FINISH) {
            if (substr($startTime, 0, 10) == date('Y-m-d')) {
                $attentionNumberR = $growthBidHelper->checkAttention($bidPeriodsIdR);
            }
        }
        return $attentionNumberR;
    }
    
    /**
     * עСרҼ¼
     * @param type $growthBrokerBidBlockExpert
     * @param type $cBidPeriodsB
     */
    private function getAttentionBlockList ($cBidPeriodsB) {
        $attentionListB = $this->growthBrokerBidBlockExpert->getAttentionList($cBidPeriodsB);
        //ĿǰС
        $bidPeriodsIdB = $cBidPeriodsB['id'];
        $blockIds = $this->growthBrokerBidBlockExpert->get_valid_bid_block_id($bidPeriodsIdB);
        //$blocks = SqlCombinHelper::changeToKeyArray($blocks, 'id');
        //ӽӱ־
        foreach ($attentionListB as &$v) {
            $v['disabled_bid_link'] = !in_array($v['block_id'], $blockIds) ? true : false;
        }
        return $attentionListB;
    }
    
	 /**
     * עѧרҼ¼
     * @param type $getAttentionSchoolList
     * @param type $cBidPeriodsB
     */
    private function getAttentionSchoolList ($cBidPeriodsS) {
        $attentionListS = $this->growthBrokerBidSchoolExpert->getAttentionList($cBidPeriodsS);
        //Ŀǰѧ
        $bidPeriodsIdS = $cBidPeriodsS['id'];
        $schoolIds = $this->growthBrokerBidSchoolExpert->get_valid_bid_school_id($bidPeriodsIdS);
        //$blocks = SqlCombinHelper::changeToKeyArray($blocks, 'id');
        //ӽӱ־
        foreach ($attentionListS as &$v) {
            $v['disabled_bid_link'] = !in_array($v['school_id'], $schoolIdS) ? true : false;
        }
        return $attentionListS;
    }



    private function getAttentionHouseList($growthBrokerBidHouse,$cBidPeriodsH) {
        $attentionListH = $growthBrokerBidHouse->getAttentionList($cBidPeriodsH);
        return $attentionListH;
    }
    private function getAttentionRentList($growthBrokerBidRent,$cBidPeriodsH) {
        $attentionListH = $growthBrokerBidRent->getAttentionList($cBidPeriodsH);
        return $attentionListH;
    }
    private function initUser() {
        $info = $this->broker_model->get_user_session();
        $groupId = $info['package_id']; //ײ
        //$brokerType = $info['groupid'];//or
        $gbe = new GrowthBrokerExp(array('id' => $info['uid'], 'groupid' => $groupId));
        $gbc = new GrowthBrokerCredit(array('id' => $info['uid'], 'groupid' => $groupId));
        //ȼ
        $info['level'] = $gbe->getLevel(2);
        //
        $info['exp'] = $gbe->getExp();
        //
        $info['credit'] = $gbc->getValidCredit();
        $this->info = $info;
        $this->uid = $info['uid'];
        //broker
        $broker['id'] = $this->uid;
        $broker['level'] = 'LV'.$this->info['level'];
        $broker['credit'] = $this->info['credit'];
        $broker['groupid'] = $groupId;
        $broker['is_pay'] = $this->info['is_pay'];
        $this->broker = $broker;
    }
    
    public function bidHouseUrl($type,$houseId) {
        $types = array(1 => 'block',2 => 'hotword',3 => 'districtword',4 => 'streetword');
        return '/market_bid_house/'.$types[$type].'/on/'.$houseId.'/';
    }

    public function bidRentUrl($type,$houseId) {
        $types = array(1=>'block',2=>'hotword');
        return '/market_bid_rent/'.$types[$type].'/on/'.$houseId.'/';
    }
    
    public function bidBlockUrl($bidId) {
        return '/market_bid_block_expert/on/';
    }

	public function bidSchoolUrl($bidId) {
        return '/market_bid_school_expert/on/';
    }

    /**
     * ʼɳϵ-˷ԴͶ
     */
    private function initGrowthBrokerBidHouse() {
        $growthConfig = $this->config->item('growth');
        $mode = $growthConfig['mode'];
        $this->growthBrokerBidHouse = new GrowthBrokerBidHouse($this->broker, $this->growthBrokerCredit,$mode);
        $this->growthBrokerBidHouse->setCheckStar(true);
        $additionalScore = $growthConfig['additionalScore']['house'];
        $this->growthBrokerBidHouse->setAdditionalScore($additionalScore);
    }
    
    /**
     * ʼɳϵ-ⷿԴͶ
     */
    private function initGrowthBrokerBidRent() {
        $growthConfig = $this->config->item('growth');
        $mode = $growthConfig['mode'];
        $this->growthBrokerBidRent = new GrowthBrokerBidRent($this->broker, $this->growthBrokerCredit,$mode);
        $this->growthBrokerBidRent->setCheckStar(true);
        $additionalScore = $growthConfig['additionalScore']['rent'];
        $this->growthBrokerBidRent->setAdditionalScore($additionalScore);
    }
    
    /**
     * ʼɳϵ-СרҾͶ
     */
    private function initGrowthBrokerBidBlockExpert() {
        $growthConfig = $this->config->item('growth');
        $mode = $growthConfig['mode'];
        $this->growthBrokerBidBlockExpert = new GrowthBrokerBidBlockExpert($this->broker, $this->growthBrokerCredit, $mode);
        //$this->growthBrokerBidHouse->setCheckStar(true);
        $additionalScore = $growthConfig['additionalScore']['block'];
        $this->growthBrokerBidBlockExpert->setAdditionalScore($additionalScore);
    }


	 /**
     * ʼɳϵ-ѧרҾͶ
     */
    private function initGrowthBrokerBidSchoolExpert() {
        $growthConfig = $this->config->item('growth');
        $mode = $growthConfig['mode'];
        $this->growthBrokerBidSchoolExpert = new GrowthBrokerBidSchoolExpert($this->broker, $this->growthBrokerCredit, $mode);
        //$this->growthBrokerBidHouse->setCheckStar(true);
        $additionalScore = $growthConfig['additionalScore']['school'];
        $this->growthBrokerBidSchoolExpert->setAdditionalScore($additionalScore);
    }
    
    private function initBidPeriods() {
        $growthBidPeriods = new GrowthBidPeriods();
        $this->cBidPeriodsB = $growthBidPeriods->currentBidPeriods(1);
        $this->cBidPeriodsH = $growthBidPeriods->currentBidPeriods(2);
        $this->cBidPeriodsR = $growthBidPeriods->currentBidPeriods(3);
		$this->cBidPeriodsS = $growthBidPeriods->currentBidPeriods(4);
    }

    /**
     * Թע
     * @param type $attentionList
     * @param type $sortKey
     * @param type $sortOption
     */
    private function sort(&$attentionList,$sortKey='attention_id',$sortOption=SORT_DESC) {
        //򰴾Ͷʱ
        $volume = array();
        foreach ($attentionList as $key => &$v) {
			$v[$sortKey]['ctime'] = isset($v[$sortKey]['ctime']) ? $v[$sortKey]['ctime'] : '';
            $v[$sortKey.'_sort'] = strtotime($v[$sortKey]['ctime']);
            $volume[$key] = $v[$sortKey.'_sort'];
        }
        array_multisort($volume, $sortOption, $attentionList);
    }
    /**
     * 
     * жϽǷǾͶ
     */
    private function isBidDay() {
        return $this->absIsBidDay($this->cBidPeriodsB)||$this->absIsBidDay($this->cBidPeriodsH)
                ||$this->absIsBidDay($this->cBidPeriodsR);
    }
    /**
     * 
     * @param type $cBidPeriods
     * @return type
     */
    private function absIsBidDay($cBidPeriods) {
        $startTime = $cBidPeriods['start_time'];
        $isBidDay = substr($startTime, 0, 10) == date('Y-m-d')?true:false;
        return $isBidDay;
    }
    /**
     * 
     */
    private function loginCredit() {
        //¼췿
        $growthCreditDayCount = new GrowthCreditDayCount();
        $ctime = date('Y-m-d');
        $brokerCreditDayLoginActivity = $growthCreditDayCount->findByTimeWayAliasBrokerId($ctime, 'loginActivity', $this->uid);
        $isBrokerCreditLogin = count($brokerCreditDayLoginActivity) > 0 ? true : false;
    }


    private function check_auth() {
        $isPay = $this->broker['is_pay'];
        $level = $this->broker['level'];
        if($isPay!=payStatus) {//ѵģûȨޣfalse
            return false;
        } else {
            return true;
        }
        $brokerLevelNum = intval(substr($level,2));
        //˲ȼȨ
        $growthBidLowLevel = new GrowthBidLowLevel();
        $lowLevel = $growthBidLowLevel->findLevelByType(1);
        $lowLevelId = intval(substr($lowLevel,2));
        if ($brokerLevelNum < $lowLevelId) {
           return false;
        } else {
            return true;
        }
   }
   
   /**
     * ajaxӦ
     * @param type $data Ӧ
     * @param type $encode 룬$type=jsonʱ
     * @param type $type ʽ json  text
     */
    private function ajaxResponse($data, $encode = 'gbk',$type='json') {
        if($type=='json') {
            if ($encode == 'gbk') {
                $data = $this->gbk2utf($data);
            }
            $res = json_encode($data);
            $this->output->set_content_type('application/json')
                ->set_output($res);
        } else {
            $res = $data;
            $this->output->set_content_type('text/html')
                ->set_output($res);
        }
        
    }
    private function gbk2utf($data) {
        if (is_array($data)) {
            foreach ($data as &$value) {
                $value = $this->gbk2utf($value);
            }
        } else {
            $data = iconv('gbk', 'utf-8', $data);
        }
        return $data;
    }
    private function creditWay() {
        /*
         * <span class="text_nav">
                        <strong class="t">׬ȡͨ</strong>
                        <a value="{$broker['id']}" name="<!--# if($isBrokerCreditLogin) echo '1';#-->" id="loginactivity"  class="<!--# if($isBrokerCreditLogin){echo 'logined';}else{echo 'loginno';}  #-->">ǩ</a> | 
                        <a target="_blank" href="./sell_modify.php?action=add">Դ</a> | 
                        <a target="_blank" href="./sell_manage.php?esta=1">ˢ·Դ</a> | 
                        <a target="_blank" href="block_improve_manage.php">С</a>
                    </span> 
                    <span class="text_link">
                        <a href="{$rule_url['get_credit']}" target="_blank">ֻȡ˵&gt;&gt;</a></span> 
         */
    }
}

?>
